/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.util.ErrorManager;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class SharedDiskManager {
    private static final Map<String, List<Resource>> shared2Machines = new HashMap<String, List<Resource>>();
    private static final Map<Resource, Machine> machine2Shareds = new HashMap<Resource, Machine>();
    private static final Map<String, Set<LogicalData>> sharedDisk2SharedFiles = new TreeMap<String, Set<LogicalData>>();

    public static synchronized void addMachine(Resource host) {
        Machine m = new Machine();
        machine2Shareds.put(host, m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void addSharedToMachine(String diskName, String mountpoint, Resource host) {
        Machine resource = machine2Shareds.get(host);
        if (resource != null) {
            resource.addSharedDisk(diskName, mountpoint);
            List<Resource> machines = shared2Machines.get(diskName);
            if (machines == null) {
                machines = new LinkedList<Resource>();
                shared2Machines.put(diskName, machines);
            }
            List<Resource> list = machines;
            synchronized (list) {
                machines.add(host);
            }
        } else {
            ErrorManager.warn("Host " + host.getName() + " not registered as machine in the Shared disk manager.");
        }
    }

    public static synchronized String getSharedName(Resource host, String path) {
        Machine m = machine2Shareds.get(host);
        if (m == null) {
            return null;
        }
        return m.getSharedName(path);
    }

    public static synchronized String getSharedStatus() {
        StringBuilder sb = new StringBuilder("Shared disk in machines:\n");
        for (Map.Entry<String, List<Resource>> entry : shared2Machines.entrySet()) {
            sb.append(entry.getKey()).append("--> {");
            for (int i = 0; i < entry.getValue().size(); ++i) {
                sb.append(entry.getValue().get(i).getName()).append(", ");
            }
            sb.append("}\n");
        }
        sb.append("Machines :\n");
        for (Map.Entry<Object, Object> entry : machine2Shareds.entrySet()) {
            sb.append(((Resource)entry.getKey()).getName()).append("--> {");
            for (Map.Entry me : ((Machine)entry.getValue()).name2Mountpoint.entrySet()) {
                sb.append((String)me.getKey()).append("@").append((String)me.getValue()).append(", ");
            }
            sb.append("}\n");
        }
        return sb.toString();
    }

    public static synchronized List<String> getAllSharedNames(Resource host) {
        Machine m = machine2Shareds.get(host);
        if (m == null) {
            return new LinkedList<String>();
        }
        return m.getAllSharedNames();
    }

    public static synchronized String getMounpoint(Resource host, String sharedDisk) {
        Machine m = machine2Shareds.get(host);
        if (m == null) {
            return null;
        }
        return m.getPath(sharedDisk);
    }

    public static synchronized List<Resource> getAllMachinesfromDisk(String diskName) {
        return shared2Machines.get(diskName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized Map<String, String> terminate(Resource host) {
        Machine m = machine2Shareds.remove(host);
        if (m != null) {
            for (String sharedName : m.allShared) {
                List<Resource> machines;
                List<Resource> list = machines = shared2Machines.get(sharedName);
                synchronized (list) {
                    machines.remove(host);
                }
            }
        }
        if (m != null) {
            return m.name2Mountpoint;
        }
        return new HashMap<String, String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void addLogicalData(String diskName, LogicalData ld) {
        Set<Object> lds = null;
        if (sharedDisk2SharedFiles.containsKey(diskName)) {
            lds = sharedDisk2SharedFiles.get(diskName);
        } else {
            lds = new HashSet();
            sharedDisk2SharedFiles.put(diskName, lds);
        }
        Set<Object> set = lds;
        synchronized (set) {
            lds.add(ld);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void removeLogicalData(String diskName, LogicalData obsolete) {
        Set<LogicalData> lds = sharedDisk2SharedFiles.get(diskName);
        if (lds != null) {
            Set<LogicalData> set = lds;
            synchronized (set) {
                lds.remove(obsolete);
            }
        }
    }

    public static synchronized Set<LogicalData> getAllSharedFiles(String diskName) {
        Set<LogicalData> lds = sharedDisk2SharedFiles.get(diskName);
        return lds;
    }

    private static class Machine {
        private List<String> allShared = new LinkedList<String>();
        private HashMap<String, String> mountpoint2Name = new HashMap();
        private HashMap<String, String> name2Mountpoint = new HashMap();

        public void addSharedDisk(String diskName, String mountpoint) {
            if (!this.allShared.contains(diskName)) {
                this.allShared.add(diskName);
            }
            if (!mountpoint.endsWith(File.separator)) {
                mountpoint = mountpoint + File.separator;
            }
            this.mountpoint2Name.put(mountpoint, diskName);
            this.name2Mountpoint.put(diskName, mountpoint);
        }

        public String getSharedName(String path) {
            if (path == null) {
                return null;
            }
            for (Map.Entry<String, String> e : this.mountpoint2Name.entrySet()) {
                if (!path.startsWith(e.getKey())) continue;
                return e.getValue();
            }
            return null;
        }

        public String getPath(String sharedDisk) {
            return this.name2Mountpoint.get(sharedDisk);
        }

        public List<String> getAllSharedNames() {
            return this.allShared;
        }
    }
}

