/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.local;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.InvocationParamURI;
import es.bsc.compss.types.parameter.BasicTypeParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import java.util.List;

public class LocalParameter
implements InvocationParam {
    private final Parameter param;
    private final boolean preserveSourceData;
    private final boolean writeFinalValue;
    private final String dataMgmtId;
    private final String sourceDataMgmtId;
    private String originalName;
    private String renamedName;
    private Object value;
    private Class<?> valueClass;

    public LocalParameter(Parameter param) {
        this.param = param;
        DataType type = param.getType();
        switch (type) {
            case FILE_T: 
            case OBJECT_T: 
            case STREAM_T: 
            case PSCO_T: 
            case EXTERNAL_STREAM_T: 
            case EXTERNAL_PSCO_T: 
            case BINDING_OBJECT_T: {
                String pscoId;
                DependencyParameter dPar = (DependencyParameter)param;
                DataAccessId dAccId = dPar.getDataAccessId();
                this.value = dPar.getDataTarget();
                boolean preserveSourceData = true;
                preserveSourceData = dAccId instanceof RAccessId ? ((RAccessId)dAccId).isPreserveSourceData() : (dAccId instanceof RWAccessId ? ((RWAccessId)dAccId).isPreserveSourceData() : false);
                DataAccessId faId = dPar.getDataAccessId();
                if (faId instanceof RWAccessId) {
                    RWAccessId rwaId = (RWAccessId)faId;
                    this.sourceDataMgmtId = rwaId.getReadDataInstance().getRenaming();
                    this.dataMgmtId = rwaId.getWrittenDataInstance().getRenaming();
                } else if (faId instanceof RAccessId) {
                    RAccessId raId = (RAccessId)faId;
                    this.dataMgmtId = this.sourceDataMgmtId = raId.getReadDataInstance().getRenaming();
                } else {
                    WAccessId waId = (WAccessId)faId;
                    this.sourceDataMgmtId = null;
                    this.dataMgmtId = waId.getWrittenDataInstance().getRenaming();
                }
                if (this.sourceDataMgmtId != null && (pscoId = Comm.getData((String)this.sourceDataMgmtId).getPscoId()) != null) {
                    if (type.equals((Object)DataType.OBJECT_T)) {
                        param.setType(DataType.PSCO_T);
                    } else if (type.equals((Object)DataType.FILE_T)) {
                        param.setType(DataType.EXTERNAL_PSCO_T);
                    }
                    this.param.setType(param.getType());
                }
                this.preserveSourceData = preserveSourceData;
                this.writeFinalValue = !(dAccId instanceof RAccessId);
                this.originalName = dPar.getOriginalName();
                break;
            }
            default: {
                BasicTypeParameter btParB = (BasicTypeParameter)param;
                this.value = btParB.getValue();
                this.preserveSourceData = false;
                this.writeFinalValue = false;
                this.sourceDataMgmtId = null;
                this.dataMgmtId = null;
            }
        }
    }

    public String getName() {
        return this.param.getName();
    }

    public void setType(DataType type) {
        this.param.setType(type);
    }

    public DataType getType() {
        return this.param.getType();
    }

    public boolean isPreserveSourceData() {
        return this.preserveSourceData;
    }

    public boolean isWriteFinalValue() {
        return this.writeFinalValue;
    }

    public String getPrefix() {
        return this.param.getPrefix();
    }

    public StdIOStream getStdIOStream() {
        return this.param.getStream();
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public String getRenamedName() {
        return this.renamedName;
    }

    public void setRenamedName(String renamedName) {
        this.renamedName = renamedName;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object val) {
        this.value = val;
    }

    public void setValueClass(Class<?> valClass) {
        this.valueClass = valClass;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public String getDataMgmtId() {
        return this.dataMgmtId;
    }

    public String getSourceDataId() {
        return this.sourceDataMgmtId;
    }

    public List<? extends InvocationParamURI> getSources() {
        return null;
    }

    public Parameter getParam() {
        return this.param;
    }

    public String toString() {
        return (Object)((Object)this.getType()) + " " + this.getValue() + " " + (this.isPreserveSourceData() ? "PRESERVE " : "VOLATILE ") + (this.isWriteFinalValue() ? "WRITE" : "DISMISS");
    }
}

