/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.ServiceImplementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.BinaryDefinition;
import es.bsc.compss.types.implementations.definition.COMPSsDefinition;
import es.bsc.compss.types.implementations.definition.DecafDefinition;
import es.bsc.compss.types.implementations.definition.MPIDefinition;
import es.bsc.compss.types.implementations.definition.MethodDefinition;
import es.bsc.compss.types.implementations.definition.MultiNodeDefinition;
import es.bsc.compss.types.implementations.definition.OmpSsDefinition;
import es.bsc.compss.types.implementations.definition.OpenCLDefinition;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.ServiceResourceDescription;
import es.bsc.compss.util.EnvironmentLoader;

public abstract class ImplementationDefinition<T extends ResourceDescription> {
    private final String signature;
    private final T constraints;

    public static final <T extends ResourceDescription> ImplementationDefinition<T> defineImplementation(String implType, String implSignature, T implConstraints, String ... implTypeArgs) throws IllegalArgumentException {
        ImplementationDefinition id = null;
        if (implType.toUpperCase().compareTo(TaskType.SERVICE.toString()) == 0) {
            if (implTypeArgs.length != 4) {
                throw new IllegalArgumentException("Incorrect parameters for type SERVICE on " + implSignature);
            }
            String namespace = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
            String serviceName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
            String operation = EnvironmentLoader.loadFromEnvironment(implTypeArgs[2]);
            String port = EnvironmentLoader.loadFromEnvironment(implTypeArgs[3]);
            id = new ServiceDefinition(implSignature, namespace, serviceName, operation, port);
        } else {
            MethodType mt;
            try {
                mt = MethodType.valueOf(implType);
            }
            catch (IllegalArgumentException iae) {
                throw new IllegalArgumentException("Unrecognised method type " + implType);
            }
            switch (mt) {
                case METHOD: {
                    if (implTypeArgs.length != 2) {
                        throw new IllegalArgumentException("Incorrect parameters for type METHOD on " + implSignature);
                    }
                    String declaringClass = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String methodName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    if (declaringClass == null || declaringClass.isEmpty()) {
                        throw new IllegalArgumentException("Empty declaringClass annotation for method " + implSignature);
                    }
                    if (methodName == null || methodName.isEmpty()) {
                        throw new IllegalArgumentException("Empty methodName annotation for method " + implSignature);
                    }
                    id = new MethodDefinition(implSignature, declaringClass, methodName, (MethodResourceDescription)implConstraints);
                    break;
                }
                case BINARY: {
                    if (implTypeArgs.length != 2) {
                        throw new IllegalArgumentException("Incorrect parameters for type BINARY on " + implSignature);
                    }
                    String binary = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String binaryWorkingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    if (binary == null || binary.isEmpty()) {
                        throw new IllegalArgumentException("Empty binary annotation for BINARY method " + implSignature);
                    }
                    id = new BinaryDefinition(implSignature, binary, binaryWorkingDir, (MethodResourceDescription)implConstraints);
                    break;
                }
                case MPI: {
                    if (implTypeArgs.length != 3) {
                        throw new IllegalArgumentException("Incorrect parameters for type MPI on " + implSignature);
                    }
                    String mpiBinary = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String mpiWorkingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    String mpiRunner = EnvironmentLoader.loadFromEnvironment(implTypeArgs[2]);
                    if (mpiRunner == null || mpiRunner.isEmpty()) {
                        throw new IllegalArgumentException("Empty mpiRunner annotation for MPI method " + implSignature);
                    }
                    if (mpiBinary == null || mpiBinary.isEmpty()) {
                        throw new IllegalArgumentException("Empty binary annotation for MPI method " + implSignature);
                    }
                    id = new MPIDefinition(implSignature, mpiBinary, mpiWorkingDir, mpiRunner, (MethodResourceDescription)implConstraints);
                    break;
                }
                case COMPSs: {
                    if (implTypeArgs.length != 5) {
                        throw new IllegalArgumentException("Incorrect parameters for type MPI on " + implSignature);
                    }
                    String runcompss = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String flags = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    String appName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[2]);
                    String workerInMaster = EnvironmentLoader.loadFromEnvironment(implTypeArgs[3]);
                    String compssWorkingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[4]);
                    if (appName == null || appName.isEmpty()) {
                        throw new IllegalArgumentException("Empty appName annotation for COMPSs method " + implSignature);
                    }
                    id = new COMPSsDefinition(implSignature, runcompss, flags, appName, workerInMaster, compssWorkingDir, (MethodResourceDescription)implConstraints);
                    break;
                }
                case DECAF: {
                    if (implTypeArgs.length != 5) {
                        throw new IllegalArgumentException("Incorrect parameters for type DECAF on " + implSignature);
                    }
                    String dfScript = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String dfExecutor = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    String dfLib = EnvironmentLoader.loadFromEnvironment(implTypeArgs[2]);
                    String decafWorkingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[3]);
                    String decafRunner = EnvironmentLoader.loadFromEnvironment(implTypeArgs[4]);
                    if (decafRunner == null || decafRunner.isEmpty()) {
                        throw new IllegalArgumentException("Empty mpiRunner annotation for DECAF method " + implSignature);
                    }
                    if (dfScript == null || dfScript.isEmpty()) {
                        throw new IllegalArgumentException("Empty dfScript annotation for DECAF method " + implSignature);
                    }
                    id = new DecafDefinition(implSignature, dfScript, dfExecutor, dfLib, decafWorkingDir, decafRunner, (MethodResourceDescription)implConstraints);
                    break;
                }
                case OMPSS: {
                    if (implTypeArgs.length != 2) {
                        throw new IllegalArgumentException("Incorrect parameters for type OMPSS on " + implSignature);
                    }
                    String ompssBinary = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String ompssWorkingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    if (ompssBinary == null || ompssBinary.isEmpty()) {
                        throw new IllegalArgumentException("Empty binary annotation for OmpSs method " + implSignature);
                    }
                    id = new OmpSsDefinition(implSignature, ompssBinary, ompssWorkingDir, (MethodResourceDescription)implConstraints);
                    break;
                }
                case OPENCL: {
                    if (implTypeArgs.length != 2) {
                        throw new IllegalArgumentException("Incorrect parameters for type OPENCL on " + implSignature);
                    }
                    String openclKernel = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String openclWorkingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    if (openclKernel == null || openclKernel.isEmpty()) {
                        throw new IllegalArgumentException("Empty kernel annotation for OpenCL method " + implSignature);
                    }
                    id = new OpenCLDefinition(implSignature, openclKernel, openclWorkingDir, (MethodResourceDescription)implConstraints);
                    break;
                }
                case MULTI_NODE: {
                    if (implTypeArgs.length != 2) {
                        throw new IllegalArgumentException("Incorrect parameters for type MultiNode on " + implSignature);
                    }
                    String multiNodeClass = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
                    String multiNodeName = EnvironmentLoader.loadFromEnvironment(implTypeArgs[1]);
                    if (multiNodeClass == null || multiNodeClass.isEmpty()) {
                        throw new IllegalArgumentException("Empty declaringClass annotation for method " + implSignature);
                    }
                    if (multiNodeName == null || multiNodeName.isEmpty()) {
                        throw new IllegalArgumentException("Empty methodName annotation for method " + implSignature);
                    }
                    id = new MultiNodeDefinition(implSignature, multiNodeClass, multiNodeName, (MethodResourceDescription)implConstraints);
                }
            }
        }
        return id;
    }

    protected ImplementationDefinition(String signature, T constraints) {
        this.signature = signature;
        this.constraints = constraints;
    }

    public String getSignature() {
        return this.signature;
    }

    public T getConstraints() {
        return this.constraints;
    }

    public abstract Implementation getImpl(int var1, int var2);

    private static class ServiceDefinition
    extends ImplementationDefinition<ServiceResourceDescription> {
        private final String namespace;
        private final String serviceName;
        private final String operation;
        private final String port;

        protected ServiceDefinition(String signature, String namespace, String serviceName, String operation, String port) {
            super(signature, null);
            this.namespace = namespace;
            this.serviceName = serviceName;
            this.operation = operation;
            this.port = port;
        }

        @Override
        public Implementation getImpl(int coreId, int implId) {
            return new ServiceImplementation(coreId, this.namespace, this.serviceName, this.port, this.operation);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("SERVICE Implementation \n");
            sb.append("\t Signature: ").append(this.getSignature()).append("\n");
            sb.append("\t Namespace: ").append(this.namespace).append("\n");
            sb.append("\t Service name: ").append(this.serviceName).append("\n");
            sb.append("\t Operation: ").append(this.operation).append("\n");
            sb.append("\t Port: ").append(this.port).append("\n");
            return sb.toString();
        }
    }
}

