/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.executor;

import es.bsc.compss.executor.types.Execution;
import es.bsc.compss.executor.utils.ExecutionPlatform;
import es.bsc.compss.executor.utils.ResourceManager;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.exceptions.InitializationException;
import es.bsc.compss.types.execution.exceptions.InvalidMapException;
import es.bsc.compss.util.ErrorManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExecutionManager {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.ExecManager");
    private final ExecutionPlatform cpuExecutors;

    public ExecutionManager(InvocationContext context, int computingUnitsCPU, String cpuMap, int computingUnitsGPU, String gpuMap, int computingUnitsFPGA, String fpgaMap, int limitOfTasks) {
        ResourceManager rm = null;
        try {
            rm = new ResourceManager(computingUnitsCPU, cpuMap, computingUnitsGPU, gpuMap, computingUnitsFPGA, fpgaMap);
        }
        catch (InvalidMapException ime) {
            ErrorManager.fatal((Exception)((Object)ime));
        }
        this.cpuExecutors = new ExecutionPlatform("CPUThreadPool", context, computingUnitsCPU, rm);
    }

    public void init() throws InitializationException {
        LOGGER.info("Init Execution Manager");
        this.cpuExecutors.start();
    }

    public void enqueue(Execution exec) {
        this.cpuExecutors.execute(exec);
    }

    public void stop() {
        LOGGER.info("Stopping Threads...");
        this.cpuExecutors.stop();
    }

    public void increaseCapabilities(int cpuCount, int gpuCount, int fpgaCount, int otherCount) {
        this.cpuExecutors.addWorkerThreads(cpuCount);
    }

    public void reduceCapabilities(int cpuCount, int gpuCount, int fpgaCount, int otherCount) {
        this.cpuExecutors.removeWorkerThreads(cpuCount);
    }

    public void cancelJob(int jobId) {
        this.cpuExecutors.cancelJob(jobId);
    }
}

