/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.external;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.exceptions.StreamCloseException;
import es.bsc.compss.executor.external.commands.ExecuteTaskExternalCommand;
import es.bsc.compss.executor.external.piped.commands.ExecuteTaskPipeCommand;
import es.bsc.compss.executor.types.InvocationResources;
import es.bsc.compss.invokers.external.ExternalInvoker;
import es.bsc.compss.invokers.types.PythonParams;
import es.bsc.compss.invokers.util.BinaryRunner;
import es.bsc.compss.invokers.util.StdIOStream;
import es.bsc.compss.types.CollectionLayout;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.LanguageParams;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.PythonMPIImplementation;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;

public class PythonMPIInvoker
extends ExternalInvoker {
    private static final int NUM_BASE_PYTHON_MPI_ARGS = 8;
    private final String mpiRunner;
    private final String mpiFlags;
    private final String declaringclass;
    private final String alternativeMethod;
    private final boolean scaleByCU;
    private final boolean failByEV;
    private BinaryRunner br;
    private CollectionLayout cl;

    public PythonMPIInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources);
        PythonMPIImplementation pythonmpiImpl = null;
        try {
            pythonmpiImpl = (PythonMPIImplementation)this.invocation.getMethodImplementation();
        }
        catch (Exception e) {
            throw new JobExecutionException("Incorrect method definition for task of type " + (Object)((Object)this.invocation.getMethodImplementation().getMethodType()), (Throwable)e);
        }
        this.mpiRunner = pythonmpiImpl.getMpiRunner();
        this.mpiFlags = pythonmpiImpl.getMpiFlags();
        this.declaringclass = pythonmpiImpl.getDeclaringClass();
        this.alternativeMethod = pythonmpiImpl.getAlternativeMethodName();
        this.scaleByCU = pythonmpiImpl.getScaleByCU();
        this.failByEV = pythonmpiImpl.isFailByEV();
        this.br = null;
        this.cl = pythonmpiImpl.getCollectionLayout();
        if (this.cl.isEmpty()) {
            this.cl = null;
        }
    }

    @Override
    protected ExecuteTaskExternalCommand getTaskExecutionCommand(InvocationContext context, Invocation invocation, String sandBox, InvocationResources assignedResources) {
        ExecuteTaskPipeCommand taskExecution = new ExecuteTaskPipeCommand(invocation.getJobId());
        return taskExecution;
    }

    @Override
    protected void invokeMethod() throws JobExecutionException {
        Object retObj;
        try {
            retObj = this.runPythonMPIInvocation();
        }
        catch (InvokeExecutionException e1) {
            throw new JobExecutionException((Throwable)e1);
        }
        try {
            if (this.br != null) {
                String pythonInterpreter = null;
                LanguageParams lp = this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
                if (lp instanceof PythonParams) {
                    PythonParams pp = (PythonParams)lp;
                    pythonInterpreter = pp.getPythonInterpreter();
                }
                this.br.closeStreams(this.invocation.getParams(), pythonInterpreter);
            }
        }
        catch (StreamCloseException se) {
            LOGGER.error("Exception closing binary streams", (Throwable)se);
            throw new JobExecutionException((Throwable)se);
        }
        if (this.invocation.isDebugEnabled()) {
            LOGGER.debug("Exit value of MPI executor of job " + this.invocation.getJobId() + " of task " + this.invocation.getTaskId() + ": " + retObj.toString());
        }
        if (retObj.toString().compareTo("0") != 0) {
            throw new JobExecutionException("Received non-zero exit value: " + retObj.toString() + " for job " + this.invocation.getJobId() + " of task " + this.invocation.getTaskId());
        }
    }

    private Object runPythonMPIInvocation() throws InvokeExecutionException {
        String taskCMD = this.command.getAsString();
        String hostfile = null;
        hostfile = this.scaleByCU ? PythonMPIInvoker.writeHostfile(this.taskSandboxWorkingDir, this.workers) : PythonMPIInvoker.writeHostfile(this.taskSandboxWorkingDir, this.hostnames);
        String pythonInterpreter = null;
        LanguageParams lp = this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
        if (lp instanceof PythonParams) {
            PythonParams pp = (PythonParams)lp;
            pythonInterpreter = pp.getPythonInterpreter();
        }
        StdIOStream streamValues = new StdIOStream();
        ArrayList<String> binaryParams = BinaryRunner.createCMDParametersFromValues(this.invocation.getParams(), this.invocation.getTarget(), streamValues, pythonInterpreter);
        int numMPIFlags = 0;
        String[] mpiflagsArray = null;
        if (this.mpiFlags == null || this.mpiFlags.isEmpty()) {
            mpiflagsArray = this.mpiFlags.split(" ");
            numMPIFlags = mpiflagsArray.length;
        }
        int numBasePythonMpiArgs = 8;
        String[] cmd = new String[(numBasePythonMpiArgs += numMPIFlags) + binaryParams.size()];
        cmd[0] = this.mpiRunner;
        cmd[1] = "-hostfile";
        cmd[2] = hostfile;
        cmd[3] = "-n";
        cmd[4] = this.scaleByCU ? String.valueOf(this.numWorkers * this.computingUnits) : String.valueOf(this.numWorkers);
        for (int i = 0; i < numMPIFlags; ++i) {
            cmd[5 + i] = mpiflagsArray[i];
        }
        cmd[numBasePythonMpiArgs - 3] = ((PythonParams)this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON)).getPythonInterpreter();
        String installDir = this.context.getInstallDir();
        String pycompssRelativePath = File.separator + "Bindings" + File.separator + "python";
        String pythonVersion = ((PythonParams)this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON)).getPythonVersion();
        String pyCOMPSsHome = installDir + pycompssRelativePath + File.separator + pythonVersion;
        cmd[numBasePythonMpiArgs - 2] = pyCOMPSsHome + File.separator + "pycompss" + File.separator + "worker" + File.separator + "external" + File.separator + "mpi_executor.py";
        int collectionLayoutNum = this.cl == null ? 0 : 1;
        int collectionLayoutParamsNum = collectionLayoutNum * 4;
        String collectionLayoutParams = " ";
        for (int i = 0; i < collectionLayoutParamsNum; i += 4) {
            collectionLayoutParams = collectionLayoutParams + this.cl.getParamName() + " ";
            collectionLayoutParams = collectionLayoutParams + Integer.toString(this.cl.getBlockCount()) + " ";
            collectionLayoutParams = collectionLayoutParams + Integer.toString(this.cl.getBlockLen()) + " ";
            collectionLayoutParams = collectionLayoutParams + Integer.toString(this.cl.getBlockStride()) + " ";
        }
        collectionLayoutParams = collectionLayoutParams + Integer.toString(collectionLayoutNum);
        cmd[numBasePythonMpiArgs - 1] = taskCMD + collectionLayoutParams;
        String pythonPath = System.getenv("PYTHONPATH");
        pythonPath = pyCOMPSsHome + ":" + pythonPath;
        for (int i = 0; i < binaryParams.size(); ++i) {
            cmd[numBasePythonMpiArgs + i] = binaryParams.get(i);
        }
        if (this.invocation.isDebugEnabled()) {
            PrintStream outLog = this.context.getThreadOutStream();
            outLog.println("");
            outLog.println("[Python MPI INVOKER] Begin MPI call to " + this.declaringclass + "." + this.alternativeMethod);
            outLog.println("[Python MPI INVOKER] On WorkingDir : " + this.taskSandboxWorkingDir.getAbsolutePath());
            outLog.print("[Python MPI INVOKER] MPI CMD: ");
            for (int i = 0; i < cmd.length; ++i) {
                outLog.print(cmd[i] + " ");
            }
            outLog.println("");
        }
        this.br = new BinaryRunner();
        return this.br.executeCMD(cmd, streamValues, this.taskSandboxWorkingDir, this.context.getThreadOutStream(), this.context.getThreadErrStream(), pythonPath, this.failByEV);
    }

    @Override
    public void cancelMethod() {
        LOGGER.debug("Cancelling PythonMPI process");
        if (this.br != null) {
            this.br.cancelProcess();
        }
    }
}

