/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers;

import es.bsc.compss.api.ApplicationRunner;
import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.execution.types.InvocationResources;
import es.bsc.compss.executor.InvocationRunner;
import es.bsc.compss.invokers.types.StdIOStream;
import es.bsc.compss.invokers.util.BinaryRunner;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.ExecType;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.tracing.TraceEventType;
import es.bsc.compss.util.Tracer;
import es.bsc.compss.worker.COMPSsException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Invoker
implements ApplicationRunner {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.Executor.Invoker");
    protected static final String ERROR_METHOD_DEFINITION = "Incorrect method definition for task of type ";
    protected static final String ERROR_TASK_EXECUTION = "ERROR: Exception executing task (user code)";
    protected static final String ERROR_UNKNOWN_TYPE = "ERROR: Unrecognised type ";
    public static final String COMPSS_NUM_NODES = "COMPSS_NUM_NODES";
    public static final String COMPSS_NODES = "COMPSS_NODES";
    public static final String COMPSS_HOSTNAMES = "COMPSS_HOSTNAMES";
    public static final String COMPSS_NUM_PROCS = "COMPSS_NUM_PROCS";
    public static final String COMPSS_NUM_THREADS = "COMPSS_NUM_THREADS";
    public static final String OMP_NUM_THREADS = "OMP_NUM_THREADS";
    public static final String IB_SUFFIX = "-ib0";
    protected final InvocationContext context;
    protected final Invocation invocation;
    protected InvocationRunner runner;
    protected final File taskSandboxWorkingDir;
    protected final InvocationResources assignedResources;
    protected final int computingUnits;
    protected final String workers;
    protected final int numWorkers;
    protected final List<String> hostnames;

    public Invoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, InvocationResources assignedResources) throws JobExecutionException {
        this.context = context;
        this.invocation = invocation;
        this.taskSandboxWorkingDir = taskSandboxWorkingDir;
        this.assignedResources = assignedResources;
        ResourceDescription rd = this.invocation.getRequirements();
        if (this.invocation.getTaskType() == TaskType.METHOD) {
            boolean mpiImpl = false;
            AbstractMethodImplementation impl = this.invocation.getMethodImplementation();
            if (impl.getMethodType() == MethodType.PYTHON_MPI || impl.getMethodType() == MethodType.MPI) {
                mpiImpl = true;
            }
            this.computingUnits = impl.isIO() && mpiImpl ? ((MethodResourceDescription)rd).getTotalMPIComputingUnits() : ((MethodResourceDescription)rd).getTotalCPUComputingUnits();
        } else {
            this.computingUnits = 0;
        }
        this.hostnames = invocation.getSlaveNodesNames();
        this.hostnames.add(context.getHostName());
        this.numWorkers = this.hostnames.size();
        this.workers = Invoker.buildWorkersString(this.hostnames, this.computingUnits);
        AbstractMethodImplementation impl = invocation.getMethodImplementation();
        for (InvocationParam np : invocation.getParams()) {
            this.processParameter(np);
        }
        if (invocation.getTarget() != null) {
            this.processParameter(invocation.getTarget());
        }
        if (invocation.isDebugEnabled()) {
            PrintStream out = context.getThreadOutStream();
            out.println("WORKER - Parameters of execution:");
            out.println("  * Method type: " + (Object)((Object)impl.getMethodType()));
            out.println("  * Method definition: " + impl.getMethodDefinition());
            out.print("  * Parameter types:");
            for (InvocationParam p : invocation.getParams()) {
                if (p.getValueClass() == null) continue;
                out.print(" " + p.getValueClass().getName());
            }
            out.println("");
            out.print("  * Parameter values:");
            for (InvocationParam p : invocation.getParams()) {
                out.print(" " + p.getValue());
            }
            out.println("");
            out.print("  * Parameter streams:");
            for (InvocationParam p : invocation.getParams()) {
                out.print(" " + (Object)((Object)p.getStdIOStream()));
            }
            if (invocation.getTarget() != null) {
                out.print(" " + (Object)((Object)invocation.getTarget().getStdIOStream()));
            }
            out.println("");
            out.print("  * Parameter prefixes:");
            for (InvocationParam p : invocation.getParams()) {
                out.print(" " + p.getPrefix());
            }
            if (invocation.getTarget() != null) {
                out.print(" " + invocation.getTarget().getPrefix());
            }
            out.println("");
            out.println("  * Has Target: " + (invocation.getTarget() != null));
            out.println("  * Has Return: " + !invocation.getResults().isEmpty());
        }
    }

    private static String buildWorkersString(List<String> hostnames, int computingUnits) {
        boolean firstElement = true;
        StringBuilder hostnamesSTR = new StringBuilder();
        for (String hostname : hostnames) {
            int i;
            if (hostname.endsWith(IB_SUFFIX)) {
                hostname = hostname.substring(0, hostname.lastIndexOf(IB_SUFFIX));
            }
            if (firstElement) {
                firstElement = false;
                hostnamesSTR.append(hostname);
                for (i = 1; i < computingUnits; ++i) {
                    hostnamesSTR.append(",").append(hostname);
                }
                continue;
            }
            for (i = 0; i < computingUnits; ++i) {
                hostnamesSTR.append(",").append(hostname);
            }
        }
        return hostnamesSTR.toString();
    }

    private void processParameter(InvocationParam np) throws JobExecutionException {
        try {
            this.context.loadParam(np);
            Object obj = np.getValue();
            switch (np.getType()) {
                case BOOLEAN_T: {
                    np.setValueClass(Boolean.TYPE);
                    break;
                }
                case CHAR_T: {
                    np.setValueClass(Character.TYPE);
                    break;
                }
                case BYTE_T: {
                    np.setValueClass(Byte.TYPE);
                    break;
                }
                case SHORT_T: {
                    np.setValueClass(Short.TYPE);
                    break;
                }
                case INT_T: {
                    np.setValueClass(Integer.TYPE);
                    break;
                }
                case LONG_T: {
                    np.setValueClass(Long.TYPE);
                    break;
                }
                case FLOAT_T: {
                    np.setValueClass(Float.TYPE);
                    break;
                }
                case DOUBLE_T: {
                    np.setValueClass(Double.TYPE);
                    break;
                }
                case STRING_T: 
                case STRING_64_T: 
                case DIRECTORY_T: 
                case FILE_T: 
                case BINDING_OBJECT_T: 
                case EXTERNAL_STREAM_T: 
                case EXTERNAL_PSCO_T: {
                    np.setValueClass(String.class);
                    break;
                }
                case OBJECT_T: 
                case COLLECTION_T: 
                case DICT_COLLECTION_T: 
                case STREAM_T: 
                case PSCO_T: {
                    if (obj != null) {
                        np.setValueClass(obj.getClass());
                    }
                    break;
                }
                case NULL_T: {
                    np.setValue((Object)"None");
                    break;
                }
                default: {
                    throw new JobExecutionException(ERROR_UNKNOWN_TYPE + (Object)((Object)np.getType()));
                }
            }
        }
        catch (Exception e) {
            throw new JobExecutionException(e.getMessage(), (Throwable)e);
        }
    }

    public void runInvocation(InvocationRunner runner) throws JobExecutionException, COMPSsException {
        this.runner = runner;
        this.invoke();
        try {
            this.storeFinalValues();
        }
        catch (COMPSsException ee) {
            throw new COMPSsException(ee.getMessage());
        }
        catch (Exception e) {
            throw new JobExecutionException("Error storing a task result", (Throwable)e);
        }
    }

    public void serializeBinaryExitValue(InvocationParam returnParam, Object exitValue) throws JobExecutionException {
        LOGGER.debug("Checking binary exit value serialization");
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("- Param Type: " + returnParam.getType().name());
            LOGGER.debug("- Preserve source data: " + returnParam.isPreserveSourceData());
            LOGGER.debug("- Write final value: " + returnParam.isWriteFinalValue());
            LOGGER.debug("- Prefix: " + returnParam.getPrefix());
        }
        if (returnParam.getType().equals((Object)DataType.FILE_T)) {
            String renaming = returnParam.getOriginalName();
            LOGGER.info("Writing Binary Exit Value (" + exitValue.toString() + ") to " + renaming);
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(renaming));){
                String value = "0000I" + exitValue + "\n.\n";
                writer.write(value);
                writer.flush();
            }
            catch (IOException ioe) {
                throw new JobExecutionException("ERROR: Cannot serialize binary exit value for bindings", (Throwable)ioe);
            }
        }
    }

    private void storeFinalValues() throws Exception {
        for (InvocationParam np : this.invocation.getParams()) {
            this.storeValue(np);
        }
        if (this.invocation.getTarget() != null) {
            this.storeValue(this.invocation.getTarget());
        }
        for (InvocationParam np : this.invocation.getResults()) {
            this.storeValue(np);
        }
    }

    private void storeValue(InvocationParam np) throws Exception {
        if (np.isWriteFinalValue()) {
            this.context.storeParam(np);
        }
    }

    private void invoke() throws JobExecutionException, COMPSsException {
        this.emitStartTask();
        try {
            this.setEnvironmentVariables();
            ExecType prolog = this.invocation.getMethodImplementation().getDescription().getProlog();
            this.executeBinary(prolog);
            this.invokeMethod();
            ExecType epilog = this.invocation.getMethodImplementation().getDescription().getEpilog();
            this.executeBinary(epilog);
        }
        catch (JobExecutionException jee) {
            throw jee;
        }
        catch (COMPSsException e) {
            throw e;
        }
        catch (InvokeExecutionException e) {
            throw new JobExecutionException((Throwable)e);
        }
        finally {
            this.emitEndTask();
        }
    }

    public void cancel() {
        this.cancelMethod();
    }

    protected void setEnvironmentVariables() {
        System.setProperty("COMPSS_TASK_ID", String.valueOf(this.invocation.getTaskId()));
        System.setProperty(COMPSS_NUM_NODES, String.valueOf(this.numWorkers));
        System.setProperty(COMPSS_HOSTNAMES, this.workers);
        System.setProperty(COMPSS_NODES, Invoker.buildWorkersString(this.hostnames, 1));
        System.setProperty(COMPSS_NUM_THREADS, String.valueOf(this.computingUnits));
        System.setProperty(COMPSS_NUM_PROCS, "1");
        System.setProperty(OMP_NUM_THREADS, String.valueOf(this.computingUnits));
        if (LOGGER.isDebugEnabled()) {
            System.out.println("[INVOKER] COMPSS_HOSTNAMES: " + this.workers);
            System.out.println("[INVOKER] COMPSS_NUM_NODES: " + this.numWorkers);
            System.out.println("[INVOKER] COMPSS_NUM_THREADS: " + this.computingUnits);
            System.out.println("[INVOKER] COMPSS_NUM_PROCS: 1");
        }
    }

    private void emitStartTask() {
        if (Tracer.isActivated()) {
            int coreId = this.invocation.getMethodImplementation().getCoreId() + 1;
            int taskId = this.invocation.getTaskId();
            Tracer.emitEventAndCounters((TraceEventType)TraceEventType.TASKS_FUNC, (int)coreId);
            Tracer.emitEvent((TraceEventType)TraceEventType.TASKS_ID, (long)taskId);
        }
    }

    private void emitEndTask() {
        if (Tracer.isActivated()) {
            Tracer.emitEventEndAndCounters((TraceEventType)TraceEventType.TASKS_FUNC);
            Tracer.emitEventEnd((TraceEventType)TraceEventType.TASKS_ID);
        }
    }

    protected abstract void invokeMethod() throws JobExecutionException, COMPSsException;

    protected abstract void cancelMethod();

    private Object executeBinary(ExecType executable) throws InvokeExecutionException {
        if (executable == null || !executable.isAssigned()) {
            return new Object();
        }
        BinaryRunner br = new BinaryRunner();
        String[] params = BinaryRunner.buildAppParams(this.invocation.getParams(), executable.getParams(), null);
        String[] cmd = new String[1 + params.length];
        cmd[0] = executable.getBinary();
        System.arraycopy(params, 0, cmd, 1, params.length);
        return br.executeCMD(cmd, new StdIOStream(), this.taskSandboxWorkingDir, this.context.getThreadOutStream(), this.context.getThreadErrStream(), null, executable.isFailByExitValue());
    }

    @Override
    public void stalledApplication() {
        this.runner.stalledCodeExecution();
    }

    @Override
    public void readyToContinue(Semaphore sem) {
        this.runner.readyToContinueExecution(sem);
    }
}

