/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.api.COMPSsRuntime;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.comm.CommAdaptor;
import es.bsc.compss.data.BindingDataManager;
import es.bsc.compss.exceptions.AnnounceException;
import es.bsc.compss.exceptions.CannotLoadException;
import es.bsc.compss.invokers.types.CParams;
import es.bsc.compss.invokers.types.JavaParams;
import es.bsc.compss.invokers.types.PythonParams;
import es.bsc.compss.loader.LoaderAPI;
import es.bsc.compss.local.LocalJob;
import es.bsc.compss.local.LocalParameter;
import es.bsc.compss.log.LoggerManager;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.NodeMonitor;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.BindingObjectLocation;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.LocationType;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.operation.DataOperation;
import es.bsc.compss.types.data.operation.copy.CompletedCopyException;
import es.bsc.compss.types.data.operation.copy.Copy;
import es.bsc.compss.types.execution.Execution;
import es.bsc.compss.types.execution.ExecutionListener;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.LanguageParams;
import es.bsc.compss.types.execution.exceptions.InitializationException;
import es.bsc.compss.types.execution.exceptions.UnloadableValueException;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobEndStatus;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.ExecutorShutdownListener;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.FileOpsManager;
import es.bsc.compss.util.serializers.Serializer;
import es.bsc.compss.utils.execution.ExecutionManager;
import es.bsc.compss.utils.execution.ThreadedPrintStream;
import es.bsc.compss.worker.COMPSsException;
import es.bsc.distrostreamlib.server.types.StreamBackend;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import storage.StorageException;
import storage.StorageItf;
import storage.StubItf;

public final class COMPSsMaster
extends COMPSsWorker
implements InvocationContext {
    private static final String ERROR_TEMP_DIR = "ERROR: Cannot create temp directory";
    private static final String ERROR_JOBS_DIR = "ERROR: Cannot create jobs directory";
    private static final String ERROR_WORKERS_DIR = "ERROR: Cannot create workers directory";
    private static final String EXECUTION_MANAGER_ERR = "Error starting ExecutionManager";
    public static final String SUFFIX_OUT = ".out";
    public static final String SUFFIX_ERR = ".err";
    private COMPSsRuntime runtimeApi;
    private LoaderAPI loaderApi;
    private final String storageConf;
    private final COMPSsConstants.TaskExecution executionType;
    private final String installDirPath;
    private final String appDirPath;
    private final String tempDirPath;
    private final String jobsDirPath;
    private final String workersDirPath;
    private final LanguageParams[] langParams = new LanguageParams[COMPSsConstants.Lang.values().length];
    private boolean persistentEnabled;
    private ExecutionManager executionManager;
    private final ThreadedPrintStream out;
    private final ThreadedPrintStream err;
    private boolean started = false;

    public COMPSsMaster(NodeMonitor monitor) {
        super(monitor);
        String pythonCacheProfiler;
        String pythonWorkerCache;
        String pythonMpiWorker;
        String pythonExtraeFile;
        String pythonPath;
        String pythonPropagateVEnv;
        String pythonVEnv;
        String pythonVersion;
        String appDir;
        LoggerManager.init();
        String appLogDirPath = LoggerManager.getAppLogDirPath();
        this.tempDirPath = appLogDirPath + "tmpFiles" + File.separator;
        if (!new File(this.tempDirPath).mkdirs()) {
            ErrorManager.error(ERROR_TEMP_DIR);
        }
        this.jobsDirPath = appLogDirPath + "jobs" + File.separator;
        if (!new File(this.jobsDirPath).mkdirs()) {
            ErrorManager.error(ERROR_JOBS_DIR);
        }
        this.workersDirPath = appLogDirPath + "workers" + File.separator;
        if (!new File(this.workersDirPath).mkdirs()) {
            System.err.println(ERROR_WORKERS_DIR);
            System.exit(1);
        }
        this.runtimeApi = null;
        this.loaderApi = null;
        String storageConf = System.getProperty("compss.storage.conf");
        if (storageConf == null || storageConf.equals("") || storageConf.equals("null")) {
            storageConf = "null";
            LOGGER.warn("No storage configuration file passed");
        }
        this.storageConf = storageConf;
        String executionType = System.getProperty("compss.task.execution");
        if (executionType == null || executionType.equals("") || executionType.equals("null")) {
            executionType = COMPSsConstants.TaskExecution.COMPSS.toString();
            LOGGER.warn("No executionType passed");
        } else {
            executionType = executionType.toUpperCase();
        }
        this.executionType = COMPSsConstants.TaskExecution.valueOf(executionType);
        this.out = new ThreadedPrintStream(SUFFIX_OUT, System.out);
        this.err = new ThreadedPrintStream(SUFFIX_ERR, System.err);
        System.setErr(this.err);
        System.setOut(this.out);
        this.installDirPath = System.getenv("COMPSS_HOME");
        String classPath = System.getProperty("compss.worker.cp");
        if (classPath == null || classPath.isEmpty()) {
            classPath = "";
        }
        if ((appDir = System.getProperty("compss.worker.appdir")) == null || appDir.isEmpty()) {
            appDir = "";
        }
        this.appDirPath = appDir;
        String pythonInterpreter = System.getProperty("compss.python.interpreter");
        if (pythonInterpreter == null || pythonInterpreter.isEmpty() || pythonInterpreter.equals("null")) {
            pythonInterpreter = "python3";
        }
        if ((pythonVersion = System.getProperty("compss.python.version")) == null || pythonVersion.isEmpty() || pythonVersion.equals("null")) {
            pythonVersion = "3";
        }
        if ((pythonVEnv = System.getProperty("compss.python.virtualenvironment")) == null || pythonVEnv.isEmpty() || pythonVEnv.equals("null")) {
            pythonVEnv = "null";
        }
        if ((pythonPropagateVEnv = System.getProperty("compss.python.propagate_virtualenvironment")) == null || pythonPropagateVEnv.isEmpty() || pythonPropagateVEnv.equals("null")) {
            pythonPropagateVEnv = "true";
        }
        if ((pythonPath = System.getProperty("compss.worker.pythonpath")) == null || pythonPath.isEmpty()) {
            pythonPath = "";
        }
        if ((pythonExtraeFile = System.getProperty("compss.extrae.file.python")) == null || pythonExtraeFile.isEmpty() || pythonExtraeFile.equals("null")) {
            pythonExtraeFile = "null";
        }
        if ((pythonMpiWorker = System.getProperty("compss.python.mpi_worker")) == null || pythonMpiWorker.isEmpty() || pythonMpiWorker.equals("null")) {
            pythonMpiWorker = "false";
        }
        if ((pythonWorkerCache = System.getProperty("compss.python.worker_cache")) == null || pythonWorkerCache.isEmpty() || pythonWorkerCache.equals("null")) {
            pythonWorkerCache = "false";
        }
        if ((pythonCacheProfiler = System.getProperty("compss.python.cache_profiler")) == null || pythonCacheProfiler.isEmpty() || pythonCacheProfiler.equals("null")) {
            pythonCacheProfiler = "false";
        }
        JavaParams javaParams = new JavaParams(classPath);
        PythonParams pyParams = new PythonParams(pythonInterpreter, pythonVersion, pythonVEnv, pythonPropagateVEnv, pythonPath, pythonExtraeFile, pythonMpiWorker, pythonWorkerCache, pythonCacheProfiler);
        CParams cParams = new CParams(classPath);
        this.langParams[COMPSsConstants.Lang.JAVA.ordinal()] = javaParams;
        this.langParams[COMPSsConstants.Lang.PYTHON.ordinal()] = pyParams;
        this.langParams[COMPSsConstants.Lang.C.ordinal()] = cParams;
        String workerPersistentC = System.getProperty("compss.worker.persistent.c");
        if (workerPersistentC == null || workerPersistentC.isEmpty() || workerPersistentC.equals("null")) {
            workerPersistentC = "false";
        }
        this.persistentEnabled = workerPersistentC.toUpperCase().compareTo("TRUE") == 0;
        boolean reuse = Boolean.parseBoolean(System.getProperty("compss.execution.reuseOnBlock"));
        this.executionManager = new ExecutionManager(this, 0, "disabled", reuse, 0, "disabled", 0, "disabled", 0, 0);
        try {
            this.executionManager.init();
        }
        catch (InitializationException ie) {
            ErrorManager.error(EXECUTION_MANAGER_ERR, (Exception)((Object)ie));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        COMPSsMaster cOMPSsMaster = this;
        synchronized (cOMPSsMaster) {
            if (this.started) {
                return;
            }
            this.started = true;
        }
    }

    public String getName() {
        return MASTER_NAME;
    }

    public void setInternalURI(MultiURI u) {
        for (CommAdaptor adaptor : Comm.getAdaptors().values()) {
            adaptor.completeMasterURI(u);
        }
    }

    public void stop(ShutdownListener sl) {
        sl.notifyEnd();
    }

    public void sendData(LogicalData ld, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        for (Resource targetRes : target.getHosts()) {
            COMPSsNode node = targetRes.getNode();
            if (node == this) continue;
            try {
                node.obtainData(ld, source, target, tgtData, reason, listener);
            }
            catch (Exception e) {
                continue;
            }
            return;
        }
    }

    public void obtainBindingData(final LogicalData ld, DataLocation source, final DataLocation target, final LogicalData tgtData, final Transferable reason, final EventListener listener) {
        COMPSsNode node;
        final BindingObject tgtBO = ((BindingObjectLocation)target).getBindingObject();
        Collection copiesInProgress = ld.getCopiesInProgress();
        if (copiesInProgress != null && !copiesInProgress.isEmpty()) {
            for (final Copy copy : copiesInProgress) {
                if (copy == null) continue;
                if (copy.getTargetLoc() != null && copy.getTargetLoc().getHosts().contains(Comm.getAppHost())) {
                    if (DEBUG) {
                        LOGGER.debug("Copy in progress tranfering " + ld.getName() + "to master. Waiting for finishing");
                    }
                    copy.addEventListener(new EventListener(){

                        public void notifyEnd(DataOperation fOp) {
                            if (COMPSsNode.DEBUG) {
                                COMPSsNode.LOGGER.debug("Master local copy " + ld.getName() + " from " + copy.getFinalTarget() + " to " + tgtBO.getName());
                            }
                            try {
                                if (COMPSsMaster.this.persistentEnabled) {
                                    COMPSsMaster.this.manageObtainBindingObjectInCache(copy.getFinalTarget(), tgtBO, tgtData, target, reason);
                                } else {
                                    COMPSsMaster.this.manageObtainBindingObjectAsFile(copy.getFinalTarget(), tgtBO, tgtData, target, reason);
                                }
                                listener.notifyEnd(null);
                            }
                            catch (Exception e) {
                                COMPSsNode.LOGGER.error("ERROR: managing obtain binding object at cache", (Throwable)e);
                                listener.notifyFailure(fOp, e);
                            }
                        }

                        public void notifyFailure(DataOperation fOp, Exception e) {
                            if (COMPSsNode.DEBUG) {
                                COMPSsNode.LOGGER.debug("Master local copy " + ld.getName() + " from " + copy.getFinalTarget() + " to " + tgtBO.getName());
                            }
                            COMPSsNode.LOGGER.error("ERROR: managing obtain binding object at cache", (Throwable)e);
                            listener.notifyFailure(fOp, e);
                        }
                    });
                    return;
                }
                if (!DEBUG) continue;
                LOGGER.debug("Current copies are not transfering " + ld.getName() + " to master. Ignoring at this moment");
            }
        }
        if (DEBUG) {
            LOGGER.debug("Checking if " + ld.getName() + " is at master (" + Comm.getAppHost().getName() + ").");
        }
        for (MultiURI u : ld.getURIs()) {
            String hostname;
            if (DEBUG) {
                hostname = u.getHost() != null ? u.getHost().getName() : "null";
                LOGGER.debug(ld.getName() + " is at " + u.toString() + "(" + hostname + ")");
            }
            if (u.getHost() == Comm.getAppHost()) {
                if (DEBUG) {
                    LOGGER.debug("Master local copy " + ld.getName() + " from " + u.getHost().getName() + " to " + tgtBO.getName());
                }
                try {
                    if (this.persistentEnabled) {
                        this.manageObtainBindingObjectInCache(u.getPath(), tgtBO, tgtData, target, reason);
                    } else {
                        this.manageObtainBindingObjectAsFile(u.getPath(), tgtBO, tgtData, target, reason);
                    }
                    listener.notifyEnd(null);
                }
                catch (Exception e) {
                    LOGGER.error("ERROR: managing obtain binding object at cache", (Throwable)e);
                    listener.notifyFailure(null, e);
                }
                return;
            }
            if (!DEBUG) continue;
            hostname = u.getHost() != null ? u.getHost().getName() : "null";
            LOGGER.debug("Data " + ld.getName() + " copy in " + hostname + " not evaluated now");
        }
        if (source != null) {
            for (Resource sourceRes : source.getHosts()) {
                node = sourceRes.getNode();
                String sourcePath = source.getURIInHost(sourceRes).getPath();
                if (node != this) {
                    try {
                        if (DEBUG) {
                            LOGGER.debug("Sending data " + ld.getName() + " from (" + node.getName() + ") " + sourcePath + " to (master) " + tgtBO.getName());
                        }
                        node.sendData(ld, source, target, tgtData, reason, listener);
                    }
                    catch (Exception e) {
                        ErrorManager.warn("Not possible to sending data master to " + tgtBO.getName(), e);
                        continue;
                    }
                    LOGGER.debug("Data " + ld.getName() + " sent.");
                    return;
                }
                try {
                    if (this.persistentEnabled) {
                        this.manageObtainBindingObjectInCache(sourcePath, tgtBO, tgtData, target, reason);
                    } else {
                        this.manageObtainBindingObjectAsFile(sourcePath, tgtBO, tgtData, target, reason);
                    }
                    listener.notifyEnd(null);
                }
                catch (Exception e) {
                    LOGGER.error("ERROR: managing obtain binding object at cache", (Throwable)e);
                    listener.notifyFailure(null, e);
                }
                return;
            }
        } else {
            LOGGER.debug("Source data location is null. Trying other alternatives");
        }
        for (Resource sourceRes : ld.getAllHosts()) {
            node = sourceRes.getNode();
            if (node != this) {
                try {
                    LOGGER.debug("Sending data " + ld.getName() + " from (" + node.getName() + ") " + sourceRes.getName() + " to (master)" + tgtBO.getName());
                    node.sendData(ld, source, target, tgtData, reason, listener);
                }
                catch (Exception e) {
                    LOGGER.error("Error: exception sending data", (Throwable)e);
                    continue;
                }
                LOGGER.debug("Data " + ld.getName() + " sent.");
                return;
            }
            if (!DEBUG) continue;
            LOGGER.debug("Data " + ld.getName() + " copy in " + sourceRes.getName() + " not evaluated now. Should have been evaluated before");
        }
        LOGGER.warn("WARN: All posibilities checked for obtaining data " + ld.getName() + " and nothing done. Releasing listeners and locks");
        listener.notifyEnd(null);
    }

    private void manageObtainBindingObjectInCache(String initialPath, BindingObject tgtBO, LogicalData tgtData, DataLocation target, Transferable reason) throws Exception {
        BindingObject bo = BindingObject.generate(initialPath);
        if (bo.getName().equals(tgtBO.getName())) {
            if (BindingDataManager.isInBinding((String)tgtBO.getName())) {
                LOGGER.debug("Current transfer is the same as expected. Nothing to do setting data target to " + initialPath);
                reason.setDataTarget(initialPath);
            } else {
                String tgtPath = this.getCompletePath(DataType.BINDING_OBJECT_T, tgtBO.getName()).getPath();
                LOGGER.debug("Data " + tgtBO.getName() + " not in cache loading from file " + tgtPath);
                if (BindingDataManager.loadFromFile((String)tgtBO.getName(), (String)tgtPath, (int)tgtBO.getType(), (int)tgtBO.getElements()) != 0) {
                    throw new Exception("Error loading object " + tgtBO.getName() + " from " + tgtPath);
                }
                reason.setDataTarget(target.getPath());
            }
        } else {
            if (BindingDataManager.isInBinding((String)tgtBO.getName())) {
                LOGGER.debug("Making cache copy from " + bo.getName() + " to " + tgtBO.getName());
                if (reason.isSourcePreserved()) {
                    if (BindingDataManager.copyCachedData((String)bo.getName(), (String)tgtBO.getName()) != 0) {
                        throw new Exception("Error copying cache from " + bo.getName() + " to " + tgtBO.getName());
                    }
                } else if (BindingDataManager.moveCachedData((String)bo.getName(), (String)tgtBO.getName()) != 0) {
                    throw new Exception("Error moved cache from " + bo.getName() + " to " + tgtBO.getName());
                }
            } else {
                String tgtPath = this.getCompletePath(DataType.BINDING_OBJECT_T, tgtBO.getName()).getPath();
                LOGGER.debug("Data " + tgtBO.getName() + " not in cache loading from file " + tgtPath);
                if (BindingDataManager.loadFromFile((String)tgtBO.getName(), (String)tgtPath, (int)tgtBO.getType(), (int)tgtBO.getElements()) != 0) {
                    throw new Exception("Error loading object " + tgtBO.getName() + " from " + tgtPath);
                }
            }
            if (tgtData != null) {
                tgtData.addLocation(target);
            }
            LOGGER.debug("BindingObject copied/moved set data target as " + target.getPath());
            reason.setDataTarget(target.getPath());
        }
    }

    private void manageObtainBindingObjectAsFile(String initialPath, BindingObject tgtBO, LogicalData tgtData, DataLocation target, Transferable reason) throws Exception {
        BindingObject bo = BindingObject.generate(initialPath);
        if (bo.getName().equals(tgtBO.getName())) {
            LOGGER.debug("Current transfer is the same as expected. Nothing to do setting data target to " + initialPath);
            reason.setDataTarget(initialPath);
        } else {
            if (bo.getId().startsWith(File.separator)) {
                String iPath = this.getCompletePath(DataType.BINDING_OBJECT_T, bo.getName()).getPath();
                String tPath = this.getCompletePath(DataType.BINDING_OBJECT_T, tgtBO.getName()).getPath();
                if (reason.isSourcePreserved()) {
                    if (DEBUG) {
                        LOGGER.debug("Master local copy of data" + bo.getName() + " from " + iPath + " to " + tPath);
                    }
                    Files.copy(new File(iPath).toPath(), new File(tPath).toPath(), StandardCopyOption.REPLACE_EXISTING);
                } else {
                    if (DEBUG) {
                        LOGGER.debug("Master local move of data " + bo.getName() + " from " + iPath + " to " + tPath);
                    }
                    Files.move(new File(iPath).toPath(), new File(tPath).toPath(), StandardCopyOption.REPLACE_EXISTING);
                }
            } else if (BindingDataManager.isInBinding((String)bo.getName())) {
                String tPath = this.getCompletePath(DataType.BINDING_OBJECT_T, tgtBO.getName()).getPath();
                LOGGER.debug("Storing object data " + bo.getName() + " from cache to " + tPath);
                BindingDataManager.storeInFile((String)bo.getName(), (String)tPath);
            } else {
                throw new Exception("Data " + bo.getName() + "not a filepath and its not in cache");
            }
            if (tgtData != null) {
                tgtData.addLocation(target);
            }
            LOGGER.debug("BindingObject as file copied/moved set data target as " + target.getPath());
            reason.setDataTarget(target.getPath());
        }
        LOGGER.debug(" Checking if BindingObject " + tgtBO.getId() + " has relative path");
        if (!tgtBO.getId().startsWith(File.separator)) {
            LOGGER.debug("Loading BindingObject " + tgtBO.getName() + " to cache...");
            String tgtPath = this.getCompletePath(DataType.BINDING_OBJECT_T, tgtBO.getName()).getPath();
            if (BindingDataManager.loadFromFile((String)tgtBO.getName(), (String)tgtPath, (int)tgtBO.getType(), (int)tgtBO.getElements()) != 0) {
                throw new Exception("Error loading object " + tgtBO.getName() + " from " + tgtPath);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void obtainFileData(LogicalData ld, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        Set hosts;
        Collection copiesInProgress;
        String targetPath = target.getURIInHost((Resource)Comm.getAppHost()).getPath();
        List uris = ld.getURIs();
        for (Object u : uris) {
            if (DEBUG) {
                String hostname = u.getHost() != null ? u.getHost().getName() : "null";
                LOGGER.debug(ld.getName() + " is at " + u.toString() + "(" + hostname + ")");
            }
            if (u.getHost().getNode() != this || targetPath.compareTo(u.getPath()) != 0) continue;
            LOGGER.debug(ld.getName() + " is already at " + targetPath);
            reason.setDataTarget(targetPath);
            listener.notifyEnd(null);
            return;
        }
        if (DEBUG) {
            LOGGER.debug("Data " + ld.getName() + " not in memory. Checking if there is a copy to the master in progress");
        }
        if ((copiesInProgress = ld.getCopiesInProgress()) != null && !copiesInProgress.isEmpty()) {
            for (Copy copy : copiesInProgress) {
                if (copy == null || copy.getTargetLoc() == null || !copy.getTargetLoc().getHosts().contains(Comm.getAppHost())) continue;
                try {
                    if (target.getProtocol() == ProtocolType.OBJECT_URI && ld.isAlias(tgtData)) {
                        reason.setDataTarget(targetPath);
                        copy.addEventListener(listener);
                    } else {
                        copy.addSiblingCopy(targetPath, target, tgtData, reason, listener);
                    }
                    if (DEBUG) {
                        LOGGER.debug("Copy in progress tranfering " + ld.getName() + "to master. Waiting for finishing");
                    }
                    return;
                }
                catch (CompletedCopyException completedCopyException) {
                }
            }
        }
        if (DEBUG) {
            LOGGER.debug("Checking if " + ld.getName() + " is at master (" + Comm.getAppHost().getName() + ").");
        }
        for (MultiURI u : uris) {
            String hostname;
            if (DEBUG) {
                hostname = u.getHost() != null ? u.getHost().getName() : "null";
                LOGGER.debug(ld.getName() + " is at " + u.toString() + "(" + hostname + ")");
            }
            if (u.getHost().getNode() == this) {
                try {
                    if (DEBUG) {
                        LOGGER.debug("Data " + ld.getName() + " is already accessible at " + u.getPath());
                    }
                    if (reason.isSourcePreserved() || ld.countKnownAlias() > 1) {
                        if (DEBUG) {
                            LOGGER.debug("Master local copy " + ld.getName() + " from " + u.getHost().getName() + " to " + targetPath);
                        }
                        FileOpsManager.copySync((File)new File(u.getPath()), (File)new File(targetPath));
                    } else {
                        if (DEBUG) {
                            LOGGER.debug("Master local move " + ld.getName() + " from " + u.getHost().getName() + " to " + targetPath);
                        }
                        try {
                            SimpleURI deletedUri = new SimpleURI(u.getPath());
                            DataLocation loc = DataLocation.createLocation((Resource)Comm.getAppHost(), (SimpleURI)deletedUri);
                            LogicalData logicalData = ld;
                            synchronized (logicalData) {
                                ld.removeLocation(loc);
                            }
                        }
                        catch (Exception e) {
                            ErrorManager.error("ERROR: Invalid location URI " + targetPath, e);
                        }
                        FileOpsManager.moveSync((File)new File(u.getPath()), (File)new File(targetPath));
                    }
                    if (tgtData != null) {
                        LogicalData e = tgtData;
                        synchronized (e) {
                            tgtData.addLocation(target);
                        }
                    }
                    LOGGER.debug("File on path. Set data target to " + targetPath);
                    reason.setDataTarget(targetPath);
                    listener.notifyEnd(null);
                    return;
                }
                catch (IOException ex) {
                    ErrorManager.warn("Error master local copy file from " + u.getPath() + " to " + targetPath + " with replacing", ex);
                    continue;
                }
            }
            if (!DEBUG) continue;
            hostname = u.getHost() != null ? u.getHost().getName() : "null";
            LOGGER.debug("Data " + ld.getName() + " copy in " + hostname + " not evaluated now");
        }
        if (source != null) {
            for (Resource sourceRes : source.getHosts()) {
                COMPSsNode node = sourceRes.getNode();
                String sourcePath = source.getURIInHost(sourceRes).getPath();
                if (node != this) {
                    try {
                        if (DEBUG) {
                            LOGGER.debug("Sending data " + ld.getName() + " from " + sourcePath + " to " + targetPath);
                        }
                        node.sendData(ld, source, target, tgtData, reason, listener);
                    }
                    catch (Exception e) {
                        ErrorManager.warn("Not possible to sending data master to " + targetPath, e);
                        continue;
                    }
                    LOGGER.debug("Data " + ld.getName() + " sent.");
                    return;
                }
                try {
                    if (DEBUG) {
                        LOGGER.debug("Local copy " + ld.getName() + " from " + sourcePath + " to " + targetPath);
                    }
                    FileOpsManager.copySync((File)new File(sourcePath), (File)new File(targetPath));
                    LOGGER.debug("File copied. Set data target to " + targetPath);
                    reason.setDataTarget(targetPath);
                    listener.notifyEnd(null);
                    return;
                }
                catch (IOException ex) {
                    ErrorManager.warn("Error master local copy file from " + sourcePath + " to " + targetPath, ex);
                }
            }
        } else {
            LOGGER.debug("Source data location is null. Trying other alternatives");
        }
        LogicalData logicalData = ld;
        synchronized (logicalData) {
            hosts = ld.getAllHosts();
        }
        for (Resource sourceRes : hosts) {
            COMPSsNode node = sourceRes.getNode();
            if (node != this) {
                try {
                    LOGGER.debug("Sending data " + ld.getName() + " from " + sourceRes.getName() + " to " + targetPath);
                    node.sendData(ld, source, target, tgtData, reason, listener);
                }
                catch (Exception e) {
                    LOGGER.error("Error: exception sending data", (Throwable)e);
                    continue;
                }
                LOGGER.debug("Data " + ld.getName() + " sent.");
                return;
            }
            if (!DEBUG) continue;
            LOGGER.debug("Data " + ld.getName() + " copy in " + sourceRes.getName() + " not evaluated now. Should have been evaluated before");
        }
        ErrorManager.warn("Error file " + ld.getName() + " not transferred to " + targetPath);
        listener.notifyEnd(null);
    }

    public void obtainData(final LogicalData ld, final DataLocation source, final DataLocation target, final LogicalData tgtData, final Transferable reason, final EventListener listener) {
        LOGGER.info("Obtain Data " + ld.getName());
        if (DEBUG) {
            if (ld != null) {
                LOGGER.debug("srcData: " + ld.toString());
            }
            if (reason != null) {
                LOGGER.debug("Reason: " + (Object)((Object)reason.getType()));
            }
            if (source != null) {
                LOGGER.debug("Source Data location: " + source.getType().toString() + " " + source.getProtocol().toString() + " " + source.getURIs().get(0));
            }
            if (target != null) {
                if (target.getProtocol() != ProtocolType.PERSISTENT_URI) {
                    LOGGER.debug("Target Data location: " + target.getType().toString() + " " + target.getProtocol().toString() + " " + target.getURIs().get(0));
                } else {
                    LOGGER.debug("Target Data location: " + target.getType().toString() + " " + target.getProtocol().toString());
                }
            }
            if (tgtData != null) {
                LOGGER.debug("tgtData: " + tgtData.toString());
            }
        }
        if (reason != null && (reason.getType().equals((Object)DataType.COLLECTION_T) || reason.getType().equals((Object)DataType.DICT_COLLECTION_T))) {
            this.obtainCollection(ld, source, target, tgtData, reason, listener);
            return;
        }
        if (ld.isBindingData() || reason != null && reason.getType().equals((Object)DataType.BINDING_OBJECT_T) || source != null && source.getType().equals((Object)LocationType.BINDING) || target != null && target.getType().equals((Object)LocationType.BINDING)) {
            this.obtainBindingData(ld, source, target, tgtData, reason, listener);
            return;
        }
        String pscoId = ld.getPscoId();
        if (pscoId != null) {
            this.obtainPSCO(pscoId, reason, listener);
            return;
        }
        if (ld.isInMemory()) {
            final String targetPath = target.getURIInHost((Resource)Comm.getAppHost()).getPath();
            if (ld.isAlias(tgtData)) {
                LOGGER.debug("Object already in memory. Avoiding copy and setting dataTarget to " + targetPath);
                reason.setDataTarget(targetPath);
                listener.notifyEnd(null);
                return;
            }
            final SimpleURI serialURI = this.getCompletePath(DataType.FILE_T, targetPath);
            String serialPath = serialURI.getPath();
            LOGGER.debug("Serializing data " + ld.getName() + " to " + serialPath);
            Object o = ld.getValue();
            FileOpsManager.serializeAsync((Object)o, (String)serialPath, (FileOpsManager.FileOpListener)new FileOpsManager.FileOpListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void completed() {
                    if (tgtData != null) {
                        try {
                            DataLocation loc = DataLocation.createLocation((Resource)Comm.getAppHost(), (SimpleURI)serialURI);
                            LogicalData logicalData = tgtData;
                            synchronized (logicalData) {
                                tgtData.addLocation(loc);
                            }
                            COMPSsNode.LOGGER.debug("Object in memory. Set dataTarget to " + targetPath);
                            reason.setDataTarget(targetPath);
                            listener.notifyEnd(null);
                        }
                        catch (IOException ioe) {
                            this.failed(ioe);
                        }
                    }
                }

                public void failed(IOException e) {
                    ErrorManager.warn("Error copying file from memory to " + targetPath, e);
                    COMPSsMaster.this.obtainDataAsynch(ld, source, target, tgtData, reason, listener);
                }
            });
            return;
        }
        this.obtainDataAsynch(ld, source, target, tgtData, reason, listener);
    }

    private void obtainCollection(LogicalData ld, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        String targetPath;
        if (target != null) {
            targetPath = target.getURIInHost((Resource)Comm.getAppHost()).getPath();
        } else if (tgtData != null) {
            targetPath = tgtData.getName();
        } else {
            targetPath = ld.getName();
            LOGGER.warn("No target location neither target data available. Setting targetPath to " + ld.getName());
        }
        LOGGER.debug("Data " + ld.getName() + "is COLLECTION_T/DICT_COLLECTION_T nothing to tranfer. Elements already transferred.Setting target path to " + targetPath);
        reason.setDataTarget(targetPath);
        listener.notifyEnd(null);
    }

    private void obtainPSCO(String pscoId, Transferable reason, EventListener listener) {
        LOGGER.debug("Object in Persistent Storage. Set dataTarget to " + pscoId);
        reason.setDataTarget(pscoId);
        listener.notifyEnd(null);
    }

    private void obtainDataAsynch(final LogicalData ld, final DataLocation source, final DataLocation target, final LogicalData tgtData, final Transferable reason, final EventListener listener) {
        FileOpsManager.composedOperationAsync((Runnable)new Runnable(){

            @Override
            public void run() {
                COMPSsMaster.this.obtainFileData(ld, source, target, tgtData, reason, listener);
            }
        });
    }

    public void enforceDataObtaining(Transferable reason, EventListener listener) {
        listener.notifyEnd(null);
    }

    public Job<?> newJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener, List<Integer> predecessors, Integer numSuccessors) {
        return new LocalJob(taskId, taskParams, impl, res, slaveWorkersNodeNames, listener, predecessors, numSuccessors);
    }

    public SimpleURI getCompletePath(DataType type, String name) {
        String path = null;
        switch (type) {
            case DIRECTORY_T: {
                path = ProtocolType.DIR_URI.getSchema() + Comm.getAppHost().getTempDirPath() + name;
                break;
            }
            case FILE_T: {
                path = ProtocolType.FILE_URI.getSchema() + Comm.getAppHost().getTempDirPath() + name;
                break;
            }
            case OBJECT_T: {
                path = ProtocolType.OBJECT_URI.getSchema() + name;
                break;
            }
            case COLLECTION_T: {
                path = ProtocolType.OBJECT_URI.getSchema() + Comm.getAppHost().getTempDirPath() + name;
                break;
            }
            case DICT_COLLECTION_T: {
                path = ProtocolType.OBJECT_URI.getSchema() + Comm.getAppHost().getTempDirPath() + name;
                break;
            }
            case STREAM_T: {
                path = ProtocolType.STREAM_URI.getSchema() + name;
                break;
            }
            case EXTERNAL_STREAM_T: {
                path = ProtocolType.EXTERNAL_STREAM_URI.getSchema() + Comm.getAppHost().getTempDirPath() + name;
                break;
            }
            case PSCO_T: {
                path = ProtocolType.PERSISTENT_URI.getSchema() + name;
                break;
            }
            case EXTERNAL_PSCO_T: {
                path = ProtocolType.PERSISTENT_URI.getSchema() + name;
                break;
            }
            case BINDING_OBJECT_T: {
                path = ProtocolType.BINDING_URI.getSchema() + Comm.getAppHost().getTempDirPath() + name;
                break;
            }
            default: {
                return null;
            }
        }
        return new SimpleURI(path);
    }

    public void deleteTemporary() {
        File dir = new File(Comm.getAppHost().getTempDirPath());
        for (File f : dir.listFiles()) {
            this.deleteFolder(f);
        }
    }

    private void deleteFolder(File folder) {
        if (folder.isDirectory()) {
            for (File f : folder.listFiles()) {
                this.deleteFolder(f);
            }
        }
        if (!folder.delete()) {
            LOGGER.error("Error deleting file " + (folder == null ? "" : folder.getName()));
        }
    }

    public boolean generatePackage() {
        return false;
    }

    public boolean generateWorkersDebugInfo() {
        return false;
    }

    public void shutdownExecutionManager(ExecutorShutdownListener sl) {
        this.executionManager.stop();
        sl.notifyEnd();
    }

    public String getUser() {
        return "";
    }

    public String getClasspath() {
        return "";
    }

    public String getPythonpath() {
        return "";
    }

    public void updateTaskCount(int processorCoreCount) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void announceDestruction() throws AnnounceException {
    }

    public void announceCreation() throws AnnounceException {
    }

    public void runJob(final LocalJob job) {
        Execution exec = new Execution(job, new ExecutionListener(){

            @Override
            public void notifyEnd(Invocation invocation, boolean success, COMPSsException e) {
                for (LocalParameter p : job.getParams()) {
                    COMPSsMaster.this.updateParameter(p);
                }
                LocalParameter targetParam = job.getTarget();
                if (targetParam != null) {
                    COMPSsMaster.this.updateParameter(targetParam);
                }
                for (LocalParameter p : job.getResults()) {
                    COMPSsMaster.this.updateParameter(p);
                }
                job.profileEndNotification();
                if (success) {
                    job.completed();
                } else if (e != null) {
                    job.exception(e);
                } else {
                    job.failed(JobEndStatus.EXECUTION_FAILED);
                }
            }
        });
        this.executionManager.enqueue(exec);
    }

    private void updateParameter(LocalParameter lp) {
        String pscoId;
        DataType newType = lp.getType();
        switch (newType) {
            case PSCO_T: {
                pscoId = ((StubItf)lp.getValue()).getID();
                break;
            }
            case EXTERNAL_PSCO_T: {
                pscoId = (String)lp.getValue();
                break;
            }
            case BOOLEAN_T: 
            case CHAR_T: 
            case BYTE_T: 
            case SHORT_T: 
            case INT_T: 
            case LONG_T: 
            case FLOAT_T: 
            case DOUBLE_T: 
            case STRING_T: 
            case STRING_64_T: {
                return;
            }
            default: {
                pscoId = null;
            }
        }
        String tgtName = lp.getDataMgmtId();
        SimpleURI resultUri = this.getCompletePath(lp.getType(), tgtName);
        if (pscoId != null) {
            DataType previousType = lp.getOriginalType();
            if (previousType == DataType.PSCO_T || previousType == DataType.EXTERNAL_PSCO_T) {
                if (!previousType.equals((Object)newType)) {
                    LOGGER.warn("WARN: Cannot update parameter " + lp.getDataMgmtId() + " because types are not compatible");
                }
            } else {
                this.registerPersistedParameter(newType, pscoId, lp);
            }
        }
        DependencyParameter dp = (DependencyParameter)lp.getParam();
        dp.setType(newType);
        dp.setDataTarget(resultUri.toString());
    }

    private void registerPersistedParameter(DataType newType, String pscoId, LocalParameter lp) {
        String renaming = lp.getDataMgmtId();
        switch (newType) {
            case PSCO_T: {
                Comm.registerPSCO((String)renaming, (String)pscoId);
                break;
            }
            case EXTERNAL_PSCO_T: {
                if (renaming.contains("/")) {
                    renaming = renaming.substring(renaming.lastIndexOf(47) + 1);
                }
                Comm.registerExternalPSCO((String)renaming, (String)pscoId);
                break;
            }
            default: {
                LOGGER.warn("WARN: Invalid new type " + (Object)((Object)newType) + " for parameter " + renaming);
            }
        }
    }

    public String getHostName() {
        return MASTER_NAME;
    }

    public long getTracingHostID() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public String getAppDir() {
        return this.appDirPath;
    }

    public String getInstallDir() {
        return this.installDirPath;
    }

    public String getWorkingDir() {
        return this.tempDirPath;
    }

    public String getLogDir() {
        return LoggerManager.getAppLogDirPath();
    }

    public COMPSsConstants.TaskExecution getExecutionType() {
        return this.executionType;
    }

    public boolean isPersistentCEnabled() {
        return this.persistentEnabled;
    }

    public LanguageParams getLanguageParams(COMPSsConstants.Lang language) {
        return this.langParams[language.ordinal()];
    }

    public void registerOutputs(String path) {
        this.err.registerThread(path);
        this.out.registerThread(path);
    }

    public void unregisterOutputs() {
        this.err.unregisterThread();
        this.out.unregisterThread();
    }

    public String getStandardStreamsPath(Invocation invocation) {
        return Comm.getAppHost().getJobsDirPath() + File.separator + "job" + invocation.getJobId() + "_" + invocation.getHistory();
    }

    public PrintStream getThreadOutStream() {
        return this.out.getStream();
    }

    public PrintStream getThreadErrStream() {
        return this.err.getStream();
    }

    public String getStorageConf() {
        return this.storageConf;
    }

    public StreamBackend getStreamingBackend() {
        return Comm.getStreamingBackend();
    }

    public String getStreamingMasterName() {
        return MASTER_NAME;
    }

    public int getStreamingMasterPort() {
        return Comm.getStreamingPort();
    }

    public void loadParam(InvocationParam invParam) throws UnloadableValueException {
        LocalParameter localParam = (LocalParameter)invParam;
        switch (localParam.getType()) {
            case FILE_T: {
                break;
            }
            case OBJECT_T: 
            case STREAM_T: {
                DependencyParameter dpar = (DependencyParameter)localParam.getParam();
                String dataId = (String)localParam.getValue();
                LogicalData ld = Comm.getData((String)dataId);
                Object value = null;
                if (ld.isInMemory()) {
                    value = ld.getValue();
                } else {
                    try {
                        ld.loadFromStorage();
                        value = ld.getValue();
                    }
                    catch (CannotLoadException cle) {
                        try {
                            value = Serializer.deserialize(dpar.getDataTarget());
                        }
                        catch (IOException | ClassNotFoundException e) {
                            throw new UnloadableValueException(e);
                        }
                    }
                }
                invParam.setValue(value);
                break;
            }
            case PSCO_T: {
                String pscoId = (String)localParam.getValue();
                try {
                    Object o = StorageItf.getByID(pscoId);
                    invParam.setValue(o);
                    break;
                }
                catch (StorageException se) {
                    throw new UnloadableValueException((Exception)se);
                }
            }
        }
    }

    public void storeParam(InvocationParam invParam) {
        LocalParameter localParam = (LocalParameter)invParam;
        Parameter param = localParam.getParam();
        switch (param.getType()) {
            case FILE_T: 
            case COLLECTION_T: 
            case DICT_COLLECTION_T: 
            case EXTERNAL_STREAM_T: {
                break;
            }
            case OBJECT_T: 
            case STREAM_T: 
            case PSCO_T: {
                String resultName = localParam.getDataMgmtId();
                LogicalData ld = Comm.getData((String)resultName);
                ld.setValue(invParam.getValue());
                break;
            }
            case BINDING_OBJECT_T: {
                break;
            }
            default: {
                throw new UnsupportedOperationException("Not supported yet." + (Object)((Object)param.getType()));
            }
        }
    }

    public String getCOMPSsLogBaseDirPath() {
        return LoggerManager.getCompssLogBaseDirPath();
    }

    public String getWorkingDirectory() {
        return this.tempDirPath;
    }

    public String getUserExecutionDirPath() {
        return LoggerManager.getUserExecutionDirPath();
    }

    public String getAppLogDirPath() {
        return LoggerManager.getAppLogDirPath();
    }

    public String getTempDirPath() {
        return this.tempDirPath;
    }

    public String getJobsDirPath() {
        return this.jobsDirPath;
    }

    public String getWorkersDirPath() {
        return this.workersDirPath;
    }

    public void increaseComputingCapabilities(ResourceDescription descr) {
        MethodResourceDescription description = (MethodResourceDescription)descr;
        int cpuCount = description.getTotalCPUComputingUnits();
        int gpuCount = description.getTotalGPUComputingUnits();
        int fpgaCount = description.getTotalFPGAComputingUnits();
        int otherCount = description.getTotalOTHERComputingUnits();
        this.executionManager.increaseCapabilities(cpuCount, gpuCount, fpgaCount, otherCount);
    }

    public void reduceComputingCapabilities(ResourceDescription descr) {
        MethodResourceDescription description = (MethodResourceDescription)descr;
        int cpuCount = description.getTotalCPUComputingUnits();
        int gpuCount = description.getTotalGPUComputingUnits();
        int fpgaCount = description.getTotalFPGAComputingUnits();
        int otherCount = description.getTotalOTHERComputingUnits();
        this.executionManager.reduceCapabilities(cpuCount, gpuCount, fpgaCount, otherCount);
    }

    public void removeObsoletes(List<MultiURI> obsoletes) {
    }

    public void verifyNodeIsRunning() {
    }

    public COMPSsRuntime getRuntimeAPI() {
        return this.runtimeApi;
    }

    public void setRuntimeApi(COMPSsRuntime runtimeApi) {
        this.runtimeApi = runtimeApi;
    }

    public LoaderAPI getLoaderAPI() {
        return this.loaderApi;
    }

    public void setLoaderApi(LoaderAPI loaderApi) {
        this.loaderApi = loaderApi;
    }
}

