/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.tracing;

public enum Threads {
    APP(1, "APP", "App thread", ExtraeTaskType.APPLICATION),
    MAIN(1, "MAIN", "Main thread", ExtraeTaskType.RUNTIME),
    AP(2, "RUNTIME AP", "Access Processor thread", ExtraeTaskType.RUNTIME),
    TD(3, "RUNTIME TD", "Task Dispacher thread", ExtraeTaskType.RUNTIME),
    FSL(4, "RUNTIME FS L", "File system thread", ExtraeTaskType.RUNTIME),
    FSH(5, "RUNTIME FS H", "File system thread", ExtraeTaskType.RUNTIME),
    TIMER(6, "RUNTIME TIMER", "Timer thread", ExtraeTaskType.RUNTIME),
    WC(7, "RUNTIME WALLCLOCK", "WallClock thread", ExtraeTaskType.RUNTIME),
    EXEC(8, "EXECUTOR", "Executor thread", ExtraeTaskType.EXECUTOR);

    public final int id;
    public final String label;
    public final String description;
    private final ExtraeTaskType task;

    private Threads(int id, String label, String description, ExtraeTaskType task) {
        this.id = id;
        this.label = label;
        this.description = description;
        this.task = task;
    }

    public static String getLabelByID(int id) {
        if (id < 0 || id >= Threads.values().length) {
            return null;
        }
        if (id < 2) {
            return "";
        }
        return Threads.values()[id].label;
    }

    public static enum ExtraeTaskType {
        APPLICATION("1"),
        RUNTIME("1"),
        EXECUTOR("2");

        private final String label;

        private ExtraeTaskType(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

