/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.implementations.definition;

import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.implementations.definition.AbstractMethodImplementationDefinition;
import es.bsc.compss.util.EnvironmentLoader;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;

public class BinaryDefinition
implements AbstractMethodImplementationDefinition {
    private static final long serialVersionUID = 1L;
    public static final int NUM_PARAMS = 4;
    public static final String SIGNATURE = "binary.BINARY";
    private String binary;
    private String workingDir;
    private String params;
    private boolean failByEV;

    public BinaryDefinition() {
    }

    public BinaryDefinition(String binary, String workingDir, String params, boolean failByEV) {
        this.binary = binary;
        this.workingDir = workingDir;
        this.params = params;
        this.failByEV = failByEV;
    }

    public BinaryDefinition(String[] implTypeArgs, int offset) {
        this.binary = EnvironmentLoader.loadFromEnvironment(implTypeArgs[0]);
        this.workingDir = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 1]);
        this.params = EnvironmentLoader.loadFromEnvironment(implTypeArgs[offset + 2]);
        this.failByEV = Boolean.parseBoolean(implTypeArgs[offset + 3]);
        if (this.binary == null || this.binary.isEmpty() || this.binary.equals("[unassigned]")) {
            throw new IllegalArgumentException("Empty binary annotation for BINARY method");
        }
    }

    @Override
    public void appendToArgs(List<String> lArgs, String auxParam) {
        lArgs.add(this.binary);
        lArgs.add(this.workingDir);
        lArgs.add(this.params);
        lArgs.add(Boolean.toString(this.failByEV));
    }

    public String getBinary() {
        return this.binary;
    }

    public String getParams() {
        return this.params;
    }

    public String getWorkingDir() {
        return this.workingDir;
    }

    public boolean isFailByEV() {
        return this.failByEV;
    }

    @Override
    public TaskType getTaskType() {
        return TaskType.METHOD;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.BINARY;
    }

    @Override
    public String toMethodDefinitionFormat() {
        StringBuilder sb = new StringBuilder();
        sb.append("[BINARY=").append(this.binary);
        sb.append("\t   PARAMS=").append(this.params);
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String toShortFormat() {
        return "Binary Method with binary " + this.binary;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.binary = (String)in.readObject();
        this.workingDir = (String)in.readObject();
        this.params = (String)in.readObject();
        this.failByEV = in.readBoolean();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.binary);
        out.writeObject(this.workingDir);
        out.writeObject(this.params);
        out.writeBoolean(this.failByEV);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Binary Definition \n");
        sb.append("\t Binary: ").append(this.binary).append("\n");
        sb.append("\t Working directory: ").append(this.workingDir).append("\n");
        sb.append("\t Params String: ").append(this.params).append("\n");
        sb.append("\t Fail by EV: ").append(this.failByEV).append("\n");
        return sb.toString();
    }

    public boolean hasParamsString() {
        return this.params != null && !this.params.equals("[unassigned]");
    }
}

