/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.binary;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.exceptions.InvokeExecutionException;
import es.bsc.compss.exceptions.StreamCloseException;
import es.bsc.compss.execution.types.InvocationResources;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.invokers.binary.ContainerInvoker;
import es.bsc.compss.invokers.types.PythonParams;
import es.bsc.compss.invokers.types.StdIOStream;
import es.bsc.compss.invokers.util.BinaryRunner;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.execution.ExecutionSandbox;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.LanguageParams;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.implementations.definition.MPIDefinition;
import es.bsc.compss.types.resources.ContainerDescription;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;

public class MPIInvoker
extends Invoker {
    private static final int NUM_BASE_MPI_ARGS = 6;
    private static final String ERROR_TARGET_PARAM = "ERROR: MPI Execution doesn't support target parameters";
    MPIDefinition mpiDef;
    private BinaryRunner br;

    public MPIInvoker(InvocationContext context, Invocation invocation, ExecutionSandbox sandBox, InvocationResources assignedResources) throws JobExecutionException {
        super(context, invocation, sandBox, assignedResources);
        try {
            this.mpiDef = (MPIDefinition)this.invocation.getMethodImplementation().getDefinition();
            this.mpiDef.setRunnerProperties(context.getInstallDir());
        }
        catch (Exception e) {
            throw new JobExecutionException("Incorrect method definition for task of type " + (Object)((Object)this.invocation.getMethodImplementation().getMethodType()), (Throwable)e);
        }
        this.br = null;
    }

    private void checkArguments() throws JobExecutionException {
        try {
            this.mpiDef.checkArguments();
        }
        catch (IllegalArgumentException e) {
            throw new JobExecutionException((Throwable)e);
        }
        if (this.invocation.getTarget() != null && this.invocation.getTarget().getValue() != null) {
            throw new JobExecutionException(ERROR_TARGET_PARAM);
        }
    }

    @Override
    public void invokeMethod() throws JobExecutionException {
        Object retValue;
        this.checkArguments();
        LOGGER.info("Invoked MPI " + this.mpiDef.getBinary() + " in " + this.context.getHostName());
        try {
            retValue = this.runInvocation();
        }
        catch (InvokeExecutionException iee) {
            throw new JobExecutionException((Throwable)iee);
        }
        try {
            if (this.br != null) {
                String pythonInterpreter = null;
                LanguageParams lp = this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
                if (lp instanceof PythonParams) {
                    PythonParams pp = (PythonParams)lp;
                    pythonInterpreter = pp.getPythonInterpreter();
                }
                this.br.closeStreams(this.invocation.getParams(), pythonInterpreter);
            }
        }
        catch (StreamCloseException se) {
            LOGGER.error("Exception closing binary streams", (Throwable)se);
            throw new JobExecutionException((Throwable)se);
        }
        for (InvocationParam np : this.invocation.getResults()) {
            if (np.getType() == DataType.FILE_T) {
                this.serializeBinaryExitValue(np, retValue);
                continue;
            }
            np.setValue(retValue);
            np.setValueClass(retValue.getClass());
        }
    }

    private Object runInvocation() throws InvokeExecutionException {
        String pythonInterpreter = null;
        LanguageParams lp = this.context.getLanguageParams(COMPSsConstants.Lang.PYTHON);
        if (lp instanceof PythonParams) {
            PythonParams pp = (PythonParams)lp;
            pythonInterpreter = pp.checkCoverageAndGetPythonInterpreter();
        }
        String[] appParams = new String[]{};
        if (this.mpiDef.hasParamsString()) {
            appParams = BinaryRunner.buildAppParams(this.invocation.getParams(), this.mpiDef.getParams(), pythonInterpreter);
        }
        StdIOStream streamValues = new StdIOStream();
        ArrayList<String> binaryParams = BinaryRunner.createCMDParametersFromValues(this.invocation.getParams(), this.invocation.getTarget(), streamValues, pythonInterpreter);
        String mpiFlags = this.mpiDef.getMpiFlags();
        int numMPIFlags = 0;
        String[] mpiflagsArray = null;
        if (mpiFlags != null && !mpiFlags.isEmpty() && !mpiFlags.equals("[unassigned]")) {
            mpiflagsArray = mpiFlags.split(" ");
            numMPIFlags = mpiflagsArray.length;
        }
        int cmdLength = 6 + numMPIFlags;
        cmdLength = this.mpiDef.hasParamsString() ? (cmdLength += appParams.length) : (cmdLength += binaryParams.size());
        ContainerDescription container = this.mpiDef.getContainer();
        int numOptions = 0;
        String[] options = null;
        if (container != null) {
            String dockerWorkDirVolume;
            cmdLength += 3;
            if (!container.getOptions().isEmpty() && !container.getOptions().equals("[unassigned]")) {
                options = BinaryRunner.buildAppParams(this.invocation.getParams(), container.getOptions(), pythonInterpreter);
                numOptions = options.length;
            }
            if ((dockerWorkDirVolume = System.getenv("DOCKER_WORKING_DIR_VOLUME")) != null && !dockerWorkDirVolume.isEmpty()) {
                numOptions += 4;
            }
            cmdLength += numOptions;
        }
        String[] cmd = new String[cmdLength];
        int pos = 0;
        cmd[pos++] = this.mpiDef.getMpiRunner();
        cmd[pos++] = this.mpiDef.getHostsFlag();
        try {
            cmd[pos++] = this.mpiDef.generateHostsDefinition(this.sandBox.getFolder(), this.hostnames, this.computingUnits);
        }
        catch (IOException ioe) {
            throw new InvokeExecutionException("ERROR: writting hostfile", (Exception)ioe);
        }
        cmd[pos++] = "-n";
        cmd[pos++] = this.mpiDef.generateNumberOfProcesses(this.numWorkers, this.computingUnits);
        for (int i = 0; i < numMPIFlags; ++i) {
            cmd[pos++] = mpiflagsArray[i];
        }
        if (container != null) {
            cmd[pos++] = container.getEngine().name().toLowerCase();
            cmd[pos++] = container.getEngine().equals((Object)ContainerDescription.ContainerEngine.SINGULARITY) ? "exec" : "run";
            pos = ContainerInvoker.addContainerOptions(cmd, pos, options);
            String dockerWorkDirVolume = System.getenv("DOCKER_WORKING_DIR_VOLUME");
            if (dockerWorkDirVolume != null && !dockerWorkDirVolume.isEmpty()) {
                cmd[pos++] = "-e";
                cmd[pos++] = "DOCKER_WORKING_DIR_VOLUME=\"" + dockerWorkDirVolume + "\"";
                String dockerWorkDirMount = System.getenv("DOCKER_WORKING_DIR_MOUNT");
                cmd[pos++] = "-e";
                cmd[pos++] = "DOCKER_WORKING_DIR_MOUNT=\"" + dockerWorkDirMount + "\"";
            }
            cmd[pos++] = container.getImage();
        }
        cmd[pos++] = this.mpiDef.getBinary();
        if (this.mpiDef.hasParamsString()) {
            for (String appParam : appParams) {
                cmd[pos++] = appParam;
            }
        } else {
            for (String binParam : binaryParams) {
                cmd[pos++] = binParam;
            }
        }
        if (this.invocation.isDebugEnabled()) {
            PrintStream outLog = this.context.getThreadOutStream();
            outLog.println("");
            outLog.println("[MPI INVOKER] Begin MPI call to " + this.mpiDef.getBinary());
            outLog.println("[MPI INVOKER] On WorkingDir : " + this.sandBox.getFolder().getAbsolutePath());
            outLog.print("[MPI INVOKER] MPI CMD: ");
            for (String s : cmd) {
                outLog.print(s + " ");
            }
            outLog.println("");
            outLog.println("[MPI INVOKER] MPI STDIN: " + streamValues.getStdIn());
            outLog.println("[MPI INVOKER] MPI STDOUT: " + streamValues.getStdOut());
            outLog.println("[MPI INVOKER] MPI STDERR: " + streamValues.getStdErr());
        }
        this.br = new BinaryRunner();
        return this.br.executeCMD(cmd, streamValues, this.sandBox, this.context.getThreadOutStream(), this.context.getThreadErrStream(), null, this.mpiDef.isFailByEV());
    }

    @Override
    public void cancelMethod() {
        LOGGER.debug("Cancelling MPI process");
        if (this.br != null) {
            this.br.cancelProcess();
        }
    }

    @Override
    protected void setEnvironmentVariables() {
        super.setEnvironmentVariables();
        int ppn = this.mpiDef.getPPN();
        if (LOGGER.isDebugEnabled()) {
            System.out.println("[MPI INVOKER] OVERWRITING COMPSS_NUM_PROCS: " + this.computingUnits);
        }
        System.setProperty("COMPSS_NUM_PROCS", String.valueOf(this.computingUnits));
        if (ppn > 1) {
            int threads = this.computingUnits / ppn;
            System.setProperty("COMPSS_NUM_THREADS", String.valueOf(threads));
            System.setProperty("OMP_NUM_THREADS", String.valueOf(threads));
            if (LOGGER.isDebugEnabled()) {
                System.out.println("[MPI INVOKER] OVERWRITING COMPSS_NUM_THREADS: " + threads);
            }
        }
    }
}

