/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.uri;

import es.bsc.compss.exceptions.UnstartedNodeException;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.resources.Resource;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class MultiURI
implements Comparable<MultiURI> {
    private final DataLocation.Protocol protocol;
    private final Resource host;
    private final String path;
    private final HashMap<String, Object> internal;

    public MultiURI(DataLocation.Protocol protocol, Resource host, String path) {
        this.protocol = protocol;
        this.host = host;
        this.path = path;
        this.internal = new HashMap();
        try {
            host.setInternalURI(this);
        }
        catch (UnstartedNodeException unstartedNodeException) {
            // empty catch block
        }
    }

    public void setInternalURI(String adaptor, Object uri) {
        this.internal.put(adaptor, uri);
    }

    public Object getInternalURI(String adaptor) throws UnstartedNodeException {
        Object o = this.internal.get(adaptor);
        if (o == null) {
            this.host.setInternalURI(this);
            o = this.internal.get(adaptor);
        }
        return o;
    }

    public Resource getHost() {
        return this.host;
    }

    public String getPath() {
        return this.path;
    }

    public DataLocation.Protocol getProtocol() {
        return this.protocol;
    }

    public String getScheme() {
        return this.protocol.getSchema();
    }

    public String toString() {
        return this.protocol.getSchema() + this.host.getName() + File.separator + this.path;
    }

    public String debugString() {
        StringBuilder sb = new StringBuilder(this.protocol.getSchema() + this.host.getName() + File.separator + this.path + "\n");
        for (Map.Entry<String, Object> e : this.internal.entrySet()) {
            sb.append("\t * ").append(e.getKey()).append(" -> ").append(e.getValue()).append("\n");
        }
        return sb.toString();
    }

    @Override
    public int compareTo(MultiURI o) {
        if (o == null) {
            throw new NullPointerException();
        }
        int compare = this.host.getName().compareTo(o.host.getName());
        if (compare == 0) {
            compare = this.path.compareTo(o.path);
        }
        return compare;
    }
}

