/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.compss.nio.NIOData;
import es.bsc.compss.nio.NIOUri;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.StdIOStream;
import es.bsc.compss.types.execution.InvocationParam;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.OptionalDataException;
import java.util.List;

public class NIOParam
implements Externalizable,
InvocationParam {
    private String dataMgmtId;
    private DataType type;
    private StdIOStream stream;
    private String prefix;
    private String name;
    private String contentType;
    private boolean preserveSourceData;
    private boolean writeFinalValue;
    private Object value;
    private NIOData source;
    private String originalName;
    private String renamedName;
    private Class<?> valueClass;

    public NIOParam() {
    }

    public NIOParam(String dataMgmtId, DataType type, StdIOStream stream, String prefix, String name, String contentType, boolean preserveSourceData, boolean writeFinalValue, Object value, NIOData data, String originalName) {
        this.dataMgmtId = dataMgmtId;
        this.type = type;
        this.stream = stream;
        this.prefix = prefix;
        this.name = name;
        this.contentType = contentType == null ? "null" : contentType;
        this.value = value;
        this.preserveSourceData = preserveSourceData;
        this.writeFinalValue = writeFinalValue;
        this.source = data;
        this.originalName = originalName;
    }

    public NIOParam(NIOParam p) {
        this.dataMgmtId = p.dataMgmtId;
        this.type = p.type;
        this.stream = p.stream;
        this.prefix = p.prefix;
        this.name = p.name;
        this.contentType = p.contentType;
        this.value = p.value;
        this.preserveSourceData = p.preserveSourceData;
        this.writeFinalValue = p.writeFinalValue;
        this.source = p.source;
        this.originalName = p.originalName;
    }

    public DataType getType() {
        return this.type;
    }

    public StdIOStream getStdIOStream() {
        return this.stream;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getName() {
        return this.name;
    }

    public String getContentType() {
        return this.contentType;
    }

    public boolean isPreserveSourceData() {
        return this.preserveSourceData;
    }

    public boolean isWriteFinalValue() {
        return this.writeFinalValue;
    }

    public String getDataMgmtId() {
        return this.dataMgmtId;
    }

    public String getSourceDataId() {
        return this.source != null ? this.source.getDataMgmtId() : null;
    }

    public List<NIOUri> getSources() {
        return this.source.getSources();
    }

    public String getOriginalName() {
        return this.originalName;
    }

    public void setOriginalName(String originalName) {
        this.originalName = originalName;
    }

    public String getRenamedName() {
        return this.renamedName;
    }

    public void setRenamedName(String renamedName) {
        this.renamedName = renamedName;
    }

    public Object getValue() {
        return this.value;
    }

    public Class<?> getValueClass() {
        return this.valueClass;
    }

    public NIOData getData() {
        return this.source;
    }

    public void setType(DataType type) {
        this.type = type;
    }

    public void setValue(Object o) {
        this.value = o;
    }

    public void setValueClass(Class<?> valueClass) {
        this.valueClass = valueClass;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.dataMgmtId = (String)in.readObject();
        this.type = (DataType)in.readObject();
        this.stream = (StdIOStream)in.readObject();
        this.prefix = in.readUTF();
        this.name = in.readUTF();
        this.contentType = in.readUTF();
        this.preserveSourceData = in.readBoolean();
        this.writeFinalValue = in.readBoolean();
        this.originalName = (String)in.readObject();
        this.value = in.readObject();
        try {
            this.source = (NIOData)in.readObject();
        }
        catch (OptionalDataException e) {
            this.source = null;
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.dataMgmtId);
        out.writeObject(this.type);
        out.writeObject(this.stream);
        out.writeUTF(this.prefix);
        out.writeUTF(this.name);
        out.writeUTF(this.contentType);
        out.writeBoolean(this.preserveSourceData);
        out.writeBoolean(this.writeFinalValue);
        out.writeObject(this.originalName);
        out.writeObject(this.value);
        if (this.source != null) {
            out.writeObject(this.source);
        }
    }

    public void dumpInternalInfo(StringBuilder sb) {
        sb.append("[MGMT ID = ").append(this.dataMgmtId).append("]");
        sb.append("[TYPE = ").append(this.type).append("]");
        sb.append("[IOSTREAM = ").append(this.stream).append("]");
        sb.append("[PREFIX = ").append(this.prefix).append("]");
        sb.append("[NAME = ").append(this.name).append("]");
        sb.append("[CONTENT TYPE = ").append(this.contentType).append("]");
        sb.append("[PRESERVE SOURCE DATA = ").append(this.preserveSourceData).append("]");
        sb.append("[WRITE FINAL VALUE = ").append(this.writeFinalValue).append("]");
        sb.append("[ORIGINAL NAME = ").append(this.originalName).append("]");
        sb.append("[VALUE = ").append(this.value).append("]");
        sb.append("[DATA ").append(this.source).append("]");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[PARAM");
        this.dumpInternalInfo(sb);
        sb.append("]");
        return sb.toString();
    }
}

