/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.nio.NIOResult;
import es.bsc.compss.types.annotations.parameter.DataType;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;

public class NIOResultCollection
extends NIOResult
implements Externalizable {
    private List<NIOResult> elements;

    public NIOResultCollection() {
    }

    public NIOResultCollection(TaskMonitor.CollectionTaskResult param) {
        super(param.getType(), param.getDataLocation());
        this.elements = new ArrayList<NIOResult>();
        for (TaskMonitor.TaskResult subParam : param.getSubelements()) {
            if (subParam.getType() == DataType.COLLECTION_T) {
                this.elements.add(new NIOResultCollection((TaskMonitor.CollectionTaskResult)subParam));
                continue;
            }
            this.elements.add(new NIOResult(subParam.getType(), subParam.getDataLocation()));
        }
    }

    public NIOResultCollection(DataType type, String location, List<NIOResult> elements) {
        super(type, location);
        this.elements = elements;
    }

    public List<NIOResult> getElements() {
        return this.elements;
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        super.writeExternal(oo);
        oo.writeObject(this.elements);
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        super.readExternal(oi);
        this.elements = (List)oi.readObject();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder("[COLLECTION");
        sb.append(" TYPE=").append(this.getType());
        sb.append(" LOCATION=").append(this.getLocation());
        sb.append(" ELEMENTS=[");
        boolean many = false;
        for (NIOResult nr : this.elements) {
            if (many) {
                sb.append(", ");
            }
            sb.append(nr.toString());
            many = true;
        }
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }
}

