/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOResult;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;
import java.util.List;

public class NIOTaskResult
implements Externalizable {
    private int jobId;
    private List<NIOResult> results = new LinkedList<NIOResult>();

    public NIOTaskResult() {
    }

    public NIOTaskResult(int jobId) {
        this.jobId = jobId;
    }

    public NIOTaskResult(int jobId, List<NIOParam> arguments, NIOParam targetParam, List<NIOParam> results) {
        this.jobId = jobId;
        for (NIOParam np : arguments) {
            this.results.add(np.getResult());
        }
        if (targetParam != null) {
            this.results.add(targetParam.getResult());
        }
        for (NIOParam np : results) {
            this.results.add(np.getResult());
        }
    }

    public int getJobId() {
        return this.jobId;
    }

    public List<NIOResult> getParamResults() {
        return this.results;
    }

    public void addParamResult(NIOResult pr) {
        this.results.add(pr);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.jobId = in.readInt();
        this.results = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.jobId);
        out.writeObject(this.results);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[JOB_RESULT ");
        sb.append("[JOB ID= ").append(this.jobId).append("]");
        sb.append("[PARAM_RESULTS");
        for (NIOResult param : this.results) {
            sb.append(" ").append(param);
        }
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }
}

