/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.utils;

import es.bsc.comm.nio.NIOConnection;
import es.bsc.comm.stage.Transfer;
import es.bsc.compss.nio.exceptions.BindingObjectTypeException;
import es.bsc.compss.nio.utils.NIOBindingObjectTransferListener;
import java.nio.ByteBuffer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NIOBindingObjectStream {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Communication");
    private static final String DBG_PREFIX = "[NIOBindingObjectStream] ";
    private final NIOConnection c;
    private final NIOBindingObjectTransferListener ncl;

    public NIOBindingObjectStream(NIOConnection c, NIOBindingObjectTransferListener ncl) {
        this.c = c;
        this.ncl = ncl;
    }

    public void push(ByteBuffer b) {
        if (this.ncl == null && b != null) {
            if (b.hasArray()) {
                byte[] bArray = b.array();
                LOGGER.debug("[NIOBindingObjectStream] Sending buffer array " + bArray.length);
                this.c.sendDataArray(b.array());
            } else {
                byte[] bArray = new byte[b.limit()];
                b.get(bArray);
                LOGGER.debug("[NIOBindingObjectStream] Sending array " + bArray.length);
                this.c.sendDataArray(bArray);
            }
        }
    }

    public byte[] pull() throws BindingObjectTypeException {
        LOGGER.debug("[NIOBindingObjectStream] Pulling byte array");
        this.ncl.addOperation();
        this.c.receiveDataArray();
        this.ncl.enable();
        LOGGER.debug("[NIOBindingObjectStream] Waiting to receive the data array");
        this.ncl.aquire();
        Transfer t = this.ncl.getTransfer();
        if (t.isArray()) {
            byte[] bArray = this.ncl.getTransfer().getArray();
            LOGGER.debug("[NIOBindingObjectStream] Returning array of " + bArray.length);
            return bArray;
        }
        LOGGER.debug("[NIOBindingObjectStream] Error is not an Array");
        throw new BindingObjectTypeException("Transfer is not an array");
    }
}

