/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.compss.nio.NIOUri;
import es.bsc.compss.types.data.location.ProtocolType;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.LinkedList;

public class NIOResult
implements Externalizable {
    private Collection<NIOUri> uris = new LinkedList<NIOUri>();

    public NIOResult() {
    }

    public NIOResult(String location) {
        this();
        if (location != null) {
            this.addLocation(location);
        }
    }

    public NIOResult(NIOUri uri) {
        this();
        if (uri != null) {
            this.uris.add(uri);
        }
    }

    public void addUri(NIOUri uri) {
        this.uris.add(uri);
    }

    public void addLocation(String location) {
        NIOUri uri = new NIOUri(null, location, ProtocolType.ANY_URI);
        this.addUri(uri);
    }

    public Collection<NIOUri> getUris() {
        return this.uris;
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeObject(this.uris);
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        this.uris = (Collection)oi.readObject();
    }

    public String toString() {
        return "[URIS=" + this.uris + "]";
    }
}

