/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.compss.nio.NIOResult;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class NIOTaskResult
implements Externalizable {
    private int jobId;
    private List<NIOResult> results = new LinkedList<NIOResult>();

    public NIOTaskResult() {
    }

    public NIOTaskResult(int jobId) {
        this.jobId = jobId;
    }

    public int getJobId() {
        return this.jobId;
    }

    public List<NIOResult> getParamResults() {
        return this.results;
    }

    public void addParamResult(NIOResult pr) {
        this.results.add(pr);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.jobId = in.readInt();
        this.results = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.jobId);
        out.writeObject(this.results);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        sb.append("\"job_id\":").append(this.jobId).append(",");
        sb.append("\"params\":[");
        Iterator<NIOResult> itr = this.results.iterator();
        if (itr.hasNext()) {
            NIOResult nr = itr.next();
            sb.append(nr);
            while (itr.hasNext()) {
                nr = itr.next();
                sb.append("," + nr);
            }
        }
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }
}

