/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOTaskProfile;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.job.JobHistory;
import es.bsc.compss.types.resources.MethodResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class NIOTask
implements Externalizable,
Invocation {
    private COMPSsConstants.Lang lang;
    private boolean workerDebug;
    private AbstractMethodImplementation impl;
    private String parallelismSource;
    private LinkedList<NIOParam> arguments;
    private NIOParam target;
    private LinkedList<NIOParam> results;
    private List<String> slaveWorkersNodeNames;
    private int taskId;
    private int jobId;
    private JobHistory history;
    private int transferGroupId;
    private int numReturns;
    private OnFailure onFailure;
    private long timeOut;
    private List<Integer> predecessors;
    private Integer numSuccessors;
    private final NIOTaskProfile profile;

    public NIOTask() {
        this.profile = new NIOTaskProfile();
    }

    public NIOTask(COMPSsConstants.Lang lang, boolean workerDebug, AbstractMethodImplementation impl, String parallelismSource, boolean hasTarget, int numReturns, LinkedList<NIOParam> params, List<String> slaveWorkersNodeNames, int taskId, int jobId, JobHistory hist, int transferGroupId, OnFailure onFailure, long timeOut, List<Integer> predecessors, Integer numSuccessors) {
        this.lang = lang;
        this.workerDebug = workerDebug;
        this.impl = impl;
        this.parallelismSource = parallelismSource;
        this.arguments = new LinkedList();
        this.results = new LinkedList();
        this.onFailure = onFailure;
        this.timeOut = timeOut;
        this.predecessors = predecessors;
        this.numSuccessors = numSuccessors;
        Iterator<NIOParam> paramItr = params.descendingIterator();
        for (int rIdx = 0; rIdx < numReturns; ++rIdx) {
            NIOParam p = paramItr.next();
            this.results.addFirst(p);
        }
        if (hasTarget) {
            NIOParam p;
            this.target = p = paramItr.next();
        }
        while (paramItr.hasNext()) {
            NIOParam p = paramItr.next();
            this.arguments.addFirst(p);
        }
        this.slaveWorkersNodeNames = slaveWorkersNodeNames;
        this.taskId = taskId;
        this.jobId = jobId;
        this.history = hist;
        this.transferGroupId = transferGroupId;
        this.numReturns = numReturns;
        this.profile = new NIOTaskProfile();
    }

    public NIOTask(COMPSsConstants.Lang lang, boolean workerDebug, AbstractMethodImplementation impl, String parallelismSource, LinkedList<NIOParam> arguments, NIOParam target, LinkedList<NIOParam> results, List<String> slaveWorkersNodeNames, int taskId, int jobId, JobHistory hist, int transferGroupId, OnFailure onFailure, long timeOut) {
        this.lang = lang;
        this.workerDebug = workerDebug;
        this.impl = impl;
        this.parallelismSource = parallelismSource;
        this.arguments = arguments;
        this.target = target;
        this.results = results;
        this.onFailure = onFailure;
        this.timeOut = timeOut;
        this.slaveWorkersNodeNames = slaveWorkersNodeNames;
        this.taskId = taskId;
        this.jobId = jobId;
        this.history = hist;
        this.transferGroupId = transferGroupId;
        this.numReturns = results.size();
        this.profile = new NIOTaskProfile();
    }

    public COMPSsConstants.Lang getLang() {
        return this.lang;
    }

    public boolean isDebugEnabled() {
        return this.workerDebug;
    }

    public String getMethodDefinition() {
        return this.impl.getMethodDefinition();
    }

    public AbstractMethodImplementation getMethodImplementation() {
        return this.impl;
    }

    public List<NIOParam> getParams() {
        return this.arguments;
    }

    public NIOParam getTarget() {
        return this.target;
    }

    public List<NIOParam> getResults() {
        return this.results;
    }

    public int getNumReturns() {
        return this.numReturns;
    }

    public int getTaskId() {
        return this.taskId;
    }

    public TaskType getTaskType() {
        return this.impl.getTaskType();
    }

    public int getJobId() {
        return this.jobId;
    }

    public JobHistory getHistory() {
        return this.history;
    }

    public int getTransferGroupId() {
        return this.transferGroupId;
    }

    public MethodResourceDescription getRequirements() {
        return this.impl.getRequirements();
    }

    public List<String> getSlaveNodesNames() {
        return this.slaveWorkersNodeNames;
    }

    public OnFailure getOnFailure() {
        return this.onFailure;
    }

    public boolean producesEmptyResultsOnFailure() {
        return this.onFailure != OnFailure.RETRY && this.onFailure != OnFailure.FAIL;
    }

    public long getTimeOut() {
        return this.timeOut;
    }

    public String getParallelismSource() {
        return this.parallelismSource;
    }

    public List<Integer> getPredecessors() {
        return this.predecessors;
    }

    public Integer getNumSuccessors() {
        return this.numSuccessors;
    }

    public void profileArrival() {
        this.profile.arrived();
    }

    public void profileFetchedData() {
        this.profile.dataFetched();
    }

    public void executionStarts() {
        this.profile.executionStarts();
    }

    public void executionEnds() {
        this.profile.executionEnds();
    }

    public void profileEndNotification() {
        this.profile.end();
    }

    public NIOTaskProfile getProfile() {
        return this.profile;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.lang = COMPSsConstants.Lang.valueOf((String)((String)in.readObject()));
        this.workerDebug = in.readBoolean();
        this.impl = (AbstractMethodImplementation)in.readObject();
        boolean ceiDefined = in.readBoolean();
        if (ceiDefined) {
            this.parallelismSource = in.readUTF();
        }
        this.numReturns = in.readInt();
        this.arguments = (LinkedList)in.readObject();
        this.target = (NIOParam)in.readObject();
        this.results = (LinkedList)in.readObject();
        this.slaveWorkersNodeNames = (List)in.readObject();
        this.taskId = in.readInt();
        this.jobId = in.readInt();
        this.history = (JobHistory)in.readObject();
        this.transferGroupId = in.readInt();
        this.onFailure = (OnFailure)in.readObject();
        this.timeOut = in.readLong();
        this.predecessors = (List)in.readObject();
        this.numSuccessors = (Integer)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.lang.toString());
        out.writeBoolean(this.workerDebug);
        out.writeObject(this.impl);
        boolean ceiDefined = this.parallelismSource != null && !this.parallelismSource.isEmpty();
        out.writeBoolean(ceiDefined);
        if (ceiDefined) {
            out.writeUTF(this.parallelismSource);
        }
        out.writeInt(this.numReturns);
        out.writeObject(this.arguments);
        out.writeObject(this.target);
        out.writeObject(this.results);
        out.writeObject(this.slaveWorkersNodeNames);
        out.writeInt(this.taskId);
        out.writeInt(this.jobId);
        out.writeObject(this.history);
        out.writeInt(this.transferGroupId);
        out.writeObject(this.onFailure);
        out.writeLong(this.timeOut);
        out.writeObject(this.predecessors);
        out.writeObject(this.numSuccessors);
    }

    protected void dumpContent(StringBuilder sb) {
        sb.append("\"lang\":\"").append(this.lang).append("\",");
        sb.append("\"task_id\":").append(this.taskId).append(",");
        sb.append("\"job_id\":").append(this.jobId).append(",");
        sb.append("\"history\":\"").append(this.history).append("\",");
        sb.append("\"implementation\":").append(this.impl.toJSON()).append(",");
        sb.append("\"parallelism_source\":").append(this.parallelismSource == null ? "null" : "\"" + this.parallelismSource + "\"").append(",");
        sb.append("\"params\":[");
        Iterator argsItr = this.arguments.iterator();
        if (argsItr.hasNext()) {
            sb.append(argsItr.next());
        }
        while (argsItr.hasNext()) {
            sb.append(",").append(argsItr.next());
        }
        sb.append(" ],\"target\":");
        if (this.target != null) {
            sb.append(this.target);
        } else {
            sb.append("null");
        }
        sb.append(",\"results\":[");
        Iterator resItr = this.arguments.iterator();
        if (resItr.hasNext()) {
            sb.append(resItr.next());
        }
        while (resItr.hasNext()) {
            sb.append(",").append(resItr.next());
        }
        sb.append("],");
        sb.append("\"slave_workers_node_names\":[");
        for (String name : this.slaveWorkersNodeNames) {
            sb.append("{\"sw_name\":").append(name).append("}");
        }
        sb.append("]");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{");
        this.dumpContent(sb);
        sb.append("}");
        return sb.toString();
    }
}

