/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.compss.types.tracing.TraceEvent;
import es.bsc.compss.types.tracing.TraceEventType;
import es.bsc.compss.util.Tracer;
import java.util.Map;

public class NIOTracer
extends Tracer {
    private static final int ID = 121;
    public static final String TRANSFER_END = "0";

    public static void emitDataTransferEvent(String data, boolean end) {
        boolean dataTransfer = !data.startsWith("worker") && !data.startsWith("tracing") && !data.startsWith("binding") && !data.startsWith("cache") && !data.endsWith("trace.tar.gz");
        int transferID = Math.abs(data.hashCode());
        if (dataTransfer) {
            if (end) {
                NIOTracer.emitEventEnd((TraceEventType)TraceEventType.DATA_TRANSFERS);
            } else {
                NIOTracer.emitEvent((TraceEventType)TraceEventType.DATA_TRANSFERS, (long)transferID);
            }
        }
        if (DEBUG) {
            LOGGER.debug((dataTransfer ? "E" : "Not E") + "mitting synchronized data transfer event [name, id] = [" + data + " , " + transferID + "]");
        }
    }

    public static void emitCommEvent(boolean send, int partnerID, int tag) {
        NIOTracer.emitCommEvent((boolean)send, (int)121, (int)partnerID, (int)tag, (long)0L);
    }

    public static void emitCommEvent(boolean send, int partnerID, int tag, long size) {
        NIOTracer.emitCommEvent((boolean)send, (int)121, (int)partnerID, (int)tag, (long)size);
    }

    public static void fini(Map<String, Integer> runtimeEvents) {
        NIOTracer.emitEvent((TraceEvent)TraceEvent.STOP);
        NIOTracer.emitEventEnd((TraceEvent)TraceEvent.STOP);
        Tracer.fini(runtimeEvents);
    }
}

