/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.commands;

import es.bsc.comm.Connection;
import es.bsc.comm.nio.NIONode;
import es.bsc.compss.nio.NIOAgent;
import es.bsc.compss.nio.commands.Command;
import es.bsc.compss.nio.commands.CommandCheckWorkerACK;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CommandCheckWorker
implements Command {
    private String uuid;
    private String nodeName;

    public CommandCheckWorker() {
    }

    public CommandCheckWorker(String uuid, String nodeName) {
        this.uuid = uuid;
        this.nodeName = nodeName;
    }

    @Override
    public void handle(NIOAgent agent, Connection c) {
        if (agent.isMyUuid(this.uuid, this.nodeName)) {
            if (agent.getMaster() == null) {
                agent.setMaster((NIONode)c.getNode());
            }
            CommandCheckWorkerACK cmd = new CommandCheckWorkerACK(this.uuid, this.nodeName);
            c.sendCommand((Object)cmd);
        }
        c.finishConnection();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.uuid = in.readUTF();
        this.nodeName = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.uuid);
        out.writeUTF(this.nodeName);
    }

    public String toString() {
        return "CommandCheckWorker for deployment ID " + this.uuid + " on nodeName " + this.nodeName;
    }

    @Override
    public void error(NIOAgent agent, Connection c) {
    }
}

