/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.master;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.nio.NIOTracer;
import es.bsc.compss.nio.master.NIOAdaptor;
import es.bsc.compss.types.WorkerStarterCommand;
import java.io.File;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NIOStarterCommand
extends WorkerStarterCommand {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Communication");
    private static final String SCRIPT_PATH = "Runtime" + File.separator + "scripts" + File.separator + "system" + File.separator + "adaptors" + File.separator + "nio" + File.separator;
    private static final String STARTER_SCRIPT_NAME = "persistent_worker.sh";
    private String scriptName;

    public NIOStarterCommand(String workerName, int workerPort, String masterName, String workingDir, String installDir, String appDir, String classpathFromFile, String pythonpathFromFile, String libPathFromFile, String envScriptPathFromFile, String pythonInterpreterFromFile, int totalCPU, int totalGPU, int totalFPGA, int limitOfTasks, String hostId) {
        super(workerName, workerPort, masterName, workingDir, installDir, appDir, classpathFromFile, pythonpathFromFile, libPathFromFile, envScriptPathFromFile, pythonInterpreterFromFile, totalCPU, totalGPU, totalFPGA, limitOfTasks, hostId);
        this.scriptName = installDir + (installDir.endsWith(File.separator) ? "" : File.separator) + SCRIPT_PATH + STARTER_SCRIPT_NAME;
    }

    public String[] getStartCommand() throws Exception {
        String[] cmd = new String[46 + this.jvmFlags.length + 1 + this.fpgaArgs.length];
        cmd[0] = this.scriptName;
        cmd[1] = this.workerEnvScriptPath.isEmpty() ? "null" : this.workerEnvScriptPath;
        String string = cmd[2] = this.workerLibPath.isEmpty() ? "null" : this.workerLibPath;
        if (this.appDir.isEmpty()) {
            LOGGER.warn("No path passed via appdir option neither xml AppDir field");
            cmd[3] = "null";
        } else {
            cmd[3] = this.appDir;
        }
        cmd[4] = this.workerClasspath.isEmpty() ? "null" : this.workerClasspath;
        cmd[5] = Comm.getStreamingBackend().name();
        cmd[6] = String.valueOf(this.jvmFlags.length);
        for (int i = 0; i < this.jvmFlags.length; ++i) {
            cmd[7 + i] = this.jvmFlags[i];
        }
        int nextPosition = 7 + this.jvmFlags.length;
        cmd[nextPosition++] = String.valueOf(this.fpgaArgs.length);
        for (String fpgaArg : this.fpgaArgs) {
            cmd[nextPosition++] = fpgaArg;
        }
        cmd[nextPosition++] = this.workerDebug;
        cmd[nextPosition++] = String.valueOf(5);
        cmd[nextPosition++] = String.valueOf(5);
        cmd[nextPosition++] = this.workerName;
        cmd[nextPosition++] = String.valueOf(this.workerPort);
        cmd[nextPosition++] = this.masterName;
        cmd[nextPosition++] = String.valueOf(NIOAdaptor.MASTER_PORT);
        cmd[nextPosition++] = String.valueOf(Comm.getStreamingPort());
        cmd[nextPosition++] = String.valueOf(this.totalCPU);
        cmd[nextPosition++] = String.valueOf(this.totalGPU);
        cmd[nextPosition++] = String.valueOf(this.totalFPGA);
        cmd[nextPosition++] = String.valueOf(CPU_AFFINITY);
        cmd[nextPosition++] = String.valueOf(GPU_AFFINITY);
        cmd[nextPosition++] = String.valueOf(FPGA_AFFINITY);
        cmd[nextPosition++] = String.valueOf(IO_EXECUTORS);
        cmd[nextPosition++] = String.valueOf(this.limitOfTasks);
        cmd[nextPosition++] = DEPLOYMENT_ID;
        cmd[nextPosition++] = this.lang;
        cmd[nextPosition++] = this.sandboxedWorkingDir;
        cmd[nextPosition++] = this.installDir;
        cmd[nextPosition++] = cmd[3];
        cmd[nextPosition++] = this.workerLibPath.isEmpty() ? "null" : this.workerLibPath;
        cmd[nextPosition++] = this.workerClasspath.isEmpty() ? "null" : this.workerClasspath;
        cmd[nextPosition++] = this.workerPythonpath.isEmpty() ? "null" : this.workerPythonpath;
        cmd[nextPosition++] = String.valueOf(NIOTracer.isActivated());
        cmd[nextPosition++] = NIOTracer.getExtraeFile();
        cmd[nextPosition++] = this.hostId;
        cmd[nextPosition++] = String.valueOf(NIOTracer.isTracingTaskDependencies());
        cmd[nextPosition++] = this.storageConf;
        cmd[nextPosition++] = this.executionType;
        cmd[nextPosition++] = this.workerPersistentC;
        cmd[nextPosition++] = this.pythonInterpreter;
        cmd[nextPosition++] = this.pythonVersion;
        cmd[nextPosition++] = this.pythonVirtualEnvironment;
        cmd[nextPosition++] = this.pythonPropagateVirtualEnvironment;
        cmd[nextPosition++] = this.pythonExtraeFile;
        cmd[nextPosition++] = this.pythonMpiWorker;
        cmd[nextPosition++] = this.pythonWorkerCache;
        cmd[nextPosition++] = this.pythonCacheProfiler;
        if (cmd.length != nextPosition) {
            throw new Exception("ERROR: Incorrect number of parameters. Expected: " + cmd.length + ". Got: " + nextPosition);
        }
        return cmd;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }
}

