/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

public class ByteBufferInputStream
extends InputStream {
    ByteBuffer bb;

    public ByteBufferInputStream(ByteBuffer bb) {
        this.bb = bb;
    }

    @Override
    public int read() throws IOException {
        if (this.bb == null) {
            throw new IOException("Buffer is not initialized");
        }
        if (this.bb.remaining() == 0) {
            return -1;
        }
        return this.bb.get();
    }

    @Override
    public int read(byte[] b, int offset, int numBytes) throws IOException {
        if (this.bb == null) {
            throw new IOException("Buffer is not initialized");
        }
        if (b == null) {
            throw new IOException("Byte array is null");
        }
        if (offset < 0 || numBytes < 0 || numBytes > b.length - offset) {
            throw new IndexOutOfBoundsException();
        }
        if (numBytes == 0) {
            return 0;
        }
        int length = Math.min(this.bb.remaining(), numBytes);
        if (length == 0) {
            return -1;
        }
        this.bb.get(b, offset, numBytes);
        return length;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int available() throws IOException {
        if (this.bb == null) {
            throw new IOException("Buffer is not initialized");
        }
        return this.bb.remaining();
    }

    @Override
    public void close() throws IOException {
        this.bb = null;
    }
}

