/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.master;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.commands.NIOData;
import es.bsc.compss.nio.master.NIOAdaptor;
import es.bsc.compss.nio.master.NIOWorkerNode;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.implementations.MethodImplementation;
import es.bsc.compss.types.implementations.MultiNodeImplementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.BasicTypeParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Resource;
import java.util.LinkedList;
import java.util.List;

public class NIOJob
extends Job<NIOWorkerNode> {
    private final List<String> slaveWorkersNodeNames;

    public NIOJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener) {
        super(taskId, taskParams, impl, res, listener);
        this.slaveWorkersNodeNames = slaveWorkersNodeNames;
    }

    @Override
    public Implementation.TaskType getType() {
        return Implementation.TaskType.METHOD;
    }

    @Override
    public String getHostName() {
        return this.worker.getName();
    }

    @Override
    public void submit() throws Exception {
        LOGGER.info("Submit NIOJob with ID " + this.jobId);
        NIOAdaptor.submitTask(this);
    }

    public NIOTask prepareJob() {
        AbstractMethodImplementation absMethodImpl = (AbstractMethodImplementation)this.impl;
        switch (absMethodImpl.getMethodType()) {
            case METHOD: {
                MethodImplementation methodImpl = (MethodImplementation)absMethodImpl;
                String methodName = methodImpl.getAlternativeMethodName();
                if (methodName != null && !methodName.isEmpty()) break;
                methodImpl.setAlternativeMethodName(this.taskParams.getName());
                break;
            }
            case MULTI_NODE: {
                MultiNodeImplementation multiNodeImpl = (MultiNodeImplementation)absMethodImpl;
                String multiNodeMethodName = multiNodeImpl.getMethodName();
                if (multiNodeMethodName != null && !multiNodeMethodName.isEmpty()) break;
                multiNodeImpl.setMethodName(this.taskParams.getName());
                break;
            }
        }
        LinkedList<NIOParam> params = this.addParams();
        int numParams = params.size() - this.taskParams.getNumReturns();
        NIOTask nt = new NIOTask(this.getLang(), DEBUG, absMethodImpl, this.taskParams.hasTargetObject(), this.taskParams.getNumReturns(), params, numParams, absMethodImpl.getRequirements(), this.slaveWorkersNodeNames, this.taskId, this.taskParams.getType(), this.jobId, this.history, this.transferId);
        return nt;
    }

    private LinkedList<NIOParam> addParams() {
        LinkedList<NIOParam> params = new LinkedList<NIOParam>();
        for (Parameter param : this.taskParams.getParameters()) {
            NIOParam np;
            DataType type = param.getType();
            switch (type) {
                case FILE_T: 
                case OBJECT_T: 
                case PSCO_T: 
                case EXTERNAL_PSCO_T: 
                case BINDING_OBJECT_T: {
                    String pscoId;
                    String dataMgmtId;
                    DependencyParameter dPar = (DependencyParameter)param;
                    DataAccessId dAccId = dPar.getDataAccessId();
                    Object value = dPar.getDataTarget();
                    boolean preserveSourceData = true;
                    preserveSourceData = dAccId instanceof DataAccessId.RAccessId ? ((DataAccessId.RAccessId)dAccId).isPreserveSourceData() : (dAccId instanceof DataAccessId.RWAccessId ? ((DataAccessId.RWAccessId)dAccId).isPreserveSourceData() : false);
                    String renaming = null;
                    DataAccessId faId = dPar.getDataAccessId();
                    if (faId instanceof DataAccessId.RWAccessId) {
                        DataAccessId.RWAccessId rwaId = (DataAccessId.RWAccessId)faId;
                        renaming = rwaId.getReadDataInstance().getRenaming();
                        dataMgmtId = rwaId.getWrittenDataInstance().getRenaming();
                    } else if (faId instanceof DataAccessId.RAccessId) {
                        DataAccessId.RAccessId raId = (DataAccessId.RAccessId)faId;
                        dataMgmtId = renaming = raId.getReadDataInstance().getRenaming();
                    } else {
                        DataAccessId.WAccessId waId = (DataAccessId.WAccessId)faId;
                        dataMgmtId = waId.getWrittenDataInstance().getRenaming();
                    }
                    if (renaming != null && (pscoId = Comm.getData(renaming).getPscoId()) != null) {
                        if (type.equals((Object)DataType.OBJECT_T)) {
                            param.setType(DataType.PSCO_T);
                        } else if (type.equals((Object)DataType.FILE_T)) {
                            param.setType(DataType.EXTERNAL_PSCO_T);
                        }
                        type = param.getType();
                    }
                    boolean writeFinalValue = !(dAccId instanceof DataAccessId.RAccessId);
                    np = new NIOParam(dataMgmtId, type, param.getStream(), param.getPrefix(), param.getName(), preserveSourceData, writeFinalValue, value, (NIOData)dPar.getDataSource(), dPar.getOriginalName());
                    break;
                }
                default: {
                    BasicTypeParameter btParB = (BasicTypeParameter)param;
                    Object value = btParB.getValue();
                    boolean preserveSourceData = false;
                    boolean writeFinalValue = false;
                    np = new NIOParam(null, type, param.getStream(), param.getPrefix(), param.getName(), preserveSourceData, writeFinalValue, value, null, "NO_NAME");
                }
            }
            params.add(np);
        }
        return params;
    }

    public void taskFinished(boolean successful) {
        if (successful) {
            this.listener.jobCompleted(this);
        } else {
            this.listener.jobFailed(this, JobListener.JobEndStatus.EXECUTION_FAILED);
        }
    }

    @Override
    public void stop() throws Exception {
    }

    @Override
    public String toString() {
        MethodImplementation method = (MethodImplementation)this.impl;
        String className = method.getDeclaringClass();
        String methodName = this.taskParams.getName();
        return "NIOJob JobId" + this.jobId + " for method " + methodName + " at class " + className;
    }
}

