/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.impl;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.BindingObject;
import es.bsc.compss.types.data.AccessParams;
import es.bsc.compss.types.data.CollectionInfo;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.DataVersion;
import es.bsc.compss.types.data.FileInfo;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.ObjectInfo;
import es.bsc.compss.types.data.ResultFile;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.BindingObjectLocation;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.PersistentLocation;
import es.bsc.compss.types.data.operation.BindingObjectTransferable;
import es.bsc.compss.types.data.operation.FileTransferable;
import es.bsc.compss.types.data.operation.ObjectTransferable;
import es.bsc.compss.types.data.operation.OneOpWithSemListener;
import es.bsc.compss.types.data.operation.ResultListener;
import es.bsc.compss.types.parameter.CollectionParameter;
import es.bsc.compss.types.request.ap.TransferBindingObjectRequest;
import es.bsc.compss.types.request.ap.TransferObjectRequest;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Serializer;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StorageException;
import storage.StorageItf;

public class DataInfoProvider {
    private static final String RES_FILE_TRANSFER_ERR = "Error transferring result files";
    private TreeMap<String, Integer> nameToId = new TreeMap();
    private TreeMap<String, Integer> collectionToId = new TreeMap();
    private TreeMap<Integer, Integer> codeToId = new TreeMap();
    private TreeMap<Integer, DataInfo> idToData = new TreeMap();
    private TreeMap<String, Object> renamingToValue = new TreeMap();
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor.DataInfoProvider");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();

    public DataInfoProvider() {
        LOGGER.info("Initialization finished");
    }

    public DataAccessId registerDataAccess(AccessParams access) {
        if (access instanceof AccessParams.FileAccessParams) {
            AccessParams.FileAccessParams fAccess = (AccessParams.FileAccessParams)access;
            return this.registerFileAccess(fAccess.getMode(), fAccess.getLocation());
        }
        if (access instanceof AccessParams.BindingObjectAccessParams) {
            AccessParams.BindingObjectAccessParams oAccess = (AccessParams.BindingObjectAccessParams)access;
            return this.registerBindingObjectAccess(oAccess.getMode(), oAccess.getBindingObject(), oAccess.getCode());
        }
        AccessParams.ObjectAccessParams oAccess = (AccessParams.ObjectAccessParams)access;
        return this.registerObjectAccess(oAccess.getMode(), oAccess.getValue(), oAccess.getCode());
    }

    public DataAccessId registerFileAccess(AccessParams.AccessMode mode, DataLocation location) {
        DataInfo fileInfo;
        String locationKey = location.getLocationKey();
        Integer fileId = this.nameToId.get(locationKey);
        if (fileId == null) {
            if (DEBUG) {
                LOGGER.debug("FIRST access to " + location.getLocationKey());
            }
            fileInfo = new FileInfo(location);
            fileId = fileInfo.getDataId();
            this.nameToId.put(locationKey, fileId);
            this.idToData.put(fileId, fileInfo);
            if (mode != AccessParams.AccessMode.W) {
                Comm.registerLocation(fileInfo.getCurrentDataVersion().getDataInstanceId().getRenaming(), location);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("Another access to " + location.getLocationKey());
            }
            fileInfo = this.idToData.get(fileId);
        }
        return this.willAccess(mode, fileInfo);
    }

    public void finishFileAccess(AccessParams.AccessMode mode, DataLocation location) {
        String locationKey = location.getLocationKey();
        Integer fileId = this.nameToId.get(locationKey);
        if (fileId == null) {
            LOGGER.warn("File " + location.getLocationKey() + " has not been accessed before");
            return;
        }
        DataInfo fileInfo = this.idToData.get(fileId);
        DataAccessId daid = this.getAccess(mode, fileInfo);
        if (daid == null) {
            LOGGER.warn("File " + location.getLocationKey() + " has not been accessed before");
            return;
        }
        this.dataHasBeenAccessed(daid);
    }

    public void finishBindingObjectAccess(AccessParams.AccessMode mode, int code) {
        Integer aoId = this.codeToId.get(code);
        if (aoId == null) {
            LOGGER.warn("Binding Object " + code + " has not been accessed before");
            return;
        }
        DataInfo boInfo = this.idToData.get(aoId);
        DataAccessId daid = this.getAccess(mode, boInfo);
        if (daid == null) {
            LOGGER.warn("Binding Object " + code + " has not been accessed before");
            return;
        }
        this.dataHasBeenAccessed(daid);
    }

    public DataAccessId registerObjectAccess(AccessParams.AccessMode mode, Object value, int code) {
        DataInfo oInfo;
        Integer aoId = this.codeToId.get(code);
        if (aoId == null) {
            if (DEBUG) {
                LOGGER.debug("FIRST access to object " + code);
            }
            oInfo = new ObjectInfo(code);
            aoId = oInfo.getDataId();
            this.codeToId.put(code, aoId);
            this.idToData.put(aoId, oInfo);
            DataInstanceId lastDID = oInfo.getCurrentDataVersion().getDataInstanceId();
            String renaming = lastDID.getRenaming();
            if (mode != AccessParams.AccessMode.W) {
                Comm.registerValue(renaming, value);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("Another access to object " + code);
            }
            oInfo = this.idToData.get(aoId);
        }
        return this.willAccess(mode, oInfo);
    }

    public DataAccessId registerBindingObjectAccess(AccessParams.AccessMode mode, BindingObject bo, int code) {
        DataInfo oInfo;
        Integer aoId = this.codeToId.get(code);
        if (aoId == null) {
            if (DEBUG) {
                LOGGER.debug("FIRST access to external object " + code);
            }
            oInfo = new ObjectInfo(code);
            aoId = oInfo.getDataId();
            this.codeToId.put(code, aoId);
            this.idToData.put(aoId, oInfo);
            DataInstanceId lastDID = oInfo.getCurrentDataVersion().getDataInstanceId();
            String renaming = lastDID.getRenaming();
            if (mode != AccessParams.AccessMode.W) {
                Comm.registerBindingObject(renaming, bo);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("Another access to external object " + code);
            }
            oInfo = this.idToData.get(aoId);
        }
        return this.willAccess(mode, oInfo);
    }

    public DataAccessId registerExternalPSCOAccess(AccessParams.AccessMode mode, String pscoId, int code) {
        DataInfo oInfo;
        Integer aoId = this.codeToId.get(code);
        if (aoId == null) {
            if (DEBUG) {
                LOGGER.debug("FIRST access to external object " + code);
            }
            oInfo = new ObjectInfo(code);
            aoId = oInfo.getDataId();
            this.codeToId.put(code, aoId);
            this.idToData.put(aoId, oInfo);
            DataInstanceId lastDID = oInfo.getCurrentDataVersion().getDataInstanceId();
            String renaming = lastDID.getRenaming();
            if (mode != AccessParams.AccessMode.W) {
                Comm.registerExternalPSCO(renaming, pscoId);
            }
        } else {
            if (DEBUG) {
                LOGGER.debug("Another access to external object " + code);
            }
            oInfo = this.idToData.get(aoId);
        }
        return this.willAccess(mode, oInfo);
    }

    private DataAccessId willAccess(AccessParams.AccessMode mode, DataInfo di) {
        DataAccessId daId = null;
        switch (mode) {
            case C: 
            case R: {
                di.willBeRead();
                daId = new DataAccessId.RAccessId(di.getCurrentDataVersion());
                if (!DEBUG) break;
                StringBuilder sb = new StringBuilder("");
                sb.append("Access:").append("\n");
                sb.append("  * Type: R").append("\n");
                sb.append("  * Read Datum: d").append(daId.getDataId()).append("v").append(((DataAccessId.RAccessId)daId).getRVersionId()).append("\n");
                LOGGER.debug(sb.toString());
                break;
            }
            case W: {
                di.willBeWritten();
                daId = new DataAccessId.WAccessId(di.getCurrentDataVersion());
                if (!DEBUG) break;
                StringBuilder sb = new StringBuilder("");
                sb.append("Access:").append("\n");
                sb.append("  * Type: W").append("\n");
                sb.append("  * Write Datum: d").append(daId.getDataId()).append("v").append(((DataAccessId.WAccessId)daId).getWVersionId()).append("\n");
                LOGGER.debug(sb.toString());
                break;
            }
            case RW: {
                di.willBeRead();
                DataVersion readInstance = di.getCurrentDataVersion();
                di.willBeWritten();
                DataVersion writtenInstance = di.getCurrentDataVersion();
                daId = new DataAccessId.RWAccessId(readInstance, writtenInstance);
                if (!DEBUG) break;
                StringBuilder sb = new StringBuilder("");
                sb.append("Access:").append("\n");
                sb.append("  * Type: RW").append("\n");
                sb.append("  * Read Datum: d").append(daId.getDataId()).append("v").append(((DataAccessId.RWAccessId)daId).getRVersionId()).append("\n");
                sb.append("  * Write Datum: d").append(daId.getDataId()).append("v").append(((DataAccessId.RWAccessId)daId).getWVersionId()).append("\n");
                LOGGER.debug(sb.toString());
            }
        }
        return daId;
    }

    private DataAccessId getAccess(AccessParams.AccessMode mode, DataInfo di) {
        DataAccessId daId = null;
        DataVersion currentInstance = di.getCurrentDataVersion();
        if (currentInstance != null) {
            switch (mode) {
                case C: 
                case R: {
                    daId = new DataAccessId.RAccessId(currentInstance);
                    break;
                }
                case W: {
                    daId = new DataAccessId.WAccessId(di.getCurrentDataVersion());
                    break;
                }
                case RW: {
                    DataVersion readInstance = di.getPreviousDataVersion();
                    if (readInstance != null) {
                        daId = new DataAccessId.RWAccessId(readInstance, currentInstance);
                        break;
                    }
                    LOGGER.warn("Previous instance for data" + di.getDataId() + " is null.");
                }
            }
        } else {
            LOGGER.warn("Current instance for data" + di.getDataId() + " is null.");
        }
        return daId;
    }

    public void dataHasBeenAccessed(DataAccessId dAccId) {
        Integer dataId = dAccId.getDataId();
        DataInfo di = this.idToData.get(dataId);
        boolean deleted = false;
        switch (dAccId.getDirection()) {
            case C: 
            case R: {
                Integer rVersionId = ((DataAccessId.RAccessId)dAccId).getReadDataInstance().getVersionId();
                deleted = di.versionHasBeenRead(rVersionId);
                break;
            }
            case RW: {
                Integer rVersionId = ((DataAccessId.RWAccessId)dAccId).getReadDataInstance().getVersionId();
                di.versionHasBeenRead(rVersionId);
                di.tryRemoveVersion(rVersionId);
                Integer wVersionId = ((DataAccessId.RWAccessId)dAccId).getWrittenDataInstance().getVersionId();
                deleted = di.versionHasBeenWritten(wVersionId);
                break;
            }
            default: {
                Integer wVersionId = ((DataAccessId.WAccessId)dAccId).getWrittenDataInstance().getVersionId();
                deleted = di.versionHasBeenWritten(wVersionId);
            }
        }
        if (deleted) {
            // empty if block
        }
    }

    public boolean alreadyAccessed(DataLocation loc) {
        LOGGER.debug("Check already accessed: " + loc.getLocationKey());
        String locationKey = loc.getLocationKey();
        Integer fileId = this.nameToId.get(locationKey);
        return fileId != null;
    }

    public String getLastRenaming(int code) {
        Integer aoId = this.codeToId.get(code);
        DataInfo oInfo = this.idToData.get(aoId);
        return oInfo.getCurrentDataVersion().getDataInstanceId().getRenaming();
    }

    public DataLocation getOriginalLocation(int fileId) {
        FileInfo info = (FileInfo)this.idToData.get(fileId);
        return info.getOriginalLocation();
    }

    public void setObjectVersionValue(String renaming, Object value) {
        this.renamingToValue.put(renaming, value);
        Comm.registerValue(renaming, value);
    }

    public boolean isHere(DataInstanceId dId) {
        return this.renamingToValue.get(dId.getRenaming()) != null;
    }

    public Object getObject(String renaming) {
        return this.renamingToValue.get(renaming);
    }

    public void newVersionSameValue(String rRenaming, String wRenaming) {
        this.renamingToValue.put(wRenaming, this.renamingToValue.get(rRenaming));
    }

    public DataInstanceId getLastDataAccess(int code) {
        Integer aoId = this.codeToId.get(code);
        DataInfo oInfo = this.idToData.get(aoId);
        return oInfo.getCurrentDataVersion().getDataInstanceId();
    }

    public List<DataInstanceId> getLastVersions(TreeSet<Integer> dataIds) {
        ArrayList<DataInstanceId> versionIds = new ArrayList<DataInstanceId>(dataIds.size());
        for (Integer dataId : dataIds) {
            DataInfo dataInfo = this.idToData.get(dataId);
            if (dataInfo != null) {
                versionIds.add(dataInfo.getCurrentDataVersion().getDataInstanceId());
                continue;
            }
            versionIds.add(null);
        }
        return versionIds;
    }

    public void unblockDataId(Integer dataId) {
        DataInfo dataInfo = this.idToData.get(dataId);
        dataInfo.unblockDeletions();
    }

    public DataInfo deleteData(DataLocation loc) {
        LOGGER.debug("Deleting Data location: " + loc.getPath());
        String locationKey = loc.getLocationKey();
        Integer dataId = this.nameToId.get(locationKey);
        if (dataId == null) {
            LOGGER.debug("No data id found for this data location" + loc.getPath());
            return null;
        }
        DataInfo dataInfo = this.idToData.get(dataId);
        this.nameToId.remove(locationKey);
        if (dataInfo.delete()) {
            // empty if block
        }
        return dataInfo;
    }

    public DataInfo deleteData(int code) {
        LOGGER.debug("Deleting Data associated with code: " + String.valueOf(code));
        Integer id = this.codeToId.get(code);
        DataInfo dataInfo = this.idToData.get(id);
        dataInfo.delete();
        return dataInfo;
    }

    public void transferObjectValue(TransferObjectRequest toRequest) {
        LogicalData ld;
        Semaphore sem = toRequest.getSemaphore();
        DataAccessId daId = toRequest.getDaId();
        DataAccessId.RWAccessId rwaId = (DataAccessId.RWAccessId)daId;
        String sourceName = rwaId.getReadDataInstance().getRenaming();
        if (DEBUG) {
            LOGGER.debug("Requesting getting object " + sourceName);
        }
        if ((ld = Comm.getData(sourceName)) == null) {
            ErrorManager.error("Unregistered data " + sourceName);
            return;
        }
        if (ld.isInMemory()) {
            Object value = null;
            if (!rwaId.isPreserveSourceData()) {
                value = ld.getValue();
                ld.removeValue();
            } else {
                try {
                    ld.writeToStorage();
                }
                catch (Exception e) {
                    ErrorManager.error("Exception writing object to file.", e);
                }
                for (DataLocation loc : ld.getLocations()) {
                    if (loc.getProtocol() == DataLocation.Protocol.OBJECT_URI) continue;
                    MultiURI mu = loc.getURIInHost(Comm.getAppHost());
                    String path = mu.getPath();
                    try {
                        value = Serializer.deserialize(path);
                        break;
                    }
                    catch (IOException | ClassNotFoundException e) {
                        ErrorManager.error("Exception writing object to file.", e);
                    }
                }
            }
            toRequest.setResponse(value);
            toRequest.setTargetData(ld);
            sem.release();
        } else {
            if (DEBUG) {
                LOGGER.debug("Object " + sourceName + " not in memory. Requesting tranfers to " + Comm.getAppHost().getName());
            }
            DataLocation targetLocation = null;
            String path = DataLocation.Protocol.FILE_URI.getSchema() + Comm.getAppHost().getTempDirPath() + sourceName;
            try {
                SimpleURI uri = new SimpleURI(path);
                targetLocation = DataLocation.createLocation(Comm.getAppHost(), uri);
            }
            catch (Exception e) {
                ErrorManager.error("ERROR: Invalid location URI " + path, e);
            }
            toRequest.setTargetData(ld);
            Comm.getAppHost().getData(sourceName, targetLocation, (Transferable)new ObjectTransferable(), (EventListener)new OneOpWithSemListener(sem));
        }
    }

    public LogicalData transferBindingObject(TransferBindingObjectRequest toRequest) {
        LogicalData srcLd;
        Semaphore sem = toRequest.getSemaphore();
        DataAccessId daId = toRequest.getDaId();
        DataAccessId.RAccessId rwaId = (DataAccessId.RAccessId)daId;
        String sourceName = rwaId.getReadDataInstance().getRenaming();
        if (DEBUG) {
            LOGGER.debug("[DataInfoProvider] Requesting getting object " + sourceName);
        }
        LogicalData tgtLd = srcLd = Comm.getData(sourceName);
        if (DEBUG) {
            LOGGER.debug("[DataInfoProvider] Logical data for binding object is:" + srcLd);
        }
        if (srcLd == null) {
            ErrorManager.error("Unregistered data " + sourceName);
            return null;
        }
        if (DEBUG) {
            LOGGER.debug("Requesting tranfers binding object " + sourceName + " to " + Comm.getAppHost().getName());
        }
        BindingObject srcBO = BindingObject.generate(srcLd.getURIs().get(0).getPath());
        BindingObject tgtBO = new BindingObject(Comm.getAppHost().getTempDirPath() + sourceName, srcBO.getType(), srcBO.getElements());
        BindingObjectLocation targetLocation = new BindingObjectLocation(Comm.getAppHost(), tgtBO);
        BindingObjectTransferable transfer = new BindingObjectTransferable(toRequest);
        Comm.getAppHost().getData(srcLd, (DataLocation)targetLocation, tgtLd, (Transferable)transfer, (EventListener)new OneOpWithSemListener(sem));
        if (DEBUG) {
            LOGGER.debug(" Setting tgtName " + transfer.getDataTarget() + " in " + Comm.getAppHost().getName());
        }
        return srcLd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultFile blockDataAndGetResultFile(int dataId, ResultListener listener) {
        FileInfo fileInfo = (FileInfo)this.idToData.get(dataId);
        if (fileInfo != null && !fileInfo.isCurrentVersionToDelete()) {
            String[] splitPath = fileInfo.getOriginalLocation().getPath().split(File.separator);
            String origName = splitPath[splitPath.length - 1];
            if (origName.startsWith("compss-serialized-obj_")) {
                if (DEBUG) {
                    LOGGER.debug("Discarding file " + origName + " as a result");
                }
                return null;
            }
            fileInfo.blockDeletions();
            DataInstanceId lastVersion = fileInfo.getCurrentDataVersion().getDataInstanceId();
            ResultFile rf = new ResultFile(lastVersion, fileInfo.getOriginalLocation());
            DataInstanceId fId = rf.getFileInstanceId();
            String renaming = fId.getRenaming();
            while (renaming != null && !Comm.existsData(renaming)) {
                renaming = DataInstanceId.previousVersionRenaming(renaming);
            }
            if (renaming == null) {
                LOGGER.error("Error transferring result files: Cannot transfer file " + fId.getRenaming() + " nor any of its previous versions");
                return null;
            }
            for (DataLocation loc : Comm.getData(renaming).getLocations()) {
                if (!(loc instanceof PersistentLocation)) continue;
                String pscoId = ((PersistentLocation)loc).getId();
                if (Tracer.isActivated()) {
                    Tracer.emitEvent(Tracer.Event.STORAGE_CONSOLIDATE.getId(), Tracer.Event.STORAGE_CONSOLIDATE.getType());
                }
                try {
                    StorageItf.consolidateVersion(pscoId);
                }
                catch (StorageException e) {
                    LOGGER.error("Cannot consolidate PSCO " + pscoId, (Throwable)e);
                }
                finally {
                    if (Tracer.isActivated()) {
                        Tracer.emitEvent(0L, Tracer.Event.STORAGE_CONSOLIDATE.getType());
                    }
                }
                LOGGER.debug("Returned because persistent object");
                return rf;
            }
            if (rf.getOriginalLocation().getProtocol() == DataLocation.Protocol.BINDING_URI) {
                if (DEBUG) {
                    LOGGER.debug("Discarding data d" + dataId + " as a result beacuse it is a binding object");
                }
            } else {
                listener.addOperation();
                Comm.getAppHost().getData(renaming, rf.getOriginalLocation(), (Transferable)new FileTransferable(), (EventListener)listener);
            }
            return rf;
        }
        if (fileInfo != null && fileInfo.isCurrentVersionToDelete()) {
            if (DEBUG) {
                String[] splitPath = fileInfo.getOriginalLocation().getPath().split(File.separator);
                String origName = splitPath[splitPath.length - 1];
                LOGGER.debug("Trying to delete file " + origName);
            }
            if (fileInfo.delete()) {
                // empty if block
            }
        }
        return null;
    }

    public void shutdown() {
    }

    public DataAccessId registerCollectionAccess(AccessParams.AccessMode am, CollectionParameter cp) {
        CollectionInfo cInfo;
        String collectionId = cp.getCollectionId();
        Integer oId = this.collectionToId.get(collectionId);
        if (oId == null) {
            cInfo = new CollectionInfo(collectionId);
            oId = cInfo.getDataId();
            this.collectionToId.put(collectionId, oId);
            this.idToData.put(oId, cInfo);
            DataInstanceId lastDID = cInfo.getCurrentDataVersion().getDataInstanceId();
            String renaming = lastDID.getRenaming();
            if (am != AccessParams.AccessMode.W) {
                LOGGER.debug("Collection " + cp.getCollectionId() + " contains " + cp.getParameters().size() + " accesses");
                Comm.registerCollection(renaming, null);
            }
        } else {
            cInfo = (CollectionInfo)this.idToData.get(oId);
        }
        return this.willAccess(am, cInfo);
    }
}

