/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types;

import es.bsc.compss.components.impl.ResourceScheduler;
import es.bsc.compss.scheduler.exceptions.ActionNotFoundException;
import es.bsc.compss.scheduler.exceptions.ActionNotWaitingException;
import es.bsc.compss.scheduler.exceptions.BlockedActionException;
import es.bsc.compss.scheduler.exceptions.FailedActionException;
import es.bsc.compss.scheduler.exceptions.InvalidSchedulingException;
import es.bsc.compss.scheduler.exceptions.UnassignedActionException;
import es.bsc.compss.scheduler.types.ActionOrchestrator;
import es.bsc.compss.scheduler.types.Profile;
import es.bsc.compss.scheduler.types.SchedulingInformation;
import es.bsc.compss.scheduler.types.Score;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.resources.Worker;
import es.bsc.compss.types.resources.WorkerResourceDescription;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AllocatableAction {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskDispatcher.TaskScheduler");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    protected static final String DBG_PREFIX = "[AllocatableAction] ";
    private static final AtomicInteger NEXT_ID = new AtomicInteger();
    protected final ActionOrchestrator orchestrator;
    private final long id;
    private final List<AllocatableAction> dataPredecessors;
    private final List<AllocatableAction> dataSuccessors;
    private State state;
    private ResourceScheduler<? extends WorkerResourceDescription> selectedResource;
    private Implementation selectedImpl;
    private WorkerResourceDescription resourceConsumption;
    private final List<ResourceScheduler<? extends WorkerResourceDescription>> executingResources;
    private final SchedulingInformation schedulingInfo;
    protected Profile profile;
    private final ReentrantLock lock = new ReentrantLock();

    public AllocatableAction(SchedulingInformation schedulingInformation, ActionOrchestrator orchestrator) {
        this.id = NEXT_ID.getAndIncrement();
        this.orchestrator = orchestrator;
        this.dataPredecessors = new LinkedList<AllocatableAction>();
        this.dataSuccessors = new LinkedList<AllocatableAction>();
        this.state = State.RUNNABLE;
        this.selectedResource = null;
        this.selectedImpl = null;
        this.executingResources = new LinkedList<ResourceScheduler<? extends WorkerResourceDescription>>();
        this.schedulingInfo = schedulingInformation;
        this.profile = null;
    }

    protected void notifyCompleted() {
        if (DEBUG) {
            LOGGER.debug("Notify completed of " + this + " to orchestrator " + this.orchestrator);
        }
        this.orchestrator.actionCompletion(this);
    }

    protected void notifyError() {
        LOGGER.warn("Notify error of " + this + " to orchestrator " + this.orchestrator);
        this.orchestrator.actionError(this);
    }

    public final long getId() {
        return this.id;
    }

    public final List<AllocatableAction> getDataPredecessors() {
        return this.dataPredecessors;
    }

    public final List<AllocatableAction> getDataSuccessors() {
        return this.dataSuccessors;
    }

    public final boolean hasDataPredecessors() {
        return this.dataPredecessors.size() > 0;
    }

    public final void addDataPredecessor(AllocatableAction predecessor) {
        if (predecessor.isPending()) {
            if (!this.dataPredecessors.contains(predecessor)) {
                this.dataPredecessors.add(predecessor);
            }
            if (!predecessor.dataSuccessors.contains(this)) {
                predecessor.dataSuccessors.add(this);
            }
        }
    }

    private void dataPredecessorDone(AllocatableAction finishedAction) {
        Iterator<AllocatableAction> it = this.dataPredecessors.iterator();
        while (it.hasNext()) {
            AllocatableAction aa = it.next();
            if (aa != finishedAction) continue;
            it.remove();
        }
    }

    public final boolean isTargetResourceEnforced() {
        return this.schedulingInfo.getEnforcedTargetResource() != null;
    }

    public final ResourceScheduler<? extends WorkerResourceDescription> getEnforcedTargetResource() {
        return this.schedulingInfo.getEnforcedTargetResource();
    }

    public final boolean isSchedulingConstrained() {
        return !this.schedulingInfo.getConstrainingPredecessors().isEmpty();
    }

    public final void addResourceConstraint(AllocatableAction predecessor) {
        this.schedulingInfo.addResourceConstraint(predecessor);
    }

    public final boolean unrequiredResource() {
        for (AllocatableAction a : this.getConstrainingPredecessors()) {
            if (a.getAssignedResource() != this.selectedResource) continue;
            return false;
        }
        return true;
    }

    public final List<AllocatableAction> getConstrainingPredecessors() {
        return this.schedulingInfo.getConstrainingPredecessors();
    }

    protected final List<ResourceScheduler<? extends WorkerResourceDescription>> getCoreElementExecutors(int coreId) {
        return SchedulingInformation.getCoreElementExecutors(coreId);
    }

    public final SchedulingInformation getSchedulingInfo() {
        return this.schedulingInfo;
    }

    public final boolean isPending() {
        return this.state != State.FAILED && this.state != State.FINISHED;
    }

    public final boolean isRunning() {
        return this.state == State.RUNNING;
    }

    public final boolean isLocked() {
        return this.lock.isLocked();
    }

    public final boolean isNotScheduling() {
        return !this.isLocked() && !this.isRunning() && this.selectedResource == null && this.state == State.RUNNABLE;
    }

    public final Long getStartTime() {
        if (this.profile == null) {
            return null;
        }
        return this.profile.getStartTime();
    }

    public final void assignImplementation(Implementation impl) {
        if (this.state == State.RUNNABLE) {
            this.selectedImpl = impl;
        }
    }

    public final Implementation getAssignedImplementation() {
        return this.selectedImpl;
    }

    public final <T extends WorkerResourceDescription> void assignResource(ResourceScheduler<T> resource) {
        if (this.state == State.RUNNABLE) {
            this.selectedResource = resource;
        }
    }

    public final ResourceScheduler<? extends WorkerResourceDescription> getAssignedResource() {
        return this.selectedResource;
    }

    public final void tryToLaunch() throws InvalidSchedulingException {
        this.lock.lock();
        if (this.selectedResource != null && this.state == State.RUNNABLE && !this.hasDataPredecessors() && this.schedulingInfo.isExecutable()) {
            if (this.selectedResource.isRemoved() && !this.isToStopResource() || this.isSchedulingConstrained() && this.unrequiredResource() || this.isTargetResourceEnforced() && this.selectedResource != this.schedulingInfo.getEnforcedTargetResource()) {
                this.lock.unlock();
                LOGGER.debug("Action " + this + " incorrectly scheduled. Throwing exception.");
                throw new InvalidSchedulingException();
            }
            this.execute();
        } else {
            if (this.hasDataPredecessors() && DEBUG) {
                LOGGER.debug("[AllocatableAction] Action " + this + " not executed because data predecessors");
                for (AllocatableAction aa : this.getDataPredecessors()) {
                    LOGGER.debug("\n Predecessor: " + aa);
                }
            }
            this.lock.unlock();
        }
    }

    private void execute() {
        boolean reserve = this.isToReserveResources();
        boolean blocked = false;
        boolean enoughResources = false;
        if (reserve) {
            blocked = this.selectedResource.hasBlockedActions();
            enoughResources = this.areEnoughResources();
        }
        if (!reserve || !blocked && enoughResources) {
            this.executingResources.add(this.selectedResource);
            this.run();
        } else {
            LOGGER.info(this + " execution paused due to lack of resources on worker " + this.selectedResource.getName());
            this.state = State.WAITING;
            this.selectedResource.waitOnResource(this);
            this.lock.unlock();
        }
    }

    public final void resumeExecution() throws ActionNotWaitingException {
        this.lock.lock();
        if (this.state != State.WAITING) {
            this.lock.unlock();
            throw new ActionNotWaitingException();
        }
        LOGGER.info(this + " execution resumed on worker " + this.selectedResource.getName());
        this.run();
    }

    private void run() {
        this.state = State.RUNNING;
        this.lock.unlock();
        this.reserveResources();
        this.profile = this.selectedResource.generateProfileForRun(this);
        this.selectedResource.hostAction(this);
        this.doAction();
    }

    public abstract boolean isToStopResource();

    public abstract boolean isToReserveResources();

    private boolean areEnoughResources() {
        Worker<? extends WorkerResourceDescription> w = this.selectedResource.getResource();
        return w.canRunNow(this.selectedImpl.getRequirements());
    }

    public abstract boolean isToReleaseResources();

    private void reserveResources() {
        if (this.isToReserveResources()) {
            Worker<? extends WorkerResourceDescription> w = this.selectedResource.getResource();
            this.resourceConsumption = w.runTask(this.selectedImpl.getRequirements());
        }
    }

    protected final WorkerResourceDescription getResourceConsumption() {
        return this.resourceConsumption;
    }

    private void releaseResources() {
        if (this.isToReleaseResources()) {
            Worker<? extends WorkerResourceDescription> w = this.selectedResource.getResource();
            w.endTask(this.resourceConsumption);
        }
    }

    public final List<ResourceScheduler<? extends WorkerResourceDescription>> getExecutingResources() {
        return this.executingResources;
    }

    protected abstract void doAction();

    public final List<AllocatableAction> completed() {
        this.state = State.FINISHED;
        this.releaseResources();
        this.selectedResource.unhostAction(this);
        this.selectedResource.tryToLaunchBlockedActions();
        this.doCompleted();
        LinkedList<AllocatableAction> freeTasks = new LinkedList<AllocatableAction>();
        for (AllocatableAction aa : this.dataSuccessors) {
            aa.dataPredecessorDone(this);
            if (aa.hasDataPredecessors()) continue;
            freeTasks.add(aa);
        }
        this.dataSuccessors.clear();
        return freeTasks;
    }

    public final void error() throws FailedActionException {
        this.state = State.RUNNABLE;
        this.releaseResources();
        this.selectedResource.unhostAction(this);
        this.selectedResource.tryToLaunchBlockedActions();
        this.doError();
    }

    public final List<AllocatableAction> failed() {
        this.state = State.FAILED;
        boolean cancelled = false;
        if (this.selectedResource != null) {
            while (!cancelled) {
                try {
                    this.selectedResource.cancelAction(this);
                    cancelled = true;
                }
                catch (ActionNotFoundException anfe) {
                    LOGGER.warn("[Allocatable Action] Action not found exception when cancelling " + this);
                    while (this.selectedResource == null) {
                    }
                }
            }
        }
        for (AllocatableAction pred : this.dataPredecessors) {
            pred.dataSuccessors.remove(this);
        }
        LinkedList<AllocatableAction> failed = new LinkedList<AllocatableAction>();
        for (AllocatableAction succ : this.dataSuccessors) {
            failed.addAll(succ.failed());
        }
        failed.add(this);
        this.dataPredecessors.clear();
        this.dataSuccessors.clear();
        this.doFailed();
        return failed;
    }

    protected abstract void doCompleted();

    protected abstract void doError() throws FailedActionException;

    protected abstract void doFailed();

    public abstract Integer getCoreId();

    public abstract List<ResourceScheduler<? extends WorkerResourceDescription>> getCompatibleWorkers();

    public abstract Implementation[] getImplementations();

    public abstract <W extends WorkerResourceDescription> boolean isCompatible(Worker<W> var1);

    public abstract <T extends WorkerResourceDescription> List<Implementation> getCompatibleImplementations(ResourceScheduler<T> var1);

    public abstract int getPriority();

    public abstract <T extends WorkerResourceDescription> Score schedulingScore(ResourceScheduler<T> var1, Score var2);

    public abstract void schedule(Score var1) throws BlockedActionException, UnassignedActionException;

    public abstract <T extends WorkerResourceDescription> void schedule(ResourceScheduler<T> var1, Score var2) throws BlockedActionException, UnassignedActionException;

    public abstract <T extends WorkerResourceDescription> void schedule(ResourceScheduler<T> var1, Implementation var2) throws BlockedActionException, UnassignedActionException;

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("HashCode ").append(this.hashCode()).append("\n");
        sb.append("\tdataPredecessors:");
        for (AllocatableAction aa : this.dataPredecessors) {
            sb.append(" ").append(aa.hashCode());
        }
        sb.append("\n");
        sb.append("\tdataSuccessors: ");
        for (AllocatableAction aa : this.dataSuccessors) {
            sb.append(" ").append(aa.hashCode());
        }
        sb.append("\n");
        sb.append(this.schedulingInfo);
        sb.append("\n");
        return sb.toString();
    }

    private static enum State {
        RUNNABLE,
        WAITING,
        RUNNING,
        FINISHED,
        FAILED;

    }
}

