/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.scheduler.types;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.Worker;
import java.util.Set;

public class Score
implements Comparable<Score> {
    protected long actionScore;
    protected long resourceScore;
    protected long waitingScore;
    protected long implementationScore;

    public Score(long actionScore, long res, long waiting, long impl) {
        this.actionScore = actionScore;
        this.resourceScore = res;
        this.waitingScore = waiting;
        this.implementationScore = impl;
    }

    public Score(Score clone) {
        this.actionScore = clone.actionScore;
        this.resourceScore = clone.resourceScore;
        this.waitingScore = clone.waitingScore;
        this.implementationScore = clone.implementationScore;
    }

    public long getActionScore() {
        return this.actionScore;
    }

    public long getWaitingScore() {
        return this.waitingScore;
    }

    public long getResourceScore() {
        return this.resourceScore;
    }

    public long getImplementationScore() {
        return this.implementationScore;
    }

    public static final boolean isBetter(Score a, Score b) {
        if (a == null) {
            return false;
        }
        if (b == null) {
            return true;
        }
        return a.isBetter(b);
    }

    public boolean isBetter(Score other) {
        if (this.actionScore != other.actionScore) {
            return this.actionScore > other.actionScore;
        }
        if (this.resourceScore != other.resourceScore) {
            return this.resourceScore > other.resourceScore;
        }
        if (this.waitingScore != other.waitingScore) {
            return this.waitingScore > other.waitingScore;
        }
        return this.implementationScore > other.implementationScore;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Long.hashCode(this.actionScore);
        result = 31 * result + Long.hashCode(this.resourceScore);
        result = 31 * result + Long.hashCode(this.waitingScore);
        result = 31 * result + Long.hashCode(this.implementationScore);
        return result;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Score) {
            Score other = (Score)obj;
            return this.actionScore == other.actionScore && this.resourceScore == other.resourceScore && this.waitingScore == other.waitingScore && this.implementationScore == other.implementationScore;
        }
        return false;
    }

    @Override
    public int compareTo(Score other) {
        if (this.equals(other)) {
            return 0;
        }
        if (this.isBetter(other)) {
            return 1;
        }
        return -1;
    }

    public static long calculateDataLocalityScore(TaskDescription params, Worker<?> w) {
        long resourceScore = 0L;
        if (params != null) {
            Parameter[] parameters;
            for (Parameter p : parameters = params.getParameters()) {
                LogicalData dataLD;
                if (!(p instanceof DependencyParameter) || p.getDirection() == Direction.OUT) continue;
                DependencyParameter dp = (DependencyParameter)p;
                DataInstanceId dId = null;
                switch (dp.getDirection()) {
                    case CONCURRENT: 
                    case IN: {
                        DataAccessId.RAccessId raId = (DataAccessId.RAccessId)dp.getDataAccessId();
                        dId = raId.getReadDataInstance();
                        break;
                    }
                    case INOUT: {
                        DataAccessId.RWAccessId rwaId = (DataAccessId.RWAccessId)dp.getDataAccessId();
                        dId = rwaId.getReadDataInstance();
                        break;
                    }
                }
                if (dId == null || (dataLD = Comm.getData(dId.getRenaming())) == null) continue;
                Set<Resource> hosts = dataLD.getAllHosts();
                for (Resource host : hosts) {
                    if (host != w) continue;
                    ++resourceScore;
                }
            }
        }
        return resourceScore;
    }

    public String toString() {
        return "[Score = [action:" + this.actionScore + ", " + "resource:" + this.resourceScore + ", " + "load:" + this.waitingScore + ", " + "implementation:" + this.implementationScore + "]" + "]";
    }
}

