/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.resources;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.comm.CommAdaptor;
import es.bsc.compss.types.COMPSsMaster;
import es.bsc.compss.types.resources.DynamicMethodWorker;
import es.bsc.compss.types.resources.MasterResource;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.util.ErrorManager;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;

public class MasterResourceImpl
extends DynamicMethodWorker
implements MasterResource {
    private static final String MASTER_NAME_PROPERTY = System.getProperty("compss.masterName");
    private static final String UNDEFINED_MASTER_NAME = "master";
    public static final String MASTER_NAME;

    public MasterResourceImpl() {
        super(MASTER_NAME, new MethodResourceDescription(), new COMPSsMaster(MASTER_NAME), 0, 0, 0, 0, new HashMap<String, String>());
    }

    public String getCOMPSsLogBaseDirPath() {
        return ((COMPSsMaster)this.getNode()).getCOMPSsLogBaseDirPath();
    }

    @Override
    public String getWorkingDirectory() {
        return ((COMPSsMaster)this.getNode()).getWorkingDirectory();
    }

    public String getUserExecutionDirPath() {
        return ((COMPSsMaster)this.getNode()).getUserExecutionDirPath();
    }

    @Override
    public String getAppLogDirPath() {
        return ((COMPSsMaster)this.getNode()).getAppLogDirPath();
    }

    @Override
    public String getTempDirPath() {
        return ((COMPSsMaster)this.getNode()).getTempDirPath();
    }

    @Override
    public String getJobsDirPath() {
        return ((COMPSsMaster)this.getNode()).getJobsDirPath();
    }

    @Override
    public String getWorkersDirPath() {
        return ((COMPSsMaster)this.getNode()).getWorkersDirPath();
    }

    @Override
    public void setInternalURI(MultiURI u) {
        for (CommAdaptor adaptor : Comm.getAdaptors().values()) {
            adaptor.completeMasterURI(u);
        }
    }

    @Override
    public Resource.Type getType() {
        return Resource.Type.MASTER;
    }

    @Override
    public int compareTo(Resource t) {
        if (t.getType() == Resource.Type.MASTER) {
            return this.getName().compareTo(t.getName());
        }
        return 1;
    }

    @Override
    public void updateDisks(Map<String, String> sharedDisks) {
        this.sharedDisks = sharedDisks;
    }

    static {
        String hostName = "";
        if (MASTER_NAME_PROPERTY != null && !MASTER_NAME_PROPERTY.equals("") && !MASTER_NAME_PROPERTY.equals("null")) {
            hostName = MASTER_NAME_PROPERTY;
        } else {
            try {
                InetAddress localHost = InetAddress.getLocalHost();
                hostName = localHost.getCanonicalHostName();
            }
            catch (UnknownHostException e) {
                ErrorManager.warn("ERROR_UNKNOWN_HOST: " + e.getLocalizedMessage());
                hostName = UNDEFINED_MASTER_NAME;
            }
        }
        MASTER_NAME = hostName;
    }
}

