/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.components.impl;

import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.components.impl.DataInfoProvider;
import es.bsc.compss.components.monitor.impl.GraphGenerator;
import es.bsc.compss.types.Task;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.AccessParams;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.DataInfo;
import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.operation.ResultListener;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.parameter.BindingObjectParameter;
import es.bsc.compss.types.parameter.CollectionParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.ExternalPSCOParameter;
import es.bsc.compss.types.parameter.FileParameter;
import es.bsc.compss.types.parameter.ObjectParameter;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.request.ap.BarrierRequest;
import es.bsc.compss.types.request.ap.EndOfAppRequest;
import es.bsc.compss.types.request.ap.WaitForConcurrentRequest;
import es.bsc.compss.types.request.ap.WaitForTaskRequest;
import es.bsc.compss.util.ErrorManager;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StubItf;

public class TaskAnalyser {
    private DataInfoProvider DIP;
    private GraphGenerator GM;
    private TreeMap<Integer, Task> writers;
    private HashMap<Integer, Integer> currentTaskCount = new HashMap();
    private HashMap<Long, Integer> appIdToTotalTaskCount;
    private HashMap<Long, Integer> appIdToTaskCount;
    private HashMap<Long, Semaphore> appIdToSemaphore;
    private HashSet<Long> appIdBarrierFlags;
    private HashMap<Long, TreeSet<Integer>> appIdToWrittenFiles;
    private HashMap<Long, TreeSet<Integer>> appIdToSCOWrittenIds;
    private Hashtable<Task, List<Semaphore>> waitedTasks;
    private TreeMap<Integer, List<Task>> concurrentAccessMap;
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor.TaskAnalyser");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String TASK_FAILED = "Task failed: ";
    private static final boolean IS_DRAW_GRAPH = GraphGenerator.isEnabled();
    private int synchronizationId = 0;
    private boolean taskDetectedAfterSync = false;

    public TaskAnalyser() {
        this.writers = new TreeMap();
        this.appIdToTaskCount = new HashMap();
        this.appIdToTotalTaskCount = new HashMap();
        this.appIdToSemaphore = new HashMap();
        this.appIdBarrierFlags = new HashSet();
        this.appIdToWrittenFiles = new HashMap();
        this.appIdToSCOWrittenIds = new HashMap();
        this.waitedTasks = new Hashtable();
        this.concurrentAccessMap = new TreeMap();
        LOGGER.info("Initialization finished");
    }

    public void setCoWorkers(DataInfoProvider DIP) {
        this.DIP = DIP;
    }

    public void setGM(GraphGenerator GM) {
        this.GM = GM;
    }

    private DataAccessId registerParameterAccessAndAddDependencies(Task currentTask, boolean isConstraining, Parameter p) {
        AccessParams.AccessMode am = AccessParams.AccessMode.R;
        switch (p.getDirection()) {
            case IN: {
                am = AccessParams.AccessMode.R;
                break;
            }
            case OUT: {
                am = AccessParams.AccessMode.W;
                break;
            }
            case INOUT: {
                am = AccessParams.AccessMode.RW;
                break;
            }
            case CONCURRENT: {
                am = AccessParams.AccessMode.C;
            }
        }
        DataAccessId daId = null;
        switch (p.getType()) {
            case FILE_T: {
                FileParameter fp = (FileParameter)p;
                daId = this.DIP.registerFileAccess(am, fp.getLocation());
                break;
            }
            case PSCO_T: {
                ObjectParameter pscop = (ObjectParameter)p;
                pscop.setType(DataType.PSCO_T);
                daId = this.DIP.registerObjectAccess(am, pscop.getValue(), pscop.getCode());
                break;
            }
            case EXTERNAL_PSCO_T: {
                ExternalPSCOParameter externalPSCOparam = (ExternalPSCOParameter)p;
                externalPSCOparam.setType(DataType.EXTERNAL_PSCO_T);
                daId = this.DIP.registerExternalPSCOAccess(am, externalPSCOparam.getId(), externalPSCOparam.getCode());
                break;
            }
            case BINDING_OBJECT_T: {
                BindingObjectParameter bindingObjectparam = (BindingObjectParameter)p;
                bindingObjectparam.setType(DataType.BINDING_OBJECT_T);
                daId = this.DIP.registerBindingObjectAccess(am, bindingObjectparam.getBindingObject(), bindingObjectparam.getCode());
                break;
            }
            case OBJECT_T: {
                ObjectParameter op = (ObjectParameter)p;
                if (op.getValue() instanceof StubItf && ((StubItf)op.getValue()).getID() != null) {
                    op.setType(DataType.PSCO_T);
                }
                daId = this.DIP.registerObjectAccess(am, op.getValue(), op.getCode());
                break;
            }
            case COLLECTION_T: {
                CollectionParameter cp = (CollectionParameter)p;
                for (Parameter content : cp.getParameters()) {
                    this.registerParameterAccessAndAddDependencies(currentTask, isConstraining, content);
                }
                daId = this.DIP.registerCollectionAccess(am, cp);
                break;
            }
            default: {
                return null;
            }
        }
        DependencyParameter dp = (DependencyParameter)p;
        dp.setDataAccessId(daId);
        this.addDependencies(am, currentTask, isConstraining, dp);
        return daId;
    }

    private void addDependencies(AccessParams.AccessMode am, Task currentTask, boolean isConstraining, DependencyParameter dp) {
        DataAccessId daId = dp.getDataAccessId();
        switch (am) {
            case R: {
                DataAccessId.RAccessId raId;
                DataInstanceId dependingDataId;
                if (!this.dataWasAccessedConcurrent(daId.getDataId())) {
                    this.checkDependencyForRead(currentTask, dp);
                } else {
                    this.checkDependencyForConcurrent(currentTask, dp);
                }
                if (!isConstraining || (dependingDataId = (raId = (DataAccessId.RAccessId)dp.getDataAccessId()).getReadDataInstance()) == null || dependingDataId.getVersionId() <= 1) break;
                currentTask.setEnforcingTask(this.writers.get(dependingDataId.getDataId()));
                break;
            }
            case RW: {
                DataAccessId.RWAccessId raId;
                DataInstanceId dependingDataId;
                if (!this.dataWasAccessedConcurrent(daId.getDataId())) {
                    this.checkDependencyForRead(currentTask, dp);
                } else {
                    this.checkDependencyForConcurrent(currentTask, dp);
                    this.removeFromConcurrentAccess(dp.getDataAccessId().getDataId());
                }
                if (isConstraining && (dependingDataId = (raId = (DataAccessId.RWAccessId)dp.getDataAccessId()).getReadDataInstance()) != null && dependingDataId.getVersionId() > 1) {
                    currentTask.setEnforcingTask(this.writers.get(dependingDataId.getDataId()));
                }
                this.registerOutputValues(currentTask, dp);
                break;
            }
            case W: {
                if (this.dataWasAccessedConcurrent(daId.getDataId())) {
                    this.removeFromConcurrentAccess(dp.getDataAccessId().getDataId());
                }
                this.registerOutputValues(currentTask, dp);
                break;
            }
            case C: {
                this.checkDependencyForRead(currentTask, dp);
                List<Task> tasks = this.concurrentAccessMap.get(daId.getDataId());
                if (tasks == null) {
                    tasks = new LinkedList<Task>();
                    this.concurrentAccessMap.put(daId.getDataId(), tasks);
                }
                tasks.add(currentTask);
            }
        }
    }

    public void processTask(Task currentTask) {
        Integer methodId;
        Integer actualCount;
        TaskDescription params = currentTask.getTaskDescription();
        LOGGER.info("New " + (params.getType() == Implementation.TaskType.METHOD ? "method" : "service") + " task(" + params.getName() + "), ID = " + currentTask.getId());
        if (IS_DRAW_GRAPH) {
            this.addNewTask(currentTask);
        }
        if ((actualCount = this.currentTaskCount.get(methodId = params.getId())) == null) {
            actualCount = 0;
        }
        this.currentTaskCount.put(methodId, actualCount + 1);
        Long appId = currentTask.getAppId();
        Integer taskCount = this.appIdToTaskCount.get(appId);
        if (taskCount == null) {
            taskCount = 0;
        }
        Integer n = taskCount;
        Integer n2 = taskCount = Integer.valueOf(taskCount + 1);
        this.appIdToTaskCount.put(appId, taskCount);
        Integer totalTaskCount = this.appIdToTotalTaskCount.get(appId);
        if (totalTaskCount == null) {
            totalTaskCount = 0;
        }
        n2 = totalTaskCount;
        Integer n3 = totalTaskCount = Integer.valueOf(totalTaskCount + 1);
        this.appIdToTotalTaskCount.put(appId, totalTaskCount);
        int constrainingParam = -1;
        if (params.getType() == Implementation.TaskType.SERVICE && params.hasTargetObject()) {
            constrainingParam = params.getParameters().length - 1 - params.getNumReturns();
        }
        Parameter[] parameters = params.getParameters();
        for (int paramIdx = 0; paramIdx < parameters.length; ++paramIdx) {
            this.registerParameterAccessAndAddDependencies(currentTask, paramIdx == constrainingParam, parameters[paramIdx]);
        }
    }

    public void endTask(Task task) {
        List<Semaphore> sems;
        int taskId = task.getId();
        boolean isFree = task.isFree();
        Task.TaskState taskState = task.getStatus();
        LOGGER.info("Notification received for task " + taskId + " with end status " + (Object)((Object)taskState));
        if (!isFree) {
            LOGGER.debug("Task " + taskId + " is not registered as free. Waiting for other executions to end");
            return;
        }
        if (taskState == Task.TaskState.FAILED) {
            ErrorManager.error(TASK_FAILED + task);
            TaskMonitor registeredMonitor = task.getTaskMonitor();
            registeredMonitor.onFailure();
            return;
        }
        LOGGER.debug("Ending task " + taskId);
        Long appId = task.getAppId();
        Integer taskCount = this.appIdToTaskCount.get(appId) - 1;
        this.appIdToTaskCount.put(appId, taskCount);
        if (taskCount == 0) {
            this.appIdBarrierFlags.remove(appId);
            Semaphore sem = this.appIdToSemaphore.remove(appId);
            if (sem != null) {
                this.appIdToTaskCount.remove(appId);
                sem.release();
            }
        }
        if ((sems = this.waitedTasks.remove(task)) != null) {
            for (Semaphore sem : sems) {
                sem.release();
            }
        }
        for (Parameter param : task.getTaskDescription().getParameters()) {
            DataType type = param.getType();
            if (type != DataType.FILE_T && type != DataType.OBJECT_T && type != DataType.PSCO_T && type != DataType.EXTERNAL_PSCO_T && type != DataType.BINDING_OBJECT_T) continue;
            DependencyParameter dPar = (DependencyParameter)param;
            DataAccessId dAccId = dPar.getDataAccessId();
            LOGGER.debug("Treating that data " + dAccId + " has been accessed at " + dPar.getDataTarget());
            this.DIP.dataHasBeenAccessed(dAccId);
        }
        if (this.appIdToSemaphore.get(appId) != null && !this.appIdBarrierFlags.contains(appId)) {
            this.checkResultFileTransfer(task);
        }
        task.releaseDataDependents();
        TaskMonitor registeredMonitor = task.getTaskMonitor();
        registeredMonitor.onCompletion();
    }

    private void checkResultFileTransfer(Task t) {
        LinkedList<DataInstanceId> fileIds = new LinkedList<DataInstanceId>();
        block10: for (Parameter p : t.getTaskDescription().getParameters()) {
            switch (p.getType()) {
                case FILE_T: {
                    FileParameter fp = (FileParameter)p;
                    switch (fp.getDirection()) {
                        case IN: 
                        case CONCURRENT: {
                            break;
                        }
                        case INOUT: {
                            DataInstanceId dId = ((DataAccessId.RWAccessId)fp.getDataAccessId()).getWrittenDataInstance();
                            if (this.writers.get(dId.getDataId()) != t) break;
                            fileIds.add(dId);
                            break;
                        }
                        case OUT: {
                            DataInstanceId dId = ((DataAccessId.WAccessId)fp.getDataAccessId()).getWrittenDataInstance();
                            if (this.writers.get(dId.getDataId()) != t) break;
                            fileIds.add(dId);
                        }
                    }
                    continue block10;
                }
            }
        }
        int numFT = fileIds.size();
        if (numFT > 0) {
            for (DataInstanceId fileId : fileIds) {
                try {
                    int id = fileId.getDataId();
                    this.DIP.blockDataAndGetResultFile(id, new ResultListener(new Semaphore(0)));
                    this.DIP.unblockDataId(id);
                }
                catch (Exception e) {
                    LOGGER.error("Exception ordering transfer when task ends", (Throwable)e);
                }
            }
        }
    }

    public void findWaitedTask(WaitForTaskRequest request) {
        int dataId = request.getDataId();
        AccessParams.AccessMode am = request.getAccessMode();
        Semaphore sem = request.getSemaphore();
        Task lastWriter = this.writers.get(dataId);
        if (lastWriter != null) {
            this.treatDataAccess(lastWriter, am, dataId);
        }
        if (lastWriter == null || lastWriter.getStatus() == Task.TaskState.FINISHED) {
            sem.release();
        } else {
            List<Semaphore> list = this.waitedTasks.get(lastWriter);
            if (list == null) {
                list = new LinkedList<Semaphore>();
                this.waitedTasks.put(lastWriter, list);
            }
            list.add(sem);
        }
    }

    private void treatDataAccess(Task lastWriter, AccessParams.AccessMode am, int dataId) {
        if (am == AccessParams.AccessMode.RW) {
            this.writers.put(dataId, null);
        }
        if (IS_DRAW_GRAPH) {
            TreeSet<Integer> toPass = new TreeSet<Integer>();
            toPass.add(dataId);
            DataInstanceId dii = this.DIP.getLastVersions(toPass).get(0);
            int dataVersion = dii.getVersionId();
            this.addEdgeFromTaskToMain(lastWriter, dataId, dataVersion);
        }
    }

    public boolean dataWasAccessedConcurrent(int daId) {
        List<Task> concurrentAccess = this.concurrentAccessMap.get(daId);
        return concurrentAccess != null;
    }

    public void findWaitedConcurrent(WaitForConcurrentRequest request) {
        int dataId = request.getDataId();
        AccessParams.AccessMode am = request.getAccessMode();
        List<Task> concurrentAccess = this.concurrentAccessMap.get(dataId);
        if (concurrentAccess != null) {
            this.concurrentAccessMap.put(dataId, null);
        }
        Semaphore semTasks = request.getTaskSemaphore();
        int n = 0;
        for (Task task : concurrentAccess) {
            this.treatDataAccess(task, am, dataId);
            if (task.getStatus() == Task.TaskState.FINISHED) continue;
            ++n;
            List<Semaphore> list = this.waitedTasks.get(task);
            if (list == null) {
                list = new LinkedList<Semaphore>();
                this.waitedTasks.put(task, list);
            }
            list.add(semTasks);
        }
        request.setNumWaitedTasks(n);
        request.getSemaphore().release();
    }

    public void barrier(BarrierRequest request) {
        Long appId = request.getAppId();
        Integer count = this.appIdToTaskCount.get(appId);
        if (IS_DRAW_GRAPH) {
            this.addNewBarrier();
            this.GM.commitGraph();
        }
        if (count == null || count == 0) {
            request.getSemaphore().release();
        } else {
            this.appIdBarrierFlags.add(appId);
            this.appIdToSemaphore.put(appId, request.getSemaphore());
        }
    }

    public void noMoreTasks(EndOfAppRequest request) {
        Long appId = request.getAppId();
        Integer count = this.appIdToTaskCount.get(appId);
        if (IS_DRAW_GRAPH) {
            this.GM.commitGraph();
        }
        if (count == null || count == 0) {
            this.appIdToTaskCount.remove(appId);
            request.getSemaphore().release();
        } else {
            this.appIdToSemaphore.put(appId, request.getSemaphore());
        }
    }

    public TreeSet<Integer> getAndRemoveWrittenFiles(Long appId) {
        return this.appIdToWrittenFiles.remove(appId);
    }

    public void shutdown() {
        if (IS_DRAW_GRAPH) {
            GraphGenerator.removeTemporaryGraph();
        }
    }

    public String getTaskStateRequest() {
        StringBuilder sb = new StringBuilder("\t").append("<TasksInfo>").append("\n");
        for (Map.Entry<Long, Integer> e : this.appIdToTotalTaskCount.entrySet()) {
            Long appId = e.getKey();
            Integer totalTaskCount = e.getValue();
            Integer taskCount = this.appIdToTaskCount.get(appId);
            if (taskCount == null) {
                taskCount = 0;
            }
            int completed = totalTaskCount - taskCount;
            sb.append("\t\t").append("<Application id=\"").append(appId).append("\">").append("\n");
            sb.append("\t\t\t").append("<TotalCount>").append(totalTaskCount).append("</TotalCount>").append("\n");
            sb.append("\t\t\t").append("<InProgress>").append(taskCount).append("</InProgress>").append("\n");
            sb.append("\t\t\t").append("<Completed>").append(completed).append("</Completed>").append("\n");
            sb.append("\t\t").append("</Application>").append("\n");
        }
        sb.append("\t").append("</TasksInfo>").append("\n");
        return sb.toString();
    }

    public void deleteData(DataInfo dataInfo) {
        int dataId = dataInfo.getDataId();
        LOGGER.debug("Deleting data with id " + dataId);
        Task task = this.writers.remove(dataId);
        if (task != null) {
            return;
        }
        LOGGER.debug("Removing " + dataInfo.getDataId() + " from written files");
        for (TreeSet<Integer> files : this.appIdToWrittenFiles.values()) {
            files.remove(dataInfo.getDataId());
        }
    }

    public void removeFromConcurrentAccess(int dataId) {
        List<Task> returnedValue = this.concurrentAccessMap.remove(dataId);
        if (returnedValue == null) {
            LOGGER.debug("The concurrent list could not be removed");
        }
    }

    private void checkDependencyForRead(Task currentTask, DependencyParameter dp) {
        int dataId = dp.getDataAccessId().getDataId();
        Task lastWriter = this.writers.get(dataId);
        if (lastWriter != null && lastWriter != currentTask) {
            if (DEBUG) {
                LOGGER.debug("Last writer for datum " + dp.getDataAccessId().getDataId() + " is task " + lastWriter.getId());
                LOGGER.debug("Adding dependency between task " + lastWriter.getId() + " and task " + currentTask.getId());
            }
            currentTask.addDataDependency(lastWriter);
        } else if (DEBUG) {
            LOGGER.debug("There is no last writer for datum " + dp.getDataAccessId().getDataId());
        }
        if (IS_DRAW_GRAPH) {
            this.drawEdges(currentTask, dp, dataId, lastWriter);
        }
    }

    private void drawEdges(Task currentTask, DependencyParameter dp, int dataId, Task lastWriter) {
        int dataVersion = -1;
        DataAccessId.Direction d = dp.getDataAccessId().getDirection();
        switch (d) {
            case C: 
            case R: {
                dataVersion = ((DataAccessId.RAccessId)dp.getDataAccessId()).getRVersionId();
                break;
            }
            case W: {
                dataVersion = ((DataAccessId.WAccessId)dp.getDataAccessId()).getWVersionId();
                break;
            }
            default: {
                dataVersion = ((DataAccessId.RWAccessId)dp.getDataAccessId()).getRVersionId();
            }
        }
        if (lastWriter != null && lastWriter != currentTask) {
            this.addEdgeFromTaskToTask(lastWriter, currentTask, dataId, dataVersion);
        } else {
            this.addEdgeFromMainToTask(currentTask, dataId, dataVersion);
        }
    }

    private void checkDependencyForConcurrent(Task currentTask, DependencyParameter dp) {
        int dataId = dp.getDataAccessId().getDataId();
        List<Task> tasks = this.concurrentAccessMap.get(dataId);
        if (this.concurrentAccessMap != null && !tasks.contains(currentTask)) {
            if (DEBUG) {
                LOGGER.debug("There was a concurrent access for datum " + dataId);
                LOGGER.debug("Adding dependency between list and task " + currentTask.getId());
            }
            for (Task t : tasks) {
                currentTask.addDataDependency(t);
                if (!IS_DRAW_GRAPH) continue;
                this.drawEdges(currentTask, dp, dataId, t);
            }
        } else if (DEBUG) {
            LOGGER.debug("There is no last writer for datum " + dataId);
        }
    }

    private void registerOutputValues(Task currentTask, DependencyParameter dp) {
        int currentTaskId = currentTask.getId();
        int dataId = dp.getDataAccessId().getDataId();
        Long appId = currentTask.getAppId();
        this.writers.put(dataId, currentTask);
        switch (dp.getType()) {
            case FILE_T: {
                TreeSet<Integer> fileIdsWritten = this.appIdToWrittenFiles.get(appId);
                if (fileIdsWritten == null) {
                    fileIdsWritten = new TreeSet();
                    this.appIdToWrittenFiles.put(appId, fileIdsWritten);
                }
                fileIdsWritten.add(dataId);
                break;
            }
            case PSCO_T: {
                TreeSet<Integer> pscoIdsWritten = this.appIdToSCOWrittenIds.get(appId);
                if (pscoIdsWritten == null) {
                    pscoIdsWritten = new TreeSet();
                    this.appIdToSCOWrittenIds.put(appId, pscoIdsWritten);
                }
                pscoIdsWritten.add(dataId);
                break;
            }
        }
        if (DEBUG) {
            LOGGER.debug("New writer for datum " + dp.getDataAccessId().getDataId() + " is task " + currentTaskId);
        }
    }

    private void addNewTask(Task task) {
        this.GM.addTaskToGraph(task);
        task.setSynchronizationId(this.synchronizationId);
        this.taskDetectedAfterSync = true;
    }

    private void addEdgeFromTaskToTask(Task source, Task dest, int dataId, int dataVersion) {
        if (source.getSynchronizationId() == dest.getSynchronizationId()) {
            String src = String.valueOf(source.getId());
            String dst = String.valueOf(dest.getId());
            String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
            this.GM.addEdgeToGraph(src, dst, dep);
        } else {
            String src = "Synchro" + dest.getSynchronizationId();
            String dst = String.valueOf(dest.getId());
            String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
            this.GM.addEdgeToGraph(src, dst, dep);
        }
    }

    private void addEdgeFromMainToTask(Task dest, int dataId, int dataVersion) {
        String src = "Synchro" + dest.getSynchronizationId();
        String dst = String.valueOf(dest.getId());
        String dep = String.valueOf(dataId) + "v" + String.valueOf(dataVersion);
        this.GM.addEdgeToGraph(src, dst, dep);
    }

    private void addEdgeFromTaskToMain(Task task, int dataId, int dataVersion) {
        if (this.taskDetectedAfterSync) {
            this.taskDetectedAfterSync = false;
            int oldSyncId = this.synchronizationId++;
            this.GM.addSynchroToGraph(this.synchronizationId);
            if (this.synchronizationId > 1) {
                String oldSync = "Synchro" + oldSyncId;
                String currentSync = "Synchro" + this.synchronizationId;
                this.GM.addEdgeToGraph(oldSync, currentSync, "");
            }
        }
        String src = String.valueOf(task.getId());
        String dest = "Synchro" + this.synchronizationId;
        this.GM.addEdgeToGraph(src, dest, String.valueOf(dataId) + "v" + String.valueOf(dataVersion));
    }

    private void addNewBarrier() {
        int oldSync = this.synchronizationId++;
        this.taskDetectedAfterSync = false;
        this.GM.addBarrierToGraph(this.synchronizationId);
        String newSync_str = "Synchro" + this.synchronizationId;
        String oldSync_str = "Synchro" + oldSync;
        if (this.synchronizationId > 1) {
            this.GM.addEdgeToGraph(oldSync_str, newSync_str, "");
        }
        HashSet<Task> uniqueWriters = new HashSet<Task>(this.writers.values());
        for (Task writer : uniqueWriters) {
            if (writer == null || writer.getSynchronizationId() != oldSync) continue;
            String taskId = String.valueOf(writer.getId());
            this.GM.addEdgeToGraph(taskId, newSync_str, "");
        }
    }
}

