/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.executor.external.piped;

import es.bsc.compss.executor.external.ExecutionPlatformMirror;
import es.bsc.compss.executor.external.commands.ExternalCommand;
import es.bsc.compss.executor.external.piped.PipePair;
import es.bsc.compss.executor.external.piped.commands.PingPipeCommand;
import es.bsc.compss.executor.external.piped.commands.PipeCommand;
import es.bsc.compss.executor.external.piped.commands.QuitPipeCommand;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.StreamGobbler;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PipedMirror
implements ExecutionPlatformMirror<PipePair> {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.Executor");
    private static final String ERROR_PB = "Error starting ProcessBuilder";
    private static final String ERROR_GC = "Error generating worker external launch command";
    protected static final String TOKEN_NEW_LINE = "\n";
    protected static final String TOKEN_SEP = " ";
    protected static final String PIPER_SCRIPT_RELATIVE_PATH = "Runtime" + File.separator + "scripts" + File.separator + "system" + File.separator + "adaptors" + File.separator + "nio" + File.separator + "pipers" + File.separator;
    private static final String PIPE_SCRIPT_NAME = "bindings_piper.sh";
    private static final String PIPE_FILE_BASENAME = "pipe_";
    protected final String mirrorId = String.valueOf(UUID.randomUUID().hashCode());
    protected final int size;
    protected final String basePipePath;
    private Process piper;
    private PipePair controlPipe;
    private StreamGobbler outputGobbler;
    private StreamGobbler errorGobbler;

    public PipedMirror(InvocationContext context, int size) {
        String workingDir = context.getWorkingDir();
        this.basePipePath = workingDir + PIPE_FILE_BASENAME + this.mirrorId + "_";
        this.size = size;
    }

    protected final void init(InvocationContext context) {
        String installDir = context.getInstallDir();
        String piperScript = installDir + PIPER_SCRIPT_RELATIVE_PATH + PIPE_SCRIPT_NAME;
        LOGGER.debug("PIPE Script: " + piperScript);
        String generalArgs = this.constructGeneralArgs(context);
        String specificArgs = this.getLaunchCommand(context);
        if (specificArgs == null) {
            ErrorManager.error(ERROR_GC);
            return;
        }
        LOGGER.info("Init piper ProcessBuilder");
        ProcessBuilder pb = new ProcessBuilder(piperScript, generalArgs, specificArgs);
        try {
            Map<String, String> env = this.getEnvironment(context);
            env.put("COMPSS_WORKING_DIR", context.getWorkingDir());
            env.put("COMPSS_APP_DIR", context.getAppDir());
            pb.directory(new File(this.getPBWorkingDir(context)));
            pb.environment().putAll(env);
            pb.environment().remove("LD_PRELOAD");
            pb.environment().remove("EXTRAE_CONFIG_FILE");
            if (Tracer.isActivated()) {
                long tracingHostId = context.getTracingHostID();
                Tracer.emitEvent(tracingHostId, Tracer.getSyncType());
            }
            this.piper = pb.start();
            LOGGER.debug("Starting stdout/stderr gobblers ...");
            try {
                this.piper.getOutputStream().close();
            }
            catch (IOException tracingHostId) {
                // empty catch block
            }
            while (!this.piper.isAlive()) {
            }
            this.outputGobbler = new StreamGobbler(this.piper.getInputStream(), null, LOGGER);
            this.errorGobbler = new StreamGobbler(this.piper.getErrorStream(), null, LOGGER);
            this.outputGobbler.start();
            this.errorGobbler.start();
            this.controlPipe = new PipePair(this.basePipePath, "control");
            this.controlPipe.sendCommand(new PingPipeCommand());
            PipeCommand reply = this.controlPipe.readCommand();
            if (reply.getType() != ExternalCommand.CommandType.PONG) {
                ErrorManager.fatal(ERROR_PB);
            }
        }
        catch (IOException e) {
            ErrorManager.error(ERROR_PB, e);
        }
    }

    private String constructGeneralArgs(InvocationContext context) {
        StringBuilder cmd = new StringBuilder();
        String computePipes = this.basePipePath + "compute";
        String controlPipe = this.basePipePath + "control";
        cmd.append(this.size).append(TOKEN_SEP);
        cmd.append(controlPipe).append(".outbound").append(TOKEN_SEP);
        cmd.append(controlPipe).append(".inbound").append(TOKEN_SEP);
        cmd.append(this.size).append(TOKEN_SEP);
        StringBuilder writePipes = new StringBuilder();
        if (this.size > 0) {
            writePipes.append(computePipes).append("0.outbound");
        }
        for (int i = 1; i < this.size; ++i) {
            writePipes.append(TOKEN_SEP).append(computePipes).append(i).append(".outbound");
        }
        cmd.append(writePipes.toString()).append(TOKEN_SEP);
        cmd.append(this.size).append(TOKEN_SEP);
        StringBuilder readPipes = new StringBuilder();
        if (this.size > 0) {
            readPipes.append(computePipes).append("0.inbound");
        }
        for (int i = 1; i < this.size; ++i) {
            readPipes.append(TOKEN_SEP).append(computePipes).append(i).append(".inbound");
        }
        cmd.append(readPipes.toString()).append(TOKEN_SEP);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("WRITE PIPE Files: " + writePipes.toString() + TOKEN_NEW_LINE);
            LOGGER.debug("READ PIPE Files: " + readPipes.toString() + TOKEN_NEW_LINE);
            LOGGER.debug("WRITE DATA PIPE: " + controlPipe + ".outbound");
            LOGGER.debug("READ DATA PIPE: " + controlPipe + ".inbound");
        }
        return cmd.toString();
    }

    public abstract String getLaunchCommand(InvocationContext var1);

    public abstract Map<String, String> getEnvironment(InvocationContext var1);

    protected String getPBWorkingDir(InvocationContext context) {
        return context.getWorkingDir();
    }

    @Override
    public void stop() {
        this.stopPipes();
        this.stopPiper();
    }

    private void stopPipes() {
        LOGGER.info("Stopping compute pipes for mirror " + this.mirrorId);
        for (int i = 0; i < this.size; ++i) {
            PipePair pipes = new PipePair(this.basePipePath, "compute" + i);
            pipes.close();
        }
    }

    private void stopPiper() {
        this.controlPipe.sendCommand(new QuitPipeCommand());
        try {
            LOGGER.info("Waiting for finishing piper process");
            int exitCode = this.piper.waitFor();
            if (Tracer.isActivated()) {
                Tracer.emitEvent(0L, Tracer.getSyncType());
            }
            this.outputGobbler.join();
            this.errorGobbler.join();
            if (exitCode != 0) {
                ErrorManager.error("ExternalExecutor piper ended with " + exitCode + " status");
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (this.piper != null) {
                if (this.piper.getInputStream() != null) {
                    try {
                        this.piper.getInputStream().close();
                    }
                    catch (IOException iOException) {}
                }
                if (this.piper.getErrorStream() != null) {
                    try {
                        this.piper.getErrorStream().close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        LOGGER.info("ExternalThreadPool finished");
    }

    @Override
    public PipePair registerExecutor(String executorId) {
        return new PipePair(this.basePipePath, executorId);
    }

    @Override
    public void unregisterExecutor(String id) {
    }
}

