/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.loader;

import es.bsc.compss.loader.LoaderConstants;
import es.bsc.compss.types.annotations.Orchestration;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.task.Binary;
import es.bsc.compss.types.annotations.task.COMPSs;
import es.bsc.compss.types.annotations.task.Decaf;
import es.bsc.compss.types.annotations.task.MPI;
import es.bsc.compss.types.annotations.task.Method;
import es.bsc.compss.types.annotations.task.MultiNode;
import es.bsc.compss.types.annotations.task.OmpSs;
import es.bsc.compss.types.annotations.task.OpenCL;
import es.bsc.compss.types.annotations.task.Service;
import es.bsc.compss.types.annotations.task.repeatables.Binaries;
import es.bsc.compss.types.annotations.task.repeatables.Decafs;
import es.bsc.compss.types.annotations.task.repeatables.MPIs;
import es.bsc.compss.types.annotations.task.repeatables.Methods;
import es.bsc.compss.types.annotations.task.repeatables.MultiCOMPSs;
import es.bsc.compss.types.annotations.task.repeatables.MultiMultiNode;
import es.bsc.compss.types.annotations.task.repeatables.MultiOmpSs;
import es.bsc.compss.types.annotations.task.repeatables.OpenCLs;
import es.bsc.compss.types.annotations.task.repeatables.Services;
import es.bsc.compss.types.exceptions.NonInstantiableException;
import es.bsc.compss.util.ErrorManager;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.expr.MethodCall;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StubItf;

public class LoaderUtils {
    public static final String BINARY_SIGNATURE = "binary.BINARY";
    public static final String MPI_SIGNATURE = "mpi.MPI";
    public static final String DECAF_SIGNATURE = "decaf.DECAF";
    public static final String COMPSs_SIGNATURE = "compss.NESTED";
    public static final String OMPSS_SIGNATURE = "ompss.OMPSS";
    public static final String OPENCL_SIGNATURE = "opencl.OPENCL";
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.LoaderUtils");

    private LoaderUtils() {
        throw new NonInstantiableException("LoaderUtils");
    }

    public static DataType checkSCOType(Object o) {
        if (o instanceof StubItf && ((StubItf)o).getID() != null) {
            return DataType.PSCO_T;
        }
        return DataType.OBJECT_T;
    }

    public static java.lang.reflect.Method checkRemote(CtMethod method, java.lang.reflect.Method[] remoteMethods) throws NotFoundException {
        LOGGER.info("Checking Method " + method.getName());
        for (java.lang.reflect.Method remoteMethod : remoteMethods) {
            Annotation methodsAnnotation;
            Annotation remoteMethodAnnotation;
            LOGGER.info("   ** To remote Method " + remoteMethod.getName());
            if (remoteMethod.isAnnotationPresent(Method.class) && LoaderUtils.isSelectedMethod(method, remoteMethod, (remoteMethodAnnotation = remoteMethod.getAnnotation(Method.class)).declaringClass(), remoteMethodAnnotation.name())) {
                return remoteMethod;
            }
            if (remoteMethod.isAnnotationPresent(Service.class) && LoaderUtils.isSelectedService(method, remoteMethod, (Service)(remoteMethodAnnotation = remoteMethod.getAnnotation(Service.class)))) {
                return remoteMethod;
            }
            if (remoteMethod.isAnnotationPresent(Binary.class) && LoaderUtils.isSelectedNonNativeMethod(method, remoteMethod, BINARY_SIGNATURE)) {
                return remoteMethod;
            }
            if (remoteMethod.isAnnotationPresent(MPI.class) && LoaderUtils.isSelectedNonNativeMethod(method, remoteMethod, MPI_SIGNATURE)) {
                return remoteMethod;
            }
            if (remoteMethod.isAnnotationPresent(COMPSs.class) && LoaderUtils.isSelectedNonNativeMethod(method, remoteMethod, COMPSs_SIGNATURE)) {
                return remoteMethod;
            }
            if (remoteMethod.isAnnotationPresent(MultiNode.class) && LoaderUtils.isSelectedMethod(method, remoteMethod, (remoteMethodAnnotation = remoteMethod.getAnnotation(MultiNode.class)).declaringClass(), remoteMethodAnnotation.name())) {
                return remoteMethod;
            }
            if (remoteMethod.isAnnotationPresent(Decaf.class) && LoaderUtils.isSelectedNonNativeMethod(method, remoteMethod, DECAF_SIGNATURE)) {
                return remoteMethod;
            }
            if (remoteMethod.isAnnotationPresent(OmpSs.class) && LoaderUtils.isSelectedNonNativeMethod(method, remoteMethod, OMPSS_SIGNATURE)) {
                return remoteMethod;
            }
            if (remoteMethod.isAnnotationPresent(OpenCL.class) && LoaderUtils.isSelectedNonNativeMethod(method, remoteMethod, OPENCL_SIGNATURE)) {
                return remoteMethod;
            }
            if (remoteMethod.isAnnotationPresent(Methods.class)) {
                methodsAnnotation = remoteMethod.getAnnotation(Methods.class);
                for (Annotation annotation2 : methodsAnnotation.value()) {
                    if (!LoaderUtils.isSelectedMethod(method, remoteMethod, annotation2.declaringClass(), annotation2.name())) continue;
                    return remoteMethod;
                }
            }
            if (remoteMethod.isAnnotationPresent(Services.class)) {
                Services servicesAnnotation = remoteMethod.getAnnotation(Services.class);
                for (Annotation annotation3 : servicesAnnotation.value()) {
                    if (!LoaderUtils.isSelectedService(method, remoteMethod, (Service)annotation3)) continue;
                    return remoteMethod;
                }
            }
            if (remoteMethod.isAnnotationPresent(Binaries.class) && LoaderUtils.isSelectedNonNativeMethod(method, remoteMethod, BINARY_SIGNATURE)) {
                return remoteMethod;
            }
            if (remoteMethod.isAnnotationPresent(MPIs.class) && LoaderUtils.isSelectedNonNativeMethod(method, remoteMethod, MPI_SIGNATURE)) {
                return remoteMethod;
            }
            if (remoteMethod.isAnnotationPresent(MultiCOMPSs.class) && LoaderUtils.isSelectedNonNativeMethod(method, remoteMethod, COMPSs_SIGNATURE)) {
                return remoteMethod;
            }
            if (remoteMethod.isAnnotationPresent(Decafs.class) && LoaderUtils.isSelectedNonNativeMethod(method, remoteMethod, DECAF_SIGNATURE)) {
                return remoteMethod;
            }
            if (remoteMethod.isAnnotationPresent(MultiMultiNode.class)) {
                methodsAnnotation = remoteMethod.getAnnotation(MultiMultiNode.class);
                for (Annotation annotation4 : methodsAnnotation.value()) {
                    if (!LoaderUtils.isSelectedMethod(method, remoteMethod, annotation4.declaringClass(), annotation4.name())) continue;
                    return remoteMethod;
                }
            }
            if (remoteMethod.isAnnotationPresent(MultiOmpSs.class) && LoaderUtils.isSelectedNonNativeMethod(method, remoteMethod, OMPSS_SIGNATURE)) {
                return remoteMethod;
            }
            if (!remoteMethod.isAnnotationPresent(OpenCLs.class) || !LoaderUtils.isSelectedNonNativeMethod(method, remoteMethod, OPENCL_SIGNATURE)) continue;
            return remoteMethod;
        }
        return null;
    }

    private static boolean isSelectedMethod(CtMethod method, java.lang.reflect.Method remote, String remoteMethodClass, String remoteMethodName) throws NotFoundException {
        Class<?>[] paramClassRemote;
        if (remoteMethodName == null || remoteMethodName.isEmpty() || remoteMethodName.equals("[unassigned]")) {
            remoteMethodName = remote.getName();
        }
        LOGGER.debug("  - Checking " + method.getName() + " against " + remoteMethodName);
        if (!remoteMethodName.equals(method.getName())) {
            return false;
        }
        LOGGER.debug("  - Checking classes " + method.getDeclaringClass().getName() + " against " + remoteMethodClass);
        boolean matchesClass = remoteMethodClass.equals(method.getDeclaringClass().getName());
        if (!matchesClass) {
            return false;
        }
        CtClass[] paramClassCurrent = method.getParameterTypes();
        if (paramClassCurrent.length != (paramClassRemote = remote.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < paramClassCurrent.length; ++i) {
            if (paramClassCurrent[i].getName().equals(paramClassRemote[i].getCanonicalName())) continue;
            return false;
        }
        return true;
    }

    private static boolean isSelectedNonNativeMethod(CtMethod method, java.lang.reflect.Method remote, String signature) throws NotFoundException {
        Class<?>[] paramClassRemote;
        LOGGER.debug("  - Checking " + method.getName() + " against " + remote.getName());
        boolean matchesMethodname = method.getName().equals(remote.getName());
        if (!matchesMethodname) {
            return false;
        }
        LOGGER.debug("  - Checking classes " + method.getDeclaringClass().getName() + " against " + signature);
        boolean matchesClass = method.getDeclaringClass().getName().equals(signature);
        if (!matchesClass) {
            return false;
        }
        CtClass[] paramClassCurrent = method.getParameterTypes();
        if (paramClassCurrent.length != (paramClassRemote = remote.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < paramClassCurrent.length; ++i) {
            if (paramClassCurrent[i].getName().equals(paramClassRemote[i].getCanonicalName())) continue;
            return false;
        }
        return true;
    }

    private static boolean isSelectedService(CtMethod method, java.lang.reflect.Method remote, Service serviceAnnot) throws NotFoundException {
        String nsp;
        Class<?>[] paramClassRemote;
        String nameRemote = serviceAnnot.operation();
        if (nameRemote.equals("[unassigned]")) {
            nameRemote = remote.getName();
        }
        LOGGER.debug("  - Checking " + method.getName() + " against " + nameRemote);
        if (!nameRemote.equals(method.getName())) {
            return false;
        }
        CtClass[] paramClassCurrent = method.getParameterTypes();
        if (paramClassCurrent.length != (paramClassRemote = remote.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < paramClassCurrent.length; ++i) {
            if (paramClassCurrent[i].getName().equals(paramClassRemote[i].getCanonicalName())) continue;
            return false;
        }
        String packName = method.getDeclaringClass().getPackageName();
        return packName.equals(nsp = LoaderUtils.combineServiceMetadata(serviceAnnot));
    }

    private static String combineServiceMetadata(Service annot) {
        String namespace = annot.namespace();
        String service = annot.name();
        String port = annot.port();
        int startIndex = namespace.indexOf("//www.");
        startIndex = startIndex < 0 ? ((startIndex = namespace.indexOf("http://")) >= 0 ? (startIndex += "http://".length()) : 0) : (startIndex += "//www.".length());
        namespace = namespace.substring(startIndex).replace('/', '.').replace('-', '.').replace(':', '.');
        return "dummy." + namespace + '.' + service + '.' + port;
    }

    public static boolean isStreamClose(MethodCall mc) {
        String className;
        String fullName;
        return "close".equals(mc.getMethodName()) && (fullName = mc.getClassName()).startsWith("java.io.") && LoaderConstants.SUPPORTED_STREAM_TYPES.contains(className = fullName.substring(8));
    }

    public static String randomName(int length, String prefix) {
        if (length < 1) {
            return prefix;
        }
        Random r = new Random();
        StringBuilder buffer = new StringBuilder();
        int gap = 10;
        for (int i = 0; i < length; ++i) {
            char c = (char)(r.nextInt(gap) + 48);
            buffer.append(c);
        }
        return prefix + buffer.toString();
    }

    public static boolean isMainMethod(CtMethod m) throws NotFoundException {
        return "main".equals(m.getName()) && m.getParameterTypes().length == 1 && m.getParameterTypes()[0].getName().equals(String[].class.getCanonicalName());
    }

    public static boolean isOrchestration(CtMethod m) {
        return m.hasAnnotation(Orchestration.class);
    }

    public static boolean contains(CtMethod[] methods, CtMethod method) {
        for (CtMethod m : methods) {
            if (!m.equals(method) || !method.getDeclaringClass().equals(m.getDeclaringClass())) continue;
            return true;
        }
        return false;
    }

    public static StringBuilder replaceMethodName(StringBuilder executeTask, String methodName) {
        String patternStr = ",\"" + methodName + "\",";
        int start = executeTask.toString().indexOf(patternStr);
        int end = start + patternStr.length();
        return executeTask.replace(start, end, ",\"" + methodName + "WithUR\",");
    }

    public static StringBuilder modifyString(StringBuilder executeTask, int numParams, String appNameParam, String slaIdParam, String urNameParam, String primaryHostParam, String transferIdParam) {
        int newParams = 5;
        StringBuilder params = new StringBuilder(appNameParam);
        params.append(",");
        params.append(slaIdParam);
        params.append(",");
        params.append(urNameParam);
        params.append(",");
        params.append(primaryHostParam);
        params.append(",");
        params.append(transferIdParam);
        params.append("});");
        String patternStr = numParams == 0 ? "0,null);" : "," + numParams + ",";
        int start = executeTask.toString().indexOf(patternStr);
        int end = start + patternStr.length();
        if (numParams == 0) {
            return executeTask.replace(start, end, newParams + ",new Object[]{" + params);
        }
        executeTask.replace(start + 1, end - 1, Integer.toString(numParams + newParams));
        executeTask.replace(executeTask.length() - 3, executeTask.length(), "");
        return executeTask.append("," + params);
    }

    public static Object runMethodOnObject(Object o, Class<?> methodClass, String methodName, Object[] values, Class<?>[] types) throws Throwable {
        java.lang.reflect.Method method = null;
        try {
            method = methodClass.getMethod(methodName, types);
        }
        catch (SecurityException se) {
            ErrorManager.error("Error writing the instrumented class file", se);
            return null;
        }
        catch (NoSuchMethodException nsme) {
            String errMsg = "Requested method " + methodName + " of " + methodClass + " not found\nTypes length is " + types.length + "\n";
            for (Class<?> type : types) {
                errMsg = errMsg + "Type is " + type;
            }
            ErrorManager.error(errMsg, nsme);
            return null;
        }
        Object retValue = null;
        try {
            retValue = method.invoke(o, values);
        }
        catch (IllegalArgumentException iae) {
            ErrorManager.error("Wrong argument passed to method " + methodName, iae);
        }
        catch (IllegalAccessException iae) {
            ErrorManager.error("Cannot access method " + methodName, iae);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        return retValue;
    }

    public static boolean isFileDelete(MethodCall mc) {
        if ("delete".equals(mc.getMethodName())) {
            return mc.getClassName().compareTo("java.io.File") == 0;
        }
        return false;
    }
}

