/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.api.TaskMonitor;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.allocatableactions.ExecutionAction;
import es.bsc.compss.types.colors.ColorConfiguration;
import es.bsc.compss.types.colors.ColorNode;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.parameter.Parameter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class Task
implements Comparable<Task> {
    private static final int FIRST_TASK_ID = 1;
    private static AtomicInteger nextTaskId = new AtomicInteger(1);
    private final long appId;
    private final int taskId;
    private TaskState status;
    private final TaskDescription taskDescription;
    private final List<Task> predecessors;
    private final List<Task> successors;
    private int synchronizationId;
    private Task enforcingTask;
    private final List<ExecutionAction> executions;
    private int executionCount;
    private final TaskMonitor taskMonitor;

    public Task(Long appId, COMPSsConstants.Lang lang, String signature, boolean isPrioritary, int numNodes, boolean isReplicated, boolean isDistributed, boolean hasTarget, int numReturns, Parameter[] parameters, TaskMonitor monitor) {
        this.appId = appId;
        this.taskId = nextTaskId.getAndIncrement();
        this.status = TaskState.TO_ANALYSE;
        this.taskDescription = new TaskDescription(lang, signature, isPrioritary, numNodes, isReplicated, isDistributed, hasTarget, numReturns, parameters);
        this.predecessors = new LinkedList<Task>();
        this.successors = new LinkedList<Task>();
        this.executions = new LinkedList<ExecutionAction>();
        this.taskMonitor = monitor;
    }

    public Task(Long appId, String namespace, String service, String port, String operation, boolean isPrioritary, boolean hasTarget, int numReturns, Parameter[] parameters, TaskMonitor monitor) {
        this.appId = appId;
        this.taskId = nextTaskId.getAndIncrement();
        this.status = TaskState.TO_ANALYSE;
        this.taskDescription = new TaskDescription(namespace, service, port, operation, isPrioritary, hasTarget, numReturns, parameters);
        this.predecessors = new LinkedList<Task>();
        this.successors = new LinkedList<Task>();
        this.executions = new LinkedList<ExecutionAction>();
        this.taskMonitor = monitor;
    }

    public static int getCurrentTaskCount() {
        return nextTaskId.get();
    }

    public void addDataDependency(Task producer) {
        producer.successors.add(this);
        this.predecessors.add(producer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseDataDependents() {
        Iterator<Task> iterator = this.successors.iterator();
        while (iterator.hasNext()) {
            Task t;
            Task task = t = iterator.next();
            synchronized (task) {
                t.predecessors.remove(this);
            }
        }
        this.successors.clear();
    }

    public List<Task> getSuccessors() {
        return this.successors;
    }

    public List<Task> getPredecessors() {
        return this.predecessors;
    }

    public void setSynchronizationId(int syncId) {
        this.synchronizationId = syncId;
    }

    public int getSynchronizationId() {
        return this.synchronizationId;
    }

    public long getAppId() {
        return this.appId;
    }

    public int getId() {
        return this.taskId;
    }

    public TaskState getStatus() {
        return this.status;
    }

    public void setStatus(TaskState status) {
        this.status = status;
    }

    public void setEnforcingTask(Task task) {
        this.enforcingTask = task;
    }

    public boolean isFree() {
        return this.executionCount == 0;
    }

    public void setExecutionCount(int executionCount) {
        this.executionCount = executionCount;
    }

    public void decreaseExecutionCount() {
        --this.executionCount;
    }

    public TaskDescription getTaskDescription() {
        return this.taskDescription;
    }

    public boolean isSchedulingForced() {
        return this.enforcingTask != null;
    }

    public Task getEnforcingTask() {
        return this.enforcingTask;
    }

    public String getDotDescription() {
        int monitorTaskId = this.taskDescription.getId() + 1;
        ColorNode color = ColorConfiguration.COLORS[monitorTaskId % ColorConfiguration.NUM_COLORS];
        String shape = this.taskDescription.getType() == Implementation.TaskType.METHOD ? (this.taskDescription.isReplicated() ? "doublecircle" : (this.taskDescription.isDistributed() ? "circle" : "circle")) : "diamond";
        return this.getId() + "[shape=" + shape + ", style=filled fillcolor=\"" + color.getFillColor() + "\" fontcolor=\"" + color.getFontColor() + "\"];";
    }

    public String getLegendDescription() {
        StringBuilder information = new StringBuilder();
        information.append("<tr>").append("\n");
        information.append("<td align=\"right\">").append(this.getMethodName()).append("</td>").append("\n");
        information.append("<td bgcolor=\"").append(this.getColor()).append("\">&nbsp;</td>").append("\n");
        information.append("</tr>").append("\n");
        return information.toString();
    }

    public String getMethodName() {
        String methodName = this.taskDescription.getName();
        return methodName;
    }

    public String getColor() {
        int monitorTaskId = this.taskDescription.getId() + 1;
        ColorNode color = ColorConfiguration.COLORS[monitorTaskId % ColorConfiguration.NUM_COLORS];
        return color.getFillColor();
    }

    public void addExecution(ExecutionAction execution) {
        this.executions.add(execution);
    }

    public List<ExecutionAction> getExecutions() {
        return this.executions;
    }

    public TaskMonitor getTaskMonitor() {
        return this.taskMonitor;
    }

    @Override
    public int compareTo(Task task) {
        if (task == null) {
            throw new NullPointerException();
        }
        return this.getId() - task.getId();
    }

    public boolean equals(Object o) {
        return o instanceof Task && this.taskId == ((Task)o).taskId;
    }

    public int hashCode() {
        return super.hashCode();
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("[[Task id: ").append(this.getId()).append("]");
        buffer.append(", [Status: ").append((Object)this.getStatus()).append("]");
        buffer.append(", ").append(this.getTaskDescription().toString()).append("]");
        return buffer.toString();
    }

    public static enum TaskState {
        TO_ANALYSE,
        TO_EXECUTE,
        FINISHED,
        FAILED;

    }
}

