/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.types.data;

import es.bsc.compss.types.data.DataInstanceId;
import es.bsc.compss.types.data.DataVersion;
import java.io.Serializable;

public abstract class DataAccessId
implements Serializable {
    private static final long serialVersionUID = 1L;

    public abstract int getDataId();

    public abstract Direction getDirection();

    public static class RWAccessId
    extends DataAccessId {
        private static final long serialVersionUID = 1L;
        private DataVersion readDataVersion;
        private DataVersion writtenDataVersion;

        public RWAccessId() {
        }

        public RWAccessId(DataVersion rdv, DataVersion wdv) {
            this.readDataVersion = rdv;
            this.writtenDataVersion = wdv;
        }

        @Override
        public Direction getDirection() {
            return Direction.RW;
        }

        @Override
        public int getDataId() {
            return this.readDataVersion.getDataInstanceId().getDataId();
        }

        public int getRVersionId() {
            return this.readDataVersion.getDataInstanceId().getVersionId();
        }

        public int getWVersionId() {
            return this.writtenDataVersion.getDataInstanceId().getVersionId();
        }

        public DataInstanceId getReadDataInstance() {
            return this.readDataVersion.getDataInstanceId();
        }

        public DataInstanceId getWrittenDataInstance() {
            return this.writtenDataVersion.getDataInstanceId();
        }

        public boolean isPreserveSourceData() {
            return this.readDataVersion.isOnlyReader();
        }

        public String toString() {
            return "Read data: " + this.readDataVersion.getDataInstanceId() + ", Written data: " + this.writtenDataVersion.getDataInstanceId() + (this.isPreserveSourceData() ? ", Preserved" : ", Erased");
        }
    }

    public static class WAccessId
    extends DataAccessId {
        private static final long serialVersionUID = 1L;
        private DataVersion writtenDataVersion;

        public WAccessId() {
        }

        public WAccessId(int dataId, int wVersionId) {
            this.writtenDataVersion = new DataVersion(dataId, wVersionId);
        }

        public WAccessId(DataVersion wdi) {
            this.writtenDataVersion = wdi;
        }

        @Override
        public Direction getDirection() {
            return Direction.W;
        }

        @Override
        public int getDataId() {
            return this.writtenDataVersion.getDataInstanceId().getDataId();
        }

        public int getWVersionId() {
            return this.writtenDataVersion.getDataInstanceId().getVersionId();
        }

        public DataInstanceId getWrittenDataInstance() {
            return this.writtenDataVersion.getDataInstanceId();
        }

        public String toString() {
            return "Written data: " + this.writtenDataVersion.getDataInstanceId();
        }
    }

    public static class RAccessId
    extends DataAccessId {
        private static final long serialVersionUID = 1L;
        private DataVersion readDataVersion;
        private boolean preserveSourceData = true;

        public RAccessId() {
        }

        public RAccessId(int dataId, int rVersionId) {
            this.readDataVersion = new DataVersion(dataId, rVersionId);
        }

        public RAccessId(DataVersion rdv) {
            this.readDataVersion = rdv;
        }

        @Override
        public Direction getDirection() {
            return Direction.R;
        }

        @Override
        public int getDataId() {
            return this.readDataVersion.getDataInstanceId().getDataId();
        }

        public int getRVersionId() {
            return this.readDataVersion.getDataInstanceId().getVersionId();
        }

        public DataInstanceId getReadDataInstance() {
            return this.readDataVersion.getDataInstanceId();
        }

        public boolean isPreserveSourceData() {
            return this.preserveSourceData;
        }

        public String toString() {
            return "Read data: " + this.readDataVersion.getDataInstanceId() + (this.preserveSourceData ? ", Preserved" : ", Erased");
        }
    }

    public static enum Direction {
        R,
        RW,
        W,
        C;

    }
}

