/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.CloudProvider;
import es.bsc.compss.types.ResourceCreationRequest;
import es.bsc.compss.types.resources.CloudMethodWorker;
import es.bsc.compss.types.resources.MasterResource;
import es.bsc.compss.types.resources.MasterResourceImpl;
import es.bsc.compss.types.resources.MethodWorker;
import es.bsc.compss.types.resources.description.CloudImageDescription;
import es.bsc.compss.types.resources.description.CloudInstanceTypeDescription;
import es.bsc.compss.types.resources.description.CloudMethodResourceDescription;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.ResourceManager;
import java.io.File;
import java.io.FileOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ExternalAdaptationManager
extends Thread {
    private static final Logger RUNTIME_LOGGER = LogManager.getLogger("es.bsc.compss.Components.ResourceManager");
    private static final Logger RESOURCES_LOGGER = LogManager.getLogger("es.bsc.compss.Resources");
    private static final boolean DEBUG = RUNTIME_LOGGER.isDebugEnabled();
    private static final String LOG_PREFIX = "[ExternalAdaptation] ";
    private static final String CREATE = "CREATE";
    private static final String STOP = "STOP";
    private static final String REMOVE = "REMOVE";
    private static final String ACK = "ACK";
    private final String adaptationDir;
    private final String commandPipe;
    private final String resultPipe;
    private boolean running = false;
    private boolean canBeStarted = false;

    public ExternalAdaptationManager() {
        MasterResource master = Comm.getAppHost();
        if (master == null) {
            master = new MasterResourceImpl();
        }
        this.adaptationDir = master.getAppLogDirPath() + "adaptation" + File.separator;
        this.commandPipe = this.adaptationDir + "command_pipe";
        this.resultPipe = this.adaptationDir + "result_pipe";
        this.createPipes();
    }

    @Override
    public final void run() {
        if (this.canBeStarted) {
            this.running = true;
            while (this.running) {
                String[] params = this.readPipe(this.commandPipe);
                if (params != null) {
                    String action;
                    switch (action = params[0]) {
                        case "CREATE": {
                            this.manageCreate(params);
                            break;
                        }
                        case "STOP": {
                            this.removePipes();
                            break;
                        }
                        case "REMOVE": {
                            this.manageRemove(params);
                            break;
                        }
                        default: {
                            RUNTIME_LOGGER.error("[ExternalAdaptation] ERROR: Incorrect command.");
                            this.writePipe(this.resultPipe, "ERROR: Incorrect command");
                            break;
                        }
                    }
                    continue;
                }
                RUNTIME_LOGGER.error("[ExternalAdaptation] ERROR: Read command is null.");
                this.writePipe(this.resultPipe, "ERROR: Read command is null");
            }
        } else {
            RUNTIME_LOGGER.warn("[ExternalAdaptation] External Adaptation manager not started");
        }
    }

    public void shutdown() {
        if (this.canBeStarted) {
            this.writePipe(this.commandPipe, STOP);
            this.running = false;
        }
    }

    private void createPipes() {
        if (!new File(this.adaptationDir).mkdir()) {
            ErrorManager.error("ERROR: Error creating adaptation dir");
        }
        String[] command = new String[]{"mkfifo", this.commandPipe, this.resultPipe};
        try {
            Process process = new ProcessBuilder(command).inheritIO().start();
            int result = process.waitFor();
            if (result != 0) {
                ErrorManager.error("Creating external adaptation pipes failed");
            } else {
                RUNTIME_LOGGER.info("[ExternalAdaptation] Adaptation pipes created succesfully");
                this.canBeStarted = true;
            }
        }
        catch (Exception e) {
            ErrorManager.error("Exception crating external adaptation pipes", e);
        }
    }

    private void removePipes() {
        if (!new File(this.commandPipe).delete()) {
            RUNTIME_LOGGER.error("[ExternalAdaptation] ERROR: Cannot erase command pipe");
        }
        if (!new File(this.resultPipe).delete()) {
            RUNTIME_LOGGER.error("[ExternalAdaptation] ERROR: Cannot erase result pipe");
        }
        if (!new File(this.adaptationDir).delete()) {
            RUNTIME_LOGGER.error("[ExternalAdaptation] ERROR: Cannot erase adaptation directory");
        }
    }

    private void manageRemove(String[] params) {
        if (params.length == 3) {
            String providerName = params[1];
            String ip = params[2];
            this.cloudRemove(providerName, ip);
        } else if (params.length == 2) {
            String ip = params[1];
            this.normalRemove(ip);
        } else {
            RUNTIME_LOGGER.error("[ExternalAdaptation] ERROR: Number of parameters is incorrect (" + params.length + ")");
            this.writePipe(this.resultPipe, "ERROR: Number of parameters is incorrect (" + params.length + ")");
        }
    }

    private void manageCreate(String[] params) {
        if (params.length == 4) {
            String providerName = params[1];
            String typeName = params[2];
            String imageName = params[3];
            this.cloudCreation(providerName, typeName, imageName);
        } else if (params.length == 3) {
            String resourceName = params[1];
            String description = params[2];
            this.normalCreation(resourceName, description);
        } else {
            RUNTIME_LOGGER.error("[ExternalAdaptation] ERROR: Number of parameters is incorrect (" + params.length + ")");
            this.writePipe(this.resultPipe, "ERROR: Number of parameters is incorrect (" + params.length + ")");
        }
    }

    private void normalRemove(String name) {
        MethodWorker w = (MethodWorker)ResourceManager.getWorker(name);
        if (w != null) {
            RUNTIME_LOGGER.info("[ExternalAdaptation] TODO: Resource " + name + " removed.");
            this.writePipe(this.resultPipe, ACK);
        } else {
            RUNTIME_LOGGER.error("[ExternalAdaptation] ERROR: Resource " + name + " not found.");
            this.writePipe(this.resultPipe, "ERROR: Error creating resource " + name + " not found.");
        }
    }

    private void cloudRemove(String providerName, String name) {
        if (providerName != null && name != null) {
            CloudProvider cp = ResourceManager.getCloudProvider(providerName);
            if (cp != null) {
                CloudMethodWorker cmw = cp.getHostedWorker(name);
                if (cmw != null) {
                    ResourceManager.reduceDynamicWorker(cmw, cmw.getDescription());
                    RUNTIME_LOGGER.info("[ExternalAdaptation] Submited external request for removing " + name + " in " + providerName);
                    this.writePipe(this.resultPipe, ACK);
                } else {
                    RUNTIME_LOGGER.error("[ExternalAdaptation] ERROR: resource " + name + " not found in " + providerName);
                    this.writePipe(this.resultPipe, "ERROR: Error creating resource " + name + " not found in " + providerName);
                }
            } else {
                RUNTIME_LOGGER.error("[ExternalAdaptation] ERROR: Provider " + providerName + " not found.");
                this.writePipe(this.resultPipe, "ERROR: Provider " + providerName + " not found");
            }
        } else {
            RUNTIME_LOGGER.error("[ExternalAdaptation] ERROR: One of the parameters is incorrect (" + name + "," + providerName + ")");
            this.writePipe(this.resultPipe, "ERROR: One of the parameters is incorrect (" + name + "," + providerName + ")");
        }
    }

    private void normalCreation(String name, String description) {
        RUNTIME_LOGGER.info("[ExternalAdaptation] TODO: Resource " + name + " created.");
        this.writePipe(this.resultPipe, ACK);
    }

    private void cloudCreation(String providerName, String typeName, String imageName) {
        if (providerName != null && typeName != null && imageName != null) {
            CloudProvider cp = ResourceManager.getCloudProvider(providerName);
            if (cp != null) {
                CloudImageDescription imageDescription = cp.getImage(imageName);
                CloudInstanceTypeDescription typeDescription = cp.getInstanceType(typeName);
                CloudMethodResourceDescription cmrd = new CloudMethodResourceDescription(typeDescription, imageDescription);
                ResourceCreationRequest rcr = cp.requestResourceCreation(cmrd);
                if (rcr != null) {
                    RUNTIME_LOGGER.info("[ExternalAdaptation] Submited external request for creating (" + typeName + ", " + imageName + ") in " + providerName);
                    rcr.print(RESOURCES_LOGGER, DEBUG);
                    this.writePipe(this.resultPipe, "ACK " + rcr.getRequestID());
                } else {
                    RUNTIME_LOGGER.error("[ExternalAdaptation] ERROR: Creating resource (" + typeName + ", " + imageName + ") in " + providerName);
                    this.writePipe(this.resultPipe, "ERROR: Error creating resource(" + typeName + ", " + imageName + ") in " + providerName);
                }
            } else {
                RUNTIME_LOGGER.error("[ExternalAdaptation] ERROR: Provider " + providerName + " not found.");
                this.writePipe(this.resultPipe, "ERROR: Provider " + providerName + " not found");
            }
        } else {
            RUNTIME_LOGGER.error("[ExternalAdaptation] ERROR: One of the parameters is incorrect (" + typeName + ", " + imageName + "," + providerName + ")");
            this.writePipe(this.resultPipe, "ERROR: One of the parameters is incorrect (" + typeName + ", " + imageName + "," + providerName + ")");
        }
    }

    private void writePipe(String pipe, String result) {
        try (FileOutputStream output = new FileOutputStream(pipe, true);){
            output.write(result.getBytes());
            output.flush();
            output.close();
        }
        catch (Exception e) {
            RUNTIME_LOGGER.debug("[ExternalAdaptation] Error on adaptation result pipe write. ", (Throwable)e);
        }
    }

    /*
     * Exception decompiling
     */
    private String[] readPipe(String pipe) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

