/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOParamCollection;
import es.bsc.compss.nio.commands.NIOData;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.parameter.BasicTypeParameter;
import es.bsc.compss.types.parameter.CollectionParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.Parameter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NIOParamFactory {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.TaskProcessor.TaskAnalyser");

    public static NIOParam fromParameter(Parameter param) {
        NIOParam np;
        DataType type = param.getType();
        switch (type) {
            case FILE_T: 
            case OBJECT_T: 
            case PSCO_T: 
            case EXTERNAL_PSCO_T: 
            case BINDING_OBJECT_T: 
            case COLLECTION_T: {
                String pscoId;
                String dataMgmtId;
                DependencyParameter dPar = (DependencyParameter)param;
                DataAccessId dAccId = dPar.getDataAccessId();
                Object value = dPar.getDataTarget();
                boolean preserveSourceData = dAccId instanceof DataAccessId.RAccessId ? ((DataAccessId.RAccessId)dAccId).isPreserveSourceData() : (dAccId instanceof DataAccessId.RWAccessId ? ((DataAccessId.RWAccessId)dAccId).isPreserveSourceData() : false);
                String renaming = null;
                DataAccessId faId = dPar.getDataAccessId();
                if (faId instanceof DataAccessId.RWAccessId) {
                    DataAccessId.RWAccessId rwaId = (DataAccessId.RWAccessId)faId;
                    renaming = rwaId.getReadDataInstance().getRenaming();
                    dataMgmtId = rwaId.getWrittenDataInstance().getRenaming();
                } else if (faId instanceof DataAccessId.RAccessId) {
                    DataAccessId.RAccessId raId = (DataAccessId.RAccessId)faId;
                    dataMgmtId = renaming = raId.getReadDataInstance().getRenaming();
                } else {
                    DataAccessId.WAccessId waId = (DataAccessId.WAccessId)faId;
                    dataMgmtId = waId.getWrittenDataInstance().getRenaming();
                }
                if (renaming != null && (pscoId = Comm.getData(renaming).getPscoId()) != null) {
                    if (type.equals((Object)DataType.OBJECT_T)) {
                        param.setType(DataType.PSCO_T);
                    } else if (type.equals((Object)DataType.FILE_T)) {
                        param.setType(DataType.EXTERNAL_PSCO_T);
                    }
                    type = param.getType();
                }
                boolean writeFinalValue = !(dAccId instanceof DataAccessId.RAccessId);
                np = new NIOParam(dataMgmtId, type, param.getStream(), param.getPrefix(), param.getName(), preserveSourceData, writeFinalValue, value, (NIOData)dPar.getDataSource(), dPar.getOriginalName());
                break;
            }
            default: {
                BasicTypeParameter btParB = (BasicTypeParameter)param;
                Object value = btParB.getValue();
                boolean preserveSourceData = false;
                boolean writeFinalValue = false;
                np = new NIOParam(null, type, param.getStream(), param.getPrefix(), param.getName(), preserveSourceData, writeFinalValue, value, null, "NO_NAME");
            }
        }
        if (type == DataType.COLLECTION_T) {
            LOGGER.debug("COLLECTION_T detected");
            NIOParamCollection ret = new NIOParamCollection(np.getDataMgmtId(), np.getType(), np.getStream(), np.getPrefix(), np.getName(), np.isPreserveSourceData(), np.isWriteFinalValue(), np.getValue(), np.getData(), np.getOriginalName());
            CollectionParameter cp = (CollectionParameter)param;
            for (Parameter subParam : cp.getParameters()) {
                LOGGER.debug("Adding " + subParam);
                ret.getCollectionParameters().add(NIOParamFactory.fromParameter(subParam));
            }
            LOGGER.debug("NIOParamCollection contains " + ret.getCollectionParameters().size() + " parameters.");
            np = ret;
        }
        return np;
    }
}

