/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.cepbatools.extrae.Wrapper;
import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.listener.TracingCopyListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.transferable.TracingCopyTransferable;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.CoreManager;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.StreamGobbler;
import es.bsc.compss.util.TraceMerger;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Tracer {
    private static final String taskDesc = "Task";
    private static final String apiDesc = "Runtime";
    private static final String taskIdDesc = "Task IDs";
    private static final String dataTransfersDesc = "Data Transfers";
    private static final String tasksTransfersDesc = "Task Transfers Request";
    private static final String storageDesc = "Storage API";
    private static final String insideTaskDesc = "Events inside tasks";
    protected static final String TRACE_SCRIPT_PATH = File.separator + "Runtime" + File.separator + "scripts" + File.separator + "system" + File.separator + "trace" + File.separator + "trace.sh";
    protected static final String traceOutRelativePath = File.separator + "trace" + File.separator + "tracer.out";
    protected static final String traceErrRelativePath = File.separator + "trace" + File.separator + "tracer.err";
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Components.Tracing");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    protected static final String ERROR_TRACE_DIR = "ERROR: Cannot create trace directory";
    private static final int TASKS_FUNC_TYPE = 8000000;
    private static final int RUNTIME_EVENTS = 8000001;
    private static final int TASKS_ID_TYPE = 8000002;
    private static final int TASK_TRANSFERS = 8000003;
    private static final int DATA_TRANSFERS = 8000004;
    private static final int STORAGE_TYPE = 8000005;
    private static final int READY_COUNTS = 8000006;
    private static final int SYNC_TYPE = 8000666;
    private static final int INSIDE_TASKS_TYPE = 60000100;
    public static final int EVENT_END = 0;
    public static final int BASIC_MODE = 1;
    public static final int SCOREP_MODE = -1;
    public static final int MAP_MODE = -2;
    public static final String LD_PRELOAD = "LD_PRELOAD";
    public static final String EXTRAE_CONFIG_FILE = "EXTRAE_CONFIG_FILE";
    protected static int tracingLevel = 0;
    private static final boolean isCustomExtraeFile = System.getProperty("compss.extrae.file") != null && !System.getProperty("compss.extrae.file").isEmpty() && !System.getProperty("compss.extrae.file").equals("null");
    private static final String extraeFile = isCustomExtraeFile ? System.getProperty("compss.extrae.file") : "null";
    private static String traceDirPath;
    private static Map<String, TraceHost> hostToSlots;
    private static AtomicInteger hostId;

    public static void init(int level) {
        if (DEBUG) {
            LOGGER.debug("Initializing tracing with level " + level);
        }
        hostId = new AtomicInteger(1);
        hostToSlots = new HashMap<String, TraceHost>();
        traceDirPath = Comm.getAppHost().getAppLogDirPath() + "trace" + File.separator;
        if (!new File(traceDirPath).mkdir()) {
            ErrorManager.error(ERROR_TRACE_DIR);
        }
        tracingLevel = level;
        if (Tracer.extraeEnabled()) {
            if (DEBUG) {
                LOGGER.debug("Initializing extrae Wrapper.");
            }
            Wrapper.SetTaskID(0);
            Wrapper.SetNumTasks(1);
        } else if (Tracer.scorepEnabled()) {
            if (DEBUG) {
                LOGGER.debug("Initializing scorep.");
            }
        } else if (Tracer.mapEnabled() && DEBUG) {
            LOGGER.debug("Initializing arm-map.");
        }
    }

    public static boolean extraeEnabled() {
        return tracingLevel > 0;
    }

    public static boolean scorepEnabled() {
        return tracingLevel == -1;
    }

    public static boolean mapEnabled() {
        return tracingLevel == -2;
    }

    public static boolean isActivated() {
        return tracingLevel != 0;
    }

    public static boolean basicModeEnabled() {
        return tracingLevel == 1;
    }

    public static int getLevel() {
        return tracingLevel;
    }

    public static String getExtraeFile() {
        return extraeFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enablePThreads() {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.SetOptions(Wrapper.EXTRAE_ENABLE_ALL_OPTIONS);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void disablePThreads() {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.SetOptions(Wrapper.EXTRAE_ENABLE_ALL_OPTIONS & ~Wrapper.EXTRAE_PTHREAD_OPTION);
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int registerHost(String name, int slots) {
        int id;
        if (DEBUG) {
            LOGGER.debug("Tracing: Registering host " + name + " in the tracing system");
        }
        Map<String, TraceHost> map = hostToSlots;
        synchronized (map) {
            if (hostToSlots.containsKey(name)) {
                if (DEBUG) {
                    LOGGER.debug("Host " + name + " already in tracing system, skipping");
                }
                return -1;
            }
            id = hostId.getAndIncrement();
            hostToSlots.put(name, new TraceHost(slots));
        }
        return id;
    }

    public static int getNextSlot(String host) {
        int slot = Tracer.hostToSlots.get(host).getNextSlot();
        if (DEBUG) {
            LOGGER.debug("Tracing: Getting slot " + slot + " of host " + host);
        }
        return slot;
    }

    public static void freeSlot(String host, int slot) {
        if (DEBUG) {
            LOGGER.debug("Tracing: Freeing slot " + slot + " of host " + host);
        }
        Tracer.hostToSlots.get(host).freeSlot(slot);
    }

    public static int getRuntimeEventsType() {
        return 8000001;
    }

    public static int getSyncType() {
        return 8000666;
    }

    public static int getTaskTransfersType() {
        return 8000003;
    }

    public static int getDataTransfersType() {
        return 8000004;
    }

    public static int getTaskEventsType() {
        return 8000000;
    }

    public static int getTaskSchedulingType() {
        return 8000002;
    }

    public static int getInsideTasksEventsType() {
        return 60000100;
    }

    public static Event getAcessProcessorRequestEvent(String eventType) {
        return Event.valueOf(eventType);
    }

    public static Event getTaskDispatcherRequestEvent(String eventType) {
        Event event = null;
        try {
            event = Event.valueOf(eventType);
        }
        catch (Exception e) {
            LOGGER.error("Task Dispatcher event " + eventType + " is not present in Tracer's list ");
        }
        return event;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void emitEvent(long eventID, int eventType) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.Event(eventType, eventID);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (DEBUG) {
                LOGGER.debug("Emitting synchronized event [type, id] = [" + eventType + " , " + eventID + "]");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void emitEventAndCounters(int taskId, int eventType) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.Eventandcounters(eventType, taskId);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (DEBUG) {
                LOGGER.debug("Emitting synchronized event with HW counters [type, taskId] = [" + eventType + " , " + taskId + "]");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fini() {
        if (DEBUG) {
            LOGGER.debug("Tracing: finalizing");
        }
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            if (Tracer.extraeEnabled()) {
                Tracer.defineEvents();
                Wrapper.SetOptions(Wrapper.EXTRAE_ENABLE_ALL_OPTIONS & ~Wrapper.EXTRAE_PTHREAD_OPTION);
                Wrapper.Fini();
                Wrapper.SetOptions(Wrapper.EXTRAE_DISABLE_ALL_OPTIONS);
                Tracer.generateMasterPackage("package");
                Tracer.transferMasterPackage();
                Tracer.generateTrace();
                Tracer.cleanMasterPackage();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static int getSizeByEventType(int type) {
        int size = 0;
        for (Event task : Event.values()) {
            if (task.getType() != type) continue;
            ++size;
        }
        return size;
    }

    private static void defineEvents() {
        Map<String, Integer> signatureToId = CoreManager.getSignaturesToId();
        if (DEBUG) {
            LOGGER.debug("SignatureToId size: " + signatureToId.size());
        }
        int size = Tracer.getSizeByEventType(8000001) + 1;
        long[] values = new long[size];
        String[] descriptionValues = new String[size];
        values[0] = 0L;
        descriptionValues[0] = "End";
        int i = 1;
        for (Object task : Event.values()) {
            if (task.getType() != 8000001) continue;
            values[i] = task.getId();
            descriptionValues[i] = task.getSignature();
            if (DEBUG) {
                LOGGER.debug("Tracing[API]: Api Event " + i + "=> value: " + values[i] + ", Desc: " + descriptionValues[i]);
            }
            ++i;
        }
        Wrapper.defineEventType(8000001, apiDesc, values, descriptionValues);
        size = signatureToId.entrySet().size() + 1;
        values = new long[size];
        descriptionValues = new String[size];
        values[0] = 0L;
        descriptionValues[0] = "End";
        i = 1;
        for (Map.Entry entry : signatureToId.entrySet()) {
            String methodName;
            String signature = (String)entry.getKey();
            Integer methodId = (Integer)entry.getValue();
            values[i] = methodId + 1;
            LOGGER.debug("Tracing debug: " + signature);
            descriptionValues[i] = methodName = signature.substring(signature.indexOf(46) + 1, signature.length());
            if (DEBUG) {
                LOGGER.debug("Tracing[TASKS_FUNC_TYPE] Event [i,methodId]: [" + i + "," + methodId + "] => value: " + values[i] + ", Desc: " + descriptionValues[i]);
            }
            ++i;
        }
        Wrapper.defineEventType(8000000, taskDesc, values, descriptionValues);
        size = Tracer.getSizeByEventType(8000003) + 1;
        values = new long[size];
        descriptionValues = new String[size];
        values[0] = 0L;
        descriptionValues[0] = "End";
        i = 1;
        for (Object task : Event.values()) {
            if (task.getType() != 8000003) continue;
            values[i] = task.getId();
            descriptionValues[i] = task.getSignature();
            if (DEBUG) {
                LOGGER.debug("Tracing[TASK_TRANSFERS]: Event " + i + "=> value: " + values[i] + ", Desc: " + descriptionValues[i]);
            }
            ++i;
        }
        Wrapper.defineEventType(8000003, tasksTransfersDesc, values, descriptionValues);
        size = Tracer.getSizeByEventType(8000005) + 1;
        values = new long[size];
        descriptionValues = new String[size];
        values[0] = 0L;
        descriptionValues[0] = "End";
        i = 1;
        for (Object task : Event.values()) {
            if (task.getType() != 8000005) continue;
            values[i] = task.getId();
            descriptionValues[i] = task.getSignature();
            if (DEBUG) {
                LOGGER.debug("Tracing[STORAGE_TYPE]: Event " + i + "=> value: " + values[i] + ", Desc: " + descriptionValues[i]);
            }
            ++i;
        }
        Wrapper.defineEventType(8000005, storageDesc, values, descriptionValues);
        size = Tracer.getSizeByEventType(60000100) + 1;
        values = new long[size];
        descriptionValues = new String[size];
        values[0] = 0L;
        descriptionValues[0] = "End";
        i = 1;
        for (Object task : Event.values()) {
            if (task.getType() != 60000100) continue;
            values[i] = task.getId();
            descriptionValues[i] = task.getSignature();
            if (DEBUG) {
                LOGGER.debug("Tracing[INSIDE_TASKS_EVENTS]: Event " + i + "=> value: " + values[i] + ", Desc: " + descriptionValues[i]);
            }
            ++i;
        }
        Wrapper.defineEventType(60000100, insideTaskDesc, values, descriptionValues);
        size = 0;
        values = new long[size];
        descriptionValues = new String[size];
        Wrapper.defineEventType(8000002, taskIdDesc, values, descriptionValues);
        size = 0;
        values = new long[size];
        descriptionValues = new String[size];
        Wrapper.defineEventType(8000004, dataTransfersDesc, values, descriptionValues);
    }

    private static void generateMasterPackage(String mode) {
        Process p;
        if (DEBUG) {
            LOGGER.debug("Tracing: generating master package: " + mode);
        }
        String script = System.getenv("COMPSS_HOME") + TRACE_SCRIPT_PATH;
        ProcessBuilder pb = new ProcessBuilder(script, mode, ".", "master");
        pb.environment().remove(LD_PRELOAD);
        try {
            p = pb.start();
        }
        catch (IOException e) {
            ErrorManager.warn("Error generating master package", e);
            return;
        }
        if (DEBUG) {
            StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), System.out, LOGGER);
            StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), System.err, LOGGER);
            outputGobbler.start();
            errorGobbler.start();
        }
        try {
            int exitCode = p.waitFor();
            if (exitCode != 0) {
                ErrorManager.warn("Error generating master package, exit code " + exitCode);
            }
        }
        catch (InterruptedException e) {
            ErrorManager.warn("Error generating master package (interruptedException) : " + e.getMessage());
        }
    }

    private static void transferMasterPackage() {
        if (DEBUG) {
            LOGGER.debug("Tracing: Transferring master package");
        }
        String filename = "master_compss_trace.tar.gz";
        DataLocation source = null;
        String sourcePath = DataLocation.Protocol.FILE_URI.getSchema() + filename;
        try {
            SimpleURI uri = new SimpleURI(sourcePath);
            source = DataLocation.createLocation(Comm.getAppHost(), uri);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + sourcePath, e);
        }
        DataLocation target = null;
        String targetPath = DataLocation.Protocol.FILE_URI.getSchema() + traceDirPath + filename;
        try {
            SimpleURI uri = new SimpleURI(targetPath);
            target = DataLocation.createLocation(Comm.getAppHost(), uri);
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + targetPath, e);
        }
        Semaphore sem = new Semaphore(0);
        TracingCopyListener tracingListener = new TracingCopyListener(sem);
        tracingListener.addOperation();
        Comm.getAppHost().getNode().obtainData(new LogicalData("tracing master package"), source, target, new LogicalData("tracing master package"), new TracingCopyTransferable(), tracingListener);
        tracingListener.enable();
        try {
            sem.acquire();
        }
        catch (InterruptedException ex) {
            ErrorManager.warn("Error waiting for tracing files in master to get saved");
        }
    }

    private static void generateTrace() {
        Process p;
        if (DEBUG) {
            LOGGER.debug("Tracing: Generating trace");
        }
        String script = System.getenv("COMPSS_HOME") + TRACE_SCRIPT_PATH;
        String appName = System.getProperty("compss.appName");
        ProcessBuilder pb = new ProcessBuilder(script, "gentrace", System.getProperty("compss.appLogDir"), appName, String.valueOf(hostToSlots.size() + 1));
        pb.environment().remove(LD_PRELOAD);
        try {
            p = pb.start();
        }
        catch (IOException e) {
            ErrorManager.warn("Error generating trace", e);
            return;
        }
        StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), System.out, LOGGER);
        StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), System.err, LOGGER);
        outputGobbler.start();
        errorGobbler.start();
        int exitCode = 0;
        try {
            exitCode = p.waitFor();
            if (exitCode != 0) {
                ErrorManager.warn("Error generating trace, exit code " + exitCode);
            }
        }
        catch (InterruptedException e) {
            ErrorManager.warn("Error generating trace (interruptedException) : " + e.getMessage());
        }
        String lang = System.getProperty("compss.lang");
        if (exitCode == 0 && lang.equalsIgnoreCase(COMPSsConstants.Lang.PYTHON.name())) {
            try {
                new TraceMerger(System.getProperty("compss.appLogDir"), appName).merge();
            }
            catch (IOException e) {
                ErrorManager.warn("Error while trying to merge files: " + e.toString());
            }
        }
    }

    private static void cleanMasterPackage() {
        String filePath;
        String filename = DataLocation.Protocol.FILE_URI.getSchema() + "master_compss_trace.tar.gz";
        try {
            SimpleURI uri = new SimpleURI(filename);
            filePath = new File(uri.getPath()).getCanonicalPath();
        }
        catch (Exception e) {
            ErrorManager.error("ERROR: Invalid location URI " + filename, e);
            return;
        }
        if (DEBUG) {
            LOGGER.debug("Tracing: Removing tracing master package: " + filePath);
        }
        try {
            File f = new File(filePath);
            boolean deleted = f.delete();
            if (!deleted) {
                ErrorManager.warn("Unable to remove tracing temporary files of master node.");
            } else if (DEBUG) {
                LOGGER.debug("Deleted master tracing package.");
            }
        }
        catch (Exception e) {
            ErrorManager.warn("Exception while trying to remove tracing temporary files of master node.", e);
        }
    }

    private static class TraceHost {
        private boolean[] slots;
        private int numFreeSlots;
        private int nextSlot;

        private TraceHost(int nslots) {
            this.slots = new boolean[nslots];
            this.numFreeSlots = nslots;
            this.nextSlot = 0;
        }

        private int getNextSlot() {
            if (this.numFreeSlots-- > 0) {
                while (this.slots[this.nextSlot]) {
                    this.nextSlot = (this.nextSlot + 1) % this.slots.length;
                }
                this.slots[this.nextSlot] = true;
                return this.nextSlot;
            }
            return -1;
        }

        private void freeSlot(int slot) {
            this.slots[slot] = false;
            this.nextSlot = slot;
            ++this.numFreeSlots;
        }
    }

    public static enum Event {
        STATIC_IT(1, 8000001, "Loading Runtime"),
        START(2, 8000001, "Start"),
        STOP(3, 8000001, "Stop"),
        TASK(4, 8000001, "Execute Task"),
        NO_MORE_TASKS(5, 8000001, "Waiting for tasks end"),
        WAIT_FOR_ALL_TASKS(6, 8000001, "Barrier"),
        OPEN_FILE(7, 8000001, "Waiting for open file"),
        GET_FILE(8, 8000001, "Waiting for get file"),
        GET_OBJECT(9, 8000001, "Waiting for get object"),
        TASK_RUNNING(11, 8000001, "Task Running"),
        DELETE(12, 8000001, "Delete File"),
        WORKER_RECEIVED_NEW_TASK(13, 8000001, "Received new task"),
        DEBUG(17, 8000001, "Access Processor: Debug"),
        ANALYSE_TASK(18, 8000001, "Access Processor: Analyse task"),
        UPDATE_GRAPH(19, 8000001, "Access Processor: Update graph"),
        WAIT_FOR_TASK(20, 8000001, "Access Processor: Wait for task"),
        END_OF_APP(21, 8000001, "Access Processor: End of app"),
        ALREADY_ACCESSED(22, 8000001, "Access Processor: Already accessed"),
        REGISTER_DATA_ACCESS(23, 8000001, "Access Processor: Register data access"),
        TRANSFER_OPEN_FILE(24, 8000001, "Access Processor: Transfer open file"),
        TRANSFER_RAW_FILE(25, 8000001, "Access Processor: Transfer raw file"),
        TRANSFER_OBJECT(26, 8000001, "Access Processor: Transfer object"),
        NEW_VERSION_SAME_VALUE(27, 8000001, "Access Processor: New version same value"),
        IS_OBJECT_HERE(28, 8000001, "Access Processor: Is object here"),
        SET_OBJECT_VERSION_VALUE(29, 8000001, "Access Processor: Set object version value"),
        GET_LAST_RENAMING(30, 8000001, "Access Processor: Get last renaming"),
        BLOCK_AND_GET_RESULT_FILES(31, 8000001, "Access Processor: Block and get result files"),
        UNBLOCK_RESULT_FILES(32, 8000001, "Access Processor: Unblock result files"),
        SHUTDOWN(33, 8000001, "Access Processor: Shutdown"),
        GRAPHSTATE(34, 8000001, "Access Processor: Graphstate"),
        TASKSTATE(35, 8000001, "Access Processor: Taskstate"),
        DELETE_FILE(36, 8000001, "Access Processor: Delete file"),
        FINISH_ACCESS_FILE(37, 8000001, "Access Processor: Finish acess to file"),
        STORAGE_GETBYID(38, 8000005, "getByID"),
        STORAGE_NEWREPLICA(39, 8000005, "newReplica"),
        STORAGE_NEWVERSION(40, 8000005, "newVersion"),
        STORAGE_INVOKE(41, 8000005, "invoke"),
        STORAGE_EXECUTETASK(42, 8000005, "executeTask"),
        STORAGE_GETLOCATIONS(43, 8000005, "getLocations"),
        STORAGE_CONSOLIDATE(44, 8000005, "consolidateVersion"),
        ACTION_UPDATE(45, 8000001, "Task Dispatcher: Action update"),
        CE_REGISTRATION(46, 8000001, "Task Dispatcher: CE registration"),
        EXECUTE_TASKS(47, 8000001, "Task Dispatcher: Execute tasks"),
        GET_CURRENT_SCHEDULE(48, 8000001, "Task Dispatcher: Get current schedule"),
        PRINT_CURRENT_GRAPH(49, 8000001, "Task Dispatcher: Print current graph"),
        MONITORING_DATA(50, 8000001, "Task Dispatcher: Monitoring data"),
        TD_SHUTDOWN(51, 8000001, "Task Dispatcher: Shutdown"),
        UPDATE_CEI_LOCAL(52, 8000001, "Task Dispatcher: Update CEI local"),
        WORKER_UPDATE_REQUEST(53, 8000001, "Task Dispatcher: Worker update request"),
        CREATING_TASK_SANDBOX(54, 8000001, "Worker: Creating task sandbox"),
        REMOVING_TASK_SANDBOX(55, 8000001, "Worker: Removing task sandbox"),
        TASK_EXECUTION_PYTHON(1, 60000100, "Task execution"),
        USER_CODE_PYTHON1(2, 60000100, "User code execution 1"),
        USER_CODE_PYTHON2(3, 60000100, "User code execution 2"),
        USER_CODE_PYTHON3(4, 60000100, "User code execution 3"),
        IMPORTING_MODULES_PYTHON(5, 60000100, "Importing modules"),
        THREAD_BINDING_PYTHON(6, 60000100, "Thread binding"),
        DESERIALIZE_OBJECT_PYTHON1(7, 60000100, "Deserializing object"),
        DESERIALIZE_OBJECT_PYTHON2(8, 60000100, "Deserializing object"),
        SERIALIZE_OBJECT_PYTHON(9, 60000100, "Serializing object"),
        CREATE_THREADS_PYTHON(10, 60000100, "Create persistent threads"),
        GET_BY_ID(11, 60000100, "Get by ID persistent object"),
        MAKE_PERSISTENT(12, 60000100, "Make persistent object"),
        DELETE_PERSISTENT(13, 60000100, "Delete persistent object"),
        WORKER_RUNNING(102, 60000100, "Worker running"),
        READY_COUNT(1, 8000006, "Ready queue count");

        private final int id;
        private final int type;
        private final String signature;

        private Event(int id, int type, String signature) {
            this.id = id;
            this.type = type;
            this.signature = signature;
        }

        public int getId() {
            return this.id;
        }

        public int getType() {
            return this.type;
        }

        public String getSignature() {
            return this.signature;
        }
    }
}

