/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.master;

import es.bsc.comm.Connection;
import es.bsc.comm.Node;
import es.bsc.comm.nio.NIONode;
import es.bsc.compss.comm.Comm;
import es.bsc.compss.exceptions.InitNodeException;
import es.bsc.compss.exceptions.UnstartedNodeException;
import es.bsc.compss.nio.NIOAgent;
import es.bsc.compss.nio.NIOData;
import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.NIOTracer;
import es.bsc.compss.nio.NIOUri;
import es.bsc.compss.nio.commands.Command;
import es.bsc.compss.nio.commands.CommandCancelTask;
import es.bsc.compss.nio.commands.CommandDataFetch;
import es.bsc.compss.nio.commands.CommandExecutorShutdown;
import es.bsc.compss.nio.commands.CommandNewTask;
import es.bsc.compss.nio.commands.CommandRemoveObsoletes;
import es.bsc.compss.nio.commands.CommandResourcesIncrease;
import es.bsc.compss.nio.commands.CommandResourcesReduce;
import es.bsc.compss.nio.commands.CommandShutdown;
import es.bsc.compss.nio.commands.tracing.CommandGeneratePackage;
import es.bsc.compss.nio.commands.workerfiles.CommandGenerateWorkerDebugFiles;
import es.bsc.compss.nio.master.NIOAdaptor;
import es.bsc.compss.nio.master.NIOJob;
import es.bsc.compss.nio.master.WorkerStarter;
import es.bsc.compss.nio.master.configuration.NIOConfiguration;
import es.bsc.compss.nio.master.utils.NIOParamFactory;
import es.bsc.compss.nio.requests.MasterDataRequest;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.types.COMPSsWorker;
import es.bsc.compss.types.TaskDescription;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.data.Transferable;
import es.bsc.compss.types.data.listener.EventListener;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.types.data.operation.DataOperation;
import es.bsc.compss.types.data.operation.OperationEndState;
import es.bsc.compss.types.data.operation.copy.Copy;
import es.bsc.compss.types.data.operation.copy.DeferredCopy;
import es.bsc.compss.types.data.operation.copy.StorageCopy;
import es.bsc.compss.types.execution.InvocationParamURI;
import es.bsc.compss.types.implementations.Implementation;
import es.bsc.compss.types.job.Job;
import es.bsc.compss.types.job.JobListener;
import es.bsc.compss.types.parameter.Parameter;
import es.bsc.compss.types.resources.ExecutorShutdownListener;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.Resource;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.types.resources.ShutdownListener;
import es.bsc.compss.types.uri.MultiURI;
import es.bsc.compss.types.uri.SimpleURI;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.TraceEvent;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.Semaphore;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import storage.StorageException;
import storage.StorageItf;

public class NIOWorkerNode
extends COMPSsWorker {
    protected static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Communication");
    protected static final boolean DEBUG = LOGGER.isDebugEnabled();
    protected NIONode node;
    private final NIOConfiguration config;
    private final NIOAdaptor commManager;
    protected boolean started = false;
    private WorkerStarter workerStarter;

    public NIOWorkerNode(NIOConfiguration config, NIOAdaptor adaptor) {
        this.config = config;
        this.commManager = adaptor;
    }

    public String getName() {
        return this.config.getHost();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() throws InitNodeException {
        NIONode n = null;
        try {
            WorkerStarter workerStarter = this.workerStarter = new WorkerStarter(this);
            synchronized (workerStarter) {
                this.node = n = this.workerStarter.startWorker();
                this.started = true;
            }
        }
        catch (InitNodeException e) {
            ErrorManager.warn((String)("There was an exception when initiating worker " + this.getName() + "."), (Exception)((Object)e));
            throw e;
        }
        if (NIOTracer.extraeEnabled()) {
            LOGGER.debug("Initializing NIO tracer " + this.getName());
            NIOTracer.startTracing((String)this.getName(), (String)this.getUser(), (String)this.getHost(), (Integer)this.getLimitOfTasks());
        }
    }

    public String getUser() {
        return this.config.getUser();
    }

    public NIOAdaptor getCommManager() {
        return this.commManager;
    }

    public String getHost() {
        return this.config.getHost();
    }

    public String getInstallDir() {
        return this.config.getInstallDir();
    }

    public String getBaseWorkingDir() {
        return this.config.getWorkingDir();
    }

    public String getWorkingDir() {
        return this.config.getSandboxWorkingDir();
    }

    public String getAppDir() {
        return this.config.getAppDir();
    }

    public String getLibPath() {
        return this.config.getLibraryPath();
    }

    public String getClasspath() {
        return this.config.getClasspath();
    }

    public String getPythonpath() {
        return this.config.getPythonpath();
    }

    public int getLimitOfTasks() {
        return this.config.getLimitOfTasks();
    }

    public int getTotalComputingUnits() {
        return this.config.getTotalComputingUnits();
    }

    public int getTotalGPUs() {
        return this.config.getTotalGPUComputingUnits();
    }

    public int getTotalFPGAs() {
        return this.config.getTotalFPGAComputingUnits();
    }

    public NIOConfiguration getConfiguration() {
        return this.config;
    }

    public void setInternalURI(MultiURI uri) throws UnstartedNodeException {
        if (this.node == null) {
            throw new UnstartedNodeException();
        }
        NIOUri nio = new NIOUri(this.node, uri.getPath(), uri.getProtocol());
        uri.setInternalURI(NIOAdaptor.ID, (Object)nio);
    }

    public Job<?> newJob(int taskId, TaskDescription taskParams, Implementation impl, Resource res, List<String> slaveWorkersNodeNames, JobListener listener) {
        return new NIOJob(taskId, taskParams, impl, res, slaveWorkersNodeNames, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop(ShutdownListener sl) {
        if (this.workerStarter != null) {
            this.workerStarter.setToStop();
            LOGGER.debug("Worker " + this.getName() + " set to be stopped.");
            WorkerStarter workerStarter = this.workerStarter;
            synchronized (workerStarter) {
                if (this.started) {
                    LOGGER.debug("Shutting down " + this.getName());
                    if (this.node == null) {
                        sl.notifyFailure((Exception)new UnstartedNodeException());
                        LOGGER.error("Shutdown has failed");
                    }
                    Connection c = NIOAgent.getTransferManager().startConnection((Node)this.node);
                    this.commManager.shuttingDown(this, c, sl);
                    CommandShutdown cmd = new CommandShutdown(null);
                    NIOAgent.registerOngoingCommand((Connection)c, (Command)cmd);
                    c.sendCommand((Object)cmd);
                    c.receive();
                    c.finishConnection();
                } else {
                    LOGGER.debug("Worker " + this.getName() + " has not started.");
                    sl.notifyEnd();
                }
            }
        } else {
            LOGGER.debug("Worker " + this.getName() + " has not been created.");
            sl.notifyEnd();
        }
    }

    public void shutdownExecutionManager(ExecutorShutdownListener esl) {
        if (this.started) {
            LOGGER.debug("Shutting down execution manager " + this.getName());
            if (this.node == null) {
                LOGGER.error("Shutdown execution manager has failed");
                esl.notifyFailure((Exception)new UnstartedNodeException());
            }
            Connection c = NIOAgent.getTransferManager().startConnection((Node)this.node);
            this.commManager.shuttingDownEM(this, c, esl);
            LOGGER.debug("Sending shutdown command " + this.getName());
            CommandExecutorShutdown cmd = new CommandExecutorShutdown();
            NIOAgent.registerOngoingCommand((Connection)c, (Command)cmd);
            c.sendCommand((Object)cmd);
            c.receive();
            c.finishConnection();
        } else {
            LOGGER.debug("Worker " + this.getName() + " has not started. Considering execution manager stopped");
            esl.notifyEnd();
        }
    }

    public void sendData(LogicalData ld, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        if (DEBUG) {
            LOGGER.debug("Sending data " + ld.getName() + " from worker node " + this.getName());
        }
        if (target.getHosts().contains(Comm.getAppHost())) {
            NIOData d = this.getNIODatafromLogicalData(ld);
            if (source != null) {
                for (MultiURI uri : source.getURIs()) {
                    try {
                        NIOUri nURI = (NIOUri)uri.getInternalURI(NIOAdaptor.ID);
                        if (nURI == null) continue;
                        d.getSources().add(nURI);
                    }
                    catch (UnstartedNodeException nURI) {}
                }
            } else {
                LOGGER.warn(" Source location for data " + ld.getName() + " is null.");
            }
            DeferredCopy c = new DeferredCopy(ld, null, target, tgtData, reason, listener);
            String path = target.getURIInHost((Resource)Comm.getAppHost()).getPath();
            c.setFinalTarget(path);
            ld.startCopy((Copy)c, c.getTargetLoc());
            MasterDataRequest dr = new MasterDataRequest((DataOperation)c, reason.getType(), d, path);
            this.commManager.addTransferRequest(dr);
            this.commManager.requestTransfers();
        } else {
            if (DEBUG) {
                LOGGER.debug(" Ordering deferred copy for data " + ld.getName());
            }
            this.orderCopy(new DeferredCopy(ld, source, target, tgtData, reason, listener), Comm.getAppHost().getNode());
        }
    }

    public void obtainData(LogicalData ld, DataLocation source, DataLocation target, LogicalData tgtData, Transferable reason, EventListener listener) {
        if (ld == null) {
            LOGGER.debug("Logical data to obtain is null");
            return;
        }
        if (DEBUG) {
            LOGGER.debug("Obtain Data " + ld.getName() + " as " + target);
        }
        if (ld.getPscoId() != null) {
            this.orderStorageCopy(new StorageCopy(ld, source, target, tgtData, reason, listener));
        } else {
            if (DEBUG) {
                LOGGER.debug("Ordering deferred copy " + ld.getName());
            }
            this.orderCopy(new DeferredCopy(ld, source, target, tgtData, reason, listener), (COMPSsNode)this);
        }
    }

    private void orderStorageCopy(StorageCopy sc) {
        LOGGER.info("Order PSCO Copy for " + sc.getSourceData().getName());
        if (DEBUG) {
            LOGGER.debug("LD Target " + sc.getTargetData());
            LOGGER.debug("FROM: " + sc.getPreferredSource());
            LOGGER.debug("TO: " + sc.getTargetLoc());
            LOGGER.debug("MUST PRESERVE: " + sc.mustPreserveSourceData());
        }
        LogicalData source = sc.getSourceData();
        LogicalData target = sc.getTargetData();
        if (target != null) {
            if (target.getName().equals(source.getName())) {
                this.newReplica(sc);
            } else {
                this.newVersion(sc);
            }
        } else {
            this.newVersion(sc);
        }
    }

    private void newReplica(StorageCopy sc) {
        List currentLocations;
        String targetHostname = this.getName();
        LogicalData srcLD = sc.getSourceData();
        LogicalData targetLD = sc.getTargetData();
        LOGGER.debug("Ask for new Replica of " + srcLD.getName() + " to " + targetHostname);
        String pscoId = srcLD.getPscoId();
        try {
            currentLocations = StorageItf.getLocations((String)pscoId);
        }
        catch (StorageException se) {
            sc.end(OperationEndState.OP_FAILED, (Exception)((Object)se));
            return;
        }
        if (!currentLocations.contains(targetHostname)) {
            LOGGER.debug("Performing new replica for PSCO " + pscoId);
            if (NIOTracer.extraeEnabled()) {
                NIOTracer.emitEvent((long)TraceEvent.STORAGE_NEWREPLICA.getId(), (int)TraceEvent.STORAGE_NEWREPLICA.getType());
            }
            if (NIOTracer.extraeEnabled()) {
                NIOTracer.emitEvent((long)0L, (int)TraceEvent.STORAGE_NEWREPLICA.getType());
            }
        } else {
            LOGGER.debug("PSCO " + pscoId + " already present. Skip replica.");
        }
        NIOData nd = this.getNIODatafromLogicalData(srcLD);
        sc.setProposedSource((Object)nd);
        sc.setFinalTarget(pscoId);
        if (targetLD != null) {
            targetLD.setPscoId(pscoId);
        }
        sc.end(OperationEndState.OP_OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void newVersion(StorageCopy sc) {
        String targetHostname = this.getName();
        LogicalData srcLD = sc.getSourceData();
        LogicalData targetLD = sc.getTargetData();
        boolean preserveSource = sc.mustPreserveSourceData();
        if (DEBUG) {
            LOGGER.debug("Ask for new Version of " + srcLD.getName() + " with id " + srcLD.getPscoId() + " to " + targetHostname + " with must preserve " + preserveSource);
        }
        String pscoId = srcLD.getPscoId();
        LOGGER.debug("Performing new version for PSCO " + pscoId);
        if (NIOTracer.extraeEnabled()) {
            NIOTracer.emitEvent((long)TraceEvent.STORAGE_NEWVERSION.getId(), (int)TraceEvent.STORAGE_NEWVERSION.getType());
        }
        try {
            String newId = StorageItf.newVersion((String)pscoId, (boolean)preserveSource, (String)targetHostname);
            LOGGER.debug("Register new new version of " + pscoId + " as " + newId);
            sc.setFinalTarget(newId);
            if (targetLD != null) {
                targetLD.setPscoId(newId);
            }
            NIOUri uri = new NIOUri(null, pscoId, ProtocolType.PERSISTENT_URI);
            NIOData nd = new NIOData(srcLD.getName(), uri);
            sc.setProposedSource((Object)nd);
        }
        catch (Exception e) {
            sc.end(OperationEndState.OP_FAILED, e);
            return;
        }
        finally {
            if (NIOTracer.extraeEnabled()) {
                NIOTracer.emitEvent((long)0L, (int)TraceEvent.STORAGE_NEWVERSION.getType());
            }
        }
        sc.end(OperationEndState.OP_OK);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void orderCopy(DeferredCopy c, COMPSsNode tgtNode) {
        LogicalData ld;
        LOGGER.info("Order Copy for " + c.getSourceData());
        Resource tgtRes = null;
        for (Resource r : c.getTargetLoc().getHosts()) {
            if (!r.getNode().equals((Object)tgtNode)) continue;
            tgtRes = r;
            break;
        }
        LogicalData logicalData = ld = c.getSourceData();
        synchronized (logicalData) {
            String path;
            LogicalData tgtData = c.getTargetData();
            if (tgtData != null) {
                LOGGER.debug("tgtResName:" + tgtRes.getNode().getName());
                LOGGER.debug("tgtData: " + tgtData.toString());
                MultiURI u = tgtData.alreadyAvailable(tgtRes);
                if (u != null) {
                    path = u.getPath();
                    try {
                        c.setTargetLoc(DataLocation.createLocation((Resource)tgtRes, (SimpleURI)new SimpleURI(u.getScheme(), u.getHost().getName(), u.getPath())));
                    }
                    catch (Exception e) {
                        c.end(OperationEndState.OP_FAILED, e);
                        return;
                    }
                } else {
                    path = c.getTargetLoc().getURIInHost(tgtRes).getPath();
                }
            } else if (c.getTargetLoc() != null) {
                path = c.getTargetLoc().getURIInHost(tgtRes).getPath();
            } else {
                c.end(OperationEndState.OP_FAILED, new Exception(" Target location for copy " + c.getName() + " is null."));
                return;
            }
            c.setProposedSource((Object)this.getNIODatafromLogicalData(ld));
            LOGGER.debug("Setting final target in deferred copy " + path);
            c.setFinalTarget(path);
            ld.startCopy((Copy)c, c.getTargetLoc());
            this.commManager.registerCopy((Copy)c);
        }
        c.end(OperationEndState.OP_OK);
    }

    public void enforceDataObtaining(Transferable reason, EventListener listener) {
        NIOParam param = NIOParamFactory.fromParameter((Parameter)reason, this);
        CommandDataFetch cmd = new CommandDataFetch(param, listener.getId().intValue());
        Connection c = NIOAgent.getTransferManager().startConnection((Node)this.node);
        NIOAgent.registerOngoingCommand((Connection)c, (Command)cmd);
        c.sendCommand((Object)cmd);
        c.finishConnection();
    }

    public void updateTaskCount(int processorCoreCount) {
    }

    public void announceDestruction() {
    }

    public void announceCreation() {
    }

    public SimpleURI getCompletePath(DataType type, String name) {
        String path = null;
        switch (type) {
            case FILE_T: {
                path = ProtocolType.FILE_URI.getSchema() + this.config.getSandboxWorkingDir() + name;
                break;
            }
            case OBJECT_T: {
                path = ProtocolType.OBJECT_URI.getSchema() + name;
                break;
            }
            case COLLECTION_T: {
                path = ProtocolType.OBJECT_URI.getSchema() + this.config.getSandboxWorkingDir() + name;
                break;
            }
            case STREAM_T: {
                path = ProtocolType.STREAM_URI.getSchema() + name;
                break;
            }
            case EXTERNAL_STREAM_T: {
                path = ProtocolType.EXTERNAL_STREAM_URI.getSchema() + this.config.getSandboxWorkingDir() + name;
                break;
            }
            case PSCO_T: {
                String id = Comm.getData((String)name).getPscoId();
                path = ProtocolType.PERSISTENT_URI.getSchema() + id;
                break;
            }
            case EXTERNAL_PSCO_T: {
                path = ProtocolType.PERSISTENT_URI.getSchema() + name;
                break;
            }
            case BINDING_OBJECT_T: {
                path = ProtocolType.BINDING_URI.getSchema() + this.config.getSandboxWorkingDir() + name;
                break;
            }
            default: {
                return null;
            }
        }
        return new SimpleURI(path);
    }

    public void deleteTemporary() {
    }

    public boolean generatePackage() {
        if (this.started) {
            LOGGER.debug("Sending command to generated tracing package for " + this.getHost());
            if (this.node == null) {
                LOGGER.error("ERROR: Package generation for " + this.getHost() + " has failed.");
                return false;
            }
            Connection c = NIOAgent.getTransferManager().startConnection((Node)this.node);
            CommandGeneratePackage cmd = new CommandGeneratePackage();
            NIOAgent.registerOngoingCommand((Connection)c, (Command)cmd);
            c.sendCommand((Object)cmd);
            c.receive();
            c.finishConnection();
            this.commManager.waitUntilTracingPackageGenerated();
            LOGGER.debug("Tracing Package generated");
            return true;
        }
        LOGGER.debug("Worker " + this.getHost() + " not started. No tracing package generated");
        return false;
    }

    public boolean generateWorkersDebugInfo() {
        if (this.started) {
            LOGGER.debug("Sending command to generate worker debug files for " + this.getHost());
            if (this.node == null) {
                LOGGER.error("Worker debug files generation has failed.");
            }
            Connection c = NIOAgent.getTransferManager().startConnection((Node)this.node);
            CommandGenerateWorkerDebugFiles cmd = new CommandGenerateWorkerDebugFiles();
            NIOAgent.registerOngoingCommand((Connection)c, (Command)cmd);
            c.sendCommand((Object)cmd);
            c.receive();
            c.finishConnection();
            this.commManager.waitUntilWorkersDebugInfoGenerated();
            LOGGER.debug("Worker debug files generated");
            return true;
        }
        LOGGER.debug("Worker debug files not generated because worker was not started");
        return false;
    }

    public void submitTask(NIOJob job, List<String> obsolete) throws UnstartedNodeException {
        if (this.node == null) {
            throw new UnstartedNodeException();
        }
        NIOTask t = job.prepareJob();
        CommandNewTask cmd = new CommandNewTask(t, obsolete);
        Connection c = NIOAgent.getTransferManager().startConnection((Node)this.node);
        NIOAgent.registerOngoingCommand((Connection)c, (Command)cmd);
        c.sendCommand((Object)cmd);
        c.finishConnection();
    }

    public void cancelTask(NIOJob job) throws UnstartedNodeException {
        if (this.node == null) {
            throw new UnstartedNodeException();
        }
        LOGGER.debug("Sending task cancellation command to worker");
        CommandCancelTask cmd = new CommandCancelTask(job.getJobId());
        Connection c = NIOAgent.getTransferManager().startConnection((Node)this.node);
        NIOAgent.registerOngoingCommand((Connection)c, (Command)cmd);
        c.sendCommand((Object)cmd);
        c.finishConnection();
    }

    public void setStarted(boolean b) {
        this.started = b;
    }

    public void increaseComputingCapabilities(ResourceDescription description) {
        Semaphore sem = new Semaphore(0);
        MethodResourceDescription mrd = (MethodResourceDescription)description;
        CommandResourcesIncrease cmd = new CommandResourcesIncrease(mrd);
        Connection c = NIOAgent.getTransferManager().startConnection((Node)this.node);
        this.commManager.registerPendingResourceUpdateConfirmation(c, sem);
        NIOAgent.registerOngoingCommand((Connection)c, (Command)cmd);
        c.sendCommand((Object)cmd);
        c.receive();
        try {
            sem.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void reduceComputingCapabilities(ResourceDescription description) {
        Semaphore sem = new Semaphore(0);
        MethodResourceDescription mrd = (MethodResourceDescription)description;
        CommandResourcesReduce cmd = new CommandResourcesReduce(mrd);
        Connection c = NIOAgent.getTransferManager().startConnection((Node)this.node);
        this.commManager.registerPendingResourceUpdateConfirmation(c, sem);
        NIOAgent.registerOngoingCommand((Connection)c, (Command)cmd);
        c.sendCommand((Object)cmd);
        c.receive();
        try {
            sem.acquire();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private NIOData getNIODatafromLogicalData(LogicalData ld) {
        NIOData data = new NIOData(ld.getName());
        for (MultiURI uri : ld.getURIs()) {
            try {
                Object o = uri.getInternalURI(NIOAgent.ID);
                if (o == null) continue;
                data.addSource((InvocationParamURI)((NIOUri)o));
            }
            catch (UnstartedNodeException unstartedNodeException) {}
        }
        return data;
    }

    public void removeObsoletes(List<MultiURI> obsoletes) {
        LOGGER.debug("Sending command to remove obsoletes for " + this.getHost());
        LinkedList<String> obsoleteRenamings = new LinkedList<String>();
        for (MultiURI u : obsoletes) {
            obsoleteRenamings.add(u.getPath());
        }
        Connection c = NIOAgent.getTransferManager().startConnection((Node)this.node);
        CommandRemoveObsoletes cmd = new CommandRemoveObsoletes(obsoleteRenamings);
        NIOAgent.registerOngoingCommand((Connection)c, (Command)cmd);
        c.sendCommand((Object)cmd);
        c.receive();
        c.finishConnection();
    }
}

