/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.master.utils;

import es.bsc.compss.comm.Comm;
import es.bsc.compss.nio.NIOData;
import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOParamCollection;
import es.bsc.compss.nio.NIOParamDictCollection;
import es.bsc.compss.nio.master.NIOWorkerNode;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.data.DataAccessId;
import es.bsc.compss.types.data.accessid.RAccessId;
import es.bsc.compss.types.data.accessid.RWAccessId;
import es.bsc.compss.types.data.accessid.WAccessId;
import es.bsc.compss.types.parameter.BasicTypeParameter;
import es.bsc.compss.types.parameter.CollectionParameter;
import es.bsc.compss.types.parameter.DependencyParameter;
import es.bsc.compss.types.parameter.DictCollectionParameter;
import es.bsc.compss.types.parameter.Parameter;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NIOParamFactory {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Communication");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();

    public static NIOParam fromParameter(Parameter param, NIOWorkerNode node, boolean fromReplicatedTask) {
        NIOParam np;
        switch (param.getType()) {
            case DIRECTORY_T: 
            case FILE_T: 
            case OBJECT_T: 
            case PSCO_T: 
            case STREAM_T: 
            case EXTERNAL_STREAM_T: 
            case EXTERNAL_PSCO_T: 
            case BINDING_OBJECT_T: {
                np = NIOParamFactory.buildNioDependencyParam(param, node, fromReplicatedTask);
                break;
            }
            case COLLECTION_T: {
                NIOParam collNioParam = NIOParamFactory.buildNioDependencyParam(param, node, fromReplicatedTask);
                np = NIOParamFactory.buildNioCollectionParam(param, collNioParam, node, fromReplicatedTask);
                break;
            }
            case DICT_COLLECTION_T: {
                NIOParam dictCollNioParam = NIOParamFactory.buildNioDependencyParam(param, node, fromReplicatedTask);
                np = NIOParamFactory.buildNioDictCollectionParam(param, dictCollNioParam, node, fromReplicatedTask);
                break;
            }
            default: {
                np = NIOParamFactory.buildNioBasicParam(param);
            }
        }
        return np;
    }

    private static NIOParam buildNioDependencyParam(Parameter param, NIOWorkerNode node, boolean fromReplicatedTask) {
        String pscoId;
        String dataMgmtId;
        DependencyParameter dPar = (DependencyParameter)param;
        String value = dPar.getDataTarget();
        String renaming = null;
        DataAccessId dAccId = dPar.getDataAccessId();
        boolean preserveSourceData = fromReplicatedTask;
        if (dAccId instanceof RWAccessId) {
            RWAccessId rwaId = (RWAccessId)dAccId;
            renaming = rwaId.getReadDataInstance().getRenaming();
            dataMgmtId = rwaId.getWrittenDataInstance().getRenaming();
            if (!fromReplicatedTask) {
                preserveSourceData = dPar.isSourcePreserved();
            }
        } else if (dAccId instanceof RAccessId) {
            RAccessId raId = (RAccessId)dAccId;
            dataMgmtId = renaming = raId.getReadDataInstance().getRenaming();
            if (!fromReplicatedTask) {
                preserveSourceData = dPar.isSourcePreserved();
            }
        } else {
            WAccessId waId = (WAccessId)dAccId;
            dataMgmtId = waId.getWrittenDataInstance().getRenaming();
            preserveSourceData = dPar.isSourcePreserved();
        }
        if (renaming != null && (pscoId = Comm.getData((String)renaming).getPscoId()) != null) {
            if (param.getType().equals((Object)DataType.OBJECT_T)) {
                param.setType(DataType.PSCO_T);
            } else if (param.getType().equals((Object)DataType.FILE_T)) {
                param.setType(DataType.EXTERNAL_PSCO_T);
            }
        }
        if ((dAccId instanceof RWAccessId || dAccId instanceof WAccessId) && !param.getType().equals((Object)DataType.PSCO_T) && !param.getType().equals((Object)DataType.EXTERNAL_PSCO_T)) {
            value = node.getOutputDataTarget(dataMgmtId, dPar);
        }
        boolean writeFinalValue = !(dAccId instanceof RAccessId);
        NIOParam np = new NIOParam(dataMgmtId, param.getType(), param.getStream(), param.getPrefix(), param.getName(), param.getContentType(), param.getWeight(), param.isKeepRename(), preserveSourceData, writeFinalValue, (Object)value, (NIOData)dPar.getDataSource(), dPar.getOriginalName());
        return np;
    }

    private static NIOParam buildNioCollectionParam(Parameter param, NIOParam collNioParam, NIOWorkerNode node, boolean fromReplicatedTask) {
        if (DEBUG) {
            LOGGER.debug("Detected COLLECTION_T parameter");
        }
        NIOParamCollection npc = new NIOParamCollection(collNioParam);
        CollectionParameter collParam = (CollectionParameter)param;
        for (Parameter subParam : collParam.getParameters()) {
            npc.addParameter(NIOParamFactory.fromParameter(subParam, node, fromReplicatedTask));
        }
        if (DEBUG) {
            LOGGER.debug("NIOParamCollection with id = " + npc.getDataMgmtId() + " contains " + npc.getSize() + " parameters.");
        }
        return npc;
    }

    private static NIOParam buildNioDictCollectionParam(Parameter param, NIOParam dictCollNioParam, NIOWorkerNode node, boolean fromReplicatedTask) {
        if (DEBUG) {
            LOGGER.debug("Detected DICT_COLLECTION_T parameter");
        }
        NIOParamDictCollection npdc = new NIOParamDictCollection(dictCollNioParam);
        DictCollectionParameter dictCollParam = (DictCollectionParameter)param;
        for (Map.Entry entry : dictCollParam.getParameters().entrySet()) {
            npdc.addParameter(NIOParamFactory.fromParameter((Parameter)entry.getKey(), node, fromReplicatedTask), NIOParamFactory.fromParameter((Parameter)entry.getValue(), node, fromReplicatedTask));
        }
        if (DEBUG) {
            LOGGER.debug("NIOParamDictCollection with id = " + npdc.getDataMgmtId() + " contains " + npdc.getSize() + " parameters.");
        }
        return npdc;
    }

    private static NIOParam buildNioBasicParam(Parameter param) {
        BasicTypeParameter btParB = (BasicTypeParameter)param;
        Object value = btParB.getValue();
        boolean preserveSourceData = false;
        boolean writeFinalValue = false;
        NIOParam np = new NIOParam(null, param.getType(), param.getStream(), param.getPrefix(), param.getName(), param.getContentType(), param.getWeight(), param.isKeepRename(), preserveSourceData, writeFinalValue, value, null, "NO_NAME");
        return np;
    }
}

