/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.master;

import es.bsc.comm.Connection;
import es.bsc.comm.Node;
import es.bsc.comm.nio.NIONode;
import es.bsc.compss.exceptions.InitNodeException;
import es.bsc.compss.nio.NIOAgent;
import es.bsc.compss.nio.NIOTracer;
import es.bsc.compss.nio.commands.Command;
import es.bsc.compss.nio.commands.CommandCheckWorker;
import es.bsc.compss.nio.master.NIOAdaptor;
import es.bsc.compss.nio.master.NIOStarterCommand;
import es.bsc.compss.nio.master.NIOWorkerNode;
import es.bsc.compss.nio.master.handlers.Ender;
import es.bsc.compss.nio.master.handlers.ProcessOut;
import es.bsc.compss.types.COMPSsNode;
import es.bsc.compss.util.Tracer;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Map;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorkerStarter {
    private static final Logger LOGGER = LogManager.getLogger((String)"es.bsc.compss.Communication");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();
    private static final String DEPLOYMENT_ID = System.getProperty("compss.uuid");
    private static final String CLEAN_SCRIPT_PATH = "Runtime" + File.separator + "scripts" + File.separator + "system" + File.separator + "adaptors" + File.separator + "nio" + File.separator;
    private static final String CLEAN_SCRIPT_NAME = "persistent_worker_clean.sh";
    private static final long START_WORKER_INITIAL_WAIT = 100L;
    private static final long WAIT_TIME_UNIT = 500L;
    private static final long MAX_WAIT_FOR_SSH = 160000L;
    private static final long MAX_WAIT_FOR_INIT = 20000L;
    private static final String ERROR_SHUTTING_DOWN_RETRY = "ERROR: Cannot shutdown failed worker PID process";
    private static final Map<String, WorkerStarter> ADDRESS_TO_WORKER_STARTER = new TreeMap<String, WorkerStarter>();
    private boolean workerIsReady = false;
    private boolean toStop = false;
    private final NIOWorkerNode nw;

    public WorkerStarter(NIOWorkerNode nw) {
        this.nw = nw;
    }

    public static WorkerStarter getWorkerStarter(String address) {
        return ADDRESS_TO_WORKER_STARTER.get(address);
    }

    public void setWorkerIsReady() {
        LOGGER.debug("[WorkerStarter] Worker " + this.nw.getName() + " set to ready.");
        this.workerIsReady = true;
    }

    public void setToStop() {
        this.toStop = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NIONode startWorker() throws InitNodeException {
        String name = this.nw.getName();
        String user = this.nw.getUser();
        int minPort = this.nw.getConfiguration().getMinPort();
        int maxPort = this.nw.getConfiguration().getMaxPort();
        String masterName = COMPSsNode.getMasterName();
        Map<String, WorkerStarter> map = ADDRESS_TO_WORKER_STARTER;
        synchronized (map) {
            ADDRESS_TO_WORKER_STARTER.put(name, this);
            LOGGER.debug("[WorkerStarter] Worker starter for " + name + " registers in the hashmap");
        }
        NIONode n = null;
        int pid = -1;
        for (int port = minPort; port <= maxPort && !this.toStop; ++port) {
            this.killPreviousWorker(user, name, pid);
            n = new NIONode(name, port);
            pid = this.startWorker(user, name, port, masterName);
            LOGGER.info("[WorkerStarter] Worker process started. Checking connectivity...");
            this.checkWorker(n, name);
            LOGGER.debug("[WorkerStarter] Retries for " + name + " have finished.");
            if (!this.workerIsReady) {
                continue;
            }
            try {
                Runtime.getRuntime().addShutdownHook(new Ender(this, this.nw, pid));
            }
            catch (IllegalStateException e) {
                LOGGER.warn("Tried to shutdown vm while it was already being shutdown", (Throwable)e);
            }
            return n;
        }
        if (this.toStop) {
            String msg = "[STOP]: Worker " + name + " stopped during creation because application is stopped";
            LOGGER.warn(msg);
            this.killPreviousWorker(user, name, pid);
            throw new InitNodeException(msg);
        }
        if (!this.workerIsReady) {
            String msg = "[TIMEOUT]: Could not start the NIO worker on resource " + name + " through user " + user + ".";
            LOGGER.warn(msg);
            this.killPreviousWorker(user, name, pid);
            throw new InitNodeException(msg);
        }
        String msg = "[UNKNOWN]: Could not start the NIO worker on resource " + name + " through user " + user + ".";
        LOGGER.warn(msg);
        this.killPreviousWorker(user, name, pid);
        throw new InitNodeException(msg);
    }

    private int startWorker(String user, String name, int port, String masterName) throws InitNodeException {
        try {
            Thread.sleep(100L);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
        long timer = 100L;
        int pid = -1;
        String tracingHostId = "NoTracinghostID";
        if (Tracer.extraeEnabled()) {
            tracingHostId = String.valueOf(NIOTracer.registerHost((String)this.nw.getName(), (int)0));
        }
        String[] command = this.generateStartCommand(port, masterName, tracingHostId);
        do {
            boolean error = false;
            ProcessOut po = this.executeCommand(user, name, command);
            if (po == null) {
                LOGGER.debug("Worker process started in resource " + name + " by queue system.");
                pid = 0;
            } else if (po.getExitValue() == 0) {
                String output = po.getOutput();
                try {
                    if (output.isEmpty()) {
                        throw new Exception("Output is empty.");
                    }
                    String[] lines = output.split("\n");
                    pid = Integer.parseInt(lines[lines.length - 1]);
                }
                catch (Exception e) {
                    LOGGER.warn("Incorrect Worker starter response: " + e.getMessage());
                    pid = -1;
                    error = true;
                }
            } else {
                error = true;
            }
            if (error) {
                if (timer > 160000L) {
                    throw new InitNodeException("[START_CMD_ERROR]: Could not start the NIO worker in resource " + name + " through user " + user + ".\nOUTPUT:" + po.getOutput() + "\nERROR:" + po.getError() + "\n");
                }
                LOGGER.warn(" Worker process failed to start in resource " + name + ". Retrying...");
            }
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            timer += 2000L;
        } while (pid < 0 && !this.toStop);
        return pid;
    }

    private void killPreviousWorker(String user, String name, int pid) throws InitNodeException {
        if (pid != -1) {
            String[] command = this.getStopCommand(pid);
            ProcessOut po = this.executeCommand(user, name, command);
            if (po == null) {
                LOGGER.error("[START_CMD_ERROR]: An Error has occurred when queue system started NIO worker in resource " + name + ". Retries not available in this option.");
                throw new InitNodeException("[START_CMD_ERROR]: An Error has occurred when queue system started NIO worker in resource " + name + ". Retries not available in this option.");
            }
            if (po.getExitValue() != 0) {
                LOGGER.error(ERROR_SHUTTING_DOWN_RETRY);
            }
        }
    }

    private void checkWorker(NIONode n, String name) {
        long delay = 500L;
        long totalWait = 0L;
        CommandCheckWorker cmd = new CommandCheckWorker(DEPLOYMENT_ID, name);
        do {
            if (DEBUG) {
                LOGGER.debug("[WorkerStarter] Sending check command to worker " + name);
            }
            Connection c = NIOAdaptor.getTransferManager().startConnection((Node)n);
            NIOAgent.registerOngoingCommand((Connection)c, (Command)cmd);
            c.sendCommand((Object)cmd);
            c.receive();
            c.finishConnection();
            try {
                LOGGER.debug("[WorkerStarter] Waiting to send next check worker command with delay " + delay);
                Thread.sleep(delay);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            long l = delay = delay < 3900L ? delay * 2L : 4000L;
        } while (!this.workerIsReady && (totalWait += delay) < 20000L && !this.toStop);
    }

    private String[] generateStartCommand(int workerPort, String masterName, String hostId) throws InitNodeException {
        String workingDir = this.nw.getWorkingDir();
        String installDir = this.nw.getInstallDir();
        String appDir = this.nw.getAppDir();
        String classpathFromFile = this.nw.getClasspath();
        String pythonpathFromFile = this.nw.getPythonpath();
        String libPathFromFile = this.nw.getLibPath();
        String envScriptPathFromFile = this.nw.getEnvScriptPaht();
        String workerName = this.nw.getName();
        int totalCPU = this.nw.getTotalComputingUnits();
        int totalGPU = this.nw.getTotalGPUs();
        int totalFPGA = this.nw.getTotalFPGAs();
        int limitOfTasks = this.nw.getLimitOfTasks();
        try {
            return new NIOStarterCommand(workerName, workerPort, masterName, workingDir, installDir, appDir, classpathFromFile, pythonpathFromFile, libPathFromFile, envScriptPathFromFile, totalCPU, totalGPU, totalFPGA, limitOfTasks, hostId).getStartCommand();
        }
        catch (Exception e) {
            throw new InitNodeException(e);
        }
    }

    private String[] getCleanWorkerWorkingDir(String workingDir) {
        String[] cmd = new String[]{"rm", "-rf", workingDir};
        return cmd;
    }

    private String[] getStopCommand(int pid) {
        String[] cmd = new String[2];
        String installDir = this.nw.getInstallDir();
        cmd[0] = installDir + (installDir.endsWith(File.separator) ? "" : File.separator) + CLEAN_SCRIPT_PATH + CLEAN_SCRIPT_NAME;
        cmd[1] = String.valueOf(pid);
        return cmd;
    }

    private ProcessOut executeCommand(String user, String resource, String[] command) {
        ProcessOut processOut = new ProcessOut();
        String[] cmd = this.nw.getConfiguration().getRemoteExecutionCommand(user, resource, command);
        if (cmd == null) {
            LOGGER.warn("Worker configured to be sarted by queue system.");
            return null;
        }
        StringBuilder sb = new StringBuilder("");
        for (String param : cmd) {
            sb.append(param).append(" ");
        }
        LOGGER.debug("COMM CMD: " + sb.toString());
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder(new String[0]);
            pb.environment().remove("LD_PRELOAD");
            pb.command(cmd);
            Process process = pb.start();
            InputStream stderr = process.getErrorStream();
            InputStream stdout = process.getInputStream();
            process.getOutputStream().close();
            process.waitFor();
            processOut.setExitValue(process.exitValue());
            BufferedReader reader = new BufferedReader(new InputStreamReader(stdout));
            while ((line = reader.readLine()) != null) {
                processOut.appendOutput(line);
                LOGGER.debug("COMM CMD OUT: " + line);
            }
            reader = new BufferedReader(new InputStreamReader(stderr));
            while ((line = reader.readLine()) != null) {
                processOut.appendError(line);
                LOGGER.debug("COMM CMD ERR: " + line);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception initializing worker ", (Throwable)e);
        }
        return processOut;
    }

    public void ender(NIOWorkerNode node, int pid) {
        if (pid > 0) {
            String user = node.getUser();
            String jvmWorkerOpts = System.getProperty("compss.worker.jvm_opts");
            String removeWDFlagDisabled = "compss.worker.removeWD=false";
            if (jvmWorkerOpts != null && jvmWorkerOpts.contains(removeWDFlagDisabled)) {
                LOGGER.warn("RemoveWD set to false. Not Cleaning " + node.getName() + " working directory");
            } else {
                String sandboxWorkingDir = node.getWorkingDir();
                String[] command = this.getCleanWorkerWorkingDir(sandboxWorkingDir);
                if (command != null) {
                    this.executeCommand(user, node.getName(), command);
                }
            }
            String[] command = this.getStopCommand(pid);
            LOGGER.info("getStopCommand generated this: " + command);
            if (command != null) {
                this.executeCommand(user, node.getName(), command);
            }
        }
    }
}

