/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm.nio;

import es.bsc.comm.CommProperties;
import es.bsc.comm.Node;
import es.bsc.comm.nio.NIOConnection;
import es.bsc.comm.nio.NIOEventManager;
import es.bsc.comm.nio.NIONode;
import es.bsc.comm.nio.NIOServerConnection;
import es.bsc.comm.nio.event.ClosedChannelEvent;
import es.bsc.comm.nio.event.ConnectionEstablished;
import es.bsc.comm.nio.event.EmptyBufferEvent;
import es.bsc.comm.nio.event.ErrorEvent;
import es.bsc.comm.nio.event.LowBufferEvent;
import es.bsc.comm.nio.event.PacketEntry;
import es.bsc.comm.nio.exceptions.NIOException;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.ByteBuffer;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.spi.SelectorProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NIOListener
extends Thread {
    private static final Logger LOGGER = LogManager.getLogger("Communication.NIO.Listener");
    private static final String DEFAULT_ADDRESS_IP = "127.0.0.1";
    private static final long SELECTOR_SLEEP = 1000L;
    private static final int BACK_LOG = 7000;
    private static final List<ChangeRequest> PENDING_CHANGES = new LinkedList<ChangeRequest>();
    private static final Set<SocketChannel> OPEN_CHANNELS = new HashSet<SocketChannel>();
    private static final Map<SocketChannel, ChangeRequest> PENDING_INTEREST = new HashMap<SocketChannel, ChangeRequest>();
    private static final Map<Integer, ServerSocketChannel> SERVERS = new HashMap<Integer, ServerSocketChannel>();
    private static boolean stop = false;
    private static Selector selector;
    private static NIOEventManager eventManager;
    private static NIOConnection closingConnection;

    public NIOListener() {
        Thread.currentThread().setName("NIO Listener");
    }

    public static void init(NIOEventManager nem) throws NIOException {
        try {
            selector = SelectorProvider.provider().openSelector();
        }
        catch (IOException e) {
            throw new NIOException(NIOException.SpecificErrorType.LOADING_LISTENER, (Exception)e);
        }
        eventManager = nem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startServer(Node n) throws NIOException {
        NIONode nn = (NIONode)n;
        String ip = nn.getIp();
        int port = nn.getPort();
        try {
            ServerSocketChannel ssc = ServerSocketChannel.open();
            SERVERS.put(port, ssc);
            ssc.configureBlocking(false);
            ssc.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            InetSocketAddress inet = ip == null ? new InetSocketAddress(port) : new InetSocketAddress(ip, port);
            ssc.socket().bind(inet, 7000);
            ChangeRequest cr = new ChangeRequest(null, ssc, 16, false);
            List<ChangeRequest> list = PENDING_CHANGES;
            synchronized (list) {
                PENDING_CHANGES.add(cr);
                selector.wakeup();
            }
        }
        catch (IOException e) {
            LOGGER.error("Exception starting server", (Throwable)e);
            throw new NIOException(NIOException.SpecificErrorType.STARTING_SERVER, (Exception)e);
        }
    }

    public void closeServers() {
        try {
            for (ServerSocketChannel ssc : SERVERS.values()) {
                ssc.close();
            }
        }
        catch (IOException e) {
            LOGGER.error("Error closing server connection", (Throwable)e);
        }
    }

    public void closeConnections() {
        NIOConnection.abortPendingConnections();
        for (SocketChannel sc : OPEN_CHANNELS.toArray(new SocketChannel[0])) {
            if (closingConnection != null && closingConnection.getSocket() == sc) continue;
            if (sc.isConnected()) {
                LOGGER.debug("Close channel " + sc.hashCode() + " from closeConnections");
            } else {
                LOGGER.warn("Channel " + sc.hashCode() + " is not connected");
            }
            SelectionKey key = sc.keyFor(selector);
            this.closeChannel(key, sc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeSocket(NIOConnection nc, SocketChannel sc) {
        ChangeRequest cr = new ChangeRequest(nc, sc, 0, true);
        List<ChangeRequest> list = PENDING_CHANGES;
        synchronized (list) {
            PENDING_CHANGES.add(cr);
            selector.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void changeInterest(NIOConnection nc, SocketChannel sc, int interest) {
        ChangeRequest cr = new ChangeRequest(nc, sc, interest, false);
        List<ChangeRequest> list = PENDING_CHANGES;
        synchronized (list) {
            PENDING_CHANGES.add(cr);
            selector.wakeup();
        }
    }

    @Override
    public void run() {
        LOGGER.info("NIO Listener started");
        while (!stop) {
            try {
                this.applyInterestChanges();
                selector.select(1000L);
                this.processKeys(selector.selectedKeys().iterator());
            }
            catch (IOException e) {
                LOGGER.error("Error listening on connection changes", (Throwable)e);
            }
        }
        LOGGER.info("Closing all connections " + (closingConnection != null ? "but " + closingConnection : ""));
        this.closeServers();
        this.closeConnections();
        while (!OPEN_CHANNELS.isEmpty()) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Waiting for closing connection changes");
                StringBuilder sb = new StringBuilder("Alive channels: ");
                for (SocketChannel s : OPEN_CHANNELS) {
                    sb.append(s.hashCode()).append(" ");
                }
                LOGGER.debug(sb.toString());
            }
            try {
                this.applyInterestChanges();
                selector.select(1000L);
                this.processKeys(selector.selectedKeys().iterator());
            }
            catch (IOException e) {
                LOGGER.debug("Error listening on closing connection changes", (Throwable)e);
            }
        }
        LOGGER.debug("Notifying closure to Event Manager");
        eventManager.listennerStopped();
        LOGGER.info("NIO Listener stopped");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyInterestChanges() throws IOException {
        List<ChangeRequest> list = PENDING_CHANGES;
        synchronized (list) {
            Iterator<ChangeRequest> changes = PENDING_CHANGES.iterator();
            while (changes.hasNext()) {
                try {
                    SelectionKey key;
                    SocketChannel sc;
                    ChangeRequest change = changes.next();
                    if (change.close) {
                        sc = (SocketChannel)change.channel;
                        key = sc.keyFor(selector);
                        LOGGER.debug("Closing channel " + sc.hashCode() + " no more data to write");
                        this.closeChannel(key, sc);
                        continue;
                    }
                    if (change.type != 16) {
                        sc = (SocketChannel)change.channel;
                        if (!sc.isConnected() && change.type != 8) {
                            PENDING_INTEREST.put(sc, change);
                            continue;
                        }
                        key = ((SelectableChannel)change.channel).register(selector, change.type);
                        key.attach(change.connection);
                        if (change.type != 4) continue;
                        sc.setOption((SocketOption)StandardSocketOptions.SO_SNDBUF, (Object)CommProperties.getNetworkBufferSize());
                        continue;
                    }
                    SelectionKey key2 = ((SelectableChannel)change.channel).register(selector, change.type);
                    key2.attach(change.connection);
                }
                catch (ClosedChannelException e) {
                    LOGGER.error("Exception closing channel ", (Throwable)e);
                }
            }
            PENDING_CHANGES.clear();
        }
    }

    private void processKeys(Iterator<SelectionKey> selectedKeys) {
        while (selectedKeys.hasNext()) {
            SelectionKey key = selectedKeys.next();
            selectedKeys.remove();
            if (!key.isValid()) continue;
            if (key.isAcceptable()) {
                this.accept(key);
                continue;
            }
            if (key.isConnectable()) {
                this.connect(key);
                continue;
            }
            if (key.isReadable()) {
                this.read(key);
                continue;
            }
            if (!key.isWritable()) continue;
            this.write(key);
        }
    }

    public static void shutdown(NIOConnection connection) {
        closingConnection = connection;
        stop = true;
        selector.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NIOConnection startConnection(Node targetNode) {
        NIONode n = (NIONode)targetNode;
        SocketChannel sc = null;
        NIOConnection nc = null;
        try {
            sc = SocketChannel.open();
            sc.configureBlocking(false);
            sc.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            sc.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
            if (n.getIp() == null) {
                sc.connect(new InetSocketAddress(DEFAULT_ADDRESS_IP, n.getPort()));
            } else {
                sc.connect(new InetSocketAddress(n.getIp(), n.getPort()));
            }
            nc = new NIOConnection(eventManager, sc, n);
            ChangeRequest cr = new ChangeRequest(nc, sc, 8, false);
            List<ChangeRequest> list = PENDING_CHANGES;
            synchronized (list) {
                PENDING_CHANGES.add(cr);
                selector.wakeup();
            }
        }
        catch (IOException e) {
            LOGGER.error("Error starting connection", (Throwable)e);
            NIOException ne = new NIOException(NIOException.SpecificErrorType.STARTING_CONNECTION, (Exception)e);
            nc = new NIOConnection(eventManager, null, n);
            eventManager.addEvent(new ErrorEvent(nc, ne));
        }
        return nc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restartConnection(NIOConnection nc, NIONode targetNode) {
        try {
            SocketChannel sc = SocketChannel.open();
            sc.configureBlocking(false);
            sc.setOption((SocketOption)StandardSocketOptions.SO_REUSEADDR, (Object)true);
            sc.setOption((SocketOption)StandardSocketOptions.SO_KEEPALIVE, (Object)true);
            if (targetNode.getIp() == null) {
                sc.connect(new InetSocketAddress(DEFAULT_ADDRESS_IP, targetNode.getPort()));
            } else {
                sc.connect(new InetSocketAddress(targetNode.getIp(), targetNode.getPort()));
            }
            nc.replaceChannel(sc);
            ChangeRequest cr = new ChangeRequest(nc, sc, 8, false);
            List<ChangeRequest> list = PENDING_CHANGES;
            synchronized (list) {
                PENDING_CHANGES.add(cr);
                selector.wakeup();
            }
        }
        catch (IOException e) {
            NIOException ne = new NIOException(NIOException.SpecificErrorType.RESTARTING_CONNECTION, (Exception)e);
            eventManager.addEvent(new ErrorEvent(nc, ne));
        }
    }

    private void accept(SelectionKey key) {
        try {
            ServerSocketChannel ssc = (ServerSocketChannel)key.channel();
            SocketChannel sc = ssc.accept();
            sc.configureBlocking(false);
            OPEN_CHANNELS.add(sc);
            String address = sc.socket().getInetAddress().getHostAddress();
            int port = sc.socket().getPort();
            NIONode n = new NIONode(address, port);
            NIOServerConnection nc = new NIOServerConnection(eventManager, sc, n);
            NIOListener.changeInterest(nc, sc, 1);
            eventManager.addEvent(new ConnectionEstablished(nc));
        }
        catch (IOException e) {
            NIOException ne = new NIOException(NIOException.SpecificErrorType.ACCEPTING_CONNECTION, (Exception)e);
            eventManager.addEvent(new ErrorEvent(ne));
        }
    }

    private void connect(SelectionKey key) {
        SocketChannel sc = (SocketChannel)key.channel();
        OPEN_CHANNELS.add(sc);
        NIOConnection nc = (NIOConnection)key.attachment();
        try {
            if (sc.finishConnect()) {
                this.acceptedConnection(nc, sc);
            } else {
                this.refusedConnection(nc, sc, null);
                key.cancel();
            }
        }
        catch (IOException e) {
            this.refusedConnection(nc, sc, e);
            key.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptedConnection(NIOConnection nc, SocketChannel sc) {
        eventManager.addEvent(new ConnectionEstablished(nc));
        List<ChangeRequest> list = PENDING_CHANGES;
        synchronized (list) {
            ChangeRequest cr = PENDING_INTEREST.get(sc);
            if (cr != null) {
                PENDING_CHANGES.add(cr);
            } else if (PENDING_CHANGES.isEmpty()) {
                cr = new ChangeRequest(nc, sc, 1, false);
                PENDING_CHANGES.add(cr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refusedConnection(NIOConnection nc, SocketChannel sc, Exception e) {
        List<ChangeRequest> list = PENDING_CHANGES;
        synchronized (list) {
            PENDING_INTEREST.remove(sc);
        }
        NIOException ne = new NIOException(NIOException.SpecificErrorType.FINISHING_CONNECTION, e);
        eventManager.addEvent(new ErrorEvent(nc, ne));
        try {
            sc.close();
        }
        catch (IOException ee) {
            NIOException ne2 = new NIOException(NIOException.SpecificErrorType.FINISHING_CONNECTION, (Exception)ee);
            eventManager.addEvent(new ErrorEvent(nc, ne2));
        }
    }

    private void read(SelectionKey key) {
        SocketChannel sc = (SocketChannel)key.channel();
        NIOConnection nc = (NIOConnection)key.attachment();
        try {
            ByteBuffer readBuffer = ByteBuffer.allocate(CommProperties.getPacketSize());
            int size = sc.read(readBuffer);
            if (size == -1) {
                this.closeChannel(key, sc);
                return;
            }
            readBuffer.flip();
            PacketEntry p = new PacketEntry(nc, readBuffer);
            eventManager.addEvent(p);
        }
        catch (IOException ioe) {
            LOGGER.error("Exception reading key in channel " + sc.hashCode(), (Throwable)ioe);
            NIOException ne = new NIOException(NIOException.SpecificErrorType.READ, (Exception)ioe);
            eventManager.addEvent(new ErrorEvent(nc, ne));
            this.closeChannel(key, sc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(SelectionKey key) {
        ByteBuffer writeBuffer;
        LinkedList sendBuffer;
        SocketChannel sc = (SocketChannel)key.channel();
        NIOConnection nc = (NIOConnection)key.attachment();
        LinkedList linkedList = sendBuffer = (LinkedList)nc.getSendBuffer();
        synchronized (linkedList) {
            if (sendBuffer.isEmpty()) {
                if (nc.getCurrentTransfer() != null) {
                    NIOListener.changeInterest(nc, sc, 1);
                    eventManager.addEvent(new EmptyBufferEvent(nc));
                }
                return;
            }
            writeBuffer = (ByteBuffer)sendBuffer.getFirst();
        }
        if (writeBuffer != null) {
            try {
                if (writeBuffer.remaining() > 0) {
                    int written = sc.write(writeBuffer);
                    LOGGER.debug(written + " bytes written to socket " + sc.hashCode());
                }
            }
            catch (IOException e) {
                LOGGER.error("Error writting key in channel " + this.hashCode() + ". Closing Channel " + sc.hashCode(), (Throwable)e);
                NIOException ne = new NIOException(NIOException.SpecificErrorType.WRITE, (Exception)e);
                eventManager.addEvent(new ErrorEvent(nc, ne));
                this.closeChannel(key, sc);
                return;
            }
            if (writeBuffer.remaining() == 0) {
                LinkedList linkedList2 = sendBuffer;
                synchronized (linkedList2) {
                    sendBuffer.removeFirst();
                    Integer count = sendBuffer.size();
                    if (count == 0) {
                        NIOListener.changeInterest(nc, sc, 1);
                        eventManager.addEvent(new EmptyBufferEvent(nc));
                    } else if (count < CommProperties.getMinBufferedPackets()) {
                        eventManager.addEvent(new LowBufferEvent(nc));
                    }
                }
            }
        }
    }

    private void closeChannel(SelectionKey key, SocketChannel sc) {
        if (key != null) {
            key.cancel();
        }
        OPEN_CHANNELS.remove(sc);
        if (sc.isOpen()) {
            LOGGER.debug("Channel " + sc.hashCode() + "is open. Requesting closure");
            if (key != null) {
                NIOConnection nc = (NIOConnection)key.attachment();
                eventManager.addEvent(new ClosedChannelEvent(nc));
            }
            try {
                sc.close();
            }
            catch (IOException e) {
                LOGGER.error("Could not close channel " + sc, (Throwable)e);
            }
        }
    }

    private static class ChangeRequest {
        private final NIOConnection connection;
        private final Channel channel;
        private final int type;
        private final boolean close;

        public ChangeRequest(NIOConnection nc, Channel socket, int type, boolean close) {
            this.connection = nc;
            this.channel = socket;
            this.type = type;
            this.close = close;
        }
    }
}

