/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.util;

import es.bsc.compss.types.exceptions.NonInstantiableException;
import java.beans.XMLDecoder;
import java.beans.XMLEncoder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Serializer {
    private Serializer() {
        throw new NonInstantiableException("Serializer");
    }

    public static byte[] serialize(Object o) throws IOException {
        try {
            return Serializer.serializeBinary(o);
        }
        catch (NotSerializableException e) {
            return Serializer.serializeXML(o);
        }
    }

    public static void serialize(Object o, String file) throws IOException {
        try {
            Serializer.serializeBinary(o, file);
        }
        catch (NotSerializableException e) {
            Serializer.serializeXML(o, file);
        }
    }

    public static <T> T deserialize(String file) throws IOException, ClassNotFoundException {
        try {
            return Serializer.deserializeBinary(file);
        }
        catch (Exception e) {
            return Serializer.deserializeXML(file);
        }
    }

    public static <T> T deserialize(byte[] b) throws IOException, ClassNotFoundException {
        try {
            return Serializer.deserializeBinary(b);
        }
        catch (Exception e) {
            return Serializer.deserializeXML(b);
        }
    }

    private static byte[] serializeBinary(Object o) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(o);
        oos.close();
        return bos.toByteArray();
    }

    private static void serializeBinary(Object o, String file) throws IOException {
        FileOutputStream fout = new FileOutputStream(file);
        ObjectOutputStream oos = new ObjectOutputStream(fout);
        oos.writeObject(o);
        oos.close();
    }

    private static <T> T deserializeBinary(String file) throws IOException, ClassNotFoundException {
        FileInputStream fis = new FileInputStream(file);
        ObjectInputStream ois = new ObjectInputStream(fis);
        Object o = ois.readObject();
        ois.close();
        return (T)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T deserializeBinary(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        ObjectInputStream in = null;
        in = new ObjectInputStream(bis);
        Object object = in.readObject();
        return (T)object;
        finally {
            try {
                bis.close();
            }
            catch (IOException iOException) {}
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private static byte[] serializeXML(Object o) throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        XMLEncoder e = new XMLEncoder(new BufferedOutputStream(bos));
        e.writeObject(o);
        e.close();
        return bos.toByteArray();
    }

    private static void serializeXML(Object o, String file) throws IOException {
        FileOutputStream fout = new FileOutputStream(file);
        XMLEncoder e = new XMLEncoder(new BufferedOutputStream(fout));
        e.writeObject(o);
        e.close();
    }

    private static <T> T deserializeXML(String file) throws IOException {
        FileInputStream fis = new FileInputStream(file);
        XMLDecoder d = new XMLDecoder(new BufferedInputStream(fis));
        Object o = d.readObject();
        d.close();
        return (T)o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T deserializeXML(byte[] data) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        XMLDecoder d = null;
        d = new XMLDecoder(new BufferedInputStream(bis));
        Object object = d.readObject();
        return (T)object;
        finally {
            if (d != null) {
                d.close();
            }
            try {
                bis.close();
            }
            catch (IOException iOException) {}
        }
    }
}

