/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.invokers.external.piped;

import es.bsc.compss.execution.types.InvocationResources;
import es.bsc.compss.executor.external.ExternalExecutorException;
import es.bsc.compss.executor.external.commands.CloseFileExternalCommand;
import es.bsc.compss.executor.external.commands.CloseTaskGroupExternalCommand;
import es.bsc.compss.executor.external.commands.DeleteFileExternalCommand;
import es.bsc.compss.executor.external.commands.DeleteObjectExternalCommand;
import es.bsc.compss.executor.external.commands.ExecuteNestedTaskExternalCommand;
import es.bsc.compss.executor.external.commands.GetDirectoryExternalCommand;
import es.bsc.compss.executor.external.commands.GetFileExternalCommand;
import es.bsc.compss.executor.external.commands.GetObjectExternalCommand;
import es.bsc.compss.executor.external.commands.OpenFileExternalCommand;
import es.bsc.compss.executor.external.commands.OpenTaskGroupExternalCommand;
import es.bsc.compss.executor.external.piped.PipePair;
import es.bsc.compss.executor.external.piped.commands.AccessedFilePipeCommand;
import es.bsc.compss.executor.external.piped.commands.BarrierTaskGroupPipeCommand;
import es.bsc.compss.executor.external.piped.commands.CloseFilePipeCommand;
import es.bsc.compss.executor.external.piped.commands.CloseTaskGroupPipeCommand;
import es.bsc.compss.executor.external.piped.commands.CompssExceptionPipeCommand;
import es.bsc.compss.executor.external.piped.commands.DeleteFilePipeCommand;
import es.bsc.compss.executor.external.piped.commands.DeleteObjectPipeCommand;
import es.bsc.compss.executor.external.piped.commands.EndTaskPipeCommand;
import es.bsc.compss.executor.external.piped.commands.ExecuteNestedTaskPipeCommand;
import es.bsc.compss.executor.external.piped.commands.GetDirectoryPipeCommand;
import es.bsc.compss.executor.external.piped.commands.GetFilePipeCommand;
import es.bsc.compss.executor.external.piped.commands.GetObjectPipeCommand;
import es.bsc.compss.executor.external.piped.commands.NewBarrierPipeCommand;
import es.bsc.compss.executor.external.piped.commands.OpenFilePipeCommand;
import es.bsc.compss.executor.external.piped.commands.OpenTaskGroupPipeCommand;
import es.bsc.compss.executor.external.piped.commands.PipeCommand;
import es.bsc.compss.executor.external.piped.commands.RegisterCEPipeCommand;
import es.bsc.compss.executor.external.piped.commands.SynchPipeCommand;
import es.bsc.compss.executor.types.ExternalTaskStatus;
import es.bsc.compss.invokers.external.ExternalInvoker;
import es.bsc.compss.invokers.types.TypeValuePair;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.Direction;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.InvocationParamCollection;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.worker.COMPSsException;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class PipedInvoker
extends ExternalInvoker {
    private final PipePair pipes;
    private Long appId;

    public PipedInvoker(InvocationContext context, Invocation invocation, File taskSandboxWorkingDir, InvocationResources assignedResources, PipePair pipes) throws JobExecutionException {
        super(context, invocation, taskSandboxWorkingDir, assignedResources);
        super.appendOtherExecutionCommandArguments();
        this.pipes = pipes;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void invokeMethod() throws JobExecutionException, COMPSsException {
        this.appId = null;
        int jobId = this.invocation.getJobId();
        if (!this.pipes.sendCommand((PipeCommand)((Object)this.command))) {
            LOGGER.error("ERROR: Could not execute job " + jobId + " because cannot write in pipe");
            throw new JobExecutionException("Job " + jobId + " has failed. Cannot write in pipe");
        }
        try {
            block24: while (true) {
                PipeCommand rcvdCommand;
                if ((rcvdCommand = this.pipes.readCommand()) == null) {
                    continue;
                }
                switch (rcvdCommand.getType()) {
                    case REGISTER_CE: {
                        RegisterCEPipeCommand rcpc = (RegisterCEPipeCommand)rcvdCommand;
                        String ceSignature = rcpc.getCESignature();
                        String implSignature = rcpc.getImplSignature();
                        String string = rcpc.getConstraints();
                        String string2 = rcpc.getImplType();
                        String implIO = rcpc.getImplIO();
                        String[] implTypeArgs = rcpc.getTypeArgs();
                        this.context.getRuntimeAPI().registerCoreElement(ceSignature, implSignature, string, string2, implIO, implTypeArgs);
                        continue block24;
                    }
                    case EXECUTE_NESTED_TASK: {
                        ExecuteNestedTaskPipeCommand entpc = (ExecuteNestedTaskPipeCommand)rcvdCommand;
                        ExecuteNestedTaskExternalCommand.EntryPoint entryPoint = entpc.getEntryPoint();
                        String onFailure = entpc.getOnFailure();
                        int n = entpc.getTimeOut();
                        boolean bl = entpc.getPrioritary();
                        boolean hasTarget = entpc.hasTarget();
                        int numReturns = entpc.getNumReturns();
                        int parameterCount = entpc.getParameterCount();
                        Object[] parameters = entpc.getParameters();
                        if (this.appId == null) {
                            this.appId = this.context.getRuntimeAPI().registerApplication(null, this);
                        }
                        int numNodes = entpc.getNumNodes();
                        boolean isReduce = entpc.isReduce();
                        int reduceChunkSize = entpc.getReduceChunkSize();
                        boolean isReplicated = entpc.isReplicated();
                        boolean isDistributed = entpc.isDistributed();
                        if (entryPoint == ExecuteNestedTaskExternalCommand.EntryPoint.SIGNATURE) {
                            String signature = entpc.getSignature();
                            this.context.getRuntimeAPI().executeTask(this.appId, signature, onFailure, n, bl, numNodes, isReduce, reduceChunkSize, isReplicated, isDistributed, hasTarget, numReturns, parameterCount, parameters);
                            continue block24;
                        }
                        String methodClass = entpc.getMethodClass();
                        String methodName = entpc.getMethodName();
                        this.context.getRuntimeAPI().executeTask(this.appId, methodClass, onFailure, n, methodName, bl, numNodes, isReduce, reduceChunkSize, isReplicated, isDistributed, hasTarget, (Integer)numReturns, parameterCount, parameters);
                        continue block24;
                    }
                    case ACCESSED_FILE: {
                        AccessedFilePipeCommand afpc = (AccessedFilePipeCommand)rcvdCommand;
                        String file = afpc.getFile();
                        if (this.appId == null) {
                            this.pipes.sendCommand(new SynchPipeCommand("0"));
                            continue block24;
                        }
                        boolean accessed = this.context.getRuntimeAPI().isFileAccessed(this.appId, file);
                        this.pipes.sendCommand(new SynchPipeCommand(accessed ? "1" : "0"));
                        continue block24;
                    }
                    case OPEN_FILE: {
                        PipeCommand ofpc = (OpenFilePipeCommand)rcvdCommand;
                        String file = ((OpenFileExternalCommand)((Object)ofpc)).getFile();
                        Direction dir = ((OpenFileExternalCommand)((Object)ofpc)).getDirection();
                        if (this.appId == null) {
                            this.pipes.sendCommand(new SynchPipeCommand(file));
                            continue block24;
                        }
                        String string = this.context.getRuntimeAPI().openFile(this.appId, file, dir);
                        this.pipes.sendCommand(new SynchPipeCommand(string));
                        continue block24;
                    }
                    case CLOSE_FILE: {
                        PipeCommand ofpc = (CloseFilePipeCommand)rcvdCommand;
                        String file = ((CloseFileExternalCommand)((Object)ofpc)).getFile();
                        Direction dir = ((CloseFileExternalCommand)((Object)ofpc)).getDirection();
                        if (this.appId == null) continue block24;
                        this.context.getRuntimeAPI().closeFile(this.appId, file, dir);
                        continue block24;
                    }
                    case DELETE_FILE: {
                        PipeCommand ofpc = (DeleteFilePipeCommand)rcvdCommand;
                        String file = ((DeleteFileExternalCommand)((Object)ofpc)).getFile();
                        boolean val = this.context.getRuntimeAPI().deleteFile(this.appId, file);
                        this.pipes.sendCommand(new SynchPipeCommand(val ? "1" : "0"));
                        continue block24;
                    }
                    case GET_FILE: {
                        PipeCommand gfpc = (GetFilePipeCommand)rcvdCommand;
                        String file = ((GetFileExternalCommand)((Object)gfpc)).getFile();
                        System.out.println("PIPEDINVOKER Getting file" + file);
                        if (this.appId != null) {
                            System.out.println("PIPEDINVOKER Getting file" + file + " Invoking Runtime");
                            this.context.getRuntimeAPI().getFile(this.appId, file);
                        }
                        System.out.println("PIPEDINVOKER Getting file" + file + " Sending SYNCH");
                        this.pipes.sendCommand(new SynchPipeCommand());
                        continue block24;
                    }
                    case GET_DIRECTORY: {
                        PipeCommand gfpc = (GetDirectoryPipeCommand)rcvdCommand;
                        String file = ((GetDirectoryExternalCommand)((Object)gfpc)).getDirectory();
                        if (this.appId != null) {
                            this.context.getRuntimeAPI().getDirectory(this.appId, file);
                        }
                        this.pipes.sendCommand(new SynchPipeCommand());
                        continue block24;
                    }
                    case GET_OBJECT: {
                        PipeCommand gfpc = (GetObjectPipeCommand)rcvdCommand;
                        String id = ((GetObjectExternalCommand)((Object)gfpc)).getObjectId();
                        if (this.appId != null) {
                            this.context.getRuntimeAPI().getBindingObject(this.appId, id);
                        }
                        this.pipes.sendCommand(new SynchPipeCommand());
                        continue block24;
                    }
                    case DELETE_OBJECT: {
                        PipeCommand ofpc = (DeleteObjectPipeCommand)rcvdCommand;
                        String id = ((DeleteObjectExternalCommand)((Object)ofpc)).getObjectId();
                        boolean val = this.context.getRuntimeAPI().deleteFile(this.appId, id);
                        this.pipes.sendCommand(new SynchPipeCommand(val ? "1" : "0"));
                        continue block24;
                    }
                    case BARRIER: {
                        if (this.appId != null) {
                            this.context.getRuntimeAPI().barrier(this.appId);
                        }
                        this.pipes.sendCommand(new SynchPipeCommand());
                        continue block24;
                    }
                    case BARRIER_NEW: {
                        NewBarrierPipeCommand nbpc = (NewBarrierPipeCommand)rcvdCommand;
                        boolean noMoreTasks = nbpc.isNoMoreTasks();
                        if (this.appId != null) {
                            this.context.getRuntimeAPI().barrier(this.appId, noMoreTasks);
                        }
                        this.pipes.sendCommand(new SynchPipeCommand());
                        continue block24;
                    }
                    case BARRIER_GROUP: {
                        BarrierTaskGroupPipeCommand bgpc = (BarrierTaskGroupPipeCommand)rcvdCommand;
                        String groupName = bgpc.getGroupName();
                        boolean synch = true;
                        if (this.appId != null) {
                            try {
                                this.context.getRuntimeAPI().barrierGroup(this.appId, groupName);
                            }
                            catch (COMPSsException cOMPSsException) {
                                this.pipes.sendCommand(new CompssExceptionPipeCommand(null, cOMPSsException.getMessage()));
                                synch = false;
                            }
                        }
                        if (!synch) continue block24;
                        this.pipes.sendCommand(new SynchPipeCommand());
                        continue block24;
                    }
                    case OPEN_TASK_GROUP: {
                        PipeCommand otgpc = (OpenTaskGroupPipeCommand)rcvdCommand;
                        String groupName = ((OpenTaskGroupExternalCommand)((Object)otgpc)).getGroupName();
                        boolean barrier = ((OpenTaskGroupExternalCommand)((Object)otgpc)).isImplicitBarrier();
                        if (this.appId == null) {
                            this.appId = this.context.getRuntimeAPI().registerApplication(null, this);
                        }
                        this.context.getRuntimeAPI().openTaskGroup(groupName, barrier, this.appId);
                        continue block24;
                    }
                    case CLOSE_TASK_GROUP: {
                        PipeCommand otgpc = (CloseTaskGroupPipeCommand)rcvdCommand;
                        String groupName = ((CloseTaskGroupExternalCommand)((Object)otgpc)).getGroupName();
                        if (this.appId == null) continue block24;
                        this.context.getRuntimeAPI().closeTaskGroup(groupName, this.appId);
                        continue block24;
                    }
                    case NO_MORE_TASKS: {
                        if (this.appId != null) {
                            this.context.getRuntimeAPI().noMoreTasks(this.appId);
                        }
                        this.pipes.sendCommand(new SynchPipeCommand());
                        continue block24;
                    }
                    case END_TASK: {
                        ExternalTaskStatus taskStatus = ((EndTaskPipeCommand)rcvdCommand).getTaskStatus();
                        Integer exitValue = taskStatus.getExitValue();
                        if (exitValue != 0) {
                            throw new JobExecutionException("Job " + jobId + " exit with value " + exitValue);
                        }
                        LOGGER.debug("Updating parameters for job " + this.invocation.getJobId());
                        int parIdx = 0;
                        for (InvocationParam invocationParam : this.invocation.getParams()) {
                            this.updateParam(invocationParam, taskStatus, parIdx);
                            ++parIdx;
                        }
                        InvocationParam target = this.invocation.getTarget();
                        if (target != null) {
                            this.updateParam(target, taskStatus, parIdx);
                            ++parIdx;
                        }
                        Iterator<? extends InvocationParam> iterator = this.invocation.getResults().iterator();
                        while (true) {
                            if (!iterator.hasNext()) {
                                return;
                            }
                            InvocationParam invocationParam = iterator.next();
                            this.updateParam(invocationParam, taskStatus, parIdx);
                            ++parIdx;
                        }
                    }
                    case COMPSS_EXCEPTION: {
                        throw new COMPSsException(((CompssExceptionPipeCommand)rcvdCommand).getMessage());
                    }
                }
                LOGGER.warn("Unexpected tag on PipedInvoker: " + rcvdCommand + ". Skipping message");
            }
        }
        catch (ExternalExecutorException e) {
            throw new JobExecutionException("Job " + jobId + "Notification pipe closed", e);
        }
    }

    private void updateParam(InvocationParam param, ExternalTaskStatus taskStatus, int parIdx) {
        DataType paramType = taskStatus.getParameterType(parIdx);
        if (paramType != null && paramType.equals((Object)DataType.EXTERNAL_PSCO_T)) {
            param.setType(paramType);
            String value = taskStatus.getParameterValue(parIdx);
            param.setValue(value);
            if (value != null) {
                param.setValueClass(value.getClass());
            }
        } else if (paramType != null && paramType.equals((Object)DataType.COLLECTION_T)) {
            param.setType(paramType);
            InvocationParamCollection ipc = (InvocationParamCollection)param;
            LinkedList<Object> values = taskStatus.getParameterValues(parIdx);
            if (ipc.getCollectionParameters().size() == values.size()) {
                this.updateParamCollection(ipc, values);
            }
        }
    }

    private void updateParamCollection(InvocationParamCollection ipc, LinkedList<Object> values) {
        List collectionParameters = ipc.getCollectionParameters();
        int position = 0;
        for (Object element : collectionParameters) {
            TypeValuePair pair;
            InvocationParam param = (InvocationParam)element;
            DataType elementType = param.getType();
            if (elementType.equals((Object)DataType.COLLECTION_T)) {
                param.setType(elementType);
                this.updateParamCollection((InvocationParamCollection)param, (LinkedList)values.get(position));
            } else if (elementType.equals((Object)DataType.EXTERNAL_PSCO_T)) {
                param.setType(elementType);
                pair = (TypeValuePair)values.get(position);
                if (pair != null) {
                    Object value = pair.getUpdatedParameterValue();
                    param.setValue(value);
                    if (value != null) {
                        param.setValueClass(value.getClass());
                    }
                } else {
                    param.setValue(null);
                }
            } else if (elementType.equals((Object)DataType.FILE_T) && (pair = (TypeValuePair)values.get(position)) != null && pair.getUpdatedParameterValue() != null) {
                param.setType(pair.getUpdatedParameterType());
                param.setValue(pair.getUpdatedParameterValue());
                param.setValueClass(pair.getUpdatedParameterValue().getClass());
            }
            ++position;
        }
    }

    @Override
    public void cancelMethod() {
        this.pipes.getMirror().cancelJob(this.pipes);
    }
}

