/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.executor;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.execution.types.ExecutorContext;
import es.bsc.compss.execution.types.InvocationResources;
import es.bsc.compss.executor.InvocationRunner;
import es.bsc.compss.executor.external.ExecutionPlatformMirror;
import es.bsc.compss.executor.external.persistent.PersistentMirror;
import es.bsc.compss.executor.external.piped.PipePair;
import es.bsc.compss.executor.external.piped.PipedMirror;
import es.bsc.compss.invokers.Invoker;
import es.bsc.compss.invokers.JavaInvoker;
import es.bsc.compss.invokers.JavaNestedInvoker;
import es.bsc.compss.invokers.OpenCLInvoker;
import es.bsc.compss.invokers.StorageInvoker;
import es.bsc.compss.invokers.binary.BinaryInvoker;
import es.bsc.compss.invokers.binary.COMPSsInvoker;
import es.bsc.compss.invokers.binary.ContainerInvoker;
import es.bsc.compss.invokers.binary.DecafInvoker;
import es.bsc.compss.invokers.binary.MPIInvoker;
import es.bsc.compss.invokers.binary.MpmdMPIInvoker;
import es.bsc.compss.invokers.binary.OmpSsInvoker;
import es.bsc.compss.invokers.external.ExternalInvoker;
import es.bsc.compss.invokers.external.PythonMPIInvoker;
import es.bsc.compss.invokers.external.persistent.CPersistentInvoker;
import es.bsc.compss.invokers.external.piped.CInvoker;
import es.bsc.compss.invokers.external.piped.PythonInvoker;
import es.bsc.compss.invokers.util.BinaryRunner;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.execution.Execution;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.execution.InvocationContext;
import es.bsc.compss.types.execution.InvocationParam;
import es.bsc.compss.types.execution.InvocationParamCollection;
import es.bsc.compss.types.execution.InvocationParamDictCollection;
import es.bsc.compss.types.execution.exceptions.JobExecutionException;
import es.bsc.compss.types.execution.exceptions.UnsufficientAvailableResourcesException;
import es.bsc.compss.types.implementations.MethodType;
import es.bsc.compss.types.implementations.definition.BinaryDefinition;
import es.bsc.compss.types.implementations.definition.COMPSsDefinition;
import es.bsc.compss.types.implementations.definition.ContainerDefinition;
import es.bsc.compss.types.implementations.definition.DecafDefinition;
import es.bsc.compss.types.implementations.definition.MPIDefinition;
import es.bsc.compss.types.implementations.definition.MpmdMPIDefinition;
import es.bsc.compss.types.implementations.definition.OmpSsDefinition;
import es.bsc.compss.types.implementations.definition.OpenCLDefinition;
import es.bsc.compss.types.implementations.definition.PythonMPIDefinition;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.types.resources.ResourceDescription;
import es.bsc.compss.util.TraceEvent;
import es.bsc.compss.util.Tracer;
import es.bsc.compss.worker.COMPSsException;
import es.bsc.compss.worker.TimeOutTask;
import es.bsc.wdc.affinity.ThreadAffinity;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Executor
implements Runnable,
InvocationRunner {
    private static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.Executor");
    private static final boolean WORKER_DEBUG = LOGGER.isDebugEnabled();
    private static final Logger TIMER_LOGGER = LogManager.getLogger("es.bsc.compss.Timers");
    private static final String ERROR_OUT_FILES = "ERROR: One or more OUT files have not been created by task with Method Definition [";
    private static final String WARN_ATOMIC_MOVE = "WARN: AtomicMoveNotSupportedException. File cannot be atomically moved. Trying to move without atomic";
    public static final boolean IS_TIMER_COMPSS_ENABLED;
    private static final int NANO_TO_MS = 1000000;
    private final InvocationContext context;
    protected final ExecutorContext platform;
    protected final String id;
    private boolean firstTimeAffinityCPU;
    private boolean firstTimeAffinityGPU;
    protected boolean isRegistered;
    protected PipePair cPipes;
    protected PipePair pyPipes;
    protected Invocation invocation;
    protected Invoker invoker;
    protected InvocationResources resources;

    public Executor(InvocationContext context, ExecutorContext platform, String executorId) {
        LOGGER.info("Executor " + executorId + " init");
        this.context = context;
        this.platform = platform;
        this.id = executorId;
        this.isRegistered = false;
        this.firstTimeAffinityCPU = true;
        this.firstTimeAffinityGPU = true;
    }

    public void start() {
        LOGGER.info("Executor started");
    }

    @Override
    public void run() {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.EXECUTOR_COUNTS.getId(), TraceEvent.EXECUTOR_COUNTS.getType());
            Tracer.emitEvent(TraceEvent.EXECUTOR_THREAD_ID.getId(), TraceEvent.EXECUTOR_THREAD_ID.getType());
            if (Tracer.basicModeEnabled()) {
                Tracer.disablePThreads(1);
            }
        }
        this.start();
        this.processRequests();
        this.finish();
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.EXECUTOR_COUNTS.getType());
            Tracer.emitEvent(0L, TraceEvent.EXECUTOR_THREAD_ID.getType());
        }
    }

    public void finish() {
        if (Tracer.extraeEnabled()) {
            this.emitAffinityEndEvents();
        }
        LOGGER.info("Executor " + this.id + " finished");
        Collection<ExecutionPlatformMirror<?>> mirrors = this.platform.getMirrors();
        for (ExecutionPlatformMirror<?> mirror : mirrors) {
            mirror.unregisterExecutor(this.id);
        }
    }

    public String getId() {
        return this.id;
    }

    private void processRequests() {
        while (true) {
            Execution execution;
            if ((execution = this.platform.getJob()) == null) {
                LOGGER.error("ERROR: Execution is null!!!!!");
                continue;
            }
            if (execution.getInvocation() == null) break;
            this.processExecution(execution);
        }
        LOGGER.debug("Dequeued job is null.");
    }

    private void processExecution(Execution execution) {
        COMPSsException returnException;
        boolean success;
        block6: {
            this.invocation = execution.getInvocation();
            if (this.invocation == null) {
                LOGGER.error("Dequeued job is null");
                return;
            }
            if (WORKER_DEBUG) {
                LOGGER.debug("Dequeuing job " + this.invocation.getJobId());
            }
            success = false;
            returnException = null;
            try {
                this.execute();
                success = true;
            }
            catch (COMPSsException e) {
                returnException = e;
            }
            catch (Exception e) {
                Throwable rootCause = ExceptionUtils.getRootCause(e);
                if (!(rootCause instanceof COMPSsException)) break block6;
                returnException = (COMPSsException)rootCause;
            }
        }
        if (WORKER_DEBUG) {
            LOGGER.debug("Job " + this.invocation.getJobId() + " finished (success: " + success + ")");
        }
        execution.notifyEnd(returnException, success);
        this.invocation = null;
    }

    private void execute() throws Exception {
        if (this.invocation.getMethodImplementation().getMethodType() == MethodType.METHOD && this.invocation.getLang() != COMPSsConstants.Lang.JAVA && this.invocation.getLang() != COMPSsConstants.Lang.PYTHON && this.invocation.getLang() != COMPSsConstants.Lang.C) {
            String errMsg = "Incorrect language " + (Object)((Object)this.invocation.getLang()) + " in job " + this.invocation.getJobId();
            LOGGER.error(errMsg);
            this.context.getThreadErrStream().println(errMsg);
            throw new JobExecutionException("Incorrect language " + (Object)((Object)this.invocation.getLang()));
        }
        this.totalTimerAndTracingWrapperAndRun();
    }

    private void logExecutionException(Exception e) {
        LOGGER.error("ERROR: Executing task" + e.getMessage(), (Throwable)e);
        PrintStream out = this.context.getThreadOutStream();
        out.println("Exception executing task " + e.getMessage());
        PrintStream err = this.context.getThreadErrStream();
        e.printStackTrace(err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void totalTimerAndTracingWrapperAndRun() throws Exception {
        if (Tracer.extraeEnabled()) {
            this.emitingTaskStartEvents();
        }
        long timeTotalStart = 0L;
        if (IS_TIMER_COMPSS_ENABLED) {
            timeTotalStart = System.nanoTime();
        }
        try {
            this.resourcesWrapperAndRun();
        }
        finally {
            if (Tracer.extraeEnabled()) {
                this.emitTaskEndEvents();
            }
            if (IS_TIMER_COMPSS_ENABLED) {
                long timeTotalEnd = System.nanoTime();
                float timeTotalElapsed = (float)(timeTotalEnd - timeTotalStart) / 1000000.0f;
                int jobId = this.invocation.getJobId();
                TIMER_LOGGER.info("[TIMER] Total time for job " + jobId + ": " + timeTotalElapsed + " ms");
            }
        }
    }

    private void resourcesWrapperAndRun() throws Exception {
        int jobId = this.invocation.getJobId();
        if (IS_TIMER_COMPSS_ENABLED) {
            this.obtainExecutionResourcesWithTimer(jobId, this.invocation.getRequirements());
        } else {
            this.obtainExecutionResources(jobId, this.invocation.getRequirements());
        }
        try {
            this.sandBoxWrapperAndRun();
        }
        finally {
            if (IS_TIMER_COMPSS_ENABLED) {
                this.releaseResourcesWithTimer(jobId);
            } else {
                this.releaseResources(jobId);
            }
        }
    }

    private void sandBoxWrapperAndRun() throws Exception {
        TaskWorkingDir twd = IS_TIMER_COMPSS_ENABLED ? this.createTaskSandboxWithTimer() : this.createTaskSandbox();
        this.filesWrapperAndRun(twd);
        if (IS_TIMER_COMPSS_ENABLED) {
            this.cleanTaskSandboxWithTimer(twd);
        } else {
            this.cleanTaskSandbox(twd);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void filesWrapperAndRun(TaskWorkingDir twd) throws Exception {
        boolean alreadyFailed = false;
        try {
            if (IS_TIMER_COMPSS_ENABLED) {
                this.bindOriginalFilenamesToRenamesWithTimer(twd.getWorkingDir());
                this.executeTaskWithTimer(twd);
                return;
            }
            this.bindOriginalFilenamesToRenames(twd.getWorkingDir());
            this.executeTask(twd);
            return;
        }
        catch (Exception e) {
            this.logExecutionException(e);
            alreadyFailed = true;
            throw e;
        }
        finally {
            block20: {
                try {
                    if (IS_TIMER_COMPSS_ENABLED) {
                        this.unbindOriginalFileNamesToRenamesWithTimer();
                    } else {
                        this.unbindOriginalFileNamesToRenames();
                    }
                }
                catch (Exception ex) {
                    if (alreadyFailed) {
                        LOGGER.warn("Another exception after unbinding files: " + ex.getMessage(), (Throwable)ex);
                        PrintStream out = this.context.getThreadOutStream();
                        out.println("Another exception unbinding files: " + ex.getMessage());
                        PrintStream err = this.context.getThreadErrStream();
                        ex.printStackTrace(err);
                        break block20;
                    }
                    this.logExecutionException(ex);
                    throw ex;
                }
                finally {
                    if (IS_TIMER_COMPSS_ENABLED) {
                        this.checkJobFilesWithTimer(this.invocation);
                    } else {
                        this.checkJobFiles(this.invocation);
                    }
                }
            }
        }
    }

    private void executeTaskWithTimer(TaskWorkingDir twd) throws Exception {
        int jobId = this.invocation.getJobId();
        LOGGER.debug("Executing task invocation for Job " + jobId);
        long timeExecTaskStart = 0L;
        timeExecTaskStart = System.nanoTime();
        this.executeTask(twd);
        long timeExecTaskEnd = System.nanoTime();
        float timeExecTaskElapsed = (float)(timeExecTaskEnd - timeExecTaskStart) / 1000000.0f;
        TIMER_LOGGER.info("[TIMER] Execute job " + jobId + ": " + timeExecTaskElapsed + " ms");
    }

    private void executeTask(TaskWorkingDir twd) throws Exception {
        block22: {
            String streamsPath = this.context.getStandardStreamsPath(this.invocation);
            this.context.registerOutputs(streamsPath);
            PrintStream out = this.context.getThreadOutStream();
            File taskSandboxWorkingDir = twd.getWorkingDir();
            if (this.invocation.isDebugEnabled()) {
                out.println("[EXECUTOR] executeTask - Begin task execution");
            }
            TimerTask timerTask = null;
            try {
                switch (this.invocation.getMethodImplementation().getMethodType()) {
                    case METHOD: 
                    case MULTI_NODE: {
                        this.invoker = this.selectNativeMethodInvoker(taskSandboxWorkingDir, this.resources);
                        break;
                    }
                    case CONTAINER: {
                        this.invoker = new ContainerInvoker(this.context, this.invocation, taskSandboxWorkingDir, this.resources);
                        break;
                    }
                    case BINARY: {
                        this.invoker = new BinaryInvoker(this.context, this.invocation, taskSandboxWorkingDir, this.resources);
                        break;
                    }
                    case PYTHON_MPI: {
                        this.invoker = new PythonMPIInvoker(this.context, this.invocation, taskSandboxWorkingDir, this.resources);
                        break;
                    }
                    case MPI: {
                        this.invoker = new MPIInvoker(this.context, this.invocation, taskSandboxWorkingDir, this.resources);
                        break;
                    }
                    case MPMDMPI: {
                        this.invoker = new MpmdMPIInvoker(this.context, this.invocation, taskSandboxWorkingDir, this.resources);
                        break;
                    }
                    case COMPSs: {
                        this.invoker = new COMPSsInvoker(this.context, this.invocation, taskSandboxWorkingDir, this.resources);
                        break;
                    }
                    case DECAF: {
                        this.invoker = new DecafInvoker(this.context, this.invocation, taskSandboxWorkingDir, this.resources);
                        break;
                    }
                    case OMPSS: {
                        this.invoker = new OmpSsInvoker(this.context, this.invocation, taskSandboxWorkingDir, this.resources);
                        break;
                    }
                    case OPENCL: {
                        this.invoker = new OpenCLInvoker(this.context, this.invocation, taskSandboxWorkingDir, this.resources);
                    }
                }
                timerTask = new TimeOutTask(this.invocation.getTaskId());
                this.platform.registerRunningJob(this.invocation, this.invoker, timerTask);
                if (this.invoker != null) {
                    this.invoker.runInvocation(this);
                    break block22;
                }
                throw new JobExecutionException("Undefined invoker. It could be cause by an incoherent task type");
            }
            catch (Exception jee) {
                out.println("[EXECUTOR] executeTask - Error in task execution");
                PrintStream err = this.context.getThreadErrStream();
                err.println("[EXECUTOR] executeTask - Error in task execution");
                if (this.invocation.getOnFailure() != OnFailure.RETRY) {
                    this.createEmptyFile();
                }
                jee.printStackTrace(err);
                throw jee;
            }
            finally {
                if (timerTask != null) {
                    timerTask.cancel();
                }
                if (this.invocation.isDebugEnabled()) {
                    out.println("[EXECUTOR] executeTask - End task execution");
                }
                this.platform.unregisterRunningJob(this.invocation.getJobId());
                this.invoker = null;
                this.context.unregisterOutputs();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkJobFilesWithTimer(Invocation invocation) throws JobExecutionException {
        long timeCheckOutputFilesStart = 0L;
        timeCheckOutputFilesStart = System.nanoTime();
        try {
            this.checkJobFiles(invocation);
        }
        finally {
            long timeCheckOutputFilesEnd = System.nanoTime();
            float timeCheckOutputFilesElapsed = (float)(timeCheckOutputFilesEnd - timeCheckOutputFilesStart) / 1000000.0f;
            int jobId = this.invocation.getJobId();
            TIMER_LOGGER.debug("[TIMER] Check output files for job " + jobId + ": " + timeCheckOutputFilesElapsed + " ms");
        }
    }

    private void checkJobFiles(Invocation invocation) throws JobExecutionException {
        int jobId = this.invocation.getJobId();
        LOGGER.debug("Checking generated files for Job " + jobId);
        boolean allOutFilesCreated = true;
        for (InvocationParam invocationParam : invocation.getParams()) {
            allOutFilesCreated &= this.checkOutParam(invocationParam);
        }
        for (InvocationParam invocationParam : invocation.getResults()) {
            allOutFilesCreated &= this.checkOutParam(invocationParam);
        }
        if (!allOutFilesCreated) {
            throw new JobExecutionException(ERROR_OUT_FILES + invocation.getMethodImplementation().getMethodDefinition());
        }
    }

    private boolean checkOutParam(InvocationParam param) {
        if (param.getType().equals((Object)DataType.FILE_T)) {
            String filepath;
            File f;
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(TraceEvent.CHECK_OUT_PARAM.getId(), TraceEvent.CHECK_OUT_PARAM.getType());
            }
            if (!(f = new File(filepath = (String)param.getValue())).exists()) {
                StringBuilder errMsg = new StringBuilder();
                errMsg.append("ERROR: File with path '").append(filepath);
                errMsg.append("' not generated by task with Method Definition ").append(this.invocation.getMethodImplementation().getMethodDefinition());
                LOGGER.error(errMsg.toString());
                PrintStream err = this.context.getThreadErrStream();
                err.println(errMsg.toString());
                return false;
            }
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(0L, TraceEvent.CHECK_OUT_PARAM.getType());
            }
        }
        return true;
    }

    private void createEmptyFile() {
        PrintStream out = this.context.getThreadOutStream();
        PrintStream err = this.context.getThreadOutStream();
        if (LOGGER.isDebugEnabled()) {
            out.println("[EXECUTOR] executeTask - Checking if a blank file needs to be created");
        }
        for (InvocationParam invocationParam : this.invocation.getParams()) {
            String filepath;
            File f;
            if (!invocationParam.getType().equals((Object)DataType.FILE_T) || (f = new File(filepath = (String)invocationParam.getValue())).exists()) continue;
            if (LOGGER.isDebugEnabled()) {
                out.println("[EXECUTOR] executeTask - Creating a new blank file");
            }
            try {
                f.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error("ERROR creating blank file for Task " + this.invocation.getTaskId(), (Throwable)e);
                err.println("[EXECUTOR] checkJobFiles - Error in creating a new blank file");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Invoker selectNativeMethodInvoker(File taskSandboxWorkingDir, InvocationResources assignedResources) throws JobExecutionException {
        PrintStream out = this.context.getThreadOutStream();
        switch (this.invocation.getLang()) {
            case JAVA: {
                JavaInvoker javaInvoker = null;
                switch (this.context.getExecutionType()) {
                    case COMPSS: {
                        if (this.context.getRuntimeAPI() != null && this.context.getLoaderAPI() != null) {
                            out.println("Nested Support enabled on the Invocation Context!");
                            javaInvoker = new JavaNestedInvoker(this.context, this.invocation, taskSandboxWorkingDir, assignedResources);
                            break;
                        }
                        javaInvoker = new JavaInvoker(this.context, this.invocation, taskSandboxWorkingDir, assignedResources);
                        break;
                    }
                    case STORAGE: {
                        javaInvoker = new StorageInvoker(this.context, this.invocation, taskSandboxWorkingDir, assignedResources);
                    }
                }
                return javaInvoker;
            }
            case PYTHON: {
                if (this.pyPipes == null) {
                    PipedMirror mirror;
                    ExecutorContext executorContext = this.platform;
                    synchronized (executorContext) {
                        mirror = (PipedMirror)this.platform.getMirror(PythonInvoker.class);
                        if (mirror == null) {
                            mirror = PythonInvoker.getMirror(this.context, this.platform);
                            this.platform.registerMirror(PythonInvoker.class, mirror);
                        }
                    }
                    this.pyPipes = mirror.registerExecutor(this.id);
                }
                return new PythonInvoker(this.context, this.invocation, taskSandboxWorkingDir, assignedResources, this.pyPipes);
            }
            case C: {
                ExternalInvoker cInvoker = null;
                if (this.context.isPersistentCEnabled()) {
                    cInvoker = new CPersistentInvoker(this.context, this.invocation, taskSandboxWorkingDir, assignedResources);
                    if (!this.isRegistered) {
                        PersistentMirror mirror;
                        ExecutorContext executorContext = this.platform;
                        synchronized (executorContext) {
                            mirror = (PersistentMirror)this.platform.getMirror(CPersistentInvoker.class);
                            if (mirror == null) {
                                mirror = CPersistentInvoker.getMirror(this.context, this.platform);
                                this.platform.registerMirror(CPersistentInvoker.class, mirror);
                            }
                        }
                        mirror.registerExecutor(this.id);
                        this.isRegistered = true;
                    }
                } else {
                    if (this.cPipes == null) {
                        PipedMirror mirror;
                        ExecutorContext executorContext = this.platform;
                        synchronized (executorContext) {
                            mirror = (PipedMirror)this.platform.getMirror(CInvoker.class);
                            if (mirror == null) {
                                mirror = (PipedMirror)CInvoker.getMirror(this.context, this.platform);
                                this.platform.registerMirror(CInvoker.class, mirror);
                            }
                        }
                        this.cPipes = mirror.registerExecutor(this.id);
                    }
                    cInvoker = new CInvoker(this.context, this.invocation, taskSandboxWorkingDir, assignedResources, this.cPipes);
                }
                return cInvoker;
            }
        }
        throw new JobExecutionException("Unrecognised lang for a method type invocation");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void obtainExecutionResourcesWithTimer(int jobId, ResourceDescription requirements) throws UnsufficientAvailableResourcesException {
        long timeAssignResourcesStart = 0L;
        timeAssignResourcesStart = System.nanoTime();
        try {
            this.obtainExecutionResources(jobId, requirements);
        }
        finally {
            long timeAssignResourcesEnd = System.nanoTime();
            float timeAssignResourcesElapsed = (float)(timeAssignResourcesEnd - timeAssignResourcesStart) / 1000000.0f;
            TIMER_LOGGER.debug("[TIMER] Assign resources for job " + jobId + ": " + timeAssignResourcesElapsed + " ms");
        }
    }

    private void obtainExecutionResources(int jobId, ResourceDescription requirements) throws UnsufficientAvailableResourcesException {
        LOGGER.debug("Assigning resources for Job " + jobId);
        try {
            this.resources = this.platform.acquireResources(jobId, requirements, this.resources);
            this.assignExecutionResources();
        }
        catch (Exception e) {
            this.logExecutionException(e);
            throw e;
        }
    }

    private void assignExecutionResources() {
        if (Tracer.extraeEnabled()) {
            this.emitAffinityChangeEvents();
        }
        if (this.resources.getAssignedCPUs() != null && this.resources.getAssignedCPUs().length > 0) {
            try {
                ThreadAffinity.setCurrentThreadAffinity(this.resources.getAssignedCPUs());
            }
            catch (Exception e) {
                LOGGER.warn("Error setting affinity for Job " + this.invocation.getJobId(), (Throwable)e);
            }
        }
    }

    @Override
    public void stalledCodeExecution() {
        int jobId = this.invocation.getJobId();
        LOGGER.debug("Release binded resources for Job " + jobId);
        long timeUnassignResourcesStart = 0L;
        if (IS_TIMER_COMPSS_ENABLED) {
            timeUnassignResourcesStart = System.nanoTime();
        }
        this.platform.blockedRunner(this.invocation, this, this.resources);
        if (IS_TIMER_COMPSS_ENABLED) {
            long timeUnassignResourcesEnd = System.nanoTime();
            float timeUnassignResourcesElapsed = (float)(timeUnassignResourcesEnd - timeUnassignResourcesStart) / 1000000.0f;
            TIMER_LOGGER.debug("[TIMER] Unassign resources for job " + jobId + ": " + timeUnassignResourcesElapsed + " ms");
        }
    }

    @Override
    public void readyToContinueExecution(Semaphore sem) {
        long timeAssignResourcesStart = 0L;
        if (IS_TIMER_COMPSS_ENABLED) {
            timeAssignResourcesStart = System.nanoTime();
        }
        this.platform.unblockedRunner(this.invocation, this, this.resources, sem);
        this.assignExecutionResources();
        if (IS_TIMER_COMPSS_ENABLED) {
            long timeAssignResourcesEnd = System.nanoTime();
            float timeAssignResourcesElapsed = (float)(timeAssignResourcesEnd - timeAssignResourcesStart) / 1000000.0f;
            int jobId = this.invocation.getJobId();
            TIMER_LOGGER.debug("[TIMER] Re-assign resources for job " + jobId + ": " + timeAssignResourcesElapsed + " ms");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseResourcesWithTimer(int jobId) {
        long timeUnassignResourcesStart = 0L;
        timeUnassignResourcesStart = System.nanoTime();
        try {
            this.platform.releaseResources(jobId);
        }
        finally {
            long timeUnassignResourcesEnd = System.nanoTime();
            float timeUnassignResourcesElapsed = (float)(timeUnassignResourcesEnd - timeUnassignResourcesStart) / 1000000.0f;
            TIMER_LOGGER.debug("[TIMER] Unassign resources for job " + jobId + ": " + timeUnassignResourcesElapsed + " ms");
        }
    }

    private void releaseResources(int jobId) {
        LOGGER.debug("Release binded resources for Job " + jobId);
        this.platform.releaseResources(jobId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TaskWorkingDir createTaskSandboxWithTimer() throws IOException {
        long timeSandboxStart = 0L;
        timeSandboxStart = System.nanoTime();
        try {
            TaskWorkingDir taskWorkingDir = this.createTaskSandbox();
            return taskWorkingDir;
        }
        finally {
            long timeSandboxEnd = System.nanoTime();
            float timeSandboxElapsed = (float)(timeSandboxEnd - timeSandboxStart) / 1000000.0f;
            TIMER_LOGGER.debug("[TIMER] Create sandbox for job " + this.invocation.getJobId() + ": " + timeSandboxElapsed + " ms");
        }
    }

    private TaskWorkingDir createTaskSandbox() throws IOException {
        TaskWorkingDir taskWD;
        int jobId = this.invocation.getJobId();
        LOGGER.debug("Creating task sandbox for Job " + jobId);
        try {
            String specificWD = null;
            switch (this.invocation.getMethodImplementation().getMethodType()) {
                case CONTAINER: {
                    ContainerDefinition contImpl = (ContainerDefinition)this.invocation.getMethodImplementation().getDefinition();
                    specificWD = contImpl.getWorkingDir();
                    break;
                }
                case BINARY: {
                    BinaryDefinition binaryImpl = (BinaryDefinition)this.invocation.getMethodImplementation().getDefinition();
                    specificWD = binaryImpl.getWorkingDir();
                    break;
                }
                case MPI: {
                    MPIDefinition mpiImpl = (MPIDefinition)this.invocation.getMethodImplementation().getDefinition();
                    specificWD = mpiImpl.getWorkingDir();
                    break;
                }
                case MPMDMPI: {
                    MpmdMPIDefinition mpmpdDef = (MpmdMPIDefinition)this.invocation.getMethodImplementation().getDefinition();
                    specificWD = mpmpdDef.getWorkingDir();
                    break;
                }
                case PYTHON_MPI: {
                    PythonMPIDefinition nativeMPIImpl = (PythonMPIDefinition)this.invocation.getMethodImplementation().getDefinition();
                    specificWD = nativeMPIImpl.getWorkingDir();
                    break;
                }
                case COMPSs: {
                    COMPSsDefinition compssImpl = (COMPSsDefinition)this.invocation.getMethodImplementation().getDefinition();
                    specificWD = compssImpl.getWorkingDir() + File.separator + compssImpl.getParentAppId() + File.separator + "compss_job_" + this.invocation.getJobId() + "_" + this.invocation.getHistory().name();
                    break;
                }
                case DECAF: {
                    DecafDefinition decafImpl = (DecafDefinition)this.invocation.getMethodImplementation().getDefinition();
                    specificWD = decafImpl.getWorkingDir();
                    break;
                }
                case OMPSS: {
                    OmpSsDefinition ompssImpl = (OmpSsDefinition)this.invocation.getMethodImplementation().getDefinition();
                    specificWD = ompssImpl.getWorkingDir();
                    break;
                }
                case OPENCL: {
                    OpenCLDefinition openclImpl = (OpenCLDefinition)this.invocation.getMethodImplementation().getDefinition();
                    specificWD = openclImpl.getWorkingDir();
                    break;
                }
                case METHOD: 
                case MULTI_NODE: {
                    specificWD = null;
                }
            }
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(TraceEvent.CREATING_TASK_SANDBOX.getId(), TraceEvent.CREATING_TASK_SANDBOX.getType());
            }
            if (specificWD != null && !specificWD.isEmpty() && !specificWD.equals("[unassigned]")) {
                File workingDir = BinaryRunner.getUpdatedWorkingDir(this.invocation.getParams(), specificWD);
                taskWD = new TaskWorkingDir(workingDir, true);
                Files.createDirectories(workingDir.toPath(), new FileAttribute[0]);
            } else {
                String completePath = this.context.getWorkingDir() + "sandBox" + File.separator + "job_" + this.invocation.getJobId();
                File workingDir = new File(completePath);
                taskWD = new TaskWorkingDir(workingDir, false);
                if (workingDir.exists()) {
                    LOGGER.debug("Deleting folder " + workingDir.toString());
                    if (!workingDir.delete()) {
                        LOGGER.warn("Cannot delete working dir folder: " + workingDir.toString());
                    }
                }
                Files.createDirectories(workingDir.toPath(), new FileAttribute[0]);
            }
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(0L, TraceEvent.CREATING_TASK_SANDBOX.getType());
            }
        }
        catch (Exception e) {
            this.logExecutionException(e);
            throw e;
        }
        return taskWD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanTaskSandboxWithTimer(TaskWorkingDir twd) {
        long timeCleanSandboxStart = 0L;
        timeCleanSandboxStart = System.nanoTime();
        try {
            this.cleanTaskSandbox(twd);
        }
        finally {
            long timeCleanSandboxEnd = System.nanoTime();
            float timeCleanSandboxElapsed = (float)(timeCleanSandboxEnd - timeCleanSandboxStart) / 1000000.0f;
            int jobId = this.invocation.getJobId();
            TIMER_LOGGER.debug("[TIMER] Clean sandbox for job " + jobId + ": " + timeCleanSandboxElapsed + " ms");
        }
    }

    private void cleanTaskSandbox(TaskWorkingDir twd) {
        File workingDir;
        int jobId = this.invocation.getJobId();
        LOGGER.debug("Cleaning task sandbox for Job " + jobId);
        if (twd != null && !twd.isSpecific() && (workingDir = twd.getWorkingDir()) != null && workingDir.exists() && workingDir.isDirectory()) {
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(TraceEvent.REMOVING_TASK_SANDBOX.getId(), TraceEvent.REMOVING_TASK_SANDBOX.getType());
            }
            try {
                LOGGER.debug("Deleting sandbox " + workingDir.toPath());
                Executor.deleteDirectory(workingDir);
            }
            catch (IOException e) {
                LOGGER.warn("Error deleting sandbox " + e.getMessage(), (Throwable)e);
            }
            if (Tracer.extraeEnabled()) {
                Tracer.emitEvent(0L, TraceEvent.REMOVING_TASK_SANDBOX.getType());
            }
        }
    }

    private DataComparison checkDataVersion(String file1, String file2) {
        String[] version1array = file1.split("_")[0].split("v");
        String[] version2array = file2.split("_")[0].split("v");
        if (version1array.length < 2 || version2array.length < 2) {
            return DataComparison.ERROR;
        }
        if (version1array[1] == version2array[1]) {
            Integer version1int = null;
            Integer version2int = null;
            try {
                version1int = Integer.parseInt(version1array[1]);
                version2int = Integer.parseInt(version2array[1]);
            }
            catch (NumberFormatException e) {
                return DataComparison.ERROR;
            }
            if (version1int > version2int) {
                return DataComparison.SAME_DATA_MAJOR_VERSION;
            }
            if (version1int == version2int) {
                return DataComparison.SAME_DATA_VERSION;
            }
            return DataComparison.SAME_DATA_MINOR_VERSION;
        }
        return DataComparison.DIFF_DATA;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindOriginalFilenamesToRenamesWithTimer(File sandbox) throws Exception {
        long timeBindOriginalFilesStart = 0L;
        timeBindOriginalFilesStart = System.nanoTime();
        try {
            this.bindOriginalFilenamesToRenames(sandbox);
        }
        finally {
            long timeBindOriginalFilesEnd = System.nanoTime();
            float timeBindOriginalFilesElapsed = (float)(timeBindOriginalFilesEnd - timeBindOriginalFilesStart) / 1000000.0f;
            TIMER_LOGGER.debug("[TIMER] Bind original files for job " + this.invocation.getJobId() + ": " + timeBindOriginalFilesElapsed + " ms");
        }
    }

    private void bindOriginalFilenamesToRenames(File sandbox) throws Exception {
        int jobId = this.invocation.getJobId();
        LOGGER.debug("Binding renamed files to sandboxed original names for Job " + jobId);
        try {
            String renamedFilePath;
            for (InvocationParam invocationParam : this.invocation.getParams()) {
                if (!invocationParam.isKeepRename()) {
                    this.bindOriginalFilenameToRenames(invocationParam, sandbox);
                    continue;
                }
                renamedFilePath = (String)invocationParam.getValue();
                LOGGER.debug("Parameter keeps rename: " + renamedFilePath);
                invocationParam.setRenamedName(renamedFilePath);
                invocationParam.setOriginalName(renamedFilePath);
            }
            if (this.invocation.getTarget() != null) {
                LOGGER.debug("Invocation has non-null target");
                InvocationParam param = this.invocation.getTarget();
                if (!param.isKeepRename()) {
                    this.bindOriginalFilenameToRenames(param, sandbox);
                } else {
                    String string = (String)param.getValue();
                    LOGGER.debug("Parameter keeps rename: " + string);
                    param.setRenamedName(string);
                    param.setOriginalName(string);
                }
            }
            for (InvocationParam invocationParam : this.invocation.getResults()) {
                if (!invocationParam.isKeepRename()) {
                    this.bindOriginalFilenameToRenames(invocationParam, sandbox);
                    continue;
                }
                renamedFilePath = (String)invocationParam.getValue();
                LOGGER.debug("Parameter keeps rename: " + renamedFilePath);
                invocationParam.setRenamedName(renamedFilePath);
                invocationParam.setOriginalName(renamedFilePath);
            }
        }
        catch (Exception e) {
            this.logExecutionException(e);
            throw e;
        }
    }

    private void bindOriginalFilenameToRenames(InvocationParam param, File sandbox) throws IOException {
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.BIND_ORIG_NAME.getId(), TraceEvent.BIND_ORIG_NAME.getType());
        }
        if (param.getType().equals((Object)DataType.COLLECTION_T)) {
            InvocationParamCollection cp = (InvocationParamCollection)param;
            for (InvocationParam p : cp.getCollectionParameters()) {
                this.bindOriginalFilenameToRenames(p, sandbox);
            }
        } else if (param.getType().equals((Object)DataType.DICT_COLLECTION_T)) {
            InvocationParamDictCollection dcp = (InvocationParamDictCollection)param;
            for (Map.Entry entry : dcp.getDictCollectionParameters().entrySet()) {
                this.bindOriginalFilenameToRenames((InvocationParam)entry.getKey(), sandbox);
                this.bindOriginalFilenameToRenames((InvocationParam)entry.getValue(), sandbox);
            }
        } else if (param.getType().equals((Object)DataType.FILE_T)) {
            String renamedFilePath = (String)param.getValue();
            File renamedFile = new File(renamedFilePath);
            param.setRenamedName(renamedFilePath);
            if (renamedFile.getName().equals(param.getOriginalName())) {
                param.setOriginalName(renamedFilePath);
            } else {
                this.manageSymbolicLinks(renamedFile, renamedFilePath, param, sandbox);
            }
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.BIND_ORIG_NAME.getType());
        }
    }

    private void manageSymbolicLinks(File renamedFile, String renamedFilePath, InvocationParam param, File sandbox) throws IOException {
        String inSandboxPath = sandbox.getAbsolutePath() + File.separator + param.getOriginalName();
        File inSandboxFile = new File(inSandboxPath);
        if (inSandboxFile.exists()) {
            if (renamedFile.exists()) {
                if (Files.isSymbolicLink(inSandboxFile.toPath())) {
                    this.manageOverlapInSymlink(sandbox, inSandboxPath, inSandboxFile, renamedFile, param);
                } else {
                    LOGGER.warn("WARNING: Strange case for param " + param.getDataMgmtId() + " where renamed and in sandbox already exists and it is not linked with a Symlink");
                }
            } else {
                File newSandboxFile = new File(sandbox, param.getDataMgmtId() + "_" + param.getOriginalName());
                String newSandboxPath = newSandboxFile.getAbsolutePath();
                param.setOriginalName(newSandboxPath);
                param.setValue(newSandboxPath);
            }
        } else if (renamedFile.exists()) {
            LOGGER.debug("Creating symlink " + inSandboxFile.toPath() + " pointing to " + renamedFile.toPath());
            Files.createSymbolicLink(inSandboxFile.toPath(), renamedFile.toPath(), new FileAttribute[0]);
            LOGGER.debug("Setting Original Name to " + inSandboxPath);
            LOGGER.debug("Renamed File Path is " + renamedFilePath);
            param.setOriginalName(inSandboxPath);
            param.setValue(inSandboxPath);
        } else {
            LOGGER.debug("Setting Original Name to " + inSandboxPath);
            LOGGER.debug("Renamed File Path is " + renamedFilePath);
            param.setOriginalName(inSandboxPath);
            param.setValue(inSandboxPath);
        }
    }

    private void manageOverlapInSymlink(File sandbox, String inSandboxPath, File inSandboxFile, File renamedFile, InvocationParam param) throws IOException {
        Path oldRenamed = Files.readSymbolicLink(inSandboxFile.toPath());
        LOGGER.debug("Checking if " + renamedFile.getName() + " is equal to " + oldRenamed.getFileName().toString());
        switch (this.checkDataVersion(renamedFile.getName(), oldRenamed.getFileName().toString())) {
            case SAME_DATA_VERSION: 
            case SAME_DATA_MINOR_VERSION: {
                param.setOriginalName(inSandboxPath);
                param.setValue(inSandboxPath);
                break;
            }
            case SAME_DATA_MAJOR_VERSION: {
                LOGGER.debug("Upading Symbolic link " + inSandboxFile.toPath().toString() + "->" + renamedFile.toPath().toString());
                Files.delete(inSandboxFile.toPath());
                Files.createSymbolicLink(inSandboxFile.toPath(), renamedFile.toPath(), new FileAttribute[0]);
                param.setOriginalName(inSandboxPath);
                param.setValue(inSandboxPath);
                break;
            }
            case DIFF_DATA: {
                File newSandboxFile = new File(sandbox, param.getDataMgmtId() + "_" + param.getOriginalName());
                String newSandboxPath = newSandboxFile.getAbsolutePath();
                LOGGER.debug("Creating Symbolic link " + newSandboxFile.toPath().toString() + "->" + renamedFile.toPath().toString());
                Files.createSymbolicLink(newSandboxFile.toPath(), renamedFile.toPath(), new FileAttribute[0]);
                param.setOriginalName(newSandboxPath);
                param.setValue(newSandboxPath);
                break;
            }
            case ERROR: {
                LOGGER.warn("ERROR: There was an error extracting data versions for " + oldRenamed.getFileName().toString() + " and " + renamedFile.getName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindOriginalFileNamesToRenamesWithTimer() throws IOException, JobExecutionException {
        long timeUnbindOriginalFilesStart = 0L;
        timeUnbindOriginalFilesStart = System.nanoTime();
        try {
            this.unbindOriginalFileNamesToRenames();
        }
        finally {
            long timeUnbindOriginalFilesEnd = System.nanoTime();
            float timeUnbindOriginalFilesElapsed = (float)(timeUnbindOriginalFilesEnd - timeUnbindOriginalFilesStart) / 1000000.0f;
            int jobId = this.invocation.getJobId();
            TIMER_LOGGER.debug("[TIMER] Unbind original files for job " + jobId + ": " + timeUnbindOriginalFilesElapsed + " ms");
        }
    }

    private void unbindOriginalFileNamesToRenames() throws IOException, JobExecutionException {
        int jobId = this.invocation.getJobId();
        LOGGER.debug("Removing renamed files to sandboxed original names for Job " + jobId);
        String message = null;
        boolean failure = false;
        for (InvocationParam invocationParam : this.invocation.getParams()) {
            try {
                this.unbindOriginalFilenameToRename(invocationParam);
            }
            catch (JobExecutionException e) {
                message = !failure ? e.getMessage() : message.concat("\n" + e.getMessage());
                failure = true;
            }
        }
        if (this.invocation.getTarget() != null) {
            try {
                this.unbindOriginalFilenameToRename(this.invocation.getTarget());
            }
            catch (JobExecutionException e) {
                message = !failure ? e.getMessage() : message.concat("\n" + e.getMessage());
                failure = true;
            }
        }
        for (InvocationParam invocationParam : this.invocation.getResults()) {
            try {
                this.unbindOriginalFilenameToRename(invocationParam);
            }
            catch (JobExecutionException e) {
                message = !failure ? e.getMessage() : message.concat("\n" + e.getMessage());
                failure = true;
            }
        }
        if (failure) {
            throw new JobExecutionException(message);
        }
    }

    private void unbindOriginalFilenameToRename(InvocationParam param) throws IOException, JobExecutionException {
        if (param.isKeepRename()) {
            return;
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(TraceEvent.UNBIND_ORIG_NAME.getId(), TraceEvent.UNBIND_ORIG_NAME.getType());
        }
        if (param.getType().equals((Object)DataType.COLLECTION_T)) {
            InvocationParamCollection cp = (InvocationParamCollection)param;
            for (InvocationParam p : cp.getCollectionParameters()) {
                this.unbindOriginalFilenameToRename(p);
            }
        } else if (param.getType().equals((Object)DataType.DICT_COLLECTION_T)) {
            InvocationParamDictCollection dcp = (InvocationParamDictCollection)param;
            for (Map.Entry entry : dcp.getDictCollectionParameters().entrySet()) {
                this.unbindOriginalFilenameToRename((InvocationParam)entry.getKey());
                this.unbindOriginalFilenameToRename((InvocationParam)entry.getValue());
            }
        } else if (param.getType().equals((Object)DataType.FILE_T)) {
            String inSandboxPath = param.getOriginalName();
            String renamedFilePath = param.getRenamedName();
            LOGGER.debug("Treating file " + inSandboxPath);
            File inSandboxFile = new File(inSandboxPath);
            String originalFileName = inSandboxFile.getName();
            if (!inSandboxPath.equals(renamedFilePath)) {
                File renamedFile = new File(renamedFilePath);
                if (renamedFile.exists()) {
                    if (inSandboxFile.exists()) {
                        if (Files.isSymbolicLink(inSandboxFile.toPath())) {
                            LOGGER.debug("Deleting symlink " + inSandboxFile.toPath());
                            Files.delete(inSandboxFile.toPath());
                        } else {
                            LOGGER.debug("Moving from " + inSandboxFile.toPath() + " to " + renamedFile.toPath());
                            Files.delete(renamedFile.toPath());
                            this.move(inSandboxFile.toPath(), renamedFile.toPath());
                        }
                    } else {
                        LOGGER.debug("Repeated data for " + inSandboxPath + ". Nothing to do");
                    }
                } else if (inSandboxFile.exists()) {
                    if (Files.isSymbolicLink(inSandboxFile.toPath())) {
                        String msg = "ERROR: Unexpected case. A Problem occurred with File " + inSandboxPath + ". Either this file or the original name " + renamedFilePath + " do not exist.";
                        LOGGER.error(msg);
                        this.context.getThreadErrStream().println(msg);
                        param.setValue(renamedFilePath);
                        param.setOriginalName(originalFileName);
                        throw new JobExecutionException(msg);
                    }
                    this.move(inSandboxFile.toPath(), renamedFile.toPath());
                } else {
                    if (this.invocation.getOnFailure() != OnFailure.RETRY) {
                        LOGGER.debug("Generating empty renamed file (" + renamedFilePath + ") for on_failure management");
                        if (!renamedFile.createNewFile()) {
                            // empty if block
                        }
                    }
                    param.setValue(renamedFilePath);
                    param.setOriginalName(originalFileName);
                    String msg = "WARN: Output file " + inSandboxFile.toPath() + " does not exist";
                    throw new JobExecutionException(msg);
                }
            }
            param.setValue(renamedFilePath);
            param.setOriginalName(originalFileName);
        }
        if (Tracer.extraeEnabled()) {
            Tracer.emitEvent(0L, TraceEvent.UNBIND_ORIG_NAME.getType());
        }
    }

    private void move(Path origFilePath, Path renamedFilePath) throws IOException {
        LOGGER.debug("Moving " + origFilePath.toString() + " to " + renamedFilePath.toString());
        try {
            Files.move(origFilePath, renamedFilePath, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException amnse) {
            LOGGER.warn(WARN_ATOMIC_MOVE);
            Files.move(origFilePath, renamedFilePath, new CopyOption[0]);
        }
    }

    private static void deleteDirectory(File directory) throws IOException {
        Path dPath = directory.toPath();
        Files.walkFileTree(dPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private void emitingTaskStartEvents() {
        if (Tracer.isActivated() & Tracer.isTracingTaskDependencies() && this.invocation.getPredecessors() != null) {
            for (Integer i : this.invocation.getPredecessors()) {
                Tracer.emitCommEvent(false, 123, 1, i, 0L);
            }
        }
        int numNodes = 1;
        if (this.invocation.getSlaveNodesNames() != null) {
            numNodes = this.invocation.getSlaveNodesNames().size() + 1;
        }
        int nCPUs = ((MethodResourceDescription)this.invocation.getRequirements()).getTotalCPUComputingUnits() * numNodes;
        Tracer.emitEvent(nCPUs, Tracer.getCPUCountEventsType());
        int nGPUs = ((MethodResourceDescription)this.invocation.getRequirements()).getTotalGPUComputingUnits() * numNodes;
        Tracer.emitEvent(nGPUs, Tracer.getGPUCountEventsType());
        int memory = (int)((MethodResourceDescription)this.invocation.getRequirements()).getMemorySize() * numNodes;
        if (memory < 0) {
            memory = 0;
        }
        Tracer.emitEvent(memory, Tracer.getMemoryEventsType());
        int diskBW = ((MethodResourceDescription)this.invocation.getRequirements()).getStorageBW() * numNodes;
        if (diskBW < 0) {
            diskBW = 0;
        }
        Tracer.emitEvent(diskBW, Tracer.getDiskBWEventsType());
        int taskType = this.invocation.getMethodImplementation().getMethodType().ordinal() + 1;
        Tracer.emitEvent(taskType, Tracer.getTaskTypeEventsType());
        Tracer.emitEvent(TraceEvent.TASK_RUNNING.getId(), TraceEvent.TASK_RUNNING.getType());
    }

    private void emitTaskEndEvents() {
        if (Tracer.isActivated() & Tracer.isTracingTaskDependencies()) {
            for (int i = 0; i < this.invocation.getNumSuccessors(); ++i) {
                Tracer.emitCommEvent(true, 123, 1, this.invocation.getTaskId(), 0L);
            }
        }
        Tracer.emitEvent(0L, Tracer.getCPUCountEventsType());
        Tracer.emitEvent(0L, Tracer.getGPUCountEventsType());
        Tracer.emitEvent(0L, Tracer.getMemoryEventsType());
        Tracer.emitEvent(0L, Tracer.getDiskBWEventsType());
        Tracer.emitEvent(0L, Tracer.getTaskTypeEventsType());
        Tracer.emitEvent(0L, TraceEvent.TASK_RUNNING.getType());
    }

    private void emitAffinityChangeEvents() {
        if (this.resources != null) {
            int[] gpus;
            int[] cpus = this.resources.getAssignedCPUs();
            if (cpus != null && cpus.length > 0) {
                if (this.firstTimeAffinityCPU) {
                    this.firstTimeAffinityCPU = false;
                } else {
                    Tracer.emitEvent(0L, Tracer.getTasksCPUAffinityEventsType());
                }
                Tracer.emitEvent((long)cpus[0] + 1L, Tracer.getTasksCPUAffinityEventsType());
            }
            if ((gpus = this.resources.getAssignedGPUs()) != null && gpus.length > 0) {
                if (this.firstTimeAffinityGPU) {
                    this.firstTimeAffinityGPU = false;
                } else {
                    Tracer.emitEvent(0L, Tracer.getTasksGPUAffinityEventsType());
                }
                Tracer.emitEvent((long)gpus[0] + 1L, Tracer.getTasksGPUAffinityEventsType());
            }
        }
    }

    private void emitAffinityEndEvents() {
        if (!this.firstTimeAffinityCPU) {
            Tracer.emitEvent(0L, Tracer.getTasksCPUAffinityEventsType());
        }
        if (!this.firstTimeAffinityGPU) {
            Tracer.emitEvent(0L, Tracer.getTasksGPUAffinityEventsType());
        }
    }

    static {
        String isTimerCOMPSsEnabledProperty = System.getProperty("compss.timers");
        IS_TIMER_COMPSS_ENABLED = isTimerCOMPSsEnabledProperty == null || isTimerCOMPSsEnabledProperty.isEmpty() || isTimerCOMPSsEnabledProperty.equals("null") ? false : Boolean.valueOf(isTimerCOMPSsEnabledProperty);
    }

    private class TaskWorkingDir {
        private final File workingDir;
        private final boolean isSpecific;

        public TaskWorkingDir(File workingDir, boolean isSpecific) {
            this.workingDir = workingDir;
            this.isSpecific = isSpecific;
        }

        public File getWorkingDir() {
            return this.workingDir;
        }

        public boolean isSpecific() {
            return this.isSpecific;
        }
    }

    private static enum DataComparison {
        SAME_DATA_VERSION,
        SAME_DATA_MAJOR_VERSION,
        SAME_DATA_MINOR_VERSION,
        DIFF_DATA,
        ERROR;

    }
}

