/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.types.annotations.parameter.OnFailure;
import es.bsc.compss.types.execution.Invocation;
import es.bsc.compss.types.implementations.AbstractMethodImplementation;
import es.bsc.compss.types.implementations.TaskType;
import es.bsc.compss.types.job.JobHistory;
import es.bsc.compss.types.resources.MethodResourceDescription;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class NIOTask
implements Externalizable,
Invocation {
    private COMPSsConstants.Lang lang;
    private boolean workerDebug;
    private AbstractMethodImplementation impl;
    private String parallelismSource;
    private LinkedList<NIOParam> arguments;
    private NIOParam target;
    private LinkedList<NIOParam> results;
    private MethodResourceDescription reqs;
    private List<String> slaveWorkersNodeNames;
    private int taskId;
    private TaskType taskType;
    private int jobId;
    private JobHistory history;
    private int transferGroupId;
    private int numReturns;
    private OnFailure onFailure;
    private long timeOut;
    private List<Integer> predecessors;
    private Integer numSuccessors;

    public NIOTask() {
    }

    public NIOTask(COMPSsConstants.Lang lang, boolean workerDebug, AbstractMethodImplementation impl, String parallelismSource, boolean hasTarget, int numReturns, LinkedList<NIOParam> params, int numParams, MethodResourceDescription reqs, List<String> slaveWorkersNodeNames, int taskId, TaskType taskType, int jobId, JobHistory hist, int transferGroupId, OnFailure onFailure, long timeOut, List<Integer> predecessors, Integer numSuccessors) {
        this.lang = lang;
        this.workerDebug = workerDebug;
        this.impl = impl;
        this.parallelismSource = parallelismSource;
        this.arguments = new LinkedList();
        this.results = new LinkedList();
        this.onFailure = onFailure;
        this.timeOut = timeOut;
        this.predecessors = predecessors;
        this.numSuccessors = numSuccessors;
        Iterator<NIOParam> paramItr = params.descendingIterator();
        for (int rIdx = 0; rIdx < numReturns; ++rIdx) {
            NIOParam p = paramItr.next();
            this.results.addFirst(p);
        }
        if (hasTarget) {
            NIOParam p;
            this.target = p = paramItr.next();
        }
        while (paramItr.hasNext()) {
            NIOParam p = paramItr.next();
            this.arguments.addFirst(p);
        }
        this.reqs = reqs;
        this.slaveWorkersNodeNames = slaveWorkersNodeNames;
        this.taskType = taskType;
        this.taskId = taskId;
        this.jobId = jobId;
        this.history = hist;
        this.transferGroupId = transferGroupId;
        this.numReturns = numReturns;
    }

    public NIOTask(COMPSsConstants.Lang lang, boolean workerDebug, AbstractMethodImplementation impl, String parallelismSource, LinkedList<NIOParam> arguments, NIOParam target, LinkedList<NIOParam> results, List<String> slaveWorkersNodeNames, int taskId, int jobId, JobHistory hist, int transferGroupId, OnFailure onFailure, long timeOut) {
        this.lang = lang;
        this.workerDebug = workerDebug;
        this.impl = impl;
        this.arguments = arguments;
        this.target = target;
        this.results = results;
        this.onFailure = onFailure;
        this.timeOut = timeOut;
        this.reqs = impl.getRequirements();
        this.slaveWorkersNodeNames = slaveWorkersNodeNames;
        this.taskType = impl.getTaskType();
        this.taskId = taskId;
        this.jobId = jobId;
        this.history = hist;
        this.transferGroupId = transferGroupId;
        this.numReturns = results.size();
    }

    @Override
    public COMPSsConstants.Lang getLang() {
        return this.lang;
    }

    @Override
    public boolean isDebugEnabled() {
        return this.workerDebug;
    }

    public String getMethodDefinition() {
        return this.impl.getMethodDefinition();
    }

    @Override
    public AbstractMethodImplementation getMethodImplementation() {
        return this.impl;
    }

    public List<NIOParam> getParams() {
        return this.arguments;
    }

    @Override
    public NIOParam getTarget() {
        return this.target;
    }

    public List<NIOParam> getResults() {
        return this.results;
    }

    public int getNumReturns() {
        return this.numReturns;
    }

    @Override
    public int getTaskId() {
        return this.taskId;
    }

    @Override
    public TaskType getTaskType() {
        return this.taskType;
    }

    @Override
    public int getJobId() {
        return this.jobId;
    }

    @Override
    public JobHistory getHistory() {
        return this.history;
    }

    public int getTransferGroupId() {
        return this.transferGroupId;
    }

    @Override
    public MethodResourceDescription getRequirements() {
        return this.reqs;
    }

    @Override
    public List<String> getSlaveNodesNames() {
        return this.slaveWorkersNodeNames;
    }

    @Override
    public OnFailure getOnFailure() {
        return this.onFailure;
    }

    @Override
    public long getTimeOut() {
        return this.timeOut;
    }

    @Override
    public String getParallelismSource() {
        return this.parallelismSource;
    }

    @Override
    public List<Integer> getPredecessors() {
        return this.predecessors;
    }

    @Override
    public Integer getNumSuccessors() {
        return this.numSuccessors;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.lang = COMPSsConstants.Lang.valueOf((String)in.readObject());
        this.workerDebug = in.readBoolean();
        this.impl = (AbstractMethodImplementation)in.readObject();
        boolean ceiDefined = in.readBoolean();
        if (ceiDefined) {
            this.parallelismSource = in.readUTF();
        }
        this.numReturns = in.readInt();
        this.arguments = (LinkedList)in.readObject();
        this.target = (NIOParam)in.readObject();
        this.results = (LinkedList)in.readObject();
        this.reqs = (MethodResourceDescription)in.readObject();
        this.slaveWorkersNodeNames = (List)in.readObject();
        this.taskType = TaskType.values()[in.readInt()];
        this.taskId = in.readInt();
        this.jobId = in.readInt();
        this.history = (JobHistory)((Object)in.readObject());
        this.transferGroupId = in.readInt();
        this.onFailure = (OnFailure)((Object)in.readObject());
        this.timeOut = in.readLong();
        this.predecessors = (List)in.readObject();
        this.numSuccessors = (Integer)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.lang.toString());
        out.writeBoolean(this.workerDebug);
        out.writeObject(this.impl);
        boolean ceiDefined = this.parallelismSource != null && !this.parallelismSource.isEmpty();
        out.writeBoolean(ceiDefined);
        if (ceiDefined) {
            out.writeUTF(this.parallelismSource);
        }
        out.writeInt(this.numReturns);
        out.writeObject(this.arguments);
        out.writeObject(this.target);
        out.writeObject(this.results);
        out.writeObject(this.reqs);
        out.writeObject(this.slaveWorkersNodeNames);
        out.writeInt(this.taskType.ordinal());
        out.writeInt(this.taskId);
        out.writeInt(this.jobId);
        out.writeObject((Object)this.history);
        out.writeInt(this.transferGroupId);
        out.writeObject((Object)this.onFailure);
        out.writeLong(this.timeOut);
        out.writeObject(this.predecessors);
        out.writeObject(this.numSuccessors);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[TASK ");
        sb.append("[LANG= ").append((Object)this.lang).append("]");
        sb.append("[TASK TYPE= ").append((Object)this.taskType).append("]");
        sb.append("[TASK ID= ").append(this.taskId).append("]");
        sb.append("[JOB ID= ").append(this.jobId).append("]");
        sb.append("[HISTORY= ").append((Object)this.history).append("]");
        sb.append("[IMPLEMENTATION= ").append(this.impl.getMethodDefinition()).append("]");
        sb.append("[PARALLELISM SOURCE= ").append(this.parallelismSource).append("]");
        sb.append(" [PARAMS ");
        for (NIOParam param : this.arguments) {
            sb.append(param);
        }
        if (this.target != null) {
            sb.append(this.target);
        }
        for (NIOParam param : this.results) {
            sb.append(param);
        }
        sb.append("]");
        sb.append("[REQUIREMENTS= ").append(this.reqs).append("]");
        sb.append("[SLAVE_WORKERS_NODE_NAMES= ");
        for (String name : this.slaveWorkersNodeNames) {
            sb.append("[SW_NAME=").append(name).append("]");
        }
        sb.append("]");
        sb.append("]");
        return sb.toString();
    }
}

