/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.compss.types.data.location.ProtocolType;
import es.bsc.compss.util.StreamGobbler;
import es.bsc.compss.util.TraceEvent;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.io.IOException;

public class NIOTracer
extends Tracer {
    private static String scriptDir = "";
    private static String workingDir = "";
    private static String nodeName = "master";
    private static String hostID = "0";
    private static final int ID = 121;
    public static final String TRANSFER_END = "0";

    public static void init(int level, boolean tracingTaskDep) {
        LOGGER.debug("Initializing NIO tracing level [" + level + "," + tracingTaskDep + "]");
        tracingLevel = level;
        tracingTaskDependencies = tracingTaskDep;
    }

    public static void setWorkerInfo(String scriptDir, String nodeName, String workingDir, int hostID) {
        NIOTracer.scriptDir = scriptDir;
        NIOTracer.workingDir = workingDir;
        NIOTracer.nodeName = nodeName;
        NIOTracer.hostID = String.valueOf(hostID);
        if (Tracer.extraeEnabled()) {
            Tracer.setUpWrapper(hostID, hostID + 1);
        }
        if (DEBUG) {
            LOGGER.debug("Tracer worker for host " + hostID + " and: " + NIOTracer.scriptDir + ", " + NIOTracer.workingDir + ", " + NIOTracer.nodeName);
        }
    }

    public static void startTracing(String workerName, String workerUser, String workerHost, Integer numThreads) {
        if (numThreads <= 0) {
            if (DEBUG) {
                LOGGER.debug("Resource " + workerName + " has 0 slots, it won't appear in the trace");
            }
            return;
        }
        if (DEBUG) {
            LOGGER.debug("NIO uri File: " + ProtocolType.ANY_URI.getSchema() + File.separator + System.getProperty("compss.appLogDir") + TRACE_OUT_RELATIVE_PATH);
            LOGGER.debug(ProtocolType.ANY_URI.getSchema() + File.separator + System.getProperty("compss.appLogDir") + TRACE_OUT_RELATIVE_PATH);
        }
    }

    public static String getHostID() {
        return hostID;
    }

    public static void emitDataTransferEvent(String data, boolean end) {
        boolean dataTransfer = !data.startsWith("worker") && !data.startsWith("tracing") && !data.startsWith("binding") && !data.startsWith("cache") && !data.endsWith("trace.tar.gz");
        int transferID = Math.abs(data.hashCode());
        if (dataTransfer) {
            if (end) {
                NIOTracer.emitEvent(0L, NIOTracer.getDataTransfersType());
            } else {
                NIOTracer.emitEvent(transferID, NIOTracer.getDataTransfersType());
            }
        }
        if (DEBUG) {
            LOGGER.debug((dataTransfer ? "E" : "Not E") + "mitting synchronized data transfer event [name, id] = [" + data + " , " + transferID + "]");
        }
    }

    public static void emitCommEvent(boolean send, int partnerID, int tag) {
        NIOTracer.emitCommEvent(send, 121, partnerID, tag, 0L);
    }

    public static void emitCommEvent(boolean send, int partnerID, int tag, long size) {
        NIOTracer.emitCommEvent(send, 121, partnerID, tag, size);
    }

    public static void generatePackage() {
        String mode = "package";
        if (DEBUG) {
            LOGGER.debug("[NIOTracer] Generating trace package of " + nodeName);
        }
        if (Tracer.extraeEnabled()) {
            NIOTracer.emitEvent(TraceEvent.STOP.getId(), TraceEvent.STOP.getType());
            NIOTracer.emitEvent(0L, TraceEvent.STOP.getType());
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            Tracer.stopWrapper();
            mode = "package";
        } else if (Tracer.scorepEnabled()) {
            mode = "package-scorep";
            if (DEBUG) {
                LOGGER.debug("[NIOTracer] Finishing scorep");
            }
        } else if (Tracer.mapEnabled()) {
            mode = "package-map";
            if (DEBUG) {
                LOGGER.debug("[NIOTracer] Finishing map");
            }
        }
        if (DEBUG) {
            LOGGER.debug("[NIOTracer] Executing command " + scriptDir + TRACE_SCRIPT_PATH + " " + mode + " " + workingDir + " " + nodeName + " " + hostID);
        }
        ProcessBuilder pb = new ProcessBuilder(scriptDir + TRACE_SCRIPT_PATH, mode, workingDir, nodeName, hostID);
        pb.environment().remove("LD_PRELOAD");
        Process p = null;
        try {
            p = pb.start();
        }
        catch (IOException e) {
            LOGGER.error("Error generating " + nodeName + " package", (Throwable)e);
            return;
        }
        StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), System.out, LOGGER, false);
        StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), System.err, LOGGER, true);
        outputGobbler.start();
        errorGobbler.start();
        if (DEBUG) {
            LOGGER.debug("Created globbers");
        }
        try {
            int exitCode = p.waitFor();
            if (exitCode != 0) {
                LOGGER.error("Error generating " + nodeName + " package, exit code " + exitCode);
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Error generating " + nodeName + " package, interruptedException", (Throwable)e);
        }
        LOGGER.debug("Finish generating");
    }
}

