/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.comm;

import es.bsc.comm.exceptions.NonInstantiableException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CommProperties {
    private static final Logger LOGGER = LogManager.getLogger("Communication.Properties");
    private static final String MAX_BUFFERED_PACKETS_NAME = "MAX_BUFFERED_PACKETS";
    private static final int DEFAULT_MAX_BUFFERED_PACKETS = 10;
    private static int maxBufferedPackets;
    private static final String MIN_BUFFERED_PACKETS_NAME = "MIN_BUFFERED_PACKETS";
    private static final int DEFAULT_MIN_BUFFERED_PACKETS = 5;
    private static int minBufferedPackets;
    private static final String PACKET_SIZE_NAME = "PACKET_SIZE";
    private static final int DEFAULT_PACKET_SIZE = 8192;
    private static int packetSize;
    private static final String NETWORK_BUFFER_SIZE_NAME = "NETWORK_BUFFER_SIZE";
    private static final int DEFAULT_NETWORK_BUFFER_SIZE = 81920;
    private static int networkBufferSize;
    private static final String MAX_SENDS_NAME = "MAX_SEND";
    private static final int DEFAULT_MAX_SENDS = Integer.MAX_VALUE;
    private static int maxSends;
    private static final String MAX_RECEIVES_NAME = "MAX_RECEIVES";
    private static final int DEFAULT_MAX_RECEIVES = Integer.MAX_VALUE;
    private static int maxReceives;
    private static final String MAX_RETRIES_NAME = "MAX_RETRIES";
    private static final int DEFAULT_MAX_RETRIES = 5;
    private static int maxRetries;
    private static final String PROP_FILE_NAME = "nio.cfg";

    private CommProperties() {
        throw new NonInstantiableException("CommProperties");
    }

    public static void importProperties(String loc) {
        if (loc == null) {
            maxBufferedPackets = 10;
            minBufferedPackets = 5;
            packetSize = 8192;
            networkBufferSize = 81920;
            maxSends = Integer.MAX_VALUE;
            maxReceives = Integer.MAX_VALUE;
            maxRetries = 5;
        } else {
            String path = loc + File.separator + PROP_FILE_NAME;
            try (FileInputStream inputStream = new FileInputStream(path);){
                Properties prop = new Properties();
                prop.load(inputStream);
                maxBufferedPackets = Integer.parseInt(prop.getProperty(MAX_BUFFERED_PACKETS_NAME));
                minBufferedPackets = Integer.parseInt(prop.getProperty(MIN_BUFFERED_PACKETS_NAME));
                packetSize = Integer.parseInt(prop.getProperty(PACKET_SIZE_NAME));
                networkBufferSize = Integer.parseInt(prop.getProperty(NETWORK_BUFFER_SIZE_NAME));
                maxSends = Integer.parseInt(prop.getProperty(MAX_SENDS_NAME));
                maxReceives = Integer.parseInt(prop.getProperty(MAX_RECEIVES_NAME));
                maxRetries = Integer.parseInt(prop.getProperty(MAX_RETRIES_NAME));
            }
            catch (FileNotFoundException fnfe) {
                LOGGER.error("ERROR: Cannot find properties file " + path, (Throwable)fnfe);
                return;
            }
            catch (IOException e) {
                LOGGER.error("Error loading properties", (Throwable)e);
            }
        }
    }

    public static void printProperties() {
        LOGGER.info("MAX_BUFFERED_PACKETS = " + maxBufferedPackets);
        LOGGER.info("MIN_BUFFERED_PACKETS = " + minBufferedPackets);
        LOGGER.info("PACKET_SIZE = " + packetSize);
        LOGGER.info("NETWORK_BUFFER_SIZE = " + networkBufferSize);
        LOGGER.info("MAX_SEND = " + maxSends);
        LOGGER.info("MAX_RECEIVES = " + maxReceives);
        LOGGER.info("MAX_RETRIES = " + maxRetries);
    }

    public static int getMaxBufferedPackets() {
        return maxBufferedPackets;
    }

    public static int getMinBufferedPackets() {
        return minBufferedPackets;
    }

    public static int getPacketSize() {
        return packetSize;
    }

    public static int getNetworkBufferSize() {
        return networkBufferSize;
    }

    public static int getMaxSends() {
        return maxSends;
    }

    public static int getMaxReceives() {
        return maxReceives;
    }

    public static int getMaxRetries() {
        return maxRetries;
    }
}

