/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.comm.Connection;
import es.bsc.comm.TransferManager;
import es.bsc.comm.nio.NIOEventManager;
import es.bsc.comm.nio.NIONode;
import es.bsc.comm.stage.Transfer;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.NIOTaskResult;
import es.bsc.compss.nio.NIOTracer;
import es.bsc.compss.nio.NIOURI;
import es.bsc.compss.nio.commands.CommandDataDemand;
import es.bsc.compss.nio.commands.CommandTracingID;
import es.bsc.compss.nio.commands.Data;
import es.bsc.compss.nio.commands.tracing.CommandGenerateDone;
import es.bsc.compss.nio.dataRequest.DataRequest;
import es.bsc.compss.nio.exceptions.SerializedObjectException;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.util.ErrorManager;
import es.bsc.compss.util.Serializer;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class NIOAgent {
    protected static final String NIO_EVENT_MANAGER_CLASS = NIOEventManager.class.getCanonicalName();
    public static final String ID = NIOAgent.class.getCanonicalName();
    public static final int NUM_PARAMS_PER_WORKER_SH = 5;
    public static final int NUM_PARAMS_NIO_WORKER = 25;
    public static final String BINDER_DISABLED = "disabled";
    public static final String BINDER_AUTOMATIC = "automatic";
    private int sendTransfers = 0;
    private final int MAX_SEND_TRANSFERS;
    private final Connection[] trasmittingConnections;
    private int receiveTransfers;
    private final int MAX_RECEIVE_TRANSFERS;
    private boolean finish;
    private Connection closingConnection = null;
    protected final Map<String, List<DataRequest>> dataToRequests;
    private final LinkedList<DataRequest> pendingRequests;
    private final Map<Connection, String> ongoingTransfers;
    protected String masterIP;
    protected static int masterPort;
    protected NIONode masterNode;
    protected static final TransferManager TM;
    private static final Logger LOGGER;
    protected static boolean tracing;
    protected static int tracing_level;
    protected static int tracingID;
    protected static HashMap<Connection, Integer> connection2Partner;

    public NIOAgent(int snd, int rcv, int port) {
        this.MAX_SEND_TRANSFERS = snd;
        this.trasmittingConnections = new Connection[this.MAX_SEND_TRANSFERS];
        this.receiveTransfers = 0;
        this.MAX_RECEIVE_TRANSFERS = rcv;
        masterPort = port;
        this.ongoingTransfers = new HashMap<Connection, String>();
        this.pendingRequests = new LinkedList();
        this.dataToRequests = new HashMap<String, List<DataRequest>>();
        connection2Partner = new HashMap();
        this.finish = false;
    }

    public NIONode getMaster() {
        return this.masterNode;
    }

    public static TransferManager getTransferManager() {
        return TM;
    }

    public void addConnectionAndPartner(Connection c, int partner, int tag) {
        connection2Partner.put(c, partner);
    }

    protected List<DataRequest> getDataRequests(String dataId) {
        return this.dataToRequests.get(dataId);
    }

    public boolean hasPendingTransfers() {
        return !this.pendingRequests.isEmpty() || this.sendTransfers != 0 || this.receiveTransfers != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestTransfers() {
        DataRequest dr = null;
        LinkedList<DataRequest> linkedList = this.pendingRequests;
        synchronized (linkedList) {
            if (!this.pendingRequests.isEmpty() && this.tryAcquireReceiveSlot()) {
                dr = this.pendingRequests.remove();
            }
        }
        while (dr != null) {
            NIONode nn;
            Data source = dr.getSource();
            NIOURI uri = source.getFirstURI();
            if (NIOTracer.isActivated()) {
                NIOTracer.emitDataTransferEvent(source.getName());
            }
            if ((nn = uri.getHost()).getIp() == null) {
                nn = this.masterNode;
            }
            Connection c = null;
            try {
                c = TM.startConnection(nn);
                LOGGER.debug("Connection " + c.hashCode() + " will be used to acquire data " + dr.getTarget() + " stored in " + nn + " with name " + dr.getSource().getName());
                Data remoteData = new Data(source.getName(), uri);
                CommandDataDemand cdd = new CommandDataDemand(this, remoteData, tracingID);
                this.ongoingTransfers.put(c, dr.getSource().getName());
                c.sendCommand(cdd);
                if (NIOTracer.isActivated()) {
                    c.receive();
                }
                if (dr.getType() == DataType.FILE_T) {
                    c.receiveDataFile(dr.getTarget());
                } else {
                    c.receiveDataObject();
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
            finally {
                if (c != null) {
                    c.finishConnection();
                }
            }
            LinkedList<DataRequest> linkedList2 = this.pendingRequests;
            synchronized (linkedList2) {
                dr = !this.pendingRequests.isEmpty() && this.tryAcquireReceiveSlot() ? this.pendingRequests.remove() : null;
            }
            if (!NIOTracer.isActivated()) continue;
            NIOTracer.emitDataTransferEvent("0");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTransferRequest(DataRequest dr) {
        List<DataRequest> list = this.dataToRequests.get(dr.getSource().getName());
        if (list == null) {
            list = new LinkedList<DataRequest>();
            this.dataToRequests.put(dr.getSource().getName(), list);
            LinkedList<DataRequest> linkedList = this.pendingRequests;
            synchronized (linkedList) {
                this.pendingRequests.add(dr);
            }
        }
        list.add(dr);
    }

    public void sendData(Connection c, Data d, int receiverID) {
        String path;
        if (NIOTracer.isActivated()) {
            int tag = Math.abs(d.getName().hashCode());
            CommandTracingID cmd = new CommandTracingID(tracingID, tag);
            c.sendCommand(cmd);
            NIOTracer.emitDataTransferEvent(d.getName());
            NIOTracer.emitCommEvent(true, receiverID, tag);
        }
        if ((path = d.getFirstURI().getPath()).startsWith(File.separator)) {
            File f = new File(path);
            LOGGER.debug("INSIDE SENDATA");
            if (f.exists()) {
                LOGGER.debug("Connection " + c.hashCode() + " will transfer file " + path + " as data " + d.getName());
                c.sendDataFile(path);
            } else {
                ErrorManager.warn("Can't send file '" + path + "' via connection " + c.hashCode() + " because file doesn't exist.");
                this.handleDataToSendNotAvailable(c, d);
            }
        } else {
            try {
                Object o = this.getObject(path);
                LOGGER.debug("Connection " + c.hashCode() + " will transfer an object as data " + d.getName());
                c.sendDataObject(o);
            }
            catch (SerializedObjectException soe) {
                String newLocation = this.getObjectAsFile(path);
                LOGGER.debug("Connection " + c.hashCode() + " will transfer an object-file " + newLocation + " as data " + d.getName());
                c.sendDataFile(newLocation);
            }
        }
        if (NIOTracer.isActivated()) {
            NIOTracer.emitDataTransferEvent("0");
        }
        c.finishConnection();
    }

    public void receivedData(Connection c, Transfer t) {
        String dataId = this.ongoingTransfers.remove(c);
        if (dataId == null) {
            return;
        }
        this.releaseReceiveSlot();
        List<DataRequest> requests = this.dataToRequests.remove(dataId);
        HashMap<String, LinkedList<DataRequest>> byTarget = new HashMap<String, LinkedList<DataRequest>>();
        for (DataRequest dataRequest : requests) {
            LinkedList<DataRequest> sameTarget = (LinkedList<DataRequest>)byTarget.get(dataRequest.getTarget());
            if (sameTarget == null) {
                sameTarget = new LinkedList<DataRequest>();
                byTarget.put(dataRequest.getTarget(), sameTarget);
            }
            sameTarget.add(dataRequest);
        }
        if (NIOTracer.isActivated()) {
            int tag = Math.abs(dataId.hashCode());
            NIOTracer.emitDataTransferEvent(dataId);
            NIOTracer.emitCommEvent(false, connection2Partner.get(c), tag, t.getSize());
            connection2Partner.remove(c);
        }
        if (byTarget.size() == 1) {
            String targetName = requests.get(0).getTarget();
            this.receivedValue(t.getDestination(), targetName, t.getObject(), requests);
        } else {
            if (t.isFile()) {
                this.receivedValue(t.getDestination(), t.getFileName(), t.getObject(), (List)byTarget.remove(t.getFileName()));
            } else {
                this.receivedValue(t.getDestination(), dataId, t.getObject(), (List)byTarget.remove(dataId));
            }
            for (Map.Entry entry : byTarget.entrySet()) {
                String targetName = (String)entry.getKey();
                List reqs = (List)entry.getValue();
                try {
                    if (t.isFile()) {
                        Files.copy(new File(t.getFileName()).toPath(), new File(targetName).toPath(), new CopyOption[0]);
                        this.receivedValue(t.getDestination(), targetName, t.getObject(), (List)byTarget.remove(targetName));
                        continue;
                    }
                    Object o = Serializer.deserialize(t.getArray());
                    this.receivedValue(t.getDestination(), targetName, o, reqs);
                }
                catch (IOException | ClassNotFoundException e) {
                    LOGGER.warn("Can not replicate received Data", (Throwable)e);
                }
            }
        }
        this.requestTransfers();
        if (this.finish && !this.hasPendingTransfers()) {
            this.shutdown(this.closingConnection);
        }
    }

    public void receivedShutdown(Connection requester, List<Data> filesToSend) {
        LOGGER.debug("Command for shutdown received. Preparing for shutdown...");
        this.closingConnection = requester;
        this.finish = true;
        if (!this.hasPendingTransfers()) {
            this.shutdown(this.closingConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryAcquireReceiveSlot() {
        boolean b = false;
        NIOAgent nIOAgent = this;
        synchronized (nIOAgent) {
            if (this.receiveTransfers < this.MAX_RECEIVE_TRANSFERS) {
                ++this.receiveTransfers;
                b = true;
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseReceiveSlot() {
        NIOAgent nIOAgent = this;
        synchronized (nIOAgent) {
            --this.receiveTransfers;
        }
    }

    public boolean tryAcquireSendSlot(Connection c) {
        boolean b = false;
        if (this.sendTransfers < this.MAX_SEND_TRANSFERS) {
            ++this.sendTransfers;
            b = true;
            for (int i = 0; i < this.MAX_SEND_TRANSFERS; ++i) {
                if (this.trasmittingConnections[i] != null) continue;
                this.trasmittingConnections[i] = c;
                break;
            }
        }
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseSendSlot(Connection c) {
        NIOAgent nIOAgent = this;
        synchronized (nIOAgent) {
            for (int i = 0; i < this.MAX_SEND_TRANSFERS; ++i) {
                if (this.trasmittingConnections[i] != c) continue;
                this.trasmittingConnections[i] = null;
                --this.sendTransfers;
                if (!this.finish || this.hasPendingTransfers()) break;
                this.shutdown(this.closingConnection);
                break;
            }
        }
    }

    public void receivedRequestedDataNotAvailableError(Connection c, Transfer t) {
        String dataId = this.ongoingTransfers.remove(c);
        if (dataId == null) {
            return;
        }
        this.releaseReceiveSlot();
        List<DataRequest> requests = this.dataToRequests.remove(dataId);
        this.handleRequestedDataNotAvailableError(requests, dataId);
        this.requestTransfers();
        if (this.finish && !this.hasPendingTransfers()) {
            this.shutdown(this.closingConnection);
        }
    }

    public void generatePackage(Connection c) {
        NIOTracer.generatePackage();
        c.sendCommand(new CommandGenerateDone());
        c.finishConnection();
    }

    public abstract void setMaster(NIONode var1);

    public abstract boolean isMyUuid(String var1, String var2);

    public abstract void setWorkerIsReady(String var1);

    public abstract String getWorkingDir();

    public abstract void receivedNewTask(NIONode var1, NIOTask var2, List<String> var3);

    public abstract Object getObject(String var1) throws SerializedObjectException;

    public abstract String getObjectAsFile(String var1);

    protected abstract void handleDataToSendNotAvailable(Connection var1, Data var2);

    public abstract void handleRequestedDataNotAvailableError(List<DataRequest> var1, String var2);

    public abstract void receivedValue(Transfer.Destination var1, String var2, Object var3, List<DataRequest> var4);

    public abstract void copiedData(int var1);

    public abstract void receivedTaskDone(Connection var1, NIOTaskResult var2, boolean var3);

    public abstract void shutdown(Connection var1);

    public abstract void shutdownNotification(Connection var1);

    public abstract void shutdownExecutionManager(Connection var1);

    public abstract void shutdownExecutionManagerNotification(Connection var1);

    public abstract void waitUntilTracingPackageGenerated();

    public abstract void notifyTracingPackageGeneration();

    public abstract void generateWorkersDebugInfo(Connection var1);

    public abstract void waitUntilWorkersDebugInfoGenerated();

    public abstract void notifyWorkersDebugInfoGeneration();

    static {
        TM = new TransferManager();
        LOGGER = LogManager.getLogger("es.bsc.compss.Communication");
        tracingID = 0;
    }
}

