/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio;

import es.bsc.cepbatools.extrae.Wrapper;
import es.bsc.compss.types.data.location.DataLocation;
import es.bsc.compss.util.StreamGobbler;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.io.IOException;

public class NIOTracer
extends Tracer {
    private static String scriptDir = "";
    private static String workingDir = "";
    private static String nodeName = "master";
    private static String hostID = "0";
    private static final int ID = 121;
    public static final String TRANSFER_END = "0";

    public static void init(int level) {
        LOGGER.debug("Initializing NIO tracing");
        tracingLevel = level;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWorkerInfo(String scriptDir, String nodeName, String workingDir, int hostID) {
        NIOTracer.scriptDir = scriptDir;
        NIOTracer.workingDir = workingDir;
        NIOTracer.nodeName = nodeName;
        NIOTracer.hostID = String.valueOf(hostID);
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.SetTaskID(hostID);
            Wrapper.SetNumTasks(hostID + 1);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            if (DEBUG) {
                LOGGER.debug("Tracer worker for host " + hostID + " and: " + NIOTracer.scriptDir + ", " + NIOTracer.workingDir + ", " + NIOTracer.nodeName);
            }
            return;
        }
    }

    public static void startTracing(String workerName, String workerUser, String workerHost, Integer numThreads) {
        if (numThreads <= 0) {
            if (DEBUG) {
                LOGGER.debug("Resource " + workerName + " has 0 slots, it won't appear in the trace");
            }
            return;
        }
        if (DEBUG) {
            LOGGER.debug("NIO uri File: " + DataLocation.Protocol.ANY_URI.getSchema() + File.separator + System.getProperty("compss.appLogDir") + traceOutRelativePath);
            LOGGER.debug(DataLocation.Protocol.ANY_URI.getSchema() + File.separator + System.getProperty("compss.appLogDir") + traceOutRelativePath);
        }
    }

    public static String getHostID() {
        return hostID;
    }

    public static void emitDataTransferEvent(String data) {
        int transferID;
        boolean dataTransfer = !data.startsWith("worker") && !data.startsWith("tracing");
        int n = transferID = data.equals(TRANSFER_END) ? 0 : Math.abs(data.hashCode());
        if (dataTransfer) {
            NIOTracer.emitEvent(transferID, NIOTracer.getDataTransfersType());
        }
        if (DEBUG) {
            LOGGER.debug((dataTransfer ? "E" : "Not E") + "mitting synchronized data transfer event [name, id] = [" + data + " , " + transferID + "]");
        }
    }

    public static void emitCommEvent(boolean send, int partnerID, int tag) {
        NIOTracer.emitCommEvent(send, partnerID, tag, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void emitCommEvent(boolean send, int partnerID, int tag, long size) {
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            Wrapper.Comm(send, tag, (int)size, partnerID, 121L);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            if (DEBUG) {
                LOGGER.debug("Emitting communication event [" + (send ? "SEND" : "REC") + "] " + tag + ", " + size + ", " + partnerID + ", " + 121 + "]");
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void generatePackage() {
        NIOTracer.emitEvent(Tracer.Event.STOP.getId(), Tracer.Event.STOP.getType());
        if (DEBUG) {
            LOGGER.debug("[NIOTracer] Generating trace package of " + nodeName);
        }
        NIOTracer.emitEvent(0L, Tracer.getRuntimeEventsType());
        Class<Tracer> clazz = Tracer.class;
        synchronized (Tracer.class) {
            LOGGER.debug("[NIOTracer] Disabling pthreads");
            Wrapper.SetOptions(Wrapper.EXTRAE_ENABLE_ALL_OPTIONS & ~Wrapper.EXTRAE_PTHREAD_OPTION);
            LOGGER.debug("[NIOTracer] Finishing extrae");
            Wrapper.Fini();
            // ** MonitorExit[var0] (shouldn't be in output)
            if (DEBUG) {
                LOGGER.debug("[NIOTracer] Executing command " + scriptDir + TRACE_SCRIPT_PATH + " package " + workingDir + " " + nodeName + " " + hostID);
            }
            ProcessBuilder pb = new ProcessBuilder(scriptDir + TRACE_SCRIPT_PATH, "package", workingDir, nodeName, hostID);
            pb.environment().remove("LD_PRELOAD");
            Process p = null;
            try {
                p = pb.start();
            }
            catch (IOException e) {
                LOGGER.error("Error generating " + nodeName + " package", (Throwable)e);
                return;
            }
            if (DEBUG) {
                StreamGobbler outputGobbler = new StreamGobbler(p.getInputStream(), System.out, LOGGER);
                StreamGobbler errorGobbler = new StreamGobbler(p.getErrorStream(), System.err, LOGGER);
                outputGobbler.start();
                errorGobbler.start();
                LOGGER.debug("Created globbers");
            }
            try {
                int exitCode = p.waitFor();
                if (exitCode != 0) {
                    LOGGER.error("Error generating " + nodeName + " package, exit code " + exitCode);
                }
            }
            catch (InterruptedException e) {
                LOGGER.error("Error generating " + nodeName + " package, interruptedException", (Throwable)e);
            }
            LOGGER.debug("Finish generating");
            return;
        }
    }
}

