/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.commands;

import es.bsc.comm.Connection;
import es.bsc.compss.nio.NIOAgent;
import es.bsc.compss.nio.commands.Command;
import es.bsc.compss.nio.commands.Data;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class CommandDataDemand
extends Command
implements Externalizable {
    private Data d;
    private int id;

    public CommandDataDemand() {
    }

    public CommandDataDemand(NIOAgent ng, Data d, int receiverID) {
        super(ng);
        this.d = d;
        this.id = receiverID;
    }

    @Override
    public Command.CommandType getType() {
        return Command.CommandType.DATA_DEMAND;
    }

    @Override
    public void handle(Connection c) {
        boolean slot = this.agent.tryAcquireSendSlot(c);
        if (!slot) {
            this.agent.sendData(c, this.d, this.id);
        } else {
            this.agent.sendData(c, this.d, this.id);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.d = (Data)in.readObject();
        this.id = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.d);
        out.writeInt(this.id);
    }

    public String toString() {
        return "Request for sending data " + this.d;
    }
}

