/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.commands;

import es.bsc.compss.exceptions.UnstartedNodeException;
import es.bsc.compss.nio.NIOAgent;
import es.bsc.compss.nio.NIOURI;
import es.bsc.compss.types.data.LogicalData;
import es.bsc.compss.types.uri.MultiURI;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.LinkedList;

public class Data
implements Externalizable {
    private String name;
    private LinkedList<NIOURI> sources;

    public Data() {
    }

    public Data(String name, NIOURI uri) {
        this.name = name;
        this.sources = new LinkedList();
        this.sources.add(uri);
    }

    public Data(LogicalData ld) {
        this.name = ld.getName();
        this.sources = new LinkedList();
        for (MultiURI uri : ld.getURIs()) {
            try {
                Object o = uri.getInternalURI(NIOAgent.ID);
                if (o == null) continue;
                this.sources.add((NIOURI)o);
            }
            catch (UnstartedNodeException unstartedNodeException) {}
        }
    }

    public boolean compareTo(Data n) {
        return n.name.compareTo(this.name) == 0;
    }

    public String getName() {
        return this.name;
    }

    public LinkedList<NIOURI> getSources() {
        return this.sources;
    }

    public NIOURI getFirstURI() {
        if (this.sources != null && !this.sources.isEmpty()) {
            return this.sources.getFirst();
        }
        return null;
    }

    public NIOURI getURIinHost(String hostname) {
        for (NIOURI loc : this.sources) {
            String hostAndPort = loc.getHost().toString();
            String host = hostAndPort.substring(0, hostAndPort.indexOf(":"));
            if (!host.equals(hostname)) continue;
            return loc;
        }
        return null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.sources = (LinkedList)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeObject(this.sources);
    }

    public String toString() {
        return this.name + "@" + this.sources;
    }
}

