/*
 * Decompiled with CFR 0.152.
 */
package es.bsc.compss.nio.worker.executors;

import es.bsc.compss.COMPSsConstants;
import es.bsc.compss.nio.NIOParam;
import es.bsc.compss.nio.NIOTask;
import es.bsc.compss.nio.NIOTracer;
import es.bsc.compss.nio.exceptions.JobExecutionException;
import es.bsc.compss.nio.worker.NIOWorker;
import es.bsc.compss.nio.worker.components.ExecutionManager;
import es.bsc.compss.nio.worker.util.JobsThreadPool;
import es.bsc.compss.types.annotations.parameter.DataType;
import es.bsc.compss.types.implementations.BinaryImplementation;
import es.bsc.compss.types.implementations.DecafImplementation;
import es.bsc.compss.types.implementations.MPIImplementation;
import es.bsc.compss.types.implementations.OmpSsImplementation;
import es.bsc.compss.types.implementations.OpenCLImplementation;
import es.bsc.compss.types.resources.MethodResourceDescription;
import es.bsc.compss.util.RequestQueue;
import es.bsc.compss.util.Tracer;
import java.io.File;
import java.io.IOException;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Executor
implements Runnable {
    protected static final Logger LOGGER = LogManager.getLogger("es.bsc.compss.Worker.Executor");
    protected static final boolean WORKER_DEBUG = LOGGER.isDebugEnabled();
    private static final String ERROR_OUT_FILES = "ERROR: One or more OUT files have not been created by task with Method Definition [";
    private static final String WARN_ATOMIC_MOVE = "WARN: AtomicMoveNotSupportedException. File cannot be atomically moved. Trying to move without atomic";
    private final NIOWorker nw;
    protected final JobsThreadPool pool;
    protected final RequestQueue<NIOTask> queue;

    public Executor(NIOWorker nw, JobsThreadPool pool, RequestQueue<NIOTask> queue) {
        LOGGER.info("Executor init");
        this.nw = nw;
        this.pool = pool;
        this.queue = queue;
    }

    @Override
    public void run() {
        this.processRequests();
        this.finish();
        if (this.pool != null) {
            this.pool.threadEnd();
        }
    }

    private void processRequests() {
        while (true) {
            NIOTask nt;
            if ((nt = this.queue.dequeue()) == null) break;
            if (WORKER_DEBUG) {
                LOGGER.debug("Dequeuing job " + nt.getJobId());
            }
            boolean success = this.executeTask(nt);
            if (WORKER_DEBUG) {
                LOGGER.debug("Job " + nt.getJobId() + " finished (success: " + success + ")");
            }
            this.nw.sendTaskDone(nt, success);
        }
        LOGGER.debug("Dequeued job is null");
    }

    private boolean executeTask(NIOTask nt) {
        switch (COMPSsConstants.Lang.valueOf(nt.getLang().toUpperCase())) {
            case JAVA: 
            case PYTHON: 
            case C: {
                return this.execute(nt, this.nw);
            }
        }
        LOGGER.error("Incorrect language " + nt.getLang() + " in job " + nt.getJobId());
        System.err.println("Incorrect language " + nt.getLang() + " in job " + nt.getJobId());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean execute(NIOTask nt, NIOWorker nw) {
        if (NIOTracer.isActivated()) {
            NIOTracer.emitEvent(Tracer.Event.TASK_RUNNING.getId(), Tracer.Event.TASK_RUNNING.getType());
        }
        List<String> hostnames = nt.getSlaveWorkersNodeNames();
        hostnames.add(nw.getHostName());
        int numNodes = hostnames.size();
        int cus = nt.getResourceDescription().getTotalCPUComputingUnits();
        boolean firstElement = true;
        StringBuilder hostnamesSTR = new StringBuilder();
        for (String hostname : hostnames) {
            int i;
            if (hostname.endsWith("-ib0")) {
                hostname = hostname.substring(0, hostname.lastIndexOf("-ib0"));
            }
            if (firstElement) {
                firstElement = false;
                hostnamesSTR.append(hostname);
                for (i = 1; i < cus; ++i) {
                    hostnamesSTR.append(",").append(hostname);
                }
                continue;
            }
            for (i = 0; i < cus; ++i) {
                hostnamesSTR.append(",").append(hostname);
            }
        }
        this.setEnvironmentVariables(hostnamesSTR.toString(), numNodes, cus, nt.getResourceDescription());
        String outputsBasename = nw.getWorkingDir() + "jobs" + File.separator + "job" + nt.getJobId() + "_" + (Object)((Object)nt.getHist());
        TaskWorkingDir twd = null;
        try {
            twd = this.createTaskSandbox(nt);
            LOGGER.debug("Binding renamed files to sandboxed original names for Job " + nt.getJobId());
            this.bindOriginalFilenamesToRenames(nt, twd.getWorkingDir());
            int[] assignedCoreUnits = nw.getExecutionManager().bind(nt.getJobId(), nt.getResourceDescription().getTotalCPUComputingUnits(), ExecutionManager.BinderType.CPU);
            int[] assignedGPUs = nw.getExecutionManager().bind(nt.getJobId(), nt.getResourceDescription().getTotalGPUComputingUnits(), ExecutionManager.BinderType.GPU);
            LOGGER.debug("Executing Task of Job " + nt.getJobId());
            this.executeTask(nw, nt, outputsBasename, twd.getWorkingDir(), assignedCoreUnits, assignedGPUs);
            LOGGER.debug("Removing renamed files to sandboxed original names for Job " + nt.getJobId());
            this.removeOriginalFilenames(nt);
            LOGGER.debug("Checking generated files for Job " + nt.getJobId());
            this.checkJobFiles(nt);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            System.out.println("Exception executing task " + e.getMessage());
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            this.cleanTaskSandbox(twd);
            nw.getExecutionManager().release(nt.getJobId(), ExecutionManager.BinderType.CPU);
            nw.getExecutionManager().release(nt.getJobId(), ExecutionManager.BinderType.GPU);
            if (NIOTracer.isActivated()) {
                NIOTracer.emitEvent(0L, Tracer.Event.TASK_RUNNING.getType());
            }
        }
    }

    private TaskWorkingDir createTaskSandbox(NIOTask nt) throws IOException {
        TaskWorkingDir taskWD;
        String specificWD = null;
        switch (nt.getMethodType()) {
            case BINARY: {
                BinaryImplementation binaryImpl = (BinaryImplementation)nt.getMethodImplementation();
                specificWD = binaryImpl.getWorkingDir();
                break;
            }
            case MPI: {
                MPIImplementation mpiImpl = (MPIImplementation)nt.getMethodImplementation();
                specificWD = mpiImpl.getWorkingDir();
                break;
            }
            case DECAF: {
                DecafImplementation decafImpl = (DecafImplementation)nt.getMethodImplementation();
                specificWD = decafImpl.getWorkingDir();
                break;
            }
            case OMPSS: {
                OmpSsImplementation ompssImpl = (OmpSsImplementation)nt.getMethodImplementation();
                specificWD = ompssImpl.getWorkingDir();
                break;
            }
            case OPENCL: {
                OpenCLImplementation openclImpl = (OpenCLImplementation)nt.getMethodImplementation();
                specificWD = openclImpl.getWorkingDir();
                break;
            }
            case METHOD: {
                specificWD = null;
            }
        }
        if (specificWD != null && !specificWD.isEmpty() && !specificWD.equals("[unassigned]")) {
            File workingDir = new File(specificWD);
            taskWD = new TaskWorkingDir(workingDir, true);
            Files.createDirectories(workingDir.toPath(), new FileAttribute[0]);
        } else {
            String completePath = this.nw.getWorkingDir() + "sandBox" + File.separator + "job_" + nt.getJobId();
            File workingDir = new File(completePath);
            taskWD = new TaskWorkingDir(workingDir, false);
            if (workingDir.exists()) {
                LOGGER.debug("Deleting folder " + workingDir.toString());
                if (!workingDir.delete()) {
                    LOGGER.warn("Cannot delete working dir folder: " + workingDir.toString());
                }
            }
            Files.createDirectories(workingDir.toPath(), new FileAttribute[0]);
        }
        return taskWD;
    }

    private void cleanTaskSandbox(TaskWorkingDir twd) {
        File workingDir;
        if (twd != null && !twd.isSpecific() && (workingDir = twd.getWorkingDir()) != null && workingDir.exists() && workingDir.isDirectory()) {
            try {
                LOGGER.debug("Deleting sandbox " + workingDir.toPath());
                FileUtils.deleteDirectory(workingDir);
            }
            catch (IOException e) {
                LOGGER.warn("Error deleting sandbox " + e.getMessage(), (Throwable)e);
            }
        }
    }

    private boolean isMajorVersion(String file1, String file2) {
        String[] version1array = file1.split("_")[0].split("v");
        String[] version2array = file2.split("_")[0].split("v");
        if (version1array.length < 2 || version2array.length < 2) {
            return false;
        }
        Integer version1int = null;
        Integer version2int = null;
        try {
            version1int = Integer.parseInt(version1array[1]);
            version2int = Integer.parseInt(version2array[1]);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return version1int > version2int;
    }

    private void bindOriginalFilenamesToRenames(NIOTask nt, File sandbox) throws IOException {
        for (NIOParam param : nt.getParams()) {
            if (!param.getType().equals((Object)DataType.FILE_T)) continue;
            String renamedFilePath = (String)param.getValue();
            File renamedFile = new File(renamedFilePath);
            if (renamedFile.getName().equals(param.getOriginalName())) {
                param.setOriginalName(renamedFilePath);
                continue;
            }
            String newOrigFilePath = sandbox.getAbsolutePath() + File.separator + param.getOriginalName();
            LOGGER.debug("Setting Original Name to " + newOrigFilePath);
            param.setOriginalName(newOrigFilePath);
            File newOrigFile = new File(newOrigFilePath);
            if (!renamedFile.exists()) continue;
            if (!newOrigFile.exists()) {
                LOGGER.debug("Creating symlink " + newOrigFile.toPath() + " pointing to " + renamedFile.toPath());
                Files.createSymbolicLink(newOrigFile.toPath(), renamedFile.toPath(), new FileAttribute[0]);
                continue;
            }
            if (!Files.isSymbolicLink(newOrigFile.toPath())) continue;
            Path oldRenamed = Files.readSymbolicLink(newOrigFile.toPath());
            LOGGER.debug("Checking if " + renamedFile.getName() + " is equal to " + oldRenamed.getFileName().toString());
            if (!this.isMajorVersion(renamedFile.getName(), oldRenamed.getFileName().toString())) continue;
            Files.delete(newOrigFile.toPath());
            Files.createSymbolicLink(newOrigFile.toPath(), renamedFile.toPath(), new FileAttribute[0]);
        }
    }

    private void removeOriginalFilenames(NIOTask nt) throws IOException, JobExecutionException {
        for (NIOParam param : nt.getParams()) {
            String msg;
            if (!param.getType().equals((Object)DataType.FILE_T)) continue;
            String renamedFilePath = (String)param.getValue();
            String newOriginalFilePath = param.getOriginalName();
            LOGGER.debug("Treating file " + renamedFilePath);
            if (renamedFilePath.equals(newOriginalFilePath)) continue;
            File newOrigFile = new File(newOriginalFilePath);
            File renamedFile = new File(renamedFilePath);
            if (renamedFile.exists()) {
                if (newOrigFile.exists()) {
                    if (Files.isSymbolicLink(newOrigFile.toPath())) {
                        LOGGER.debug("Deleting symlink " + newOrigFile.toPath());
                        Files.delete(newOrigFile.toPath());
                        continue;
                    }
                    this.move(newOrigFile.toPath(), renamedFile.toPath());
                    continue;
                }
                LOGGER.debug("Repeated data for " + renamedFilePath + ". Nothing to do");
                continue;
            }
            if (newOrigFile.exists()) {
                if (Files.isSymbolicLink(newOrigFile.toPath())) {
                    msg = "ERROR: Unexpected case. A Problem occurred with File " + renamedFilePath + ". Either this file or the original name " + newOriginalFilePath + " do not exist.";
                    LOGGER.error(msg);
                    System.err.println(msg);
                    throw new JobExecutionException(msg);
                }
                this.move(newOrigFile.toPath(), renamedFile.toPath());
                continue;
            }
            msg = "ERROR: Output file " + newOriginalFilePath + " does not exist";
            if (COMPSsConstants.Lang.valueOf(nt.getLang().toUpperCase()) == COMPSsConstants.Lang.C) continue;
            LOGGER.error(msg);
            System.err.println(msg);
            throw new JobExecutionException(msg);
        }
    }

    private void move(Path origFilePath, Path renamedFilePath) throws IOException {
        LOGGER.debug("Moving " + origFilePath.toString() + " to " + renamedFilePath.toString());
        try {
            Files.move(origFilePath, renamedFilePath, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (AtomicMoveNotSupportedException amnse) {
            LOGGER.warn(WARN_ATOMIC_MOVE);
            Files.move(origFilePath, renamedFilePath, new CopyOption[0]);
        }
    }

    private void checkJobFiles(NIOTask nt) throws JobExecutionException {
        boolean allOutFilesCreated = true;
        for (NIOParam param : nt.getParams()) {
            String filepath;
            File f;
            if (!param.getType().equals((Object)DataType.FILE_T) || (f = new File(filepath = (String)param.getValue())).exists() || COMPSsConstants.Lang.valueOf(nt.getLang().toUpperCase()) == COMPSsConstants.Lang.C) continue;
            StringBuilder errMsg = new StringBuilder();
            errMsg.append("ERROR: File with path '").append(filepath);
            errMsg.append("' not generated by task with Method Definition ").append(nt.getMethodImplementation().getMethodDefinition());
            System.out.println(errMsg.toString());
            System.err.println(errMsg.toString());
            allOutFilesCreated = false;
        }
        if (!allOutFilesCreated) {
            throw new JobExecutionException(ERROR_OUT_FILES + nt.getMethodImplementation().getMethodDefinition());
        }
    }

    public abstract void setEnvironmentVariables(String var1, int var2, int var3, MethodResourceDescription var4);

    public abstract void executeTask(NIOWorker var1, NIOTask var2, String var3, File var4, int[] var5, int[] var6) throws Exception;

    public abstract void finish();

    private class TaskWorkingDir {
        private final File workingDir;
        private final boolean isSpecific;

        public TaskWorkingDir(File workingDir, boolean isSpecific) {
            this.workingDir = workingDir;
            this.isSpecific = isSpecific;
        }

        public File getWorkingDir() {
            return this.workingDir;
        }

        public boolean isSpecific() {
            return this.isSpecific;
        }
    }
}

